/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.crypto;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTUInt8Delegate;
import org.xvm.runtime.template._native.crypto.xRTAlgorithms;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xService;

public class xRTSigner
extends xService {
    public static xRTSigner INSTANCE;

    public xRTSigner(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("sign", new String[]{OBJECT[0], OBJECT[0], BYTES[0]}, BYTES);
        this.markNativeMethod("verify", new String[]{OBJECT[0], OBJECT[0], BYTES[0], BYTES[0]}, BOOLEAN);
        this.invalidateTypeInfo();
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "sign": {
                return this.invokeSign(frame, (xRTAlgorithms.SignatureHandle)ahArg[0], ahArg[1], (ByteBasedDelegate.ByteArrayHandle)((xArray.ArrayHandle)ahArg[2]).m_hDelegate, iReturn);
            }
            case "verify": {
                return this.invokeVerify(frame, (xRTAlgorithms.SignatureHandle)ahArg[0], ahArg[1], (ByteBasedDelegate.ByteArrayHandle)((xArray.ArrayHandle)ahArg[2]).m_hDelegate, (ByteBasedDelegate.ByteArrayHandle)((xArray.ArrayHandle)ahArg[3]).m_hDelegate, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    private int invokeSign(Frame frame, xRTAlgorithms.SignatureHandle hSignature, ObjectHandle hKey, ByteBasedDelegate.ByteArrayHandle haData, int iReturn) {
        Signature signature = hSignature.f_signature;
        byte[] abData = xRTUInt8Delegate.getBytes(haData);
        try {
            PrivateKey privateKey = (PrivateKey)xRTAlgorithms.extractKey(frame, hKey, signature.getAlgorithm(), xRTAlgorithms.KeyForm.Private);
            signature.initSign(privateKey);
            signature.update(abData);
            byte[] abSig = signature.sign();
            return frame.assignValue(iReturn, xArray.makeByteArrayHandle(abSig, xArray.Mutability.Constant));
        }
        catch (GeneralSecurityException e) {
            return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
        }
    }

    private int invokeVerify(Frame frame, xRTAlgorithms.SignatureHandle hSignature, ObjectHandle hKey, ByteBasedDelegate.ByteArrayHandle haSignature, ByteBasedDelegate.ByteArrayHandle haData, int iReturn) {
        Signature signature = hSignature.f_signature;
        byte[] abSig = xRTUInt8Delegate.getBytes(haSignature);
        byte[] abData = xRTUInt8Delegate.getBytes(haData);
        try {
            PublicKey publicKey = (PublicKey)xRTAlgorithms.extractKey(frame, hKey, signature.getAlgorithm(), xRTAlgorithms.KeyForm.Public);
            signature.initVerify(publicKey);
            signature.update(abData);
            return frame.assignValue(iReturn, xBoolean.makeHandle(signature.verify(abSig)));
        }
        catch (GeneralSecurityException e) {
            return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
        }
    }
}

