/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.fs;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.FSNodeConstant;
import org.xvm.asm.constants.FileStoreConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;

public class xCPFileStore
extends xConst {
    private static MethodStructure s_constructor;

    public xCPFileStore(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.f_container.getConstantPool();
        s_constructor = this.getStructure().findConstructor(pool.typeString(), pool.typeObject());
        this.markNativeMethod("loadNode", null, null);
        this.markNativeMethod("loadDirectory", null, null);
        this.markNativeMethod("loadFile", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof FileStoreConstant) {
            FileStoreConstant constStore = (FileStoreConstant)constant;
            TypeComposition clz = this.ensureClass(frame.f_context.f_container, this.getCanonicalType(), frame.poolContext().typeFileStore());
            ObjectHandle.GenericHandle hStruct = new ObjectHandle.GenericHandle(clz.ensureAccess(Constants.Access.STRUCT));
            ObjectHandle[] ahVar = Utils.ensureSize(Utils.OBJECTS_NONE, s_constructor.getMaxVars());
            ahVar[0] = xString.makeHandle(constStore.getPath());
            ahVar[1] = new ObjectHandle.ConstantHandle(constStore.getValue());
            return this.proceedConstruction(frame, s_constructor, true, hStruct, ahVar, -1);
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "loadFile": {
                ObjectHandle.ConstantHandle hNode = (ObjectHandle.ConstantHandle)hArg;
                FSNodeConstant constNode = (FSNodeConstant)hNode.getConstant();
                xArray.ArrayHandle hBinary = xArray.makeByteArrayHandle(constNode.getFileBytes(), xArray.Mutability.Constant);
                return frame.assignValue(iReturn, hBinary);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "loadNode": {
                ObjectHandle.ConstantHandle hNode = (ObjectHandle.ConstantHandle)ahArg[0];
                FSNodeConstant constNode = (FSNodeConstant)hNode.getConstant();
                ObjectHandle[] ahValue = new ObjectHandle[]{xBoolean.makeHandle(constNode.getFormat() == Constant.Format.FSDir), xString.makeHandle(constNode.getName()), frame.getConstHandle(constNode.getCreatedConstant()), frame.getConstHandle(constNode.getModifiedConstant()), xInt64.makeHandle(xCPFileStore.calcSize(constNode))};
                return new Utils.AssignValues(aiReturn, ahValue).proceed(frame);
            }
            case "loadDirectory": {
                ObjectHandle.ConstantHandle hNode = (ObjectHandle.ConstantHandle)ahArg[0];
                FSNodeConstant constNode = (FSNodeConstant)hNode.getConstant();
                FSNodeConstant[] aNodes = constNode.getDirectoryContents();
                int cNodes = aNodes.length;
                xString.StringHandle[] ahNames = new xString.StringHandle[cNodes];
                ObjectHandle[] ahCookies = new ObjectHandle[cNodes];
                for (int i = 0; i < cNodes; ++i) {
                    FSNodeConstant constEach = aNodes[i];
                    ahNames[i] = xString.makeHandle(constEach.getName());
                    ahCookies[i] = new ObjectHandle.ConstantHandle(constEach);
                }
                return frame.assignValues(aiReturn, xArray.makeStringArrayHandle(ahNames), xArray.makeObjectArrayHandle(ahCookies, xArray.Mutability.Constant));
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    static long calcSize(FSNodeConstant node) {
        switch (node.getFormat()) {
            case FSDir: {
                long lSum = 0L;
                for (FSNodeConstant nodeSub : node.getDirectoryContents()) {
                    lSum += xCPFileStore.calcSize(nodeSub);
                }
                return lSum;
            }
            case FSFile: {
                return node.getFileBytes().length;
            }
            case FSLink: {
                return xCPFileStore.calcSize(node.getLinkTarget());
            }
        }
        throw new IllegalStateException();
    }
}

