/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.fs;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.fs.xOSFileNode;
import org.xvm.runtime.template.xBoolean;

public class xOSDirectory
extends xOSFileNode {
    public static xOSDirectory INSTANCE;
    private static MethodStructure s_constructor;

    public xOSDirectory(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("deleteRecursively", null, null);
        this.markNativeMethod("watchRecursively", null, null);
        this.invalidateTypeInfo();
        s_constructor = this.getStructure().findConstructor(new TypeConstant[0]);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        xOSFileNode.NodeHandle hNode = (xOSFileNode.NodeHandle)hTarget;
        switch (method.getName()) {
            case "watchRecursively": {
                throw new UnsupportedOperationException("watchRecursively");
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        xOSFileNode.NodeHandle hNode = (xOSFileNode.NodeHandle)hTarget;
        switch (method.getName()) {
            case "deleteRecursively": {
                Path pathDir = hNode.f_path;
                File file = pathDir.toFile();
                if (!file.isDirectory()) {
                    return frame.assignValue(iReturn, xBoolean.FALSE);
                }
                try {
                    Files.walkFileTree(pathDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    return frame.assignValue(iReturn, xBoolean.TRUE);
                }
                catch (IOException e) {
                    return xOSDirectory.raisePathException(frame, e, hNode.f_path);
                }
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    public int createHandle(Frame frame, ObjectHandle hOSStore, Path path, int iReturn) {
        TypeComposition clz = this.ensureClass(frame.f_context.f_container, this.getCanonicalType(), frame.poolContext().typeDirectory());
        xOSFileNode.NodeHandle hStruct = new xOSFileNode.NodeHandle(clz.ensureAccess(Constants.Access.STRUCT), path.toAbsolutePath(), hOSStore);
        ObjectHandle[] ahVar = Utils.ensureSize(Utils.OBJECTS_NONE, s_constructor.getMaxVars());
        return this.proceedConstruction(frame, s_constructor, true, hStruct, ahVar, iReturn);
    }
}

