/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.fs.xOSFileNode;
import org.xvm.runtime.template._native.fs.xRawOSFileChannel;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xByteArray;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.util.Handy;

public class xOSFile
extends xOSFileNode {
    public static xOSFile INSTANCE;
    private static final OpenOption[] NO_ACCESS;
    private static final OpenOption[] READ_ONLY;
    private static final OpenOption[] WRITE_ONLY;
    private static final OpenOption[] READ_WRITE;
    private static MethodStructure s_constructor;

    public xOSFile(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("contents");
        this.markNativeMethod("readImpl", null, BYTES);
        this.markNativeMethod("truncateImpl", null, VOID);
        this.markNativeMethod("appendBytes", null, VOID);
        this.markNativeMethod("appendFile", null, VOID);
        this.markNativeMethod("openImpl", null, null);
        this.invalidateTypeInfo();
        s_constructor = this.getStructure().findConstructor(new TypeConstant[0]);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        xOSFileNode.NodeHandle hFile = (xOSFileNode.NodeHandle)hTarget;
        switch (sPropName) {
            case "contents": {
                return this.getPropertyContents(frame, hFile, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeSet(Frame frame, ObjectHandle hTarget, String sPropName, ObjectHandle hValue) {
        xOSFileNode.NodeHandle hFile = (xOSFileNode.NodeHandle)hTarget;
        switch (sPropName) {
            case "contents": {
                return this.setPropertyContents(frame, hFile, (xArray.ArrayHandle)hValue);
            }
        }
        return super.invokeNativeSet(frame, hTarget, sPropName, hValue);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        xOSFileNode.NodeHandle hFile = (xOSFileNode.NodeHandle)hTarget;
        switch (method.getName()) {
            case "readImpl": {
                ObjectHandle.GenericHandle hRange = (ObjectHandle.GenericHandle)hArg;
                long ixLower = ((ObjectHandle.JavaLong)hRange.getField(frame, "lowerBound")).getValue();
                long ixUpper = ((ObjectHandle.JavaLong)hRange.getField(frame, "upperBound")).getValue();
                boolean fExLower = ((xBoolean.BooleanHandle)hRange.getField(frame, "lowerExclusive")).get();
                boolean fExUpper = ((xBoolean.BooleanHandle)hRange.getField(frame, "upperExclusive")).get();
                if (fExLower) {
                    ++ixLower;
                }
                if (ixLower < 0L) {
                    return frame.raiseException(xException.outOfBounds(frame, ixLower, 0L));
                }
                if (fExUpper) {
                    --ixUpper;
                }
                return ixUpper > ixLower ? this.invokeReadImpl(frame, hFile, ixLower, ixUpper, iReturn) : frame.assignValue(iReturn, xArray.ensureEmptyByteArray());
            }
            case "appendBytes": {
                return this.invokeAppendBytes(frame, hFile, (xArray.ArrayHandle)hArg);
            }
            case "appendFile": {
                return this.invokeAppendFile(frame, hFile, (xOSFileNode.NodeHandle)hArg);
            }
            case "truncateImpl": {
                return this.invokeTruncateImpl(frame, hFile, (ObjectHandle.JavaLong)hArg);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        xOSFileNode.NodeHandle hFile = (xOSFileNode.NodeHandle)hTarget;
        switch (method.getName()) {
            case "openImpl": {
                return this.invokeOpen(frame, hFile, ahArg, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    public int createHandle(Frame frame, ObjectHandle hOSStore, Path path, int iReturn) {
        TypeComposition clz = this.ensureClass(frame.f_context.f_container, this.getCanonicalType(), frame.poolContext().typeFile());
        xOSFileNode.NodeHandle hStruct = new xOSFileNode.NodeHandle(clz.ensureAccess(Constants.Access.STRUCT), path.toAbsolutePath(), hOSStore);
        ObjectHandle[] ahVar = Utils.ensureSize(Utils.OBJECTS_NONE, s_constructor.getMaxVars());
        return this.proceedConstruction(frame, s_constructor, true, hStruct, ahVar, iReturn);
    }

    private int getPropertyContents(Frame frame, xOSFileNode.NodeHandle hFile, int iReturn) {
        Path path = hFile.f_path;
        Callable<byte[]> task = () -> Handy.readFileBytes(path.toFile());
        CompletableFuture<byte[]> cfRead = frame.f_context.f_container.scheduleIO(task);
        Frame.Continuation continuation = frameCaller -> {
            try {
                return frameCaller.assignValue(iReturn, xArray.makeByteArrayHandle((byte[])cfRead.get(), xArray.Mutability.Constant));
            }
            catch (Throwable e) {
                return xOSFile.raisePathException(frameCaller, e, path);
            }
        };
        return frame.waitForIO(cfRead, continuation);
    }

    private int setPropertyContents(Frame frame, xOSFileNode.NodeHandle hFile, xArray.ArrayHandle hValue) {
        Path path = hFile.f_path;
        byte[] ab = xByteArray.getBytes(hValue);
        Callable<Void> task = () -> {
            try (FileOutputStream out = new FileOutputStream(path.toFile());){
                ((OutputStream)out).write(ab);
                Void void_ = null;
                return void_;
            }
        };
        CompletableFuture<Void> cfWrite = frame.f_context.f_container.scheduleIO(task);
        Frame.Continuation continuation = frameCaller -> {
            try {
                cfWrite.get();
                return -1;
            }
            catch (Throwable e) {
                return xOSFile.raisePathException(frameCaller, e, path);
            }
        };
        return frame.waitForIO(cfWrite, continuation);
    }

    private int invokeReadImpl(Frame frame, xOSFileNode.NodeHandle hFile, long ixFrom, long ixTo, int iReturn) {
        Path path = hFile.f_path;
        long cSize = path.toFile().length();
        if (ixTo >= cSize) {
            return frame.raiseException(xException.outOfBounds(frame, ixTo, cSize));
        }
        int cbCapacity = (int)(ixTo - ixFrom + 1L);
        ByteBuffer buffer = ByteBuffer.allocate(cbCapacity);
        Callable<Integer> task = () -> {
            try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
                Integer n = channel.read(buffer, ixFrom);
                return n;
            }
        };
        CompletableFuture<Integer> cfRead = frame.f_context.f_container.scheduleIO(task);
        Frame.Continuation continuation = frameCaller -> {
            try {
                if ((Integer)cfRead.get() == cbCapacity) {
                    return frameCaller.assignValue(iReturn, xArray.makeByteArrayHandle(buffer.array(), xArray.Mutability.Constant));
                }
                return frameCaller.raiseException(xException.ioException(frameCaller, "Read failed"));
            }
            catch (Throwable e) {
                return xOSFile.raisePathException(frameCaller, e, path);
            }
        };
        return frame.waitForIO(cfRead, continuation);
    }

    private int invokeTruncateImpl(Frame frame, xOSFileNode.NodeHandle hFile, ObjectHandle.JavaLong hNewSize) {
        Path path = hFile.f_path;
        File file = path.toFile();
        long cOld = file.length();
        long cNew = hNewSize.getValue();
        if (cNew < 0L) {
            cNew += cOld;
        }
        if (cNew > cOld || cNew < 0L) {
            return frame.raiseException(xException.outOfBounds(frame, cNew, cOld));
        }
        long cTruncate = cNew;
        Callable<Void> task = () -> {
            try (FileChannel channel = cTruncate == 0L ? FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING) : FileChannel.open(path, StandardOpenOption.WRITE);){
                if (cTruncate > 0L) {
                    channel.truncate(cTruncate);
                }
                Void void_ = null;
                return void_;
            }
        };
        CompletableFuture<Void> cfTruncate = frame.f_context.f_container.scheduleIO(task);
        Frame.Continuation continuation = frameCaller -> {
            try {
                cfTruncate.get();
                return -1;
            }
            catch (Throwable e) {
                return xOSFile.raisePathException(frameCaller, e, path);
            }
        };
        return frame.waitForIO(cfTruncate, continuation);
    }

    private int invokeAppendBytes(Frame frame, xOSFileNode.NodeHandle hFile, xArray.ArrayHandle hContents) {
        Path path = hFile.f_path;
        byte[] ab = xByteArray.getBytes(hContents);
        Callable<Void> task = () -> {
            try (FileOutputStream out = new FileOutputStream(path.toFile(), true);){
                ((OutputStream)out).write(ab);
                Void void_ = null;
                return void_;
            }
        };
        CompletableFuture<Void> cfAppend = frame.f_context.f_container.scheduleIO(task);
        Frame.Continuation continuation = frameCaller -> {
            try {
                cfAppend.get();
                return -1;
            }
            catch (Throwable e) {
                return xOSFile.raisePathException(frameCaller, e, path);
            }
        };
        return frame.waitForIO(cfAppend, continuation);
    }

    private int invokeAppendFile(Frame frame, xOSFileNode.NodeHandle hFileThis, xOSFileNode.NodeHandle hFileThat) {
        Path pathThis = hFileThis.f_path;
        Path pathThat = hFileThat.f_path;
        Callable<Void> task = () -> {
            try (FileInputStream in = new FileInputStream(pathThat.toFile());){
                Void void_;
                try (FileOutputStream out = new FileOutputStream(pathThis.toFile(), true);){
                    int cb;
                    byte[] ab = new byte[1024];
                    while ((cb = ((InputStream)in).read(ab)) != -1) {
                        ((OutputStream)out).write(ab, 0, cb);
                    }
                    void_ = null;
                }
                return void_;
            }
        };
        CompletableFuture<Void> cfAppend = frame.f_context.f_container.scheduleIO(task);
        Frame.Continuation continuation = frameCaller -> {
            try {
                cfAppend.get();
                return -1;
            }
            catch (Throwable e) {
                return xOSFile.raisePathException(frameCaller, e, pathThis);
            }
        };
        return frame.waitForIO(cfAppend, continuation);
    }

    private int invokeOpen(Frame frame, xOSFileNode.NodeHandle hFile, ObjectHandle[] ahArg, int iReturn) {
        ReadOption optRead;
        ObjectHandle hReadOption = ahArg[0];
        ObjectHandle hWriteOption = ahArg[1];
        OpenOption[] aOpenOpt = NO_ACCESS;
        ReadOption readOption = optRead = hReadOption == ObjectHandle.DEFAULT ? ReadOption.Read : ReadOption.values()[((xEnum.EnumHandle)hReadOption).getOrdinal()];
        if (hWriteOption == ObjectHandle.DEFAULT) {
            switch (optRead.ordinal()) {
                case 0: {
                    aOpenOpt = WRITE_ONLY;
                    break;
                }
                case 1: {
                    aOpenOpt = READ_WRITE;
                    break;
                }
                case 2: {
                    return frame.raiseException(xException.notImplemented(frame, "ReadOption.Exclusive"));
                }
            }
        } else {
            ObjectHandle[] ahWriteOpt;
            xArray.ArrayHandle haWriteOpt = (xArray.ArrayHandle)hWriteOption;
            try {
                ahWriteOpt = haWriteOpt.getTemplate().toArray(frame, haWriteOpt);
            }
            catch (ObjectHandle.ExceptionHandle.WrapperException e) {
                return frame.raiseException(e);
            }
            int cWriteOpts = ahWriteOpt.length;
            if (cWriteOpts == 0) {
                switch (optRead.ordinal()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        aOpenOpt = READ_ONLY;
                        break;
                    }
                    case 2: {
                        return frame.raiseException(xException.notImplemented(frame, "ReadOption.Exclusive"));
                    }
                }
            } else {
                ArrayList<StandardOpenOption> listOpt = new ArrayList<StandardOpenOption>(cWriteOpts);
                switch (optRead.ordinal()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        listOpt.add(StandardOpenOption.READ);
                        break;
                    }
                    case 2: {
                        return frame.raiseException(xException.notImplemented(frame, "ReadOption.Exclusive"));
                    }
                }
                listOpt.add(StandardOpenOption.WRITE);
                block31: for (ObjectHandle objectHandle : ahWriteOpt) {
                    xEnum.EnumHandle hWrite = (xEnum.EnumHandle)objectHandle;
                    WriteOption optWrite = WriteOption.values()[hWrite.getOrdinal()];
                    switch (optWrite.ordinal()) {
                        case 0: {
                            continue block31;
                        }
                        case 1: {
                            listOpt.add(StandardOpenOption.CREATE);
                            continue block31;
                        }
                        case 2: {
                            listOpt.add(StandardOpenOption.CREATE_NEW);
                            continue block31;
                        }
                        case 3: {
                            listOpt.add(StandardOpenOption.SPARSE);
                            continue block31;
                        }
                        case 4: {
                            listOpt.add(StandardOpenOption.DELETE_ON_CLOSE);
                            continue block31;
                        }
                        case 5: {
                            listOpt.add(StandardOpenOption.TRUNCATE_EXISTING);
                            continue block31;
                        }
                        case 6: {
                            listOpt.add(StandardOpenOption.APPEND);
                            continue block31;
                        }
                        case 7: {
                            return frame.raiseException(xException.notImplemented(frame, "WriteOption.Exclusive"));
                        }
                        case 8: {
                            listOpt.add(StandardOpenOption.DSYNC);
                            continue block31;
                        }
                        case 9: {
                            listOpt.add(StandardOpenOption.SYNC);
                        }
                    }
                }
                aOpenOpt = listOpt.toArray(NO_ACCESS);
            }
        }
        Path path = hFile.f_path;
        try {
            FileChannel channel = FileChannel.open(path, aOpenOpt);
            return xRawOSFileChannel.INSTANCE.createHandle(frame, channel, path, iReturn);
        }
        catch (IOException e) {
            return xOSFile.raisePathException(frame, e, path);
        }
    }

    static {
        NO_ACCESS = new OpenOption[0];
        READ_ONLY = new OpenOption[]{StandardOpenOption.READ};
        WRITE_ONLY = new OpenOption[]{StandardOpenOption.WRITE};
        READ_WRITE = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
    }

    private static enum ReadOption {
        NoRead,
        Read,
        Exclusive;

    }

    private static enum WriteOption {
        Write,
        Ensure,
        Create,
        Sparse,
        Temp,
        Truncate,
        Append,
        Exclusive,
        SyncData,
        SyncAll;

    }
}

