/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.fs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ExecutionException;
import org.xvm.asm.ClassStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.fs.xOSDirectory;
import org.xvm.runtime.template._native.fs.xOSFile;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;

public class xOSFileNode
extends xConst {
    public xOSFileNode(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
    }

    @Override
    public void initNative() {
        this.markNativeProperty("pathString");
        this.markNativeProperty("exists");
        this.markNativeProperty("readable");
        this.markNativeProperty("writable");
        this.markNativeProperty("createdMillis");
        this.markNativeProperty("accessedMillis");
        this.markNativeProperty("modifiedMillis");
        this.markNativeProperty("size");
        this.invalidateTypeInfo();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        NodeHandle hNode = (NodeHandle)hTarget;
        switch (sPropName) {
            case "pathString": {
                return frame.assignValue(iReturn, xString.makeHandle(hNode.f_path.toString()));
            }
            case "exists": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(hNode.f_path.toFile().exists()));
            }
            case "readable": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(hNode.f_path.toFile().canRead()));
            }
            case "writable": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(hNode.f_path.toFile().canWrite()));
            }
            case "createdMillis": {
                try {
                    BasicFileAttributes attr = Files.readAttributes(hNode.f_path, BasicFileAttributes.class, new LinkOption[0]);
                    return frame.assignValue(iReturn, xInt64.makeHandle(attr.creationTime().toMillis()));
                }
                catch (IOException e) {
                    return xOSFileNode.raisePathException(frame, e, hNode.f_path);
                }
            }
            case "accessedMillis": {
                try {
                    BasicFileAttributes attr = Files.readAttributes(hNode.f_path, BasicFileAttributes.class, new LinkOption[0]);
                    return frame.assignValue(iReturn, xInt64.makeHandle(attr.lastAccessTime().toMillis()));
                }
                catch (IOException e) {
                    return xOSFileNode.raisePathException(frame, e, hNode.f_path);
                }
            }
            case "modifiedMillis": {
                try {
                    BasicFileAttributes attr = Files.readAttributes(hNode.f_path, BasicFileAttributes.class, new LinkOption[0]);
                    return frame.assignValue(iReturn, xInt64.makeHandle(attr.lastModifiedTime().toMillis()));
                }
                catch (IOException e) {
                    return xOSFileNode.raisePathException(frame, e, hNode.f_path);
                }
            }
            case "size": {
                try {
                    Path path = hNode.f_path;
                    if (Files.exists(path, new LinkOption[0])) {
                        BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                        return frame.assignValue(iReturn, xInt64.makeHandle(attr.size()));
                    }
                    return frame.assignValue(iReturn, xInt64.makeHandle(0L));
                }
                catch (IOException e) {
                    return xOSFileNode.raisePathException(frame, e, hNode.f_path);
                }
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    static int createHandle(Frame frame, ObjectHandle hOSStore, Path path, boolean fDir, int iReturn) {
        return fDir ? xOSDirectory.INSTANCE.createHandle(frame, hOSStore, path, iReturn) : xOSFile.INSTANCE.createHandle(frame, hOSStore, path, iReturn);
    }

    public static int raisePathException(Frame frame, Throwable e, Path path) {
        ExecutionException ee;
        if (e instanceof ExecutionException && (e = (ee = (ExecutionException)e).getCause()) instanceof IOException) {
            IOException ioe = (IOException)e;
            return xOSFileNode.raisePathException(frame, ioe, path);
        }
        return frame.raiseException(e.getMessage());
    }

    public static int raisePathException(Frame frame, IOException e, Path path) {
        Class<?> clzException = e.getClass();
        String sException = clzException == IOException.class ? "" : clzException.getSimpleName().replace("Exception", "") + ": ";
        return frame.raiseException(xException.pathException(frame, sException + e.getMessage(), xNullable.NULL));
    }

    public static class NodeHandle
    extends ObjectHandle.GenericHandle {
        protected final Path f_path;

        protected NodeHandle(TypeComposition clazz, Path path, ObjectHandle hOSStore) {
            super(clazz);
            this.f_path = path;
            this.setField(null, "store", hOSStore);
        }

        public Path getPath() {
            return this.f_path;
        }

        @Override
        public String toString() {
            return super.toString() + " " + String.valueOf(this.f_path);
        }
    }
}

