/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.fs.xOSFileNode;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;

public class xOSFileStore
extends ClassTemplate {
    private static final File ROOT = new File("/");

    public xOSFileStore(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
    }

    @Override
    public void initNative() {
        this.markNativeProperty("capacity");
        this.markNativeProperty("bytesFree");
        this.markNativeProperty("bytesUsed");
        this.markNativeMethod("dirFor", STRING, null);
        this.markNativeMethod("fileFor", STRING, null);
        this.markNativeMethod("linkAsFile", STRING, null);
        this.markNativeMethod("copyOrMove", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    protected int postValidate(Frame frame, ObjectHandle hStruct) {
        hStruct.makeImmutable();
        return -1;
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        switch (sPropName) {
            case "capacity": {
                return frame.assignValue(iReturn, xInt64.makeHandle(ROOT.getTotalSpace()));
            }
            case "bytesFree": {
                return frame.assignValue(iReturn, xInt64.makeHandle(ROOT.getFreeSpace()));
            }
            case "bytesUsed": {
                return frame.assignValue(iReturn, xInt64.makeHandle(ROOT.getTotalSpace() - ROOT.getFreeSpace()));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "dirFor": {
                xString.StringHandle hPathString = (xString.StringHandle)hArg;
                try {
                    Path path = Paths.get(hPathString.getStringValue(), new String[0]);
                    return xOSFileNode.createHandle(frame, hTarget, path, true, iReturn);
                }
                catch (InvalidPathException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
            }
            case "fileFor": {
                xString.StringHandle hPathString = (xString.StringHandle)hArg;
                try {
                    Path path = Paths.get(hPathString.getStringValue(), new String[0]);
                    return xOSFileNode.createHandle(frame, hTarget, path, false, iReturn);
                }
                catch (InvalidPathException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "copyOrMove": {
                ObjectHandle hSrc = ahArg[0];
                String sSrc = ((xString.StringHandle)ahArg[1]).getStringValue();
                ObjectHandle hDest = ahArg[2];
                String sDest = ((xString.StringHandle)ahArg[3]).getStringValue();
                boolean fMove = ((xBoolean.BooleanHandle)ahArg[4]).get();
                try {
                    Path pathSrc = Paths.get(sSrc, new String[0]);
                    boolean fDir = Files.isDirectory(pathSrc, new LinkOption[0]);
                    if (Files.notExists(pathSrc, new LinkOption[0])) {
                        return frame.raiseException(xException.fileNotFoundException(frame, "Could not find file or directory: " + sSrc, hSrc));
                    }
                    Path pathDest = Paths.get(sDest, new String[0]);
                    if (Files.exists(pathDest, new LinkOption[0]) && !Files.isDirectory(pathDest, new LinkOption[0])) {
                        return frame.raiseException(xException.fileAlreadyExistsException(frame, "Could not overwrite file or directory: " + sDest, hDest));
                    }
                    Path pathResult = fMove ? Files.move(pathSrc, pathDest, new CopyOption[0]) : Files.copy(pathSrc, pathDest, new CopyOption[0]);
                    return xOSFileNode.createHandle(frame, hTarget, pathResult, fDir, iReturn);
                }
                catch (FileNotFoundException | NoSuchFileException e) {
                    return frame.raiseException(xException.fileNotFoundException(frame, e.getMessage(), hSrc));
                }
                catch (FileAlreadyExistsException e) {
                    return frame.raiseException(xException.fileAlreadyExistsException(frame, e.getMessage(), hDest));
                }
                catch (SecurityException | AccessDeniedException e) {
                    return frame.raiseException(xException.accessDeniedException(frame, e.getMessage(), hDest));
                }
                catch (IOException | InvalidPathException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "linkAsFile": {
                xString.StringHandle hPathString = (xString.StringHandle)ahArg[0];
                try {
                    Path path = Paths.get(hPathString.getStringValue(), new String[0]);
                    if (Files.isSymbolicLink(path)) {
                        System.err.println("*** File is a link: " + String.valueOf(path));
                    }
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                catch (InvalidPathException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }
}

