/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.fs;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.NativeContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.fs.xOSDirectory;
import org.xvm.runtime.template._native.fs.xOSFileNode;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xService;
import org.xvm.util.Auto;

public class xOSStorage
extends xService {
    private static MethodStructure s_methodOnEvent;
    private static WatchServiceDaemon s_daemonWatch;

    public xOSStorage(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
    }

    @Override
    public void initNative() {
        s_methodOnEvent = this.getStructure().findMethodDeep("onEvent", Utils.ANY);
        this.markNativeProperty("homeDir");
        this.markNativeProperty("curDir");
        this.markNativeProperty("tmpDir");
        this.markNativeMethod("find", new String[]{"_native.fs.OSFileStore", "text.String"}, null);
        this.markNativeMethod("names", STRING, null);
        this.markNativeMethod("createDir", STRING, BOOLEAN);
        this.markNativeMethod("createFile", STRING, BOOLEAN);
        this.markNativeMethod("delete", STRING, BOOLEAN);
        this.markNativeMethod("watch", STRING, VOID);
        this.markNativeMethod("unwatch", STRING, VOID);
        this.markNativeMethod("instance", VOID, THIS);
        this.invalidateTypeInfo();
    }

    @Override
    public int getPropertyValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        if ("fileStore".equals(idProp.getName())) {
            return frame.assignValue(iReturn, ((xService.ServiceHandle)hTarget).getField(frame, "fileStore"));
        }
        return super.getPropertyValue(frame, hTarget, idProp, iReturn);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        xService.ServiceHandle hStorage = (xService.ServiceHandle)hTarget;
        ObjectHandle hStore = hStorage.getField(frame, "fileStore");
        switch (sPropName) {
            case "homeDir": {
                return xOSDirectory.INSTANCE.createHandle(frame, hStore, Paths.get(System.getProperty("user.home"), new String[0]), iReturn);
            }
            case "curDir": {
                return xOSDirectory.INSTANCE.createHandle(frame, hStore, Paths.get(System.getProperty("user.dir"), new String[0]), iReturn);
            }
            case "tmpDir": {
                return xOSDirectory.INSTANCE.createHandle(frame, hStore, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        xService.ServiceHandle hStorage = (xService.ServiceHandle)hTarget;
        if (frame.f_context != hStorage.f_context) {
            return xRTFunction.makeAsyncNativeHandle(method).call1(frame, hTarget, new ObjectHandle[]{hArg}, iReturn);
        }
        switch (method.getName()) {
            case "names": {
                xString.StringHandle hPathString = (xString.StringHandle)hArg;
                try {
                    Path path = Paths.get(hPathString.getStringValue(), new String[0]);
                    String[] asName = path.toFile().list();
                    int cNames = asName == null ? 0 : asName.length;
                    return cNames == 0 ? frame.assignValue(iReturn, xString.ensureEmptyArray()) : frame.assignValue(iReturn, xString.makeArrayHandle(asName));
                }
                catch (InvalidPathException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
            }
            case "createFile": {
                xString.StringHandle hPathString = (xString.StringHandle)hArg;
                try {
                    Path path = Paths.get(hPathString.getStringValue(), new String[0]);
                    if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                        return frame.assignValue(iReturn, xBoolean.FALSE);
                    }
                    return frame.assignValue(iReturn, xBoolean.makeHandle(path.toFile().createNewFile()));
                }
                catch (IOException | InvalidPathException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
            }
            case "createDir": {
                xString.StringHandle hPathString = (xString.StringHandle)hArg;
                try {
                    Path path = Paths.get(hPathString.getStringValue(), new String[0]);
                    if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                        return frame.assignValue(iReturn, xBoolean.FALSE);
                    }
                    return frame.assignValue(iReturn, xBoolean.makeHandle(path.toFile().mkdirs()));
                }
                catch (InvalidPathException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
            }
            case "delete": {
                xString.StringHandle hPathString = (xString.StringHandle)hArg;
                Path path = Paths.get(hPathString.getStringValue(), new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    return frame.assignValue(iReturn, xBoolean.FALSE);
                }
                return frame.assignValue(iReturn, xBoolean.makeHandle(path.toFile().delete()));
            }
            case "watch": {
                xString.StringHandle hPathStringDir = (xString.StringHandle)hArg;
                try {
                    Path pathDir = Paths.get(hPathStringDir.getStringValue(), new String[0]);
                    xOSStorage.ensureWatchDaemon(this.pool()).register(pathDir, hStorage);
                    return -1;
                }
                catch (IOException | InvalidPathException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        xService.ServiceHandle hStorage = (xService.ServiceHandle)hTarget;
        if (hStorage != null && frame.f_context != hStorage.f_context) {
            return xRTFunction.makeAsyncNativeHandle(method).call1(frame, hTarget, ahArg, iReturn);
        }
        switch (method.getName()) {
            case "instance": {
                return frame.assignValue(iReturn, ((NativeContainer)this.f_container).ensureOSStorage(frame, null));
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        xService.ServiceHandle hStorage = (xService.ServiceHandle)hTarget;
        if (frame.f_context != hStorage.f_context) {
            return xRTFunction.makeAsyncNativeHandle(method).callN(frame, hTarget, ahArg, aiReturn);
        }
        switch (method.getName()) {
            case "find": {
                ObjectHandle hStore = ahArg[0];
                xString.StringHandle hPathString = (xString.StringHandle)ahArg[1];
                try {
                    Path path = Paths.get(hPathString.getStringValue(), new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        return Utils.assignConditionalResult(frame, xOSFileNode.createHandle(frame, hStore, path, Files.isDirectory(path, new LinkOption[0]), -1), aiReturn);
                    }
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                catch (InvalidPathException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    protected static synchronized WatchServiceDaemon ensureWatchDaemon(ConstantPool pool) {
        WatchServiceDaemon daemonWatch = s_daemonWatch;
        if (daemonWatch == null) {
            try {
                daemonWatch = s_daemonWatch = new WatchServiceDaemon(pool);
                daemonWatch.start();
            }
            catch (IOException e) {
                return null;
            }
        }
        return daemonWatch;
    }

    protected static class WatchServiceDaemon
    extends Thread {
        private final ConstantPool f_pool;
        private final Map<WatchKey, WatchContext> f_mapWatches;
        private final WatchService f_service;

        public WatchServiceDaemon(ConstantPool pool) throws IOException {
            super("WatchServiceDaemon");
            this.setDaemon(true);
            this.f_pool = pool;
            this.f_service = FileSystems.getDefault().newWatchService();
            this.f_mapWatches = new ConcurrentHashMap<WatchKey, WatchContext>();
        }

        public void register(Path pathDir, xService.ServiceHandle hStorage) throws IOException {
            WatchKey key = pathDir.register(this.f_service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.f_mapWatches.put(key, new WatchContext(pathDir, hStorage));
        }

        @Override
        public void run() {
            try {
                Auto ignore = ConstantPool.withPool(this.f_pool);
                try {
                    while (true) {
                        this.processKey(this.f_service.take());
                    }
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        protected void processKey(WatchKey key) {
            if (key == null) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                int iKind = this.getKindId(event.kind());
                if (iKind < 0) continue;
                WatchContext context = this.f_mapWatches.get(key);
                Path pathDir = context.pathDir;
                Path pathRelative = (Path)event.context();
                Path pathAbsolute = pathDir.resolve(pathRelative);
                xRTFunction.FunctionHandle hfnOnEvent = xRTFunction.makeInternalHandle(null, s_methodOnEvent).bindTarget(null, context.hStorage);
                xString.StringHandle hPathDir = xString.makeHandle(pathDir.toString());
                xString.StringHandle hPathNode = xString.makeHandle(pathAbsolute.toString());
                ObjectHandle[] ahArg = new ObjectHandle[]{hPathDir, hPathNode, xBoolean.TRUE, xInt64.makeHandle(iKind)};
                context.hStorage.f_context.callLater(hfnOnEvent, ahArg);
            }
            key.reset();
        }

        private int getKindId(WatchEvent.Kind kind) {
            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                return 0;
            }
            if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                return 1;
            }
            if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                return 2;
            }
            if (kind == StandardWatchEventKinds.OVERFLOW) {
                return -1;
            }
            return -2;
        }

        private record WatchContext(Path pathDir, xService.ServiceHandle hStorage) {
        }
    }
}

