/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.fs.xOSFileNode;
import org.xvm.runtime.template._native.io.xRawChannel;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.xBoolean;

public class xRawOSFileChannel
extends xRawChannel {
    public static xRawOSFileChannel INSTANCE;

    public xRawOSFileChannel(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("size");
        this.markNativeProperty("position");
        this.markNativeMethod("flush", VOID, VOID);
        this.markNativeProperty("readable");
        this.markNativeProperty("writable");
        this.markNativeProperty("closed");
        this.markNativeMethod("take", VOID, null);
        this.markNativeMethod("submit", null, INT);
        this.markNativeMethod("close", VOID, VOID);
        super.initNative();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        ChannelHandle hChannel = (ChannelHandle)hTarget;
        switch (sPropName) {
            case "size": {
                try {
                    return frame.assignValue(iReturn, xInt64.makeHandle(hChannel.f_channel.size()));
                }
                catch (IOException e) {
                    return xOSFileNode.raisePathException(frame, e, hChannel.f_path);
                }
            }
            case "position": {
                try {
                    return frame.assignValue(iReturn, xInt64.makeHandle(hChannel.f_channel.position()));
                }
                catch (IOException e) {
                    return xOSFileNode.raisePathException(frame, e, hChannel.f_path);
                }
            }
            case "readable": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(hChannel.f_channel instanceof ReadableByteChannel));
            }
            case "writable": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(hChannel.f_channel instanceof WritableByteChannel));
            }
            case "closed": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(!hChannel.f_channel.isOpen()));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeSet(Frame frame, ObjectHandle hTarget, String sPropName, ObjectHandle hValue) {
        ChannelHandle hChannel = (ChannelHandle)hTarget;
        switch (sPropName) {
            case "size": {
                try {
                    long cSize = ((ObjectHandle.JavaLong)hValue).getValue();
                    hChannel.f_channel.truncate(cSize);
                    return -1;
                }
                catch (IOException e) {
                    return xOSFileNode.raisePathException(frame, e, hChannel.f_path);
                }
            }
            case "position": {
                try {
                    long nPosition = ((ObjectHandle.JavaLong)hValue).getValue();
                    hChannel.f_channel.position(nPosition);
                    return -1;
                }
                catch (IOException e) {
                    return xOSFileNode.raisePathException(frame, e, hChannel.f_path);
                }
            }
        }
        return super.invokeNativeSet(frame, hTarget, sPropName, hValue);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        ChannelHandle hChannel = (ChannelHandle)hTarget;
        switch (method.getName()) {
            case "take": {
                return this.invokeTake(frame, hChannel, iReturn);
            }
            case "submit": {
                return this.invokeSubmit(frame, hChannel, ahArg, iReturn);
            }
            case "flush": {
                try {
                    hChannel.f_channel.force(false);
                    return -1;
                }
                catch (IOException e) {
                    return xOSFileNode.raisePathException(frame, e, hChannel.f_path);
                }
            }
            case "close": {
                try {
                    hChannel.f_channel.close();
                    return -1;
                }
                catch (IOException e) {
                    return xOSFileNode.raisePathException(frame, e, hChannel.f_path);
                }
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    protected int invokeTake(Frame frame, ChannelHandle hChannel, int iReturn) {
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        Callable<Integer> task = () -> {
            try {
                return hChannel.f_channel.read(buffer);
            }
            catch (NonReadableChannelException e) {
                return -2;
            }
            catch (ClosedChannelException e) {
                return -3;
            }
        };
        CompletableFuture<Integer> cfRead = frame.f_context.f_container.scheduleIO(task);
        Frame.Continuation continuation = frameCaller -> {
            try {
                int cbRead = (Integer)cfRead.get();
                return frameCaller.assignValue(iReturn, cbRead < 0 ? xInt64.makeHandle(-1L) : xArray.makeByteArrayHandle(buffer.array(), cbRead, xArray.Mutability.Constant));
            }
            catch (InterruptedException | ExecutionException e) {
                return xOSFileNode.raisePathException(frameCaller, e, hChannel.f_path);
            }
        };
        return frame.waitForIO(cfRead, continuation);
    }

    protected int invokeSubmit(Frame frame, ChannelHandle hChannel, ObjectHandle[] ahArg, int iReturn) {
        if (!hChannel.f_channel.isOpen()) {
            return frame.assignValue(iReturn, xInt64.makeHandle(-1L));
        }
        xArray.ArrayHandle hArray = (xArray.ArrayHandle)ahArg[0];
        ObjectHandle.JavaLong hStart = (ObjectHandle.JavaLong)ahArg[1];
        ObjectHandle.JavaLong hEnd = (ObjectHandle.JavaLong)ahArg[2];
        ByteBasedDelegate.ByteArrayHandle hDelegate = (ByteBasedDelegate.ByteArrayHandle)hArray.m_hDelegate;
        int ofStart = (int)hStart.getValue();
        int ofEnd = (int)hEnd.getValue();
        ByteBuffer buffer = ((ByteBasedDelegate)hDelegate.getTemplate()).wrap(hDelegate, ofStart, ofEnd - ofStart);
        Callable<Integer> task = () -> hChannel.f_channel.write(buffer);
        frame.f_context.f_container.scheduleIO(task);
        return frame.assignValue(iReturn, xInt64.makeHandle(0L));
    }

    public int createHandle(Frame frame, FileChannel channel, Path path, int iReturn) {
        if (iReturn == -2) {
            return -1;
        }
        Container container = frame.f_context.f_container;
        ServiceContext context = container.createServiceContext(path.toString());
        ChannelHandle hChannel = new ChannelHandle(this.getCanonicalClass(), context, channel, path.toAbsolutePath());
        int cbPreferredSize = 8192;
        try {
            cbPreferredSize = Math.max(1024, Math.min(cbPreferredSize, (int)channel.size()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        hChannel.setPreferredBufferSize(cbPreferredSize);
        return frame.assignValue(iReturn, hChannel);
    }

    public static class ChannelHandle
    extends xRawChannel.ChannelHandle {
        public final FileChannel f_channel;
        public final Path f_path;

        public ChannelHandle(TypeComposition clazz, ServiceContext context, FileChannel channel, Path path) {
            super(clazz, context);
            this.f_channel = channel;
            this.f_path = path;
        }

        @Override
        public String toString() {
            return super.toString() + " " + String.valueOf(this.f_path);
        }
    }
}

