/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.io;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xService;

public abstract class xRawChannel
extends xService {
    public xRawChannel(Container container, ClassStructure structure) {
        super(container, structure, false);
    }

    @Override
    public void initNative() {
        this.markNativeMethod("allocate", BOOLEAN, null);
        this.markNativeMethod("incRefCount", BYTES, VOID);
        this.markNativeMethod("decRefCount", BYTES, VOID);
        this.invalidateTypeInfo();
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        ChannelHandle hChannel = (ChannelHandle)hTarget;
        switch (method.getName()) {
            case "allocate": {
                return this.invokeAllocate(frame, hChannel, ((xBoolean.BooleanHandle)hArg).get(), iReturn);
            }
            case "incRefCount": {
                return this.invokeUpdateRefCount(frame, hChannel, (xArray.ArrayHandle)hArg, true);
            }
            case "decRefCount": {
                return this.invokeUpdateRefCount(frame, hChannel, (xArray.ArrayHandle)hArg, false);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    protected int invokeAllocate(Frame frame, ChannelHandle hChannel, boolean fInternal, int iReturn) {
        return frame.assignValue(iReturn, xArray.makeByteArrayHandle(new byte[hChannel.m_cPreferredBufferSize], xArray.Mutability.Mutable));
    }

    protected int invokeUpdateRefCount(Frame frame, ChannelHandle hChannel, xArray.ArrayHandle hBuffer, boolean fInc) {
        return -1;
    }

    public static abstract class ChannelHandle
    extends xService.ServiceHandle {
        protected int m_cPreferredBufferSize;

        public ChannelHandle(TypeComposition clazz, ServiceContext context) {
            super(clazz, context);
        }

        public void setPreferredBufferSize(int cb) {
            this.m_cPreferredBufferSize = cb;
        }
    }
}

