/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.io;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.time.Instant;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xService;
import org.xvm.util.ConsoleLog;

public class xTerminalConsole
extends xService {
    public static xTerminalConsole INSTANCE;
    public static final Console CONSOLE;
    public static final BufferedReader CONSOLE_IN;
    public static final PrintWriter CONSOLE_OUT;
    public static final ConsoleLog CONSOLE_LOG;
    public static LineReader READER;
    public static Terminal TERMINAL;
    private static final Frame.Continuation PRINT;
    private static final Frame.Continuation PRINTLN;
    private ObjectHandle m_hConsole;

    public xTerminalConsole(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("print", null, VOID);
        this.markNativeMethod("readLine", null, STRING);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        return this.pool().ensureEcstasyTypeConstant("io.Console");
    }

    public ObjectHandle ensureConsole(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hConsole = this.m_hConsole;
        if (hConsole == null) {
            hConsole = this.m_hConsole = this.createServiceHandle(this.f_container.createServiceContext("Console"), this.getCanonicalClass(), this.getCanonicalType());
            xTerminalConsole.ensureLineReader(frame);
        }
        return hConsole;
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "print": {
                boolean fNewline = ahArg[1] != xBoolean.TRUE;
                ObjectHandle hVal = ahArg[0];
                if (hVal == ObjectHandle.DEFAULT) {
                    if (fNewline) {
                        CONSOLE_OUT.println();
                    }
                    return -1;
                }
                int iResult = Utils.callToString(frame, hVal);
                switch (iResult) {
                    case -1: {
                        return fNewline ? PRINTLN.proceed(frame) : PRINT.proceed(frame);
                    }
                    case -5: {
                        frame.m_frameNext.addContinuation(fNewline ? PRINTLN : PRINT);
                    }
                    case -3: {
                        return iResult;
                    }
                }
            }
            case "readLine": {
                return this.invokeReadLine(frame, ahArg, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    protected int invokeReadLine(Frame frame, ObjectHandle[] ahArg, int iReturn) {
        xString.StringHandle hLine;
        boolean fEcho;
        String string;
        ObjectHandle objectHandle = ahArg[0];
        if (objectHandle instanceof xString.StringHandle) {
            xString.StringHandle hString = (xString.StringHandle)objectHandle;
            string = hString.getStringValue();
        } else {
            string = "";
        }
        String sPrompt = string;
        boolean bl = fEcho = ahArg[1] != xBoolean.TRUE;
        if (READER == null) {
            try {
                if (!sPrompt.isEmpty()) {
                    CONSOLE_OUT.print(sPrompt);
                    CONSOLE_OUT.flush();
                }
                if (fEcho || CONSOLE == null) {
                    String sLine = CONSOLE_IN.readLine();
                    hLine = sLine == null ? xString.EMPTY_STRING : xString.makeHandle(sLine);
                }
                char[] achLine = CONSOLE.readPassword();
                hLine = achLine == null ? xString.EMPTY_STRING : xString.makeHandle(achLine);
            }
            catch (IOException e) {
                return frame.raiseException(xException.obscureIoException(frame, e.getMessage()));
            }
        } else {
            try {
                hLine = xString.makeHandle(READER.readLine(sPrompt, fEcho ? null : Character.valueOf('\u0000')));
            }
            catch (UserInterruptException e) {
                System.exit(0);
                return 0;
            }
        }
        return frame.assignValue(iReturn, hLine);
    }

    public static LineReader ensureLineReader(Frame frame) {
        if (READER == null) {
            try {
                if (CONSOLE != null) {
                    Terminal terminal = TerminalBuilder.builder().build();
                    LineReaderBuilder builder = LineReaderBuilder.builder();
                    builder.terminal(terminal).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).option(LineReader.Option.HISTORY_TIMESTAMPED, false);
                    if (frame != null) {
                        String sTmpDir = System.getProperty("java.io.tmpdir");
                        String sAppName = frame.f_context.f_container.getModule().getName();
                        Path pathHist = Path.of(sTmpDir, sAppName + ".history");
                        LimitedHistory history = new LimitedHistory(pathHist, 100);
                        builder = builder.variable("history-file", pathHist).history(history);
                    }
                    READER = builder.build();
                    TERMINAL = terminal;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return READER;
    }

    static {
        CONSOLE = System.console();
        CONSOLE_LOG = new ConsoleLog();
        CONSOLE_IN = CONSOLE == null || CONSOLE.reader() == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(CONSOLE.reader());
        CONSOLE_OUT = CONSOLE == null || CONSOLE.writer() == null ? new PrintWriter(System.out, true) : CONSOLE.writer();
        PRINT = frameCaller -> {
            char[] ach = ((xString.StringHandle)frameCaller.popStack()).getValue();
            CONSOLE_LOG.log(ach, false);
            CONSOLE_OUT.print(ach);
            CONSOLE_OUT.flush();
            return -1;
        };
        PRINTLN = frameCaller -> {
            char[] ach = ((xString.StringHandle)frameCaller.popStack()).getValue();
            CONSOLE_LOG.log(ach, true);
            CONSOLE_OUT.println(ach);
            CONSOLE_OUT.flush();
            return -1;
        };
    }

    public static class LimitedHistory
    extends DefaultHistory {
        private final Path f_path;
        private final int f_cMaxEntries;

        public LimitedHistory(Path path, int cMaxEntries) {
            this.f_path = path;
            this.f_cMaxEntries = cMaxEntries;
        }

        @Override
        public void add(Instant time, String line) {
            if (this.size() >= this.f_cMaxEntries) {
                try {
                    this.trimHistory(this.f_path, this.f_cMaxEntries - (this.f_cMaxEntries >> 2));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            super.add(time, line);
        }
    }
}

