/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.lang.src;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.DirRepository;
import org.xvm.asm.FileRepository;
import org.xvm.asm.LinkedRepository;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Version;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.BuildRepository;
import org.xvm.compiler.CompilerException;
import org.xvm.compiler.InstantRepository;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.fs.xOSFileNode;
import org.xvm.runtime.template._native.reflect.xRTComponentTemplate;
import org.xvm.runtime.template._native.reflect.xRTFileTemplate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xService;
import org.xvm.tool.Compiler;
import org.xvm.tool.ModuleInfo;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class xRTCompiler
extends xService {
    public static xRTCompiler INSTANCE;
    private static final int[] STACK_2;
    private static MethodConstant GET_MODULE_ID;

    public xRTCompiler(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ClassStructure structRepo = this.f_container.getClassStructure("mgmt.ModuleRepository");
        GET_MODULE_ID = structRepo.findMethod("getModule", 2, new TypeConstant[0]).getIdentityConstant();
        this.markNativeMethod("compileImpl", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        return this.pool().ensureEcstasyTypeConstant("lang.src.Compiler");
    }

    @Override
    public xService.ServiceHandle createServiceHandle(ServiceContext context, ClassComposition clz, TypeConstant typeMask) {
        CompilerHandle hCompiler = new CompilerHandle(clz.maskAs(typeMask), context, new CompilerAdapter());
        context.setService(hCompiler);
        return hCompiler;
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        CompilerHandle hCompiler = (CompilerHandle)hTarget;
        switch (method.getName()) {
            case "compileImpl": {
                try {
                    ObjectHandle hRepo = ahArg[0];
                    xArray.ArrayHandle haSources = (xArray.ArrayHandle)ahArg[1];
                    ObjectHandle[] ahSource = haSources.getTemplate().toArray(frame, haSources);
                    return this.invokeCompileImpl(frame, hCompiler, hRepo, ahSource, aiReturn);
                }
                catch (ObjectHandle.ExceptionHandle.WrapperException e) {
                    return frame.raiseException(e);
                }
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    protected int invokeCompileImpl(Frame frame, CompilerHandle hCompiler, ObjectHandle hRepo, ObjectHandle[] ahSources, int[] aiReturn) {
        CompilerAdapter compiler = hCompiler.fAdapter;
        ArrayList<File> listSources = new ArrayList<File>();
        for (ObjectHandle hSource : ahSources) {
            listSources.add(((xOSFileNode.NodeHandle)hSource).getPath().toFile());
        }
        compiler.setSourceLocations(listSources);
        LinkedRepository repoCore = (LinkedRepository)this.f_container.getModuleRepository();
        ArrayList<ModuleRepository> listNew = new ArrayList<ModuleRepository>();
        listNew.add(new BuildRepository());
        for (ModuleRepository repo : repoCore.asList()) {
            FileRepository repoFile;
            DirRepository repoDir;
            if ((!(repo instanceof DirRepository) || !(repoDir = (DirRepository)repo).isReadOnly()) && (!(repo instanceof FileRepository) || !(repoFile = (FileRepository)repo).isReadOnly())) continue;
            listNew.add(repo);
        }
        compiler.setLibraryRepos(listNew);
        return this.doCompile(frame, compiler, hRepo, null, aiReturn);
    }

    private int doCompile(Frame frame, CompilerAdapter compiler, ObjectHandle hRepo, String sMissingPrev, int[] aiReturn) {
        try {
            String sMissing = compiler.partialCompile(sMissingPrev != null);
            if (sMissing != null) {
                if (sMissing.equals(sMissingPrev) || hRepo == xNullable.NULL) {
                    return this.completeWithError(frame, compiler, sMissing, aiReturn);
                }
                CallChain chain = this.computeGetModuleChain(frame, hRepo);
                switch (chain.invoke(frame, hRepo, (ObjectHandle)xString.makeHandle(sMissing), STACK_2)) {
                    case -1: {
                        return this.popModuleStructure(frame, compiler) ? this.doCompile(frame, compiler, hRepo, sMissing, aiReturn) : this.completeWithError(frame, compiler, sMissing, aiReturn);
                    }
                    case -5: {
                        Frame.Continuation nextStep = frameCaller -> this.popModuleStructure(frameCaller, compiler) ? this.doCompile(frameCaller, compiler, hRepo, sMissing, aiReturn) : this.completeWithError(frameCaller, compiler, sMissing, aiReturn);
                        frame.m_frameNext.addContinuation(nextStep);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            return this.completeCompilation(frame, compiler, null, aiReturn);
        }
        catch (Exception e) {
            return this.completeCompilation(frame, compiler, e, aiReturn);
        }
    }

    private CallChain computeGetModuleChain(Frame frame, ObjectHandle hRepo) {
        Object nid = GET_MODULE_ID.resolveNestedIdentity(frame.poolContext(), frame.getGenericsResolver(true));
        TypeComposition clazz = hRepo.getComposition();
        CallChain chain = clazz.getMethodCallChain(nid);
        if (chain.isEmpty()) {
            return new CallChain.ExceptionChain(xException.makeHandle(frame, "Missing method \"" + String.valueOf(GET_MODULE_ID) + "\" on " + hRepo.getType().getValueString()));
        }
        return chain;
    }

    private boolean popModuleStructure(Frame frame, CompilerAdapter compiler) {
        ObjectHandle hReturn = frame.popStack();
        if (hReturn instanceof xRTComponentTemplate.ComponentTemplateHandle) {
            xRTComponentTemplate.ComponentTemplateHandle hModule = (xRTComponentTemplate.ComponentTemplateHandle)hReturn;
            assert (frame.popStack() == xBoolean.TRUE);
            compiler.addRepo((ModuleStructure)hModule.getComponent());
            return true;
        }
        assert (hReturn == xBoolean.FALSE);
        return false;
    }

    private int completeWithError(Frame frame, CompilerAdapter compiler, String sMissing, int[] aiReturn) {
        compiler.log(Severity.FATAL, "Module missing: \"" + sMissing + "\"");
        return this.completeCompilation(frame, compiler, null, aiReturn);
    }

    private int completeCompilation(Frame frame, CompilerAdapter compiler, Exception exception, int[] aiReturn) {
        xArray.ArrayHandle haErrors;
        xArray.ArrayHandle haTemplates;
        boolean fSuccess;
        ArrayList<xRTComponentTemplate.ComponentTemplateHandle> listFiles = new ArrayList<xRTComponentTemplate.ComponentTemplateHandle>();
        List<String> listErrors = compiler.getErrors();
        if (exception == null) {
            boolean bl = fSuccess = compiler.getSeverity().compareTo(Severity.ERROR) < 0;
            if (fSuccess) {
                Container container = frame.f_context.f_container;
                ModuleRepository repoBuild = compiler.getBuildRepository();
                for (String sModule : repoBuild.getModuleNames()) {
                    listFiles.add(xRTFileTemplate.makeHandle(container, repoBuild.loadModule(sModule).getFileStructure()));
                }
            }
        } else {
            fSuccess = false;
            listErrors = this.addError(exception, listErrors);
        }
        assert (fSuccess || !listErrors.isEmpty());
        ConstantPool pool = frame.poolContext();
        TypeConstant typeArray = pool.ensureArrayType(xRTFileTemplate.FILE_TEMPLATE_TYPE);
        TypeComposition clzArray = this.f_container.resolveClass(typeArray);
        if (fSuccess) {
            haTemplates = xArray.makeArrayHandle(clzArray, listFiles.size(), listFiles.toArray(Utils.OBJECTS_NONE), xArray.Mutability.Constant);
            haErrors = xString.ensureEmptyArray();
        } else {
            haTemplates = xArray.makeArrayHandle(clzArray, 0, Utils.OBJECTS_NONE, xArray.Mutability.Constant);
            haErrors = xString.makeArrayHandle(listErrors.toArray(Utils.NO_NAMES));
        }
        compiler.reset();
        return frame.assignValues(aiReturn, haTemplates, haErrors);
    }

    private List<String> addError(Exception exception, List<String> listErrors) {
        if (listErrors.isEmpty()) {
            listErrors = new ArrayList<String>();
        }
        listErrors.add(exception.toString());
        return listErrors;
    }

    public ObjectHandle ensureCompiler(Frame frame, ObjectHandle hOpts) {
        return this.createServiceHandle(this.f_container.createServiceContext("Compiler"), this.getCanonicalClass(), this.getCanonicalType());
    }

    static {
        STACK_2 = new int[]{-1, -1};
    }

    protected static class CompilerHandle
    extends xService.ServiceHandle {
        protected final CompilerAdapter fAdapter;

        protected CompilerHandle(TypeComposition clazz, ServiceContext context, CompilerAdapter adapter) {
            super(clazz, context);
            this.fAdapter = adapter;
        }
    }

    protected static class CompilerAdapter
    extends Compiler {
        private List<ModuleRepository> m_listRepos;
        private List<File> m_listSources;
        private ModuleRepository m_repoResults;
        private Version m_version = new Version("CI");
        private List<String> m_log = new ArrayList<String>();
        private org.xvm.compiler.Compiler[] m_compilers;
        private ModuleRepository m_repoOutput;
        private ModuleInfo.Node[] m_allNodes;

        protected CompilerAdapter() {
            super(null);
        }

        protected void setLibraryRepos(List<ModuleRepository> listRepos) {
            this.m_listRepos = listRepos;
        }

        protected void addRepo(ModuleStructure module) {
            this.m_listRepos.add(new InstantRepository(module));
        }

        protected List<File> getSourceLocations() {
            return this.m_listSources;
        }

        protected void setSourceLocations(List<File> listSources) {
            this.m_listSources = listSources;
        }

        protected Version getVersion() {
            return this.m_version;
        }

        protected void setVersion(Version version) {
            this.m_version = version;
        }

        protected boolean isForcedRebuild() {
            return true;
        }

        protected Severity getSeverity() {
            return this.m_sevWorst;
        }

        protected List<String> getErrors() {
            return this.m_log == null ? Collections.emptyList() : this.m_log;
        }

        protected ModuleRepository getBuildRepository() {
            return this.m_repoResults;
        }

        protected String partialCompile(boolean fReenter) {
            ModuleInfo.Node[] allNodes;
            ModuleRepository repoOutput;
            ModuleRepository repoLib;
            org.xvm.compiler.Compiler[] compilers;
            if (fReenter) {
                compilers = this.m_compilers;
                repoLib = this.configureLibraryRepo(null);
                repoOutput = this.m_repoOutput;
                allNodes = this.m_allNodes;
            } else {
                File[] resourceDirs = this.options().getResourceLocation();
                File fileOutput = this.options().getOutputLocation();
                List<ModuleInfo> listTargets = this.selectTargets(this.options().getInputLocations(), resourceDirs, fileOutput);
                boolean fRebuild = this.options().isForcedRebuild();
                this.checkErrors();
                ListMap<File, ModuleInfo.Node> mapTargets = new ListMap<File, ModuleInfo.Node>(listTargets.size());
                int cSystemModules = 0;
                for (ModuleInfo moduleInfo : listTargets) {
                    ModuleInfo.Node node = moduleInfo.getSourceTree(this);
                    if (!fRebuild && moduleInfo.isUpToDate()) continue;
                    mapTargets.put(moduleInfo.getSourceFile(), node);
                    if (!moduleInfo.isSystemModule()) continue;
                    ++cSystemModules;
                }
                if (mapTargets.isEmpty()) {
                    this.log(Severity.INFO, "All modules are up to date; terminating compiler");
                    return null;
                }
                allNodes = mapTargets.values().toArray(new ModuleInfo.Node[0]);
                this.flushAndCheckErrors(allNodes);
                repoLib = this.configureLibraryRepo(this.options().getModulePath());
                this.checkErrors();
                if (cSystemModules == 0) {
                    this.prelinkSystemLibraries(repoLib);
                }
                this.checkErrors();
                repoOutput = this.configureResultRepo(fileOutput);
                this.checkErrors();
                Map<String, org.xvm.compiler.Compiler> mapCompilers = this.populateNamespace(allNodes, repoLib);
                this.flushAndCheckErrors(allNodes);
                compilers = mapCompilers.values().toArray(NO_COMPILERS);
            }
            for (org.xvm.compiler.Compiler compiler : compilers) {
                ModuleConstant idMissing = compiler.linkModules(repoLib);
                if (idMissing == null) continue;
                this.m_compilers = compilers;
                this.m_repoOutput = repoOutput;
                this.m_allNodes = allNodes;
                return idMissing.getName();
            }
            this.resolveNames(compilers);
            this.flushAndCheckErrors(allNodes);
            this.injectNativeTurtle(repoLib);
            this.checkErrors();
            this.validateExpressions(compilers);
            this.flushAndCheckErrors(allNodes);
            this.generateCode(compilers);
            this.flushAndCheckErrors(allNodes);
            this.emitModules(allNodes, repoOutput);
            this.flushAndCheckErrors(allNodes);
            return null;
        }

        @Override
        protected void reset() {
            super.reset();
            this.m_listSources = null;
            this.m_listRepos = null;
            this.m_repoResults = null;
            this.m_compilers = null;
            this.m_repoOutput = null;
            this.m_allNodes = null;
            this.m_log.clear();
        }

        @Override
        protected ModuleRepository configureLibraryRepo(List<File> ignore) {
            return new LinkedRepository(true, this.m_listRepos.toArray(ModuleRepository.NO_REPOS));
        }

        @Override
        protected ModuleRepository configureResultRepo(File fileDest) {
            this.m_repoResults = this.makeBuildRepo();
            return this.m_repoResults;
        }

        @Override
        public void run() {
            throw new IllegalStateException();
        }

        @Override
        protected void linkModules(org.xvm.compiler.Compiler[] compilers, ModuleRepository repo) {
            throw new IllegalStateException();
        }

        @Override
        protected void log(Severity sev, String sMsg) {
            List<String> log = this.m_log;
            if (log == null) {
                log = this.m_log = new ArrayList<String>();
            }
            if (sev.compareTo(this.m_sevWorst) > 0) {
                this.m_sevWorst = sev;
            }
            if (sev.compareTo(Severity.WARNING) >= 0) {
                log.add(sev.desc() + ": " + sMsg);
            }
        }

        @Override
        protected void abort(boolean fError) {
            throw new CompilerException("");
        }

        @Override
        protected Compiler.Options instantiateOptions() {
            return new Options();
        }

        class Options
        extends Compiler.Options {
            Options() {
                super(CompilerAdapter.this);
            }

            @Override
            public List<File> getInputLocations() {
                return CompilerAdapter.this.getSourceLocations();
            }

            @Override
            public Version getVersion() {
                return CompilerAdapter.this.getVersion();
            }

            @Override
            public boolean isOutputFilenameQualified() {
                return true;
            }

            @Override
            public boolean isForcedRebuild() {
                return CompilerAdapter.this.isForcedRebuild();
            }
        }
    }
}

