/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.mgmt;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.NestedContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template._native.xRTServiceControl;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xService;
import org.xvm.util.Auto;

public class xContainerControl
extends xRTServiceControl {
    public static xContainerControl INSTANCE;
    private TypeComposition m_clzControl;

    public xContainerControl(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.pool();
        TypeConstant typeMask = pool.ensureEcstasyTypeConstant("mgmt.Container.Control");
        this.m_clzControl = this.ensureClass(this.f_container, this.getCanonicalType(), typeMask);
        this.markNativeProperty("mainService");
        this.markNativeProperty("innerTypeSystem");
        this.markNativeMethod("invoke", null, null);
        this.markNativeMethod("kill", VOID, VOID);
        this.invalidateTypeInfo();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        Container container = ((ControlHandle)hTarget).f_container;
        switch (sPropName) {
            case "mainService": {
                ServiceContext ctx = container.getServiceContext();
                return frame.assignValue(iReturn, ctx == null ? xNullable.NULL : ctx.getService());
            }
            case "innerTypeSystem": {
                return this.getPropertyTypeSystem(frame, container, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "invoke": {
                return this.invokeInvoke(frame, (ControlHandle)hTarget, (xString.StringHandle)ahArg[0], (xTuple.TupleHandle)ahArg[1], ahArg[2], iReturn);
            }
            case "kill": {
                return this.invokeKill(frame, (ControlHandle)hTarget, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    protected int invokeInvoke(Frame frame, ControlHandle hCtrl, xString.StringHandle hName, xTuple.TupleHandle hTupleArg, ObjectHandle hRunWithin, int iReturn) {
        Container container = hCtrl.f_container;
        ConstantPool pool = container.getConstantPool();
        try (Auto ignore = ConstantPool.withPool(pool);){
            xService.ServiceHandle hService;
            ServiceContext ctxContainer = container.ensureServiceContext();
            ObjectHandle[] ahArg = hTupleArg.m_ahValue;
            String sMethod = hName.getStringValue();
            ModuleConstant idModule = container.getModule();
            MethodConstant idMethod = container.findModuleMethod(sMethod, ahArg);
            if (idMethod == null) {
                int n = frame.raiseException("Missing " + sMethod + " method for " + idModule.getValueString());
                return n;
            }
            xService.ServiceHandle serviceHandle = hService = hRunWithin == ObjectHandle.DEFAULT || hRunWithin == xNullable.NULL ? ctxContainer.getService() : (xService.ServiceHandle)hRunWithin;
            if (hService.f_context.f_container != container) {
                int n = frame.raiseException("Out of context \"runWithin\" service");
                return n;
            }
            TypeComposition clzModule = container.resolveClass(idModule.getType());
            CallChain chain = clzModule.getMethodCallChain(idMethod.getSignature());
            final SingletonConstant constModule = pool.ensureSingletonConstConstant(idModule);
            xRTFunction.AsyncHandle hFunction = new xRTFunction.AsyncHandle(this, container, chain){

                @Override
                protected ObjectHandle getContextTarget(Frame frame, ObjectHandle hService) {
                    return frame.getConstHandle(constModule);
                }
            };
            int n = hFunction.callT(frame, hService, ahArg, iReturn);
            return n;
        }
    }

    protected int invokeKill(Frame frame, ControlHandle hCtrl, int iReturn) {
        Container container = hCtrl.f_container;
        if (container instanceof NestedContainer) {
            NestedContainer container2 = (NestedContainer)container;
            switch (this.closeResourceProvider(frame, container2.f_hProvider)) {
                case -1: {
                    return this.completeKill(frame, iReturn);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> this.completeKill(frameCaller, iReturn));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        return frame.raiseException("Main container cannot be killed");
    }

    private int closeResourceProvider(Frame frame, ObjectHandle hProvider) {
        TypeComposition clazz = hProvider.getComposition();
        CallChain chain = clazz.getMethodCallChain(frame.poolContext().sigClose());
        if (chain.isNative()) {
            return -1;
        }
        ObjectHandle[] ahVars = new ObjectHandle[chain.getMaxVars()];
        ahVars[0] = xNullable.NULL;
        return chain.invoke(frame, hProvider, ahVars, -2);
    }

    private int completeKill(Frame frame, int iReturn) {
        return frame.assignValue(iReturn, xTuple.H_VOID);
    }

    protected int getPropertyTypeSystem(Frame frame, final Container container, int iReturn) {
        Op opCall = new Op(this){

            @Override
            public int process(Frame frame, int iPC) {
                return container.ensureTypeSystemHandle(frame, 0);
            }

            @Override
            public String toString() {
                return "CreateTypeSystem";
            }
        };
        return container.ensureServiceContext().sendOp1Request(frame, opCall, iReturn, new TypeConstant[0]);
    }

    public ObjectHandle makeHandle(Container container) {
        return new ControlHandle(this.m_clzControl, container);
    }

    protected static class ControlHandle
    extends xRTServiceControl.ControlHandle {
        protected final Container f_container;

        protected ControlHandle(TypeComposition clazz, Container container) {
            super(clazz, container.getServiceContext());
            this.f_container = container;
        }

        @Override
        public ServiceContext getContext() {
            return this.f_container.getServiceContext();
        }
    }
}

