/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.mgmt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.FileStructure;
import org.xvm.asm.InjectionKey;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.NestedContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTUInt8Delegate;
import org.xvm.runtime.template._native.mgmt.xContainerControl;
import org.xvm.runtime.template._native.reflect.xRTComponentTemplate;
import org.xvm.runtime.template._native.reflect.xRTFileTemplate;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xService;

public class xContainerLinker
extends xService {
    public static xContainerLinker INSTANCE;
    static SignatureConstant GET_RESOURCE;
    private ObjectHandle m_hLinker;

    public xContainerLinker(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ClassStructure clz = (ClassStructure)this.pool().ensureEcstasyClassConstant("mgmt.ResourceProvider").getComponent();
        GET_RESOURCE = clz.findMethod("getResource", 2, new TypeConstant[0]).getIdentityConstant().getSignature();
        this.markNativeMethod("collectInjectionsImpl", null, null);
        this.markNativeMethod("loadFileTemplate", BYTES, null);
        this.markNativeMethod("resolveAndLink", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        return this.pool().ensureEcstasyTypeConstant("mgmt.Container.Linker");
    }

    public ObjectHandle ensureLinker(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hLinker = this.m_hLinker;
        if (hLinker == null) {
            this.m_hLinker = hLinker = this.createServiceHandle(this.f_container.createServiceContext("Linker"), this.getCanonicalClass(), this.getCanonicalType());
        }
        return hLinker;
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "loadFileTemplate": {
                try {
                    xArray.ArrayHandle hContents = (xArray.ArrayHandle)hArg;
                    byte[] abContents = xRTUInt8Delegate.getBytes((ByteBasedDelegate.ByteArrayHandle)hContents.m_hDelegate);
                    FileStructure struct = new FileStructure(new ByteArrayInputStream(abContents));
                    return frame.assignValue(iReturn, xRTFileTemplate.makeHandle(frame.f_context.f_container, struct));
                }
                catch (IOException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "resolveAndLink": {
                return this.invokeResolveAndLink(frame, ahArg, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "collectInjectionsImpl": {
                return this.invokeCollectInjections(frame, ahArg, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    private int invokeCollectInjections(Frame frame, ObjectHandle[] ahArg, int[] aiReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hModule = (xRTComponentTemplate.ComponentTemplateHandle)ahArg[0];
        xArray.ArrayHandle haCondNames = (xArray.ArrayHandle)ahArg[1];
        if (haCondNames.m_hDelegate.m_cSize > 0L) {
            return frame.raiseException(xException.unsupported(frame, "Condition names are not currently supported"));
        }
        ModuleStructure module = (ModuleStructure)hModule.getComponent();
        HashSet setInjections = new HashSet();
        module.getFileStructure().visitChildren(component -> component.collectInjections(setInjections), false, true);
        Container container = frame.f_context.f_container;
        int cInjects = setInjections.size();
        xString.StringHandle[] ahName = new xString.StringHandle[cInjects];
        ObjectHandle[] ahType = new xRTType.TypeHandle[cInjects];
        int ix = 0;
        for (InjectionKey key : setInjections) {
            ahName[ix] = xString.makeHandle(key.f_sName);
            ahType[ix++] = key.f_type.ensureTypeHandle(container);
        }
        xArray.ArrayHandle haNames = xArray.makeStringArrayHandle(ahName);
        xArray.ArrayHandle haTypes = xArray.makeArrayHandle(xRTType.ensureTypeArrayComposition(container), cInjects, ahType, xArray.Mutability.Constant);
        return frame.assignValues(aiReturn, haNames, haTypes);
    }

    private int invokeResolveAndLink(Frame frame, ObjectHandle[] ahArg, int iReturn) {
        ObjectHandle[] ahAdditional;
        ObjectHandle[] ahShared;
        xRTComponentTemplate.ComponentTemplateHandle hModule = (xRTComponentTemplate.ComponentTemplateHandle)ahArg[0];
        ObjectHandle hModel = ahArg[1];
        ObjectHandle hRepo = ahArg[2];
        ObjectHandle hProvider = ahArg[3];
        xArray.ArrayHandle haShared = (xArray.ArrayHandle)ahArg[4];
        xArray.ArrayHandle haAdditional = (xArray.ArrayHandle)ahArg[5];
        xArray.ArrayHandle haCondNames = (xArray.ArrayHandle)ahArg[6];
        if (((xEnum.EnumHandle)hModel).getOrdinal() != 0) {
            return frame.raiseException(xException.unsupported(frame, "Only Lightweight model is currently supported"));
        }
        if (!hProvider.isService()) {
            return frame.raiseException(xException.illegalArgument(frame, "ResourceProvider must be a service"));
        }
        if (haCondNames.m_hDelegate.m_cSize > 0L) {
            return frame.raiseException(xException.unsupported(frame, "Condition names are not currently supported"));
        }
        Container container = frame.f_fiber.getCallingContainer();
        FileStructure file = hModule.getComponent().getFileStructure();
        try {
            ahShared = haShared.m_hDelegate.m_cSize == 0L ? Utils.OBJECTS_NONE : haShared.getTemplate().toArray(frame, haShared);
            ahAdditional = haAdditional.m_hDelegate.m_cSize == 0L ? Utils.OBJECTS_NONE : haAdditional.getTemplate().toArray(frame, haAdditional);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
        switch (xRTFileTemplate.INSTANCE.invokeResolve(frame, file, hRepo, ahShared, ahAdditional, -1)) {
            case -1: {
                return this.completeResolveAndLink(frame, container, this.popModule(frame), hProvider, iReturn);
            }
            case -5: {
                Frame.Continuation stepNext = frameCaller -> this.completeResolveAndLink(frameCaller, container, this.popModule(frameCaller), hProvider, iReturn);
                frame.m_frameNext.addContinuation(stepNext);
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    private ModuleStructure popModule(Frame frame) {
        xRTComponentTemplate.ComponentTemplateHandle hFile = (xRTComponentTemplate.ComponentTemplateHandle)frame.popStack();
        return ((FileStructure)hFile.getComponent()).getModule();
    }

    private int completeResolveAndLink(Frame frame, Container container, ModuleStructure moduleApp, ObjectHandle hProvider, int iReturn) {
        NestedContainer containerNested = new NestedContainer(container, moduleApp.getIdentityConstant(), hProvider, Collections.emptyList());
        return new CollectResources(containerNested, iReturn).doNext(frame);
    }

    public static class CollectResources
    implements Frame.Continuation {
        private final NestedContainer container;
        private final InjectionKey[] aKeys;
        private final ObjectHandle hProvider;
        private final int iReturn;
        private int index = -1;

        public CollectResources(NestedContainer container, int iReturn) {
            this.container = container;
            this.aKeys = container.collectInjections().toArray(InjectionKey.NO_INJECTIONS);
            this.hProvider = container.f_hProvider;
            this.iReturn = iReturn;
        }

        @Override
        public int proceed(Frame frameCaller) {
            this.updateResult(frameCaller);
            return this.doNext(frameCaller);
        }

        protected void updateResult(Frame frameCaller) {
            xService.ServiceHandle hService = this.hProvider.getService();
            ObjectHandle hSupplier = frameCaller.popStack();
            this.container.addResourceSupplier(this.aKeys[this.index], hService, hSupplier);
        }

        public int doNext(Frame frameCaller) {
            block5: while (++this.index < this.aKeys.length) {
                InjectionKey key = this.aKeys[this.index];
                xRTType.TypeHandle hType = key.f_type.ensureTypeHandle(this.container);
                xString.StringHandle hName = xString.makeHandle(key.f_sName);
                CallChain chain = this.hProvider.getComposition().getMethodCallChain(GET_RESOURCE);
                ObjectHandle[] ahArg = new ObjectHandle[chain.getMaxVars()];
                ahArg[0] = hType;
                ahArg[1] = hName;
                switch (this.hProvider.getTemplate().invoke1(frameCaller, chain, this.hProvider, ahArg, -1)) {
                    case -1: {
                        this.updateResult(frameCaller);
                        continue block5;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            return frameCaller.assignValue(this.iReturn, xContainerControl.INSTANCE.makeHandle(this.container));
        }
    }
}

