/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.net;

import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xByteArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xService;

public class xRTNameService
extends xService {
    public static xRTNameService INSTANCE;
    private TypeConstant m_typeCanonical;
    private static TypeConstant BYTE_ARRAY_ARRAY_TYPE;

    public xRTNameService(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        BYTE_ARRAY_ARRAY_TYPE = this.pool().ensureArrayType(this.pool().typeByteArray());
        this.markNativeMethod("nativeResolve", null, null);
        this.markNativeMethod("nativeLookup", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        TypeConstant type = this.m_typeCanonical;
        if (type == null) {
            ConstantPool pool = this.f_container.getConstantPool();
            this.m_typeCanonical = type = pool.ensureTerminalTypeConstant(pool.ensureClassConstant(pool.ensureModuleConstant("net.xtclang.org"), "NameService"));
        }
        return type;
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        xService.ServiceHandle hService = (xService.ServiceHandle)hTarget;
        if (frame.f_context != hService.f_context) {
            return xRTFunction.makeAsyncNativeHandle(method).callN(frame, hTarget, ahArg, aiReturn);
        }
        switch (method.getName()) {
            case "nativeResolve": {
                Container container = frame.f_context.f_container;
                String sName = ((xString.StringHandle)ahArg[0]).getStringValue();
                Callable<InetAddress[]> task = () -> InetAddress.getAllByName(sName);
                CompletableFuture<InetAddress[]> cfResolve = container.scheduleIO(task);
                Frame.Continuation continuation = frameCaller -> {
                    try {
                        InetAddress[] aAddr = (InetAddress[])cfResolve.get();
                        if (aAddr != null && aAddr.length > 0) {
                            int c = aAddr.length;
                            ObjectHandle[] ah = new ObjectHandle[c];
                            for (int i = 0; i < c; ++i) {
                                ah[i] = xArray.makeByteArrayHandle(aAddr[i].getAddress(), xArray.Mutability.Constant);
                            }
                            TypeComposition clz = xRTNameService.ensureByteArrayArrayComposition(container);
                            return frameCaller.assignValues(aiReturn, xBoolean.TRUE, xArray.createImmutableArray(clz, ah));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return frameCaller.assignValue(aiReturn[0], xBoolean.FALSE);
                };
                return frame.waitForIO(cfResolve, continuation);
            }
            case "nativeLookup": {
                byte[] abIP = xByteArray.getBytes((xArray.ArrayHandle)ahArg[0]);
                Callable<InetAddress> task = () -> InetAddress.getByAddress(abIP);
                CompletableFuture<InetAddress> cfLookup = frame.f_context.f_container.scheduleIO(task);
                Frame.Continuation continuation = frameCaller -> {
                    try {
                        InetAddress addr = (InetAddress)cfLookup.get();
                        String sName = addr.getHostName();
                        String sNotName = addr.getHostAddress();
                        if (sName != null && !sName.isEmpty() && !sName.equals(sNotName)) {
                            return frameCaller.assignValues(aiReturn, xBoolean.TRUE, xString.makeHandle(sName));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return frameCaller.assignValue(aiReturn[0], xBoolean.FALSE);
                };
                return frame.waitForIO(cfLookup, continuation);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    static TypeComposition ensureByteArrayArrayComposition(Container container) {
        return container.ensureClassComposition(BYTE_ARRAY_ARRAY_TYPE, xArray.INSTANCE);
    }
}

