/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.net.xRTNameService;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xByteArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xService;

public class xRTNetwork
extends xService {
    public static xRTNetwork INSTANCE;
    private TypeConstant m_typeCanonical;

    public xRTNetwork(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("interfaces");
        this.markNativeMethod("defaultInterface", null, null);
        this.markNativeMethod("instantiateNameService", null, null);
        this.markNativeMethod("interfaceByName", null, null);
        this.markNativeMethod("isSecure", null, null);
        this.markNativeMethod("nativeConnect", null, null);
        this.markNativeMethod("nativeListen", null, null);
        this.markNativeMethod("nativeNicByAddress", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        TypeConstant type = this.m_typeCanonical;
        if (type == null) {
            ConstantPool pool = this.f_container.getConstantPool();
            this.m_typeCanonical = type = pool.ensureTerminalTypeConstant(pool.ensureClassConstant(pool.ensureModuleConstant("net.xtclang.org"), "Network"));
        }
        return type;
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        switch (sPropName) {
            case "interfaces": {
                ObjectHandle[] ahNic = new ObjectHandle[]{};
                return frame.assignValue(iReturn, xArray.makeObjectArrayHandle(ahNic, xArray.Mutability.Constant));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        xService.ServiceHandle hService = (xService.ServiceHandle)hTarget;
        if (frame.f_context != hService.f_context) {
            return xRTFunction.makeAsyncNativeHandle(method).call1(frame, hTarget, ahArg, iReturn);
        }
        switch (method.getName()) {
            case "instantiateNameService": {
                return this.instantiateNameService(frame, hService, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        xService.ServiceHandle hService = (xService.ServiceHandle)hTarget;
        if (frame.f_context != hService.f_context) {
            return xRTFunction.makeAsyncNativeHandle(method).callN(frame, hTarget, ahArg, aiReturn);
        }
        switch (method.getName()) {
            case "isSecure": {
                try {
                    if (this.isSecure(frame, hService)) {
                        return frame.assignValues(aiReturn, xBoolean.TRUE, null);
                    }
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                catch (Exception e) {
                    return frame.raiseException(xException.makeHandle(frame, e.getMessage()));
                }
            }
            case "defaultInterface": {
                try {
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                catch (Exception e) {
                    return frame.raiseException(xException.makeHandle(frame, e.getMessage()));
                }
            }
            case "interfaceByName": {
                String sName = ((xString.StringHandle)ahArg[0]).getStringValue();
                try {
                    NetworkInterface nic = NetworkInterface.getByName(sName);
                    if (nic != null) {
                        return frame.assignValues(aiReturn, xBoolean.TRUE, null);
                    }
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                catch (SocketException e) {
                    return frame.raiseException(xException.ioException(frame, e.getMessage()));
                }
                catch (Exception e) {
                    return frame.raiseException(xException.makeHandle(frame, e.getMessage()));
                }
            }
            case "nativeNicByAddress": {
                byte[] abIP = xByteArray.getBytes((xArray.ArrayHandle)ahArg[0]);
                try {
                    InetAddress addr = InetAddress.getByAddress(abIP);
                    NetworkInterface nic = NetworkInterface.getByInetAddress(addr);
                    if (nic != null) {
                        return frame.assignValues(aiReturn, xBoolean.TRUE, null);
                    }
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                catch (Exception e) {
                    return frame.raiseException(xException.makeHandle(frame, e.getMessage()));
                }
            }
            case "nativeConnect": {
                byte[] abRemoteIP = xByteArray.getBytes((xArray.ArrayHandle)ahArg[0]);
                int nRemotePort = (int)((ObjectHandle.JavaLong)ahArg[1]).getValue();
                byte[] abLocalIP = xByteArray.getBytes((xArray.ArrayHandle)ahArg[2]);
                int nLocalPort = (int)((ObjectHandle.JavaLong)ahArg[3]).getValue();
                try {
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                catch (Exception e) {
                    return frame.raiseException(xException.makeHandle(frame, e.getMessage()));
                }
            }
            case "nativeListen": {
                byte[] abLocalIP = xByteArray.getBytes((xArray.ArrayHandle)ahArg[0]);
                int nLocalPort = (int)((ObjectHandle.JavaLong)ahArg[1]).getValue();
                try {
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                catch (Exception e) {
                    return frame.raiseException(xException.makeHandle(frame, e.getMessage()));
                }
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    public boolean isSecure(Frame frame, xService.ServiceHandle hNetwork) {
        return ((xBoolean.BooleanHandle)hNetwork.getField(frame, "secure")).get();
    }

    protected int instantiateNameService(Frame frame, xService.ServiceHandle hNetwork, int iReturn) {
        xRTNameService templateSvc = xRTNameService.INSTANCE;
        ClassComposition clz = templateSvc.getCanonicalClass();
        MethodStructure constructor = templateSvc.getStructure().findConstructor(this.getCanonicalType());
        ObjectHandle[] ahParams = new ObjectHandle[constructor.getMaxVars()];
        ahParams[0] = hNetwork;
        switch (((ClassTemplate)templateSvc).construct(frame, constructor, clz, null, ahParams, -1)) {
            case -1: {
                return frame.assignValue(iReturn, frame.popStack());
            }
            case -3: {
                return -3;
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, frameCaller.popStack()));
                return -5;
            }
        }
        throw new IllegalStateException();
    }
}

