/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.numbers;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xBitArray;
import org.xvm.runtime.template.collections.xByteArray;
import org.xvm.runtime.template.numbers.BaseInt128;
import org.xvm.runtime.template.numbers.LongLong;
import org.xvm.runtime.template.numbers.xBit;
import org.xvm.runtime.template.numbers.xDec64;
import org.xvm.runtime.template.numbers.xFloat32;
import org.xvm.runtime.template.numbers.xFloat64;
import org.xvm.runtime.template.numbers.xInt16;
import org.xvm.runtime.template.numbers.xInt32;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.numbers.xInt8;
import org.xvm.runtime.template.numbers.xIntLiteral;
import org.xvm.runtime.template.numbers.xUInt16;
import org.xvm.runtime.template.numbers.xUInt32;
import org.xvm.runtime.template.numbers.xUInt64;
import org.xvm.runtime.template.numbers.xUInt8;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xService;

public class xRTRandom
extends xService {
    public static xRTRandom INSTANCE;
    private ObjectHandle m_hRandom;

    public xRTRandom(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        String[] BIT = new String[]{"numbers.Bit"};
        String[] BITARRAY = new String[]{"immutable collections.Array<numbers.Bit>"};
        String[] BYTEARRAY = new String[]{"immutable collections.Array<numbers.UInt8>"};
        String[] INT8 = new String[]{"numbers.Int8"};
        String[] INT16 = new String[]{"numbers.Int16"};
        String[] INT32 = new String[]{"numbers.Int32"};
        String[] INT64 = new String[]{"numbers.Int64"};
        String[] UINT8 = new String[]{"numbers.UInt8"};
        String[] UINT16 = new String[]{"numbers.UInt16"};
        String[] UINT32 = new String[]{"numbers.UInt32"};
        String[] UINT64 = new String[]{"numbers.UInt64"};
        String[] DEC64 = new String[]{"numbers.Dec64"};
        String[] FLOAT32 = new String[]{"numbers.Float32"};
        String[] FLOAT64 = new String[]{"numbers.Float64"};
        this.markNativeMethod("bit", VOID, BIT);
        this.markNativeMethod("bits", INT, BITARRAY);
        this.markNativeMethod("bytes", INT, BYTEARRAY);
        this.markNativeMethod("int", INT, INT);
        this.markNativeMethod("int8", VOID, INT8);
        this.markNativeMethod("int16", VOID, INT16);
        this.markNativeMethod("int32", VOID, INT32);
        this.markNativeMethod("int64", VOID, INT64);
        this.markNativeMethod("uint8", VOID, UINT8);
        this.markNativeMethod("uint16", VOID, UINT16);
        this.markNativeMethod("uint32", VOID, UINT32);
        this.markNativeMethod("uint64", VOID, UINT64);
        this.markNativeMethod("dec64", VOID, DEC64);
        this.markNativeMethod("float32", VOID, FLOAT32);
        this.markNativeMethod("float64", VOID, FLOAT64);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        return this.pool().ensureEcstasyTypeConstant("numbers.Random");
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "bits": {
                long cBits = ((ObjectHandle.JavaLong)hArg).getValue();
                if (cBits < 0L) {
                    return frame.raiseException(xException.illegalArgument(frame, "size must be >= 0: " + cBits));
                }
                if (cBits > 2000000000L) {
                    return frame.raiseException(xException.illegalArgument(frame, "size limit (2 billion bits) exceeded: " + cBits));
                }
                byte[] ab = new byte[(int)(cBits + 7L >>> 3)];
                this.rnd(hTarget).nextBytes(ab);
                return frame.assignValue(iReturn, xBitArray.makeBitArrayHandle(ab, (int)cBits, xArray.Mutability.Constant));
            }
            case "bytes": {
                long cBytes = ((ObjectHandle.JavaLong)hArg).getValue();
                if (cBytes < 0L) {
                    return frame.raiseException(xException.illegalArgument(frame, "array size must be >= 0: " + cBytes));
                }
                if (cBytes > 2000000000L) {
                    return frame.raiseException(xException.illegalArgument(frame, "array size limit (2 billion bits) exceeded: " + cBytes));
                }
                byte[] ab = new byte[(int)cBytes];
                this.rnd(hTarget).nextBytes(ab);
                return frame.assignValue(iReturn, xByteArray.makeByteArrayHandle(ab, xArray.Mutability.Constant));
            }
            case "int": {
                return this.invokeInt(frame, hTarget, hArg, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "bit": {
                return frame.assignValue(iReturn, xBit.makeHandle(this.rnd(hTarget).nextBoolean()));
            }
            case "int8": {
                return frame.assignValue(iReturn, xInt8.INSTANCE.makeJavaLong(this.rnd(hTarget).nextInt()));
            }
            case "int16": {
                return frame.assignValue(iReturn, xInt16.INSTANCE.makeJavaLong(this.rnd(hTarget).nextInt()));
            }
            case "int32": {
                return frame.assignValue(iReturn, xInt32.INSTANCE.makeJavaLong(this.rnd(hTarget).nextInt()));
            }
            case "int64": {
                return frame.assignValue(iReturn, xInt64.INSTANCE.makeJavaLong(this.rnd(hTarget).nextLong()));
            }
            case "uint8": {
                return frame.assignValue(iReturn, xUInt8.INSTANCE.makeJavaLong(this.rnd(hTarget).nextInt()));
            }
            case "uint16": {
                return frame.assignValue(iReturn, xUInt16.INSTANCE.makeJavaLong(this.rnd(hTarget).nextInt()));
            }
            case "uint32": {
                return frame.assignValue(iReturn, xUInt32.INSTANCE.makeJavaLong(this.rnd(hTarget).nextInt()));
            }
            case "uint64": {
                return frame.assignValue(iReturn, xUInt64.INSTANCE.makeJavaLong(this.rnd(hTarget).nextLong()));
            }
            case "dec64": {
                return frame.assignValue(iReturn, xDec64.INSTANCE.makeHandle(this.rnd(hTarget).nextDouble()));
            }
            case "float32": {
                return frame.assignValue(iReturn, xFloat32.INSTANCE.makeHandle(this.rnd(hTarget).nextFloat()));
            }
            case "float64": {
                return frame.assignValue(iReturn, xFloat64.INSTANCE.makeHandle(this.rnd(hTarget).nextDouble()));
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    public ObjectHandle ensureDefaultRandom(Frame frame, ObjectHandle hOpts) {
        long lSeed;
        if (hOpts instanceof ObjectHandle.JavaLong) {
            ObjectHandle.JavaLong hInt = (ObjectHandle.JavaLong)hOpts;
            v0 = hInt.getValue();
        } else if (hOpts instanceof xIntLiteral.IntNHandle) {
            xIntLiteral.IntNHandle hIntN = (xIntLiteral.IntNHandle)hOpts;
            v0 = hIntN.getValue().getLong();
        } else {
            v0 = lSeed = 0L;
        }
        if (lSeed != 0L) {
            return this.createRandomHandle(this.f_container.createServiceContext("Random"), this.getCanonicalClass(), this.getCanonicalType(), lSeed);
        }
        ObjectHandle hRnd = this.m_hRandom;
        if (hRnd == null) {
            this.m_hRandom = hRnd = this.createRandomHandle(this.f_container.createServiceContext("Random"), this.getCanonicalClass(), this.getCanonicalType(), 0L);
        }
        return hRnd;
    }

    protected int invokeInt(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        boolean fSmall = false;
        long lMax = 0L;
        LongLong llMax = null;
        if (hArg instanceof ObjectHandle.JavaLong) {
            ObjectHandle.JavaLong hL = (ObjectHandle.JavaLong)hArg;
            fSmall = true;
            lMax = hL.getValue();
        } else {
            llMax = ((BaseInt128.LongLongHandle)hArg).getValue();
            if (llMax.isSmall(true)) {
                fSmall = true;
                lMax = llMax.getLowValue();
            } else {
                throw new IllegalStateException();
            }
        }
        Random rnd = this.rnd(hTarget);
        if (lMax <= 0L) {
            return frame.raiseException(xException.illegalArgument(frame, "Illegal exclusive maximum (" + lMax + "); maximum must be > 0"));
        }
        return frame.assignValue(iReturn, xInt64.makeHandle(this.computeRandom(rnd, lMax)));
    }

    private long computeRandom(Random rnd, long lMax) {
        assert (lMax > 0L);
        if (lMax <= Integer.MAX_VALUE) {
            return rnd.nextInt((int)lMax);
        }
        if ((lMax & lMax - 1L) == 0L) {
            return rnd.nextLong() & lMax - 1L;
        }
        return rnd.nextLong() % lMax & Long.MAX_VALUE;
    }

    public xService.ServiceHandle createRandomHandle(ServiceContext context, ClassComposition clz, TypeConstant typeMask, long lSeed) {
        RandomHandle hService = new RandomHandle(clz.maskAs(typeMask), context, lSeed == 0L ? null : new Random(lSeed));
        context.setService(hService);
        return hService;
    }

    private Random rnd(ObjectHandle hTarget) {
        Random random = ((RandomHandle)hTarget).f_random;
        return random == null ? ThreadLocalRandom.current() : random;
    }

    public static class RandomHandle
    extends xService.ServiceHandle {
        public final Random f_random;

        public RandomHandle(TypeComposition clazz, ServiceContext context, Random random) {
            super(clazz, context);
            this.f_random = random;
        }
    }
}

