/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTComponentTemplate;
import org.xvm.runtime.template._native.reflect.xRTPropertyTemplate;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template._native.reflect.xRTTypeTemplate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;

public class xRTClassTemplate
extends xRTComponentTemplate {
    public static xRTClassTemplate INSTANCE;
    public static xRTComponentTemplate.ComponentTemplateHandle[] NO_TEMPLATES;
    private static TypeConstant CLASS_TEMPLATE_TYPE;
    private static TypeConstant CLASS_TEMPLATE_ARRAY_TYPE;
    private static TypeConstant MULTI_METHOD_ARRAY_TYPE;
    private static TypeConstant METHOD_ARRAY_TYPE;
    private static TypeConstant ANNOTATION_ARRAY_TYPE;
    private static TypeConstant CONTRIBUTION_ARRAY_TYPE;
    private static ArrayConstant EMPTY_PARAMETER_ARRAY;
    public static xEnum ACTION_TEMPLATE;
    public static MethodStructure CREATE_CONTRIB_METHOD;
    public static MethodStructure CREATE_TYPE_PARAMETERS_METHOD;

    public xRTClassTemplate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        if (this == INSTANCE) {
            ConstantPool pool = this.f_container.getConstantPool();
            ACTION_TEMPLATE = (xEnum)this.f_container.getTemplate("reflect.ClassTemplate.Composition.Action");
            CLASS_TEMPLATE_TYPE = pool.ensureEcstasyTypeConstant("reflect.ClassTemplate");
            CLASS_TEMPLATE_ARRAY_TYPE = pool.ensureArrayType(CLASS_TEMPLATE_TYPE);
            CONTRIBUTION_ARRAY_TYPE = pool.ensureArrayType(pool.ensureEcstasyTypeConstant("reflect.ClassTemplate.Composition.Contribution"));
            MULTI_METHOD_ARRAY_TYPE = pool.ensureArrayType(pool.ensureEcstasyTypeConstant("reflect.MultiMethodTemplate"));
            METHOD_ARRAY_TYPE = pool.ensureArrayType(pool.ensureEcstasyTypeConstant("reflect.MethodTemplate"));
            ANNOTATION_ARRAY_TYPE = pool.ensureArrayType(pool.ensureEcstasyTypeConstant("reflect.AnnotationTemplate"));
            EMPTY_PARAMETER_ARRAY = pool.ensureArrayConstant(pool.ensureArrayType(pool.ensureEcstasyTypeConstant("reflect.TypeParameter")), Constant.NO_CONSTS);
            CREATE_CONTRIB_METHOD = this.f_struct.findMethod("createContribution", 6, new TypeConstant[0]);
            CREATE_TYPE_PARAMETERS_METHOD = this.f_struct.findMethod("createTypeParameters", 2, new TypeConstant[0]);
            this.markNativeProperty("implicitName");
            this.markNativeProperty("classes");
            this.markNativeProperty("contribs");
            this.markNativeProperty("multimethods");
            this.markNativeProperty("properties");
            this.markNativeProperty("singleton");
            this.markNativeProperty("hasDefault");
            this.markNativeProperty("sourceInfo");
            this.markNativeProperty("type");
            this.markNativeProperty("typeParams");
            this.markNativeProperty("virtualChild");
            this.markNativeMethod("deannotate", null, null);
            this.markNativeMethod("ensureClass", null, null);
            super.initNative();
        }
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hComponent = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        switch (sPropName) {
            case "implicitName": {
                return this.getPropertyImplicitName(frame, hComponent, iReturn);
            }
            case "classes": {
                return this.getPropertyClasses(frame, hComponent, iReturn);
            }
            case "contribs": {
                return this.getPropertyContribs(frame, hComponent, iReturn);
            }
            case "multimethods": {
                return this.getPropertyMultimethods(frame, hComponent, iReturn);
            }
            case "properties": {
                return this.getPropertyProperties(frame, hComponent, iReturn);
            }
            case "singleton": {
                return this.getPropertySingleton(frame, hComponent, iReturn);
            }
            case "hasDefault": {
                return this.getPropertyHasDefault(frame, hComponent, iReturn);
            }
            case "sourceInfo": {
                return this.getPropertySourceInfo(frame, hComponent, iReturn);
            }
            case "type": {
                return this.getPropertyType(frame, hComponent, iReturn);
            }
            case "typeParams": {
                return this.getPropertyTypeParams(frame, hComponent, iReturn);
            }
            case "virtualChild": {
                return this.getPropertyVirtualChild(frame, hComponent, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hComponent = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        switch (method.getName()) {
            case "ensureClass": {
                return this.invokeEnsureClass(frame, hComponent, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hComponent = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        switch (method.getName()) {
            case "deannotate": {
                return this.invokeDeannotate(frame, hComponent, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    public int getPropertyImplicitName(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        ClassConstant idClz;
        String sAlias;
        ClassStructure clz = (ClassStructure)hComponent.getComponent();
        IdentityConstant id = clz.getIdentityConstant();
        if (id instanceof ClassConstant && (sAlias = (idClz = (ClassConstant)id).getImplicitImportName()) != null) {
            return frame.assignValue(iReturn, xString.makeHandle(sAlias));
        }
        return frame.assignValue(iReturn, xNullable.NULL);
    }

    public int getPropertyClasses(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        Container container = frame.f_context.f_container;
        ClassStructure clz = (ClassStructure)hComponent.getComponent();
        if (!clz.getFileStructure().isLinked()) {
            return frame.raiseException(xException.illegalState(frame, "FileTemplate is not resolved"));
        }
        ArrayList<xRTComponentTemplate.ComponentTemplateHandle> listTemplates = new ArrayList<xRTComponentTemplate.ComponentTemplateHandle>();
        for (Component component : clz.children()) {
            switch (component.getFormat()) {
                case INTERFACE: 
                case CLASS: 
                case CONST: 
                case ENUM: 
                case ENUMVALUE: 
                case ANNOTATION: 
                case MIXIN: 
                case SERVICE: {
                    listTemplates.add(xRTClassTemplate.makeHandle(container, (ClassStructure)component));
                }
            }
        }
        xArray.ArrayHandle hArray = xArray.createImmutableArray(xRTClassTemplate.ensureClassTemplateArrayComposition(container), listTemplates.toArray(NO_TEMPLATES));
        return frame.assignValue(iReturn, hArray);
    }

    public int getPropertyContribs(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        Container container = frame.f_context.f_container;
        ClassStructure clz = (ClassStructure)hComponent.getComponent();
        if (!clz.getFileStructure().isLinked()) {
            return frame.raiseException(xException.illegalState(frame, "FileTemplate is not resolved"));
        }
        List<Component.Contribution> listContrib = clz.getContributionsAsList();
        Utils.ValueSupplier supplier = (frameCaller, index) -> {
            String sAction;
            Component.Contribution contrib = (Component.Contribution)listContrib.get(index);
            TypeConstant typeContrib = contrib.getTypeConstant();
            ObjectHandle haParams = xNullable.NULL;
            xEnum.EnumHandle hDelegatee = xNullable.NULL;
            ObjectHandle haNames = xNullable.NULL;
            ObjectHandle haTypes = xNullable.NULL;
            switch (contrib.getComposition()) {
                case Annotation: {
                    ObjectHandle[] ahParam;
                    sAction = "AnnotatedBy";
                    Annotation anno = contrib.getAnnotation();
                    Constant[] aParam = anno.getParams();
                    int cParams = aParam.length;
                    if (cParams == 0) {
                        ahParam = Utils.OBJECTS_NONE;
                    } else {
                        ClassConstant idAnno = (ClassConstant)anno.getAnnotationClass();
                        ClassStructure clzAnno = (ClassStructure)idAnno.getComponent();
                        if (clzAnno == null) {
                            return frameCaller.raiseException("unknown annotation " + idAnno.getValueString());
                        }
                        TypeConstant[] atype = new TypeConstant[cParams];
                        ahParam = new ObjectHandle[cParams];
                        for (int i = 0; i < cParams; ++i) {
                            Constant constParam = aParam[i];
                            if (constParam instanceof RegisterConstant) continue;
                            atype[i] = container.getType(constParam);
                            ahParam[i] = frameCaller.getConstHandle(constParam);
                        }
                        MethodStructure ctor = clzAnno.findMethod("construct", cParams, atype);
                        if (ctor == null) {
                            return frameCaller.raiseException("missing annotation constructor " + idAnno.getValueString() + " with " + cParams + " parameters");
                        }
                        xString.StringHandle[] ahNames = new xString.StringHandle[cParams];
                        for (int i = 0; i < cParams; ++i) {
                            Parameter param = ctor.getParam(i);
                            ahNames[i] = xString.makeHandle(param.getName());
                            if (ahParam[i] != null) continue;
                            if (!param.hasDefaultValue()) {
                                return frameCaller.raiseException("missing default value for parameter \"" + param.getName() + "\" at " + String.valueOf(ctor.getIdentityConstant()));
                            }
                            ahParam[i] = frameCaller.getConstHandle(param.getDefaultValue());
                        }
                        haNames = xArray.makeStringArrayHandle(ahNames);
                    }
                    if (Op.anyDeferred(ahParam)) {
                        xEnum.EnumHandle haN = haNames;
                        xEnum.EnumHandle haT = haTypes;
                        Frame.Continuation stepNext = frameCaller2 -> xRTClassTemplate.callCreateContrib(frameCaller2, hComponent, sAction, typeContrib, xArray.makeObjectArrayHandle(ahParam, xArray.Mutability.Constant), hDelegatee, haN, haT);
                        return new Utils.GetArguments(ahParam, stepNext).doNext(frame);
                    }
                    haParams = xArray.makeObjectArrayHandle(ahParam, xArray.Mutability.Constant);
                    break;
                }
                case Extends: {
                    sAction = "Extends";
                    break;
                }
                case Implements: {
                    sAction = "Implements";
                    break;
                }
                case Delegates: {
                    sAction = "Delegates";
                    break;
                }
                case Into: {
                    sAction = "MixesInto";
                    break;
                }
                case Incorporates: {
                    int cConstraints;
                    sAction = "Incorporates";
                    Map<StringConstant, TypeConstant> mapConstraints = contrib.getTypeParams();
                    int n = cConstraints = mapConstraints == null ? 0 : mapConstraints.size();
                    if (cConstraints <= 0) break;
                    xString.StringHandle[] ahNames = new xString.StringHandle[cConstraints];
                    ObjectHandle[] ahTypes = new xRTType.TypeHandle[cConstraints];
                    int i = 0;
                    for (Map.Entry<StringConstant, TypeConstant> entry : mapConstraints.entrySet()) {
                        String sName = entry.getKey().getValue();
                        TypeConstant type = entry.getValue();
                        ahNames[i] = xString.makeHandle(sName);
                        ahTypes[i] = (type == null ? this.pool().typeObject() : type).ensureTypeHandle(container);
                        ++i;
                    }
                    haNames = xArray.makeStringArrayHandle(ahNames);
                    haTypes = xArray.createImmutableArray(xRTType.ensureTypeArrayComposition(container), ahTypes);
                    break;
                }
                case Import: {
                    sAction = "Imports";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return xRTClassTemplate.callCreateContrib(frameCaller, hComponent, sAction, typeContrib, haParams, hDelegatee, haNames, haTypes);
        };
        return xArray.createAndFill(frame, xRTClassTemplate.ensureContribArrayComposition(container), listContrib.size(), supplier, iReturn);
    }

    private static int callCreateContrib(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, String sAction, TypeConstant typeContrib, ObjectHandle haParams, ObjectHandle hDelegatee, ObjectHandle haNames, ObjectHandle haTypes) {
        ObjectHandle[] ahVar = new ObjectHandle[CREATE_CONTRIB_METHOD.getMaxVars()];
        ahVar[0] = Utils.ensureInitializedEnum(frame, ACTION_TEMPLATE.getEnumByName(sAction));
        ahVar[1] = typeContrib.ensureTypeHandle(frame.f_context.f_container);
        ahVar[2] = haParams;
        ahVar[3] = hDelegatee;
        ahVar[4] = haNames;
        ahVar[5] = haTypes;
        return frame.call1(CREATE_CONTRIB_METHOD, hComponent, ahVar, -1);
    }

    public int getPropertyMultimethods(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        Container container = frame.f_context.f_container;
        ClassStructure clz = (ClassStructure)hComponent.getComponent();
        ArrayList<xRTComponentTemplate.ComponentTemplateHandle> listHandles = new ArrayList<xRTComponentTemplate.ComponentTemplateHandle>();
        for (Component component : clz.children()) {
            if (!(component instanceof MultiMethodStructure)) continue;
            listHandles.add(xRTClassTemplate.makeComponentHandle(container, component));
        }
        xArray.ArrayHandle hArray = xArray.createImmutableArray(xRTClassTemplate.ensureMultiMethodTemplateArrayComposition(container), listHandles.toArray(NO_TEMPLATES));
        return frame.assignValue(iReturn, hArray);
    }

    public int getPropertyProperties(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        ClassStructure clz = (ClassStructure)hComponent.getComponent();
        if (!clz.getFileStructure().isLinked()) {
            return frame.raiseException(xException.illegalState(frame, "FileTemplate is not resolved"));
        }
        ArrayList<xRTComponentTemplate.ComponentTemplateHandle> listProps = new ArrayList<xRTComponentTemplate.ComponentTemplateHandle>();
        for (Component component : clz.children()) {
            if (!(component instanceof PropertyStructure)) continue;
            PropertyStructure prop = (PropertyStructure)component;
            listProps.add(xRTPropertyTemplate.makePropertyHandle(prop));
        }
        ObjectHandle[] ahProp = listProps.toArray(NO_TEMPLATES);
        xArray.ArrayHandle arrayHandle = xArray.createImmutableArray(xRTPropertyTemplate.ensureArrayComposition(), ahProp);
        return frame.assignValue(iReturn, arrayHandle);
    }

    public int getPropertySingleton(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        ClassStructure clz = (ClassStructure)hComponent.getComponent();
        boolean fSingleton = clz.isSingleton();
        return frame.assignValue(iReturn, xBoolean.makeHandle(fSingleton));
    }

    public int getPropertyHasDefault(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        ClassStructure clz = (ClassStructure)hComponent.getComponent();
        boolean fDefault = clz.getCanonicalType().getDefaultValue() != null;
        return frame.assignValue(iReturn, xBoolean.makeHandle(fDefault));
    }

    public int getPropertySourceInfo(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        return frame.raiseException("Not implemented");
    }

    public int getPropertyType(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        ClassStructure clz = (ClassStructure)hComponent.getComponent();
        if (!clz.getFileStructure().isLinked()) {
            return frame.raiseException(xException.illegalState(frame, "FileTemplate is not resolved"));
        }
        return frame.assignValue(iReturn, xRTTypeTemplate.makeHandle(frame.f_context.f_container, clz.getIdentityConstant().getType()));
    }

    public int getPropertyTypeParams(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        Container container = frame.f_context.f_container;
        ClassStructure clz = (ClassStructure)hComponent.getComponent();
        List<Map.Entry<StringConstant, TypeConstant>> listParams = clz.getTypeParamsAsList();
        if (listParams.isEmpty()) {
            return frame.assignValue(iReturn, this.ensureEmptyTypeParameterArray(container));
        }
        int cParams = listParams.size();
        xString.StringHandle[] ahName = new xString.StringHandle[cParams];
        ObjectHandle[] ahType = new ObjectHandle[cParams];
        int i = 0;
        for (Map.Entry<StringConstant, TypeConstant> entry : listParams) {
            ahName[i] = xString.makeHandle(entry.getKey().getValue());
            ahType[i++] = xRTTypeTemplate.makeHandle(container, entry.getValue());
        }
        ObjectHandle[] ahVar = new ObjectHandle[CREATE_TYPE_PARAMETERS_METHOD.getMaxVars()];
        ahVar[0] = xArray.makeStringArrayHandle(ahName);
        ahVar[1] = xArray.createImmutableArray(xRTTypeTemplate.ensureArrayClassComposition(container), ahType);
        return frame.call1(CREATE_TYPE_PARAMETERS_METHOD, null, ahVar, iReturn);
    }

    public int getPropertyVirtualChild(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        ClassStructure clz = (ClassStructure)hComponent.getComponent();
        boolean fVirtual = clz.isVirtualChild();
        return frame.assignValue(iReturn, xBoolean.makeHandle(fVirtual));
    }

    protected int invokeEnsureClass(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        return frame.raiseException("Not implemented");
    }

    protected int invokeDeannotate(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int[] aiReturn) {
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    public static xRTComponentTemplate.ComponentTemplateHandle makeHandle(Container container, ClassStructure struct) {
        TypeComposition clz = INSTANCE.ensureClass(container, INSTANCE.getCanonicalType(), CLASS_TEMPLATE_TYPE);
        return new xRTComponentTemplate.ComponentTemplateHandle(clz, struct);
    }

    public static TypeComposition ensureContribArrayComposition(Container container) {
        return container.ensureClassComposition(CONTRIBUTION_ARRAY_TYPE, xArray.INSTANCE);
    }

    public static TypeComposition ensureClassTemplateArrayComposition(Container container) {
        return container.ensureClassComposition(CLASS_TEMPLATE_ARRAY_TYPE, xArray.INSTANCE);
    }

    public static TypeComposition ensureMultiMethodTemplateArrayComposition(Container container) {
        return container.ensureClassComposition(MULTI_METHOD_ARRAY_TYPE, xArray.INSTANCE);
    }

    public static TypeComposition ensureMethodTemplateArrayComposition(Container container) {
        return container.ensureClassComposition(METHOD_ARRAY_TYPE, xArray.INSTANCE);
    }

    public static TypeComposition ensureAnnotationTemplateArrayComposition(Container container) {
        return container.ensureClassComposition(ANNOTATION_ARRAY_TYPE, xArray.INSTANCE);
    }

    public xArray.ArrayHandle ensureEmptyTypeParameterArray(Container container) {
        xArray.ArrayHandle haEmpty = (xArray.ArrayHandle)container.f_heap.getConstHandle(EMPTY_PARAMETER_ARRAY);
        if (haEmpty == null) {
            haEmpty = xArray.createImmutableArray(container.ensureClassComposition(EMPTY_PARAMETER_ARRAY.getType(), xArray.INSTANCE), Utils.OBJECTS_NONE);
            container.f_heap.saveConstHandle(EMPTY_PARAMETER_ARRAY, haEmpty);
        }
        return haEmpty;
    }

    static {
        NO_TEMPLATES = new xRTComponentTemplate.ComponentTemplateHandle[0];
    }
}

