/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.FileStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTClassTemplate;
import org.xvm.runtime.template._native.reflect.xRTFileTemplate;
import org.xvm.runtime.template._native.reflect.xRTMethodTemplate;
import org.xvm.runtime.template._native.reflect.xRTModuleTemplate;
import org.xvm.runtime.template._native.reflect.xRTPackageTemplate;
import org.xvm.runtime.template._native.reflect.xRTPropertyTemplate;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xNullable;

public class xRTComponentTemplate
extends ClassTemplate {
    public static xRTComponentTemplate INSTANCE;
    private static TypeConstant COMPONENT_ARRAY_TYPE;
    private static ClassTemplate MULTI_METHOD_TEMPLATE;

    public xRTComponentTemplate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void registerNativeTemplates() {
        if (this == INSTANCE) {
            ClassStructure struct = this.f_container.getClassStructure("_native.reflect.RTMultiMethodTemplate");
            this.registerNativeTemplate(new xRTComponentTemplate(this.f_container, struct, false));
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("access");
        this.markNativeProperty("doc");
        this.markNativeProperty("format");
        this.markNativeProperty("isAbstract");
        this.markNativeProperty("isStatic");
        this.markNativeProperty("name");
        this.markNativeProperty("parent");
        this.markNativeProperty("synthetic");
        this.markNativeMethod("children", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        ComponentTemplateHandle hComponent = (ComponentTemplateHandle)hTarget;
        switch (sPropName) {
            case "access": {
                return this.getPropertyAccess(frame, hComponent, iReturn);
            }
            case "doc": {
                return this.getPropertyDoc(frame, hComponent, iReturn);
            }
            case "format": {
                return this.getPropertyFormat(frame, hComponent, iReturn);
            }
            case "isAbstract": {
                return this.getPropertyIsAbstract(frame, hComponent, iReturn);
            }
            case "isStatic": {
                return this.getPropertyIsStatic(frame, hComponent, iReturn);
            }
            case "name": {
                return this.getPropertyName(frame, hComponent, iReturn);
            }
            case "parent": {
                return this.getPropertyParent(frame, hComponent, iReturn);
            }
            case "synthetic": {
                return this.getPropertySynthetic(frame, hComponent, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        ComponentTemplateHandle hComponent = (ComponentTemplateHandle)hTarget;
        switch (method.getName()) {
            case "children": {
                return this.invokeChildren(frame, hComponent, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        ComponentTemplateHandle hTemplate1 = (ComponentTemplateHandle)hValue1;
        ComponentTemplateHandle hTemplate2 = (ComponentTemplateHandle)hValue2;
        return frame.assignValue(iReturn, xBoolean.makeHandle(hTemplate1.getComponent().equals(hTemplate2.getComponent())));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        ComponentTemplateHandle hTemplate1 = (ComponentTemplateHandle)hValue1;
        ComponentTemplateHandle hTemplate2 = (ComponentTemplateHandle)hValue2;
        return hTemplate1.getComponent() == hTemplate2.getComponent();
    }

    protected int getPropertyAccess(Frame frame, ComponentTemplateHandle hComponent, int iReturn) {
        Component component = hComponent.getComponent();
        Constants.Access access = component.getAccess();
        return Utils.assignInitializedEnum(frame, xRTType.makeAccessHandle(frame, access), iReturn);
    }

    protected int getPropertyDoc(Frame frame, ComponentTemplateHandle hComponent, int iReturn) {
        Component component = hComponent.getComponent();
        String sDoc = component.getDocumentation();
        return frame.assignValue(iReturn, sDoc == null ? xNullable.NULL : xString.makeHandle(sDoc));
    }

    protected int getPropertyFormat(Frame frame, ComponentTemplateHandle hComponent, int iReturn) {
        Component component = hComponent.getComponent();
        xEnum.EnumHandle hFormat = xRTComponentTemplate.makeFormatHandle(frame, component.getFormat());
        return Utils.assignInitializedEnum(frame, hFormat, iReturn);
    }

    protected int getPropertyIsAbstract(Frame frame, ComponentTemplateHandle hComponent, int iReturn) {
        Component component = hComponent.getComponent();
        return frame.assignValue(iReturn, xBoolean.makeHandle(component.isAbstract()));
    }

    protected int getPropertyIsStatic(Frame frame, ComponentTemplateHandle hComponent, int iReturn) {
        Component component = hComponent.getComponent();
        return frame.assignValue(iReturn, xBoolean.makeHandle(component.isStatic()));
    }

    protected int getPropertyName(Frame frame, ComponentTemplateHandle hComponent, int iReturn) {
        Component component = hComponent.getComponent();
        return frame.assignValue(iReturn, xString.makeHandle(component.getSimpleName()));
    }

    protected int getPropertyParent(Frame frame, ComponentTemplateHandle hComponent, int iReturn) {
        Component parent = hComponent.getComponent().getParent();
        xEnum.EnumHandle hParent = parent == null ? xNullable.NULL : xRTComponentTemplate.makeComponentHandle(frame.f_context.f_container, parent);
        return frame.assignValue(iReturn, hParent);
    }

    protected int getPropertySynthetic(Frame frame, ComponentTemplateHandle hComponent, int iReturn) {
        Component component = hComponent.getComponent();
        return frame.assignValue(iReturn, xBoolean.makeHandle(component.isSynthetic()));
    }

    protected int invokeChildren(Frame frame, ComponentTemplateHandle hComponent, int iReturn) {
        Container container = frame.f_context.f_container;
        Component component = hComponent.getComponent();
        int cChildren = component.getChildrenCount();
        ObjectHandle[] ahChildren = new ObjectHandle[cChildren];
        int i = 0;
        for (Component component2 : component.children()) {
            ahChildren[i++] = xRTComponentTemplate.makeComponentHandle(container, component2);
        }
        assert (i == cChildren);
        TypeComposition clzArray = component instanceof MultiMethodStructure ? xRTClassTemplate.ensureMethodTemplateArrayComposition(container) : container.resolveClass(xRTComponentTemplate.ensureComponentArrayType());
        return frame.assignValue(iReturn, xArray.createImmutableArray(clzArray, ahChildren));
    }

    public static TypeConstant ensureComponentArrayType() {
        TypeConstant type = COMPONENT_ARRAY_TYPE;
        if (type == null) {
            ConstantPool pool = INSTANCE.pool();
            COMPONENT_ARRAY_TYPE = type = pool.ensureArrayType(pool.ensureEcstasyTypeConstant("reflect.ComponentTemplate"));
        }
        return type;
    }

    public static TypeComposition getMultiMethodTemplateComposition(Container container) {
        ClassTemplate templateRT = MULTI_METHOD_TEMPLATE;
        if (templateRT == null) {
            MULTI_METHOD_TEMPLATE = templateRT = xRTComponentTemplate.INSTANCE.f_container.getTemplate("_native.reflect.RTMultiMethodTemplate");
        }
        ConstantPool pool = container.getConstantPool();
        TypeConstant typeTemplate = pool.ensureEcstasyTypeConstant("reflect.MultiMethodTemplate");
        return templateRT.ensureClass(container, typeTemplate);
    }

    protected static xEnum.EnumHandle makeFormatHandle(Frame frame, Component.Format format) {
        xEnum enumForm = (xEnum)xRTComponentTemplate.INSTANCE.f_container.getTemplate("reflect.ComponentTemplate.Format");
        switch (format) {
            case INTERFACE: {
                return enumForm.getEnumByName("Interface");
            }
            case CLASS: {
                return enumForm.getEnumByName("Class");
            }
            case CONST: {
                return enumForm.getEnumByName("Const");
            }
            case ENUM: {
                return enumForm.getEnumByName("Enum");
            }
            case ENUMVALUE: {
                return enumForm.getEnumByName("EnumValue");
            }
            case ANNOTATION: {
                return enumForm.getEnumByName("Annotation");
            }
            case MIXIN: {
                return enumForm.getEnumByName("Mixin");
            }
            case SERVICE: {
                return enumForm.getEnumByName("Service");
            }
            case PACKAGE: {
                return enumForm.getEnumByName("Package");
            }
            case MODULE: {
                return enumForm.getEnumByName("Module");
            }
            case TYPEDEF: {
                return enumForm.getEnumByName("TypeDef");
            }
            case PROPERTY: {
                return enumForm.getEnumByName("Property");
            }
            case METHOD: {
                return enumForm.getEnumByName("Method");
            }
            case RSVD_D: {
                return enumForm.getEnumByName("Reserved_D");
            }
            case MULTIMETHOD: {
                return enumForm.getEnumByName("MultiMethod");
            }
            case FILE: {
                return enumForm.getEnumByName("File");
            }
        }
        throw new IllegalStateException("unsupported format: " + String.valueOf((Object)format));
    }

    public static ComponentTemplateHandle makeComponentHandle(Container container, Component component) {
        switch (component.getFormat()) {
            case FILE: {
                return xRTFileTemplate.makeHandle(container, (FileStructure)component);
            }
            case MODULE: {
                return xRTModuleTemplate.makeHandle(container, (ModuleStructure)component);
            }
            case PACKAGE: {
                return xRTPackageTemplate.makeHandle(container, (PackageStructure)component);
            }
            case INTERFACE: 
            case CLASS: 
            case CONST: 
            case ENUM: 
            case ENUMVALUE: 
            case ANNOTATION: 
            case MIXIN: 
            case SERVICE: {
                return xRTClassTemplate.makeHandle(container, (ClassStructure)component);
            }
            case MULTIMETHOD: {
                return new ComponentTemplateHandle(xRTComponentTemplate.getMultiMethodTemplateComposition(container), component);
            }
            case METHOD: {
                return xRTMethodTemplate.makeHandle((MethodStructure)component);
            }
            case PROPERTY: {
                return xRTPropertyTemplate.makePropertyHandle((PropertyStructure)component);
            }
        }
        throw new UnsupportedOperationException("unsupported format " + String.valueOf((Object)component.getFormat()));
    }

    public static class ComponentTemplateHandle
    extends ObjectHandle.GenericHandle {
        private final Component f_struct;

        protected ComponentTemplateHandle(TypeComposition clz, Component component) {
            super(clz);
            this.f_struct = component;
            this.m_fMutable = false;
        }

        public Component getComponent() {
            return this.f_struct;
        }

        @Override
        public String toString() {
            return super.toString() + this.f_struct.getName();
        }
    }
}

