/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Map;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.FileStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Version;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.mgmt.xCoreRepository;
import org.xvm.runtime.template._native.reflect.xRTComponentTemplate;
import org.xvm.runtime.template._native.reflect.xRTModuleTemplate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.reflect.xPackage;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;

public class xRTFileTemplate
extends xRTComponentTemplate {
    public static xRTFileTemplate INSTANCE;
    public static TypeConstant FILE_TEMPLATE_TYPE;
    private static MethodStructure LINK_MODULES_METHOD;

    public xRTFileTemplate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        FILE_TEMPLATE_TYPE = this.pool().ensureEcstasyTypeConstant("reflect.FileTemplate");
        LINK_MODULES_METHOD = this.f_struct.findMethod("linkModules", 1, new TypeConstant[0]);
        this.markNativeProperty("mainModule");
        this.markNativeProperty("resolved");
        this.markNativeProperty("contents");
        this.markNativeProperty("createdMillis");
        this.markNativeMethod("extractVersionImpl", STRING, null);
        this.markNativeMethod("resolve", null, null);
        this.markNativeMethod("replace", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hFile = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        FileStructure fileStruct = (FileStructure)hFile.getComponent();
        switch (sPropName) {
            case "mainModule": {
                return frame.assignValue(iReturn, xRTModuleTemplate.makeHandle(frame.f_context.f_container, fileStruct.getModule()));
            }
            case "resolved": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(fileStruct.isLinked()));
            }
            case "contents": {
                return this.getPropertyContents(frame, fileStruct, iReturn);
            }
            case "createdMillis": {
                File fileOS = fileStruct.getOSFile();
                if (fileOS != null) {
                    try {
                        BasicFileAttributes attr = Files.readAttributes(fileOS.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                        return frame.assignValue(iReturn, xInt64.makeHandle(attr.lastModifiedTime().toMillis()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return frame.assignValue(iReturn, xInt64.makeHandle(0L));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hFile = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        FileStructure file = (FileStructure)hFile.getComponent();
        switch (method.getName()) {
            case "resolve": {
                return this.invokeResolve(frame, file, hArg, Utils.OBJECTS_NONE, Utils.OBJECTS_NONE, iReturn);
            }
            case "replace": {
                return this.invokeReplace(frame, file, (xArray.ArrayHandle)hArg);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hFile = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        FileStructure file = (FileStructure)hFile.getComponent();
        switch (method.getName()) {
            case "extractVersionImpl": {
                String sVersion = ((xString.StringHandle)ahArg[0]).getStringValue();
                ModuleStructure module = file.getModule();
                if (!sVersion.isEmpty()) {
                    Version version = new Version(sVersion);
                    module = module.containsVersion(version) ? module.extractVersion(version) : null;
                }
                return module == null ? frame.assignValue(aiReturn[0], xBoolean.FALSE) : frame.assignValues(aiReturn, xBoolean.TRUE, xRTModuleTemplate.makeHandle(frame.f_context.f_container, module));
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    private int getPropertyContents(Frame frame, FileStructure fileStruct, int iReturn) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            fileStruct.writeTo(stream);
        }
        catch (IOException e) {
            return frame.raiseException(xException.ioException(frame, e.getMessage()));
        }
        return frame.assignValue(iReturn, xArray.makeByteArrayHandle(stream.toByteArray(), xArray.Mutability.Constant));
    }

    public int invokeResolve(Frame frame, FileStructure file, ObjectHandle hRepo, ObjectHandle[] ahSharedModules, ObjectHandle[] ahAddModules, int iReturn) {
        ObjectHandle.GenericHandle hModule;
        Container container = frame.f_context.f_container;
        int cShared = ahSharedModules.length;
        int cAdditional = ahAddModules.length;
        if (file.isLinked()) {
            if (cShared + cAdditional == 0) {
                return frame.assignValue(iReturn, xRTFileTemplate.makeHandle(container, file));
            }
        } else {
            file = container.createFileStructure(file.getModule());
        }
        for (ObjectHandle hSharedModule : ahSharedModules) {
            hModule = (xPackage.PackageHandle)hSharedModule;
            file.merge((ModuleStructure)((xPackage.PackageHandle)hModule).getStructure(), true, false);
            assert (file.validateConstants());
        }
        for (ObjectHandle hAddModule : ahAddModules) {
            hModule = (xRTComponentTemplate.ComponentTemplateHandle)hAddModule;
            file.merge((ModuleStructure)((xRTComponentTemplate.ComponentTemplateHandle)hModule).getComponent(), true, false);
            assert (file.validateConstants());
        }
        if (hRepo.getTemplate() instanceof xCoreRepository) {
            ModuleConstant idMissing = file.linkModules(this.f_container.getModuleRepository(), true);
            return idMissing == null ? frame.assignValue(iReturn, xRTFileTemplate.makeHandle(container, file)) : frame.raiseException("Missing dependent module: " + idMissing.getName());
        }
        ObjectHandle[] ahArg = new ObjectHandle[LINK_MODULES_METHOD.getMaxVars()];
        ahArg[0] = hRepo;
        FileStructure fileUnlinked = file;
        switch (frame.call1(LINK_MODULES_METHOD, xRTFileTemplate.makeHandle(container, fileUnlinked), ahArg, iReturn)) {
            case -1: {
                fileUnlinked.markLinked();
                return frame.assignValue(iReturn, xRTFileTemplate.makeHandle(container, fileUnlinked));
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> {
                    fileUnlinked.markLinked();
                    return frameCaller.assignValue(iReturn, xRTFileTemplate.makeHandle(container, fileUnlinked));
                });
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    private int invokeReplace(Frame frame, FileStructure file, xArray.ArrayHandle hArray) {
        ArrayList<ModuleStructure> listUnlinked = new ArrayList<ModuleStructure>();
        xRTDelegate.GenericArrayDelegate haGeneric = (xRTDelegate.GenericArrayDelegate)hArray.m_hDelegate;
        long c = haGeneric.m_cSize;
        for (long i = 0L; i < c; ++i) {
            xRTComponentTemplate.ComponentTemplateHandle hModule = (xRTComponentTemplate.ComponentTemplateHandle)haGeneric.get(i);
            ModuleStructure moduleUnlinked = (ModuleStructure)hModule.getComponent();
            ModuleStructure moduleReplace = file.getModule(moduleUnlinked.getIdentityConstant());
            if (moduleReplace == null) {
                return frame.raiseException("Missing module \"" + moduleUnlinked.getName() + "\" at " + String.valueOf(file.getModuleId()));
            }
            if (!moduleReplace.isFingerprint()) continue;
            listUnlinked.add(moduleUnlinked);
        }
        file.replace(listUnlinked);
        return -1;
    }

    @Override
    protected int invokeChildren(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        FileStructure file = (FileStructure)hComponent.getComponent();
        ModuleStructure module = file.getModule();
        Map<ModuleConstant, String> mapModulePaths = module.collectDependencies();
        int cModules = mapModulePaths.size() - 1;
        ObjectHandle[] ahModule = new ObjectHandle[cModules];
        Container container = frame.f_context.f_container;
        int index = 0;
        for (ModuleConstant idDep : mapModulePaths.keySet()) {
            if (idDep.equals(module.getIdentityConstant())) continue;
            ahModule[index++] = xRTFileTemplate.makeComponentHandle(container, file.getModule(idDep));
        }
        assert (index == cModules);
        TypeComposition clzArray = container.resolveClass(xRTFileTemplate.ensureComponentArrayType());
        return frame.assignValue(iReturn, xArray.createImmutableArray(clzArray, ahModule));
    }

    @Override
    protected int buildStringValue(Frame frame, ObjectHandle hTarget, int iReturn) {
        FileStructure module = (FileStructure)((xRTComponentTemplate.ComponentTemplateHandle)hTarget).getComponent();
        return frame.assignValue(iReturn, xString.makeHandle(module.getModuleId().getName()));
    }

    public static xRTComponentTemplate.ComponentTemplateHandle makeHandle(Container container, FileStructure fileStruct) {
        TypeComposition clzFile = INSTANCE.ensureClass(container, INSTANCE.getCanonicalType(), FILE_TEMPLATE_TYPE);
        return new xRTComponentTemplate.ComponentTemplateHandle(clzFile, fileStruct);
    }
}

