/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Parameter;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTMethod;
import org.xvm.runtime.template._native.reflect.xRTMethodTemplate;
import org.xvm.runtime.template._native.reflect.xRTSignature;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xOrdered;
import org.xvm.runtime.template.xService;

public class xRTFunction
extends xRTSignature {
    public static xRTFunction INSTANCE;
    private static TypeConstant FUNCTION_ARRAY_TYPE;
    private static ArrayConstant EMPTY_FUNCTION_ARRAY;
    private static TypeConstant LISTMAP_TYPE;
    private static MethodStructure TO_ARRAY;

    public xRTFunction(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.f_container.getConstantPool();
        TO_ARRAY = this.getStructure().findMethod("toArray", 1, new TypeConstant[0]);
        FUNCTION_ARRAY_TYPE = pool.ensureArrayType(pool.typeFunction());
        EMPTY_FUNCTION_ARRAY = pool.ensureArrayConstant(FUNCTION_ARRAY_TYPE, Constant.NO_CONSTS);
        this.markNativeMethod("bind", new String[]{"reflect.Type<Object>", "reflect.Parameter", "Object"}, null);
        this.markNativeMethod("bind", new String[]{"maps.Map<reflect.Parameter, Object>"}, null);
        this.markNativeMethod("invoke", null, null);
        this.markNativeMethod("isFunction", null, null);
        this.markNativeMethod("isMethod", null, null);
        super.initNative();
    }

    @Override
    public TypeComposition ensureClass(Container container, TypeConstant typeActual) {
        ConstantPool pool = container.getConstantPool();
        assert (typeActual.isA(pool.typeFunction()));
        TypeConstant typeP = pool.typeTuple0();
        TypeConstant typeR = typeActual.getParamType(1);
        TypeConstant typeClz = pool.ensureParameterizedTypeConstant(pool.typeFunction(), typeP, typeR);
        return super.ensureClass(container, typeClz);
    }

    protected TypeComposition ensureClass(Container container, MethodStructure function) {
        ConstantPool pool = container.getConstantPool();
        TypeConstant[] atypeR = function.getIdentityConstant().getRawReturns();
        TypeConstant typeP = pool.typeTuple0();
        TypeConstant typeR = atypeR.length == 0 ? pool.typeTuple0() : pool.ensureTupleType(atypeR);
        TypeConstant typeClz = pool.ensureParameterizedTypeConstant(pool.typeFunction(), typeP, typeR);
        Annotation[] aAnno = function.getAnnotations();
        if (aAnno.length > 0) {
            typeClz = pool.ensureAnnotatedTypeConstant(typeClz, function.getAnnotations());
        }
        return super.ensureClass(container, typeClz);
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof MethodConstant) {
            MethodConstant idFunc = (MethodConstant)constant;
            MethodStructure structFunc = (MethodStructure)idFunc.getComponent();
            assert (structFunc.isFunction());
            return frame.pushStack(new FunctionHandle(frame.f_context.f_container, structFunc));
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int createProxyHandle(Frame frame, ServiceContext ctxTarget, ObjectHandle hTarget, TypeConstant typeProxy) {
        return frame.assignValue(-1, ((FunctionHandle)hTarget).createProxyHandle(ctxTarget));
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        FunctionHandle hFunc = (FunctionHandle)hTarget;
        switch (method.getName()) {
            case "bind": {
                return this.invokeBind(frame, hFunc, hArg, iReturn);
            }
            case "invoke": {
                return this.invokeInvoke(frame, hFunc, hArg, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        FunctionHandle hFunc = (FunctionHandle)hTarget;
        switch (method.getName()) {
            case "bind": {
                return this.invokeBind(frame, hFunc, ahArg, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        FunctionHandle hFunc = (FunctionHandle)hTarget;
        switch (method.getName()) {
            case "isFunction": {
                return this.invokeIsFunction(frame, hFunc, aiReturn);
            }
            case "isMethod": {
                return this.invokeIsMethod(frame, hFunc, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    protected int callEqualsImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hValue1 == hValue2));
    }

    @Override
    protected int callCompareImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xOrdered.makeHandle(hValue1.hashCode() - hValue2.hashCode()));
    }

    public int invokeBind(Frame frame, FunctionHandle hFunc, ObjectHandle hArg, int iReturn) {
        Frame.Continuation stepBind = frameCaller -> {
            try {
                xArray.ArrayHandle haValues = (xArray.ArrayHandle)frameCaller.popStack();
                xArray.ArrayHandle haOrdinals = (xArray.ArrayHandle)frameCaller.popStack();
                FunctionHandle hFuncR = hFunc;
                int ixPrev = Integer.MAX_VALUE;
                ObjectHandle[] ahOrdinal = haOrdinals.getTemplate().toArray(frame, haOrdinals);
                ObjectHandle[] ahValue = haValues.getTemplate().toArray(frame, haValues);
                int c = ahOrdinal.length;
                for (int i = 0; i < c; ++i) {
                    int ix = (int)((ObjectHandle.JavaLong)ahOrdinal[i]).getValue();
                    boolean fAdjust = ix > ixPrev;
                    ixPrev = ix;
                    if (fAdjust) {
                        ix -= i;
                    }
                    hFuncR = hFuncR.bind(frameCaller, ix, ahValue[i]);
                }
                return frameCaller.assignValue(iReturn, hFuncR);
            }
            catch (Exception e) {
                return frameCaller.raiseException(e.getMessage());
            }
        };
        ObjectHandle[] ahArg = new ObjectHandle[TO_ARRAY.getMaxVars()];
        ahArg[0] = hArg;
        Frame frameNext = frame.createFrameN(TO_ARRAY, null, ahArg, new int[]{-1, -1});
        frameNext.addContinuation(stepBind);
        return frame.callInitialized(frameNext);
    }

    public int invokeBind(Frame frame, FunctionHandle hFunc, ObjectHandle[] ahArg, int iReturn) {
        ObjectHandle.GenericHandle hParam = (ObjectHandle.GenericHandle)ahArg[1];
        ObjectHandle hValue = ahArg[2];
        long nOrdinal = ((ObjectHandle.JavaLong)hParam.getField(frame, "ordinal")).getValue();
        FunctionHandle hFuncR = hFunc.bind(frame, (int)nOrdinal, hValue);
        return frame.assignValue(iReturn, hFuncR);
    }

    public int invokeInvoke(Frame frame, FunctionHandle hFunc, ObjectHandle hArg, int iReturn) {
        ObjectHandle[] ahVar;
        xTuple.TupleHandle hTuple = (xTuple.TupleHandle)hArg;
        ObjectHandle[] ahArg = hTuple.m_ahValue;
        int cArgs = ahArg.length;
        int cParams = hFunc.getParamCount();
        int cVars = hFunc.getVarCount();
        ObjectHandle[] objectHandleArray = ahVar = cArgs == cVars ? (ObjectHandle[])ahArg.clone() : Utils.ensureSize(ahArg, cVars);
        if (cArgs != cParams) {
            MethodStructure method;
            boolean fValid;
            boolean bl = fValid = cArgs < cParams;
            if (fValid && (method = hFunc.getMethod()) != null) {
                for (int i = cArgs; i < cParams; ++i) {
                    Parameter param = hFunc.getParam(i);
                    if (!param.hasDefaultValue()) {
                        fValid = false;
                        break;
                    }
                    ahVar[i] = ObjectHandle.DEFAULT;
                }
            }
            if (!fValid) {
                return frame.raiseException("Invalid tuple argument");
            }
        }
        for (int i = 0; i < cArgs; ++i) {
            TypeConstant typeParam = hFunc.getParamType(i);
            TypeConstant typeArg = ahArg[i].getUnsafeType();
            if (typeArg.isA(typeParam)) continue;
            return frame.raiseException(xException.typeMismatch(frame, typeArg.getValueString()));
        }
        return hFunc.callT(frame, null, ahVar, iReturn);
    }

    public int invokeIsFunction(Frame frame, FunctionHandle hFunc, int[] aiReturn) {
        MethodStructure method = hFunc.getMethod();
        if (method != null && method.isFunction()) {
            int cParams = method.getParamCount();
            ObjectHandle[] ahParam = new ObjectHandle[cParams];
            ObjectHandle[] ahValue = new ObjectHandle[cParams];
            hFunc.addBoundArguments(ahValue);
            frame.assignValue(aiReturn[0], xBoolean.TRUE);
            frame.assignValue(aiReturn[1], xRTMethodTemplate.makeHandle(method));
            frame.assignValue(aiReturn[2], xRTFunction.makeHandle(frame, method));
            Frame.Continuation stepNext = frameCaller -> this.constructListMap(frameCaller, ahParam, ahValue, aiReturn[3]);
            return new Utils.CreateParameters(method.getParamArray(), ahParam, stepNext).doNext(frame);
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    private int constructListMap(Frame frame, ObjectHandle[] ahParam, ObjectHandle[] ahValue, int iReturn) {
        xArray.ArrayHandle haParams = xArray.createImmutableArray(xRTSignature.ensureParamArray(), ahParam);
        xArray.ArrayHandle haValues = xArray.makeObjectArrayHandle(ahValue, xArray.Mutability.Constant);
        return Utils.constructListMap(frame, frame.f_context.f_container.resolveClass(xRTFunction.ensureListMapType()), haParams, haValues, iReturn);
    }

    public int invokeIsMethod(Frame frame, FunctionHandle hFunc, int[] aiReturn) {
        MethodStructure method = hFunc.getMethod();
        if (method != null && !method.isFunction()) {
            ObjectHandle[] ahValue = new ObjectHandle[method.getParamCount()];
            hFunc.addBoundArguments(ahValue);
            ObjectHandle hTarget = hFunc.getTarget();
            ObjectHandle hMethod = xRTMethod.makeHandle(frame, hTarget.getType(), method.getIdentityConstant());
            return Op.isDeferred(hMethod) ? hMethod.proceed(frame.m_frameNext, frameCaller -> this.createMethodParams(frameCaller, method, hMethod, hTarget, ahValue, aiReturn)) : this.createMethodParams(frame, method, hMethod, hTarget, ahValue, aiReturn);
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    private int createMethodParams(Frame frame, MethodStructure method, ObjectHandle hMethod, ObjectHandle hTarget, ObjectHandle[] ahValue, int[] aiReturn) {
        ObjectHandle[] ahParam = new ObjectHandle[method.getParamCount()];
        frame.assignValue(aiReturn[0], xBoolean.TRUE);
        frame.assignValue(aiReturn[1], hTarget);
        frame.assignValue(aiReturn[2], hMethod);
        Frame.Continuation stepNext = frameCaller -> this.constructListMap(frameCaller, ahParam, ahValue, aiReturn[3]);
        return new Utils.CreateParameters(method.getParamArray(), ahParam, stepNext).doNext(frame);
    }

    public static AsyncHandle makeAsyncHandle(Frame frame, CallChain chain) {
        return new AsyncHandle(frame.f_context.f_container, chain);
    }

    public static FunctionHandle makeAsyncDelegatingHandle(xService.ServiceHandle hService, FunctionHandle hDelegate) {
        return new FunctionProxyHandle(hDelegate, hService.f_context);
    }

    public static AsyncHandle makeAsyncNativeHandle(MethodStructure method) {
        assert (method.isNative());
        return new AsyncHandle(xRTFunction.INSTANCE.f_container, method);
    }

    public static FunctionHandle makeHandle(Frame frame, CallChain chain, int nDepth) {
        return new FunctionHandle(frame.f_context.f_container, chain, nDepth);
    }

    public static FunctionHandle makeInternalHandle(Frame frame, MethodStructure function) {
        Container container = frame == null ? xRTFunction.INSTANCE.f_container : frame.f_context.f_container;
        return new FunctionHandle(container, function);
    }

    public static ObjectHandle makeHandle(Frame frame, MethodStructure function) {
        Container container = frame == null ? xRTFunction.INSTANCE.f_container : frame.f_context.f_container;
        Annotation[] aAnno = function.getAnnotations();
        if (aAnno.length > 0) {
            TypeConstant type = function.getIdentityConstant().getSignature().asFunctionType();
            type = container.getConstantPool().ensureAnnotatedTypeConstant(type, aAnno);
            TypeComposition clzFunction = INSTANCE.ensureClass(container, function);
            FunctionHandle hStruct = new FunctionHandle(clzFunction.ensureAccess(Constants.Access.STRUCT), type, function);
            int iResult = hStruct.getTemplate().proceedConstruction(frame, null, true, hStruct, Utils.OBJECTS_NONE, -1);
            return frame.popResultImmutable(iResult);
        }
        return new FunctionHandle(container, function);
    }

    public static ObjectHandle makeConstructorHandle(Frame frame, MethodStructure constructor, TypeConstant typeConstructor, TypeComposition clzTarget, Parameter[] aParams, boolean fParent) {
        TypeComposition clzConstruct;
        Container container = frame.f_context.f_container;
        if (constructor == null) {
            clzConstruct = INSTANCE.ensureClass(container, typeConstructor);
        } else {
            Annotation[] aAnno = constructor.getAnnotations();
            if (aAnno.length > 0) {
                typeConstructor = container.getConstantPool().ensureAnnotatedTypeConstant(typeConstructor, aAnno);
                TypeComposition clzConstructor = INSTANCE.ensureClass(container, constructor).ensureAccess(Constants.Access.STRUCT);
                ConstructorHandle hConstructor = new ConstructorHandle(clzConstructor, clzTarget, typeConstructor, constructor, aParams, fParent);
                int iResult = hConstructor.getTemplate().proceedConstruction(frame, null, true, hConstructor, Utils.OBJECTS_NONE, -1);
                return frame.popResultImmutable(iResult);
            }
            clzConstruct = INSTANCE.ensureClass(container, constructor);
        }
        return new ConstructorHandle(clzConstruct, clzTarget, typeConstructor, constructor, aParams, fParent);
    }

    public static TypeComposition ensureArrayComposition(Container container) {
        return container.ensureClassComposition(FUNCTION_ARRAY_TYPE, xArray.INSTANCE);
    }

    public static xArray.ArrayHandle ensureEmptyArray(Container container) {
        xArray.ArrayHandle haEmpty = (xArray.ArrayHandle)container.f_heap.getConstHandle(EMPTY_FUNCTION_ARRAY);
        if (haEmpty == null) {
            haEmpty = xArray.createImmutableArray(xRTFunction.ensureArrayComposition(container), Utils.OBJECTS_NONE);
            container.f_heap.saveConstHandle(EMPTY_FUNCTION_ARRAY, haEmpty);
        }
        return haEmpty;
    }

    public static TypeConstant ensureListMapType() {
        TypeConstant type = LISTMAP_TYPE;
        if (type == null) {
            ConstantPool pool = INSTANCE.pool();
            LISTMAP_TYPE = type = pool.ensureParameterizedTypeConstant(pool.ensureEcstasyTypeConstant("maps.ListMap"), pool.typeParameter(), pool.typeObject());
        }
        return type;
    }

    public static TypeComposition ensureConstructorArray(Frame frame, TypeConstant typeTarget, TypeConstant typeParent) {
        assert (typeTarget != null);
        ConstantPool pool = frame.poolContext();
        TypeConstant typeParams = typeParent == null ? pool.typeTuple0() : pool.ensureTupleType(typeParent);
        TypeConstant typeReturns = pool.ensureTupleType(typeTarget);
        TypeConstant typeCtor = pool.ensureParameterizedTypeConstant(pool.typeFunction(), typeParams, typeReturns);
        TypeConstant typeArray = pool.ensureArrayType(typeCtor);
        return frame.f_context.f_container.resolveClass(typeArray);
    }

    public static class FunctionHandle
    extends xRTSignature.SignatureHandle {
        protected FunctionHandle(Container container, MethodStructure function) {
            this(container, function.getIdentityConstant().getSignature().asFunctionType(), function);
            this.m_fMutable = false;
        }

        protected FunctionHandle(Container container, CallChain chain, int nDepth) {
            super(INSTANCE.ensureClass(container, chain.getMethod(nDepth).getIdentityConstant().getSignature().asFunctionType()), chain, nDepth);
            this.m_fMutable = false;
        }

        protected FunctionHandle(Container container, TypeConstant type, MethodStructure function) {
            this(INSTANCE.ensureClass(container, type), type, function);
        }

        protected FunctionHandle(TypeComposition clz, TypeConstant type, MethodStructure function) {
            super(clz, function == null ? null : function.getIdentityConstant(), function, type);
            this.m_fMutable = clz.isStruct();
        }

        @Override
        public ObjectHandle revealOrigin() {
            return this;
        }

        @Override
        public boolean isPassThrough(Container container) {
            if (container != null && !this.getType().isShared(container.getModule().getConstantPool())) {
                return false;
            }
            return this.checkArgumentsPassThrough(container);
        }

        protected boolean checkArgumentsPassThrough(Container container) {
            return true;
        }

        public int call1(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
            ObjectHandle[] ahVar = this.prepareVars(ahArg);
            this.addBoundArguments(ahVar);
            return this.call1Impl(frame, hTarget, ahVar, iReturn);
        }

        public int callT(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
            ObjectHandle[] ahVar = this.prepareVars(ahArg);
            this.addBoundArguments(ahVar);
            return this.callTImpl(frame, hTarget, ahVar, iReturn);
        }

        public int callN(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
            ObjectHandle[] ahVar = this.prepareVars(ahArg);
            this.addBoundArguments(ahVar);
            return this.callNImpl(frame, hTarget, ahVar, aiReturn);
        }

        public FunctionHandle bindTarget(Frame frame, ObjectHandle hTarget) {
            TypeConstant type = frame == null ? this.f_type : this.f_type.resolveGenerics(frame.poolContext(), hTarget.getType());
            return new SingleBoundHandle(hTarget.getComposition().getContainer(), type, this, -1, hTarget);
        }

        public FunctionHandle bind(Frame frame, int iArg, ObjectHandle hArg) {
            Parameter parameter;
            assert (iArg >= 0);
            ConstantPool pool = frame.poolContext();
            GenericTypeResolver resolver = frame.getGenericsResolver(true);
            MethodStructure method = this.getMethod();
            if (method != null && (parameter = this.getParam(iArg)).isTypeParameter()) {
                xRTType.TypeHandle hType = (xRTType.TypeHandle)hArg;
                resolver = sName -> sName.equals(parameter.getName()) ? hType.getDataType() : null;
            }
            TypeConstant typeFn = pool.bindFunctionParam(this.f_type.resolveGenerics(pool, resolver), iArg);
            return new SingleBoundHandle(frame.f_context.f_container, typeFn, this, iArg, hArg);
        }

        protected int calculateShift(int iArg) {
            return 0;
        }

        public FullyBoundHandle bindArguments(ObjectHandle ... ahArg) {
            return new FullyBoundHandle(this.getComposition().getContainer(), this, ahArg);
        }

        protected ObjectHandle[] prepareVars(ObjectHandle[] ahArg) {
            return Utils.ensureSize(ahArg, this.getVarCount());
        }

        protected int call1Impl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            return this.f_method == null ? (this.f_chain.isNative() ? (ahVar.length == 1 ? hTarget.getTemplate().invokeNative1(frame, this.f_chain.getTop(), hTarget, ahVar[0], iReturn) : hTarget.getTemplate().invokeNativeN(frame, this.f_chain.getTop(), hTarget, ahVar, iReturn)) : frame.invoke1(this.f_chain, this.f_nDepth, hTarget, ahVar, iReturn)) : (this.f_method.isNative() ? (ahVar.length == 1 ? hTarget.getTemplate().invokeNative1(frame, this.f_method, hTarget, ahVar[0], iReturn) : hTarget.getTemplate().invokeNativeN(frame, this.f_method, hTarget, ahVar, iReturn)) : frame.call1(this.f_method, hTarget, ahVar, iReturn));
        }

        protected int callTImpl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            return this.f_method == null ? (this.f_chain.isNative() ? hTarget.getTemplate().invokeNativeT(frame, this.f_chain.getTop(), hTarget, ahVar, iReturn) : frame.invokeT(this.f_chain, this.f_nDepth, hTarget, ahVar, iReturn)) : (this.f_method.isNative() ? hTarget.getTemplate().invokeNativeT(frame, this.f_method, hTarget, ahVar, iReturn) : frame.callT(this.f_method, hTarget, ahVar, iReturn));
        }

        protected int callNImpl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
            return this.f_method == null ? (this.f_chain.isNative() ? hTarget.getTemplate().invokeNativeNN(frame, this.f_chain.getTop(), hTarget, ahVar, aiReturn) : frame.invokeN(this.f_chain, this.f_nDepth, hTarget, ahVar, aiReturn)) : (this.f_method.isNative() ? hTarget.getTemplate().invokeNativeNN(frame, this.f_method, hTarget, ahVar, aiReturn) : frame.callN(this.f_method, hTarget, ahVar, aiReturn));
        }

        protected ObjectHandle getTarget() {
            return null;
        }

        protected int addBoundArguments(ObjectHandle[] ahVar) {
            return 0;
        }

        protected FunctionHandle createProxyHandle(ServiceContext ctx) {
            return null;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName()).append('(');
            int c = this.getParamCount();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getParam(i).getName());
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class AsyncHandle
    extends FunctionHandle {
        protected AsyncHandle(Container container, CallChain chain) {
            super(container, chain, 0);
        }

        protected AsyncHandle(Container container, MethodStructure method) {
            super(container, method);
            assert (method.isNative());
        }

        protected ObjectHandle getContextTarget(Frame frame, ObjectHandle hService) {
            return hService;
        }

        @Override
        public boolean isAsync() {
            return true;
        }

        @Override
        protected int call1Impl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            assert (hTarget.isService());
            ServiceContext ctxTarget = hTarget.getService().f_context;
            if (frame.f_context == ctxTarget) {
                ObjectHandle hCtxTarget = this.getContextTarget(frame, hTarget);
                return Op.isDeferred(hCtxTarget) ? hCtxTarget.proceed(frame, frameCaller -> super.call1Impl(frameCaller, frameCaller.popStack(), ahVar, iReturn)) : super.call1Impl(frame, hCtxTarget, ahVar, iReturn);
            }
            switch (frame.f_context.validatePassThrough(frame, ctxTarget, this.supplier(frame, hTarget), ahVar)) {
                case -1: {
                    return ctxTarget.sendInvoke1Request(frame, this, hTarget, ahVar, false, iReturn);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> ctxTarget.sendInvoke1Request(frameCaller, this, hTarget, ahVar, false, iReturn));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        protected int callTImpl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            assert (hTarget.isService());
            ServiceContext ctxTarget = hTarget.getService().f_context;
            if (frame.f_context == ctxTarget) {
                ObjectHandle hCtxTarget = this.getContextTarget(frame, hTarget);
                return Op.isDeferred(hCtxTarget) ? hCtxTarget.proceed(frame, frameCaller -> super.callTImpl(frameCaller, frameCaller.popStack(), ahVar, iReturn)) : super.callTImpl(frame, hCtxTarget, ahVar, iReturn);
            }
            switch (frame.f_context.validatePassThrough(frame, ctxTarget, this.supplier(frame, hTarget), ahVar)) {
                case -1: {
                    return ctxTarget.sendInvoke1Request(frame, this, hTarget, ahVar, true, iReturn);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> ctxTarget.sendInvoke1Request(frameCaller, this, hTarget, ahVar, true, iReturn));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        protected int callNImpl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
            assert (hTarget.isService());
            ServiceContext ctxTarget = hTarget.getService().f_context;
            if (frame.f_context == ctxTarget) {
                ObjectHandle hCtxTarget = this.getContextTarget(frame, hTarget);
                return Op.isDeferred(hCtxTarget) ? hCtxTarget.proceed(frame, frameCaller -> super.callNImpl(frameCaller, frameCaller.popStack(), ahVar, aiReturn)) : super.callNImpl(frame, hCtxTarget, ahVar, aiReturn);
            }
            switch (frame.f_context.validatePassThrough(frame, ctxTarget, this.supplier(frame, hTarget), ahVar)) {
                case -1: {
                    return ctxTarget.sendInvokeNRequest(frame, this, hTarget, ahVar, aiReturn);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> ctxTarget.sendInvokeNRequest(frameCaller, this, hTarget, ahVar, aiReturn));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }

        private ServiceContext.TypeSupplier supplier(Frame frame, ObjectHandle hTarget) {
            return i -> {
                TypeConstant type = this.getParamTypes()[i];
                ObjectHandle hCtx = this.getContextTarget(frame, hTarget);
                return hCtx == null || Op.isDeferred(hCtx) ? type : type.resolveGenerics(frame.poolContext(), hCtx.getType());
            };
        }
    }

    public static class FunctionProxyHandle
    extends DelegatingHandle {
        private final ServiceContext f_ctx;

        protected FunctionProxyHandle(FunctionHandle fn, ServiceContext ctx) {
            super(fn.getComposition().getContainer(), fn.getType(), fn);
            this.f_ctx = ctx;
        }

        @Override
        public boolean isService() {
            return true;
        }

        @Override
        public boolean isPassThrough(Container container) {
            return true;
        }

        @Override
        public int call1(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            if (frame.f_context == this.f_ctx) {
                return super.call1(frame, hTarget, ahVar, iReturn);
            }
            switch (frame.f_context.validatePassThrough(frame, this.f_ctx, i -> this.getParamTypes()[i], ahVar)) {
                case -1: {
                    return this.f_ctx.sendInvoke1Request(frame, this, hTarget, ahVar, false, iReturn);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> this.f_ctx.sendInvoke1Request(frameCaller, this, hTarget, ahVar, false, iReturn));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public int callT(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            if (frame.f_context == this.f_ctx) {
                return super.callT(frame, hTarget, ahVar, iReturn);
            }
            switch (frame.f_context.validatePassThrough(frame, this.f_ctx, i -> this.getParamTypes()[i], ahVar)) {
                case -1: {
                    return this.f_ctx.sendInvoke1Request(frame, this, hTarget, ahVar, true, iReturn);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> this.f_ctx.sendInvoke1Request(frameCaller, this, hTarget, ahVar, true, iReturn));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public int callN(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
            if (frame.f_context == this.f_ctx) {
                return super.callN(frame, hTarget, ahVar, aiReturn);
            }
            switch (frame.f_context.validatePassThrough(frame, this.f_ctx, i -> this.getParamTypes()[i], ahVar)) {
                case -1: {
                    return this.f_ctx.sendInvokeNRequest(frame, this, hTarget, ahVar, aiReturn);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> this.f_ctx.sendInvokeNRequest(frameCaller, this, hTarget, ahVar, aiReturn));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class ConstructorHandle
    extends FunctionHandle {
        private final TypeComposition f_clzTarget;
        private final MethodStructure f_constructor;
        protected final Parameter[] f_aParams;
        private final boolean f_fParent;

        public ConstructorHandle(TypeComposition clzConstruct, TypeComposition clzTarget, TypeConstant typeConstruct, MethodStructure constructor, Parameter[] aParams, boolean fParent) {
            super(clzConstruct, typeConstruct, constructor);
            this.f_clzTarget = clzTarget;
            this.f_constructor = constructor;
            this.f_aParams = aParams;
            this.f_fParent = fParent;
            this.m_fMutable = clzConstruct.isStruct();
        }

        @Override
        protected int call1Impl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            return this.callImpl(frame, ahVar, iReturn);
        }

        @Override
        protected int callTImpl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            TypeConstant typeTuple = frame.poolContext().ensureTupleType(this.f_clzTarget.getType());
            TypeComposition clzTuple = xTuple.INSTANCE.ensureClass(frame.f_context.f_container, typeTuple);
            switch (this.callImpl(frame, ahVar, -1)) {
                case -1: {
                    return frame.assignValue(iReturn, xTuple.makeHandle(clzTuple, frame.popStack()));
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, xTuple.makeHandle(clzTuple, frameCaller.popStack())));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }

        private int callImpl(Frame frame, ObjectHandle[] ahArg, int iReturn) {
            ObjectHandle hParent = null;
            if (this.f_fParent) {
                hParent = ahArg[0];
                System.arraycopy(ahArg, 1, ahArg, 0, ahArg.length - 1);
            }
            TypeComposition clzTarget = this.f_clzTarget;
            ClassTemplate template = clzTarget.getTemplate();
            MethodStructure constructor = this.f_constructor;
            return constructor == null ? template.proceedConstruction(frame, null, false, ahArg[0], Utils.OBJECTS_NONE, iReturn) : template.construct(frame, constructor, clzTarget, hParent, ahArg, iReturn);
        }

        @Override
        public String getName() {
            return "construct";
        }

        @Override
        public int getParamCount() {
            return this.f_aParams.length;
        }

        @Override
        public Parameter getParam(int iArg) {
            return this.f_aParams[iArg];
        }

        @Override
        public int getReturnCount() {
            return 1;
        }

        @Override
        public Parameter getReturn(int iArg) {
            assert (iArg == 0);
            TypeConstant typeTarget = this.f_clzTarget.getType();
            return new Parameter(typeTarget.getConstantPool(), typeTarget, null, null, true, 0, false);
        }

        @Override
        public TypeConstant getReturnType(int iArg) {
            assert (iArg == 0);
            return this.f_clzTarget.getType();
        }

        @Override
        public int getVarCount() {
            int cVars = super.getVarCount();
            return Math.max(cVars, this.f_aParams.length);
        }
    }

    public static class FullyBoundHandle
    extends DelegatingHandle {
        protected final ObjectHandle[] f_ahArg;
        protected FullyBoundHandle m_next;
        public static FullyBoundHandle NO_OP = new FullyBoundHandle(xRTFunction.INSTANCE.f_container, null, Utils.OBJECTS_NONE){

            @Override
            public int callChain(Frame frame, ObjectHandle hTarget, Frame.Continuation continuation) {
                return continuation.proceed(frame);
            }

            @Override
            public FullyBoundHandle chain(FullyBoundHandle handle) {
                return handle;
            }

            @Override
            public String toString() {
                return "NO_OP";
            }
        };

        protected FullyBoundHandle(Container container, FunctionHandle hDelegate, ObjectHandle[] ahArg) {
            super(container, hDelegate == null ? INSTANCE.getCanonicalType() : hDelegate.getType(), hDelegate);
            this.f_ahArg = ahArg;
        }

        @Override
        public boolean isMutable() {
            for (ObjectHandle hArg : this.f_ahArg) {
                if (!hArg.isMutable()) continue;
                return true;
            }
            return super.isMutable();
        }

        @Override
        public boolean makeImmutable() {
            if (this.isMutable()) {
                for (ObjectHandle hArg : this.f_ahArg) {
                    if (hArg.makeImmutable()) continue;
                    return false;
                }
            }
            return super.makeImmutable();
        }

        @Override
        protected boolean checkArgumentsPassThrough(Container container) {
            for (ObjectHandle hArg : this.f_ahArg) {
                if (hArg.isPassThrough(container)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int addBoundArguments(ObjectHandle[] ahVar) {
            int cArgs = super.addBoundArguments(ahVar);
            System.arraycopy(this.f_ahArg, 0, ahVar, cArgs, Math.min(ahVar.length - cArgs, this.f_ahArg.length));
            return ahVar.length;
        }

        public FullyBoundHandle chain(FullyBoundHandle handle) {
            if (handle != NO_OP) {
                assert (this.m_next == null);
                this.m_next = handle;
            }
            return this;
        }

        public int callChain(Frame frame, ObjectHandle hTarget, Frame.Continuation continuation) {
            Frame frameNext = this.chainFrames(frame, hTarget, continuation);
            return frame.call(frameNext);
        }

        protected Frame chainFrames(Frame frame, ObjectHandle hTarget, Frame.Continuation continuation) {
            Frame frameSave = frame.m_frameNext;
            this.call1(frame, hTarget, Utils.OBJECTS_NONE, -2);
            Frame frameThis = frame.m_frameNext;
            frame.m_frameNext = frameSave;
            if (this.m_next == null) {
                frameThis.addContinuation(continuation);
                return frameThis;
            }
            Frame frameNext = this.m_next.chainFrames(frame, hTarget, continuation);
            frameThis.addContinuation(frameCaller -> frameCaller.call(frameNext));
            return frameThis;
        }
    }

    public static class SingleBoundHandle
    extends DelegatingHandle {
        protected int m_iArg;
        protected ObjectHandle m_hArg;

        protected SingleBoundHandle(Container container, TypeConstant type, FunctionHandle hDelegate, int iArg, ObjectHandle hArg) {
            super(container, type, hDelegate);
            this.m_iArg = iArg;
            this.m_hArg = hArg;
            this.m_fMutable = hDelegate.isMutable() || hArg.isMutable();
        }

        @Override
        protected boolean checkArgumentsPassThrough(Container container) {
            return this.m_hDelegate.checkArgumentsPassThrough(container) && this.m_hArg.isPassThrough(container);
        }

        @Override
        protected int calculateShift(int iArg) {
            int nShift = this.m_iArg == -1 || iArg < this.m_iArg ? 0 : 1;
            return nShift + this.m_hDelegate.calculateShift(iArg);
        }

        @Override
        protected int call1Impl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            if (this.m_iArg == -1) {
                assert (hTarget == null);
                hTarget = this.m_hArg;
            }
            return super.call1Impl(frame, hTarget, ahVar, iReturn);
        }

        @Override
        protected int callTImpl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            if (this.m_iArg == -1) {
                assert (hTarget == null);
                hTarget = this.m_hArg;
            }
            return super.callTImpl(frame, hTarget, ahVar, iReturn);
        }

        @Override
        protected int callNImpl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
            if (this.m_iArg == -1) {
                assert (hTarget == null);
                hTarget = this.m_hArg;
            }
            return super.callNImpl(frame, hTarget, ahVar, aiReturn);
        }

        @Override
        protected FunctionHandle createProxyHandle(ServiceContext ctx) {
            return new FunctionProxyHandle(this, ctx);
        }

        @Override
        public ObjectHandle getTarget() {
            return this.m_iArg == -1 ? this.m_hArg : super.getTarget();
        }

        @Override
        public int addBoundArguments(ObjectHandle[] ahVar) {
            int cArgs;
            if (this.m_iArg >= 0) {
                int cMove = super.getParamCount() - (this.m_iArg + 1);
                if (cMove > 0) {
                    System.arraycopy(ahVar, this.m_iArg, ahVar, this.m_iArg + 1, cMove);
                }
                ahVar[this.m_iArg] = this.m_hArg;
                cArgs = 1;
            } else {
                cArgs = 0;
            }
            return cArgs + super.addBoundArguments(ahVar);
        }

        @Override
        public int getParamCount() {
            int cParams = super.getParamCount();
            return this.m_iArg == -1 ? cParams : cParams - 1;
        }

        @Override
        public Parameter getParam(int iArg) {
            return this.getMethod().getParam(iArg + this.calculateShift(iArg));
        }

        @Override
        public TypeConstant getParamType(int iArg) {
            TypeConstant typeFn = this.getType();
            return typeFn.getConstantPool().extractFunctionParams(typeFn)[iArg];
        }

        @Override
        public boolean makeImmutable() {
            if (this.m_fMutable) {
                if (!this.m_hArg.isService() && !this.m_hArg.makeImmutable()) {
                    return false;
                }
                return super.makeImmutable();
            }
            return true;
        }
    }

    public static class NativeFunctionHandle
    extends FunctionHandle {
        protected final xService.NativeOperation f_op;

        public NativeFunctionHandle(xService.NativeOperation op) {
            super(xRTFunction.INSTANCE.f_container, INSTANCE.getCanonicalType(), null);
            this.f_op = op;
            this.m_fMutable = false;
        }

        @Override
        protected int call1Impl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            return this.f_op.invoke(frame, ahVar, iReturn);
        }

        @Override
        public String toString() {
            return "NativeFunctionHandle";
        }
    }

    protected static abstract class DelegatingHandle
    extends FunctionHandle {
        protected FunctionHandle m_hDelegate;

        protected DelegatingHandle(Container container, TypeConstant type, FunctionHandle hDelegate) {
            super(container, type, hDelegate == null ? null : hDelegate.getMethod());
            this.m_hDelegate = hDelegate;
            this.m_fMutable = hDelegate != null && hDelegate.isMutable();
        }

        @Override
        protected boolean checkArgumentsPassThrough(Container container) {
            return this.m_hDelegate == null || this.m_hDelegate.checkArgumentsPassThrough(container);
        }

        @Override
        protected int call1Impl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            return this.m_hDelegate.call1Impl(frame, hTarget, ahVar, iReturn);
        }

        @Override
        protected int callTImpl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int iReturn) {
            return this.m_hDelegate.callTImpl(frame, hTarget, ahVar, iReturn);
        }

        @Override
        protected int callNImpl(Frame frame, ObjectHandle hTarget, ObjectHandle[] ahVar, int[] aiReturn) {
            return this.m_hDelegate.callNImpl(frame, hTarget, ahVar, aiReturn);
        }

        @Override
        public ObjectHandle getTarget() {
            return this.m_hDelegate.getTarget();
        }

        @Override
        public int addBoundArguments(ObjectHandle[] ahVar) {
            return this.m_hDelegate.addBoundArguments(ahVar);
        }

        @Override
        public MethodStructure getMethod() {
            return this.m_hDelegate.getMethod();
        }

        @Override
        public int getParamCount() {
            return this.m_hDelegate.getParamCount();
        }

        @Override
        public Parameter getParam(int iArg) {
            return this.m_hDelegate.getParam(iArg);
        }

        @Override
        public TypeConstant getParamType(int iArg) {
            return this.m_hDelegate.getParamType(iArg);
        }

        @Override
        public int getReturnCount() {
            return this.m_hDelegate.getReturnCount();
        }

        @Override
        public Parameter getReturn(int iArg) {
            return this.m_hDelegate.getReturn(iArg);
        }

        @Override
        public TypeConstant getReturnType(int iArg) {
            return this.m_hDelegate.getReturnType(iArg);
        }

        @Override
        public int getVarCount() {
            return this.m_hDelegate.getVarCount();
        }

        @Override
        public boolean isAsync() {
            return this.m_hDelegate.isAsync();
        }

        @Override
        public boolean makeImmutable() {
            if (this.m_fMutable) {
                if (!this.m_hDelegate.makeImmutable()) {
                    return false;
                }
                this.m_fMutable = false;
            }
            return true;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + " -> " + String.valueOf(this.m_hDelegate);
        }
    }
}

