/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTSignature;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xOrdered;

public class xRTMethod
extends xRTSignature {
    public static xRTMethod INSTANCE;
    private static ArrayConstant EMPTY_ARRAY;

    public xRTMethod(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("access");
        this.markNativeMethod("formalParamNames", null, null);
        this.markNativeMethod("formalReturnNames", null, null);
        this.markNativeMethod("bindTarget", null, null);
        this.markNativeMethod("invoke", null, null);
        super.initNative();
    }

    @Override
    public TypeComposition ensureClass(Container container, TypeConstant typeActual) {
        ConstantPool pool = typeActual.getConstantPool();
        assert (typeActual.isA(pool.typeMethod()));
        TypeConstant typeTarget = typeActual.getParamType(0);
        TypeConstant typeP = typeActual.getParamType(1);
        TypeConstant typeR = typeActual.getParamType(2);
        TypeConstant typeMethod = pool.ensureParameterizedTypeConstant(pool.typeMethod(), typeTarget, typeP, typeR);
        if (typeActual.isAnnotated()) {
            typeMethod = typeMethod.adoptAnnotations(pool, typeActual);
        }
        return super.ensureClass(container, typeMethod);
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof MethodConstant) {
            ObjectHandle hMethod;
            TypeConstant typeThis;
            MethodConstant idMethod = (MethodConstant)constant;
            IdentityConstant idTarget = idMethod.getNamespace();
            TypeConstant typeTarget = idTarget.getType();
            if (frame.isMethod() && (typeThis = frame.getThis().getType()).isNestMateOf(idTarget)) {
                typeTarget = idTarget.equals(typeThis.getDefiningConstant()) ? typeThis : ((ClassStructure)idTarget.getComponent()).getFormalType().resolveGenerics(frame.poolContext(), typeThis);
            }
            return Op.isDeferred(hMethod = xRTMethod.makeHandle(frame, typeTarget, idMethod)) ? hMethod.proceed(frame, Utils.NEXT) : frame.pushStack(hMethod);
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        MethodHandle hMethod = (MethodHandle)hTarget;
        switch (sPropName) {
            case "access": {
                return this.getPropertyAccess(frame, hMethod, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "bindTarget": {
                return this.invokeBindTarget(frame, (MethodHandle)hTarget, hArg, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "invoke": {
                return this.invokeInvoke(frame, (MethodHandle)hTarget, ahArg, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        MethodHandle hMethod = (MethodHandle)hTarget;
        switch (method.getName()) {
            case "formalParamNames": {
                return this.invokeFormalParamNames(frame, hMethod, aiReturn);
            }
            case "formalReturnNames": {
                return this.invokeFormalReturnNames(frame, hMethod, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    protected int callEqualsImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        MethodHandle hMethod1 = (MethodHandle)hValue1;
        MethodHandle hMethod2 = (MethodHandle)hValue2;
        return frame.assignValue(iReturn, xBoolean.makeHandle(hMethod1.getMethodId().equals(hMethod2.getMethodId())));
    }

    @Override
    protected int callCompareImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        MethodHandle hMethod1 = (MethodHandle)hValue1;
        MethodHandle hMethod2 = (MethodHandle)hValue2;
        return frame.assignValue(iReturn, xOrdered.makeHandle(hMethod1.getMethodId().compareTo(hMethod2.getMethodId())));
    }

    public int getPropertyAccess(Frame frame, MethodHandle hMethod, int iReturn) {
        Constants.Access access = hMethod.getMethodInfo().getAccess();
        xEnum.EnumHandle hAccess = xRTType.makeAccessHandle(frame, access);
        return frame.assignValue(iReturn, hAccess);
    }

    public int invokeBindTarget(Frame frame, MethodHandle hMethod, ObjectHandle hTarget, int iReturn) {
        return hMethod.getCallChain(frame, hTarget).bindTarget(frame, hTarget, iReturn);
    }

    public int invokeInvoke(Frame frame, MethodHandle hMethod, ObjectHandle[] ahArg, int iReturn) {
        ObjectHandle hTarget = ahArg[0];
        xTuple.TupleHandle hTuple = (xTuple.TupleHandle)ahArg[1];
        ObjectHandle[] ahPass = hTuple.m_ahValue;
        CallChain chain = hMethod.getCallChain(frame, hTarget);
        return chain.invokeT(frame, hTarget, ahPass, iReturn);
    }

    public int invokeFormalParamNames(Frame frame, MethodHandle hMethod, int[] aiReturn) {
        throw new UnsupportedOperationException("TODO");
    }

    public int invokeFormalReturnNames(Frame frame, MethodHandle hMethod, int[] aiReturn) {
        throw new UnsupportedOperationException("TODO");
    }

    public static ObjectHandle makeHandle(Frame frame, TypeConstant typeTarget, MethodConstant idMethod) {
        Annotation[] aAnno;
        ConstantPool pool = frame.poolContext();
        Container container = frame.f_context.f_container;
        TypeConstant type = idMethod.getSignature().asMethodType(pool, typeTarget);
        MethodStructure method = (MethodStructure)idMethod.getComponent();
        if (method == null) {
            TypeInfo infoTarget = typeTarget.ensureTypeInfo();
            MethodInfo infoMethod = infoTarget.getMethodById(idMethod, true);
            MethodStructure methodStructure = method = infoMethod == null ? null : infoMethod.getTopmostMethodStructure(infoTarget);
            if (method == null) {
                return new ObjectHandle.DeferredCallHandle(xException.makeHandle(frame, "Invalid method: " + idMethod.getValueString()));
            }
        }
        if ((aAnno = method.getAnnotations()) != null && aAnno.length > 0) {
            type = pool.ensureAnnotatedTypeConstant(type, aAnno);
            TypeComposition clzMethod = INSTANCE.ensureClass(container, type);
            MethodHandle hStruct = new MethodHandle(clzMethod.ensureAccess(Constants.Access.STRUCT), type, method, typeTarget);
            int iResult = hStruct.getTemplate().proceedConstruction(frame, null, true, hStruct, Utils.OBJECTS_NONE, -1);
            return frame.popResultImmutable(iResult);
        }
        return new MethodHandle(INSTANCE.ensureClass(container, type), type, method, typeTarget);
    }

    public static ArrayConstant ensureEmptyArrayConstant() {
        ArrayConstant constant = EMPTY_ARRAY;
        if (constant == null) {
            ConstantPool pool = INSTANCE.pool();
            EMPTY_ARRAY = constant = new ArrayConstant(pool, Constant.Format.Array, pool.ensureArrayType(pool.typeMethod()), new Constant[0]);
        }
        return constant;
    }

    public static ObjectHandle ensureEmptyArray(Container container) {
        ArrayConstant constArray = xRTMethod.ensureEmptyArrayConstant();
        ObjectHandle hArray = container.f_heap.getConstHandle(constArray);
        if (hArray == null) {
            TypeComposition clzArray = container.resolveClass(constArray.getType());
            hArray = xArray.createImmutableArray(clzArray, Utils.OBJECTS_NONE);
            container.f_heap.saveConstHandle(constArray, hArray);
        }
        return hArray;
    }

    public static TypeComposition ensureArrayComposition(Frame frame, TypeConstant typeTarget) {
        assert (typeTarget != null);
        ConstantPool pool = frame.poolContext();
        TypeConstant typeMethodArray = pool.ensureArrayType(pool.ensureParameterizedTypeConstant(pool.typeMethod(), typeTarget));
        return frame.f_context.f_container.resolveClass(typeMethodArray);
    }

    public static class MethodHandle
    extends xRTSignature.SignatureHandle {
        private final TypeConstant f_typeTarget;

        protected MethodHandle(TypeComposition clz, TypeConstant typeMethod, MethodStructure method, TypeConstant typeTarget) {
            super(clz, method.getIdentityConstant(), method, typeMethod);
            this.m_fMutable = clz.isStruct();
            this.f_typeTarget = typeTarget;
            assert (this.getMethodInfo() != null);
        }

        public MethodInfo getMethodInfo() {
            return this.f_typeTarget.ensureTypeInfo().getMethodById(this.f_idMethod, true);
        }

        @Override
        public TypeConstant getParamType(int iArg) {
            return this.getMethodInfo().getIdentity().getSignature().getRawParams()[iArg];
        }

        @Override
        public TypeConstant getReturnType(int iArg) {
            return this.getMethodInfo().getIdentity().getSignature().getRawReturns()[iArg];
        }

        private CallChain getCallChain(Frame frame, ObjectHandle hTarget) {
            CallChain chain;
            TypeComposition clazz = hTarget.getComposition();
            MethodConstant idMethod = this.getMethodId();
            MethodStructure method = this.getMethod();
            if (method == null) {
                method = (MethodStructure)idMethod.getComponent();
            }
            if (method != null && method.getAccess() == Constants.Access.PRIVATE) {
                chain = new CallChain(method);
            } else {
                SignatureConstant sig = idMethod.getSignature().resolveGenericTypes(frame.poolContext(), frame.getGenericsResolver(true));
                chain = clazz.getMethodCallChain(sig);
                if (chain.isEmpty()) {
                    return new CallChain.ExceptionChain(xException.makeHandle(frame, "Missing method \"" + sig.getValueString() + "\" on " + hTarget.getType().getValueString()));
                }
            }
            return chain;
        }

        @Override
        public String toString() {
            return "Method: " + String.valueOf(this.getMethod());
        }
    }
}

