/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Parameter;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTComponentTemplate;
import org.xvm.runtime.template._native.reflect.xRTTypeTemplate;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xNullable;

public class xRTMethodTemplate
extends xRTComponentTemplate {
    public static xRTMethodTemplate INSTANCE;
    private static TypeComposition METHOD_TEMPLATE_COMP;

    public xRTMethodTemplate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("annotations");
        this.markNativeProperty("hasCode");
        this.markNativeProperty("parameterCount");
        this.markNativeProperty("returnCount");
        this.markNativeMethod("getParameter", INT, null);
        this.markNativeMethod("getReturn", INT, null);
        super.initNative();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hMethod = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        switch (sPropName) {
            case "annotations": {
                return this.getPropertyAnnotations(frame, hMethod, iReturn);
            }
            case "hasCode": {
                return this.getPropertyHasCode(frame, hMethod, iReturn);
            }
            case "parameterCount": {
                return frame.assignValue(iReturn, xInt64.makeHandle(((MethodStructure)hMethod.getComponent()).getParamCount()));
            }
            case "returnCount": {
                return frame.assignValue(iReturn, xInt64.makeHandle(((MethodStructure)hMethod.getComponent()).getReturnCount()));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hMethod = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        switch (method.getName()) {
            case "getParameter": {
                return this.invokeGetParameter(frame, hMethod, (ObjectHandle.JavaLong)ahArg[0], aiReturn);
            }
            case "getReturn": {
                return this.invokeGetReturn(frame, hMethod, (ObjectHandle.JavaLong)ahArg[0], aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    protected int getPropertyAnnotations(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hMethod, int iReturn) {
        MethodStructure method = (MethodStructure)hMethod.getComponent();
        Annotation[] aAnno = method.getAnnotations();
        return aAnno.length > 0 ? new Utils.CreateAnnos(aAnno, iReturn).doNext(frame) : frame.assignValue(iReturn, Utils.makeAnnoArrayHandle(frame.f_context.f_container, Utils.OBJECTS_NONE));
    }

    protected int getPropertyHasCode(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hMethod, int iReturn) {
        MethodStructure method = (MethodStructure)hMethod.getComponent();
        return frame.assignValue(iReturn, xBoolean.makeHandle(method.hasCode()));
    }

    protected int invokeGetParameter(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hMethod, ObjectHandle.JavaLong hIndex, int[] aiReturn) {
        MethodStructure method = (MethodStructure)hMethod.getComponent();
        Parameter parameter = method.getParam((int)hIndex.getValue());
        String sName = parameter.getName();
        boolean fDefault = parameter.hasDefaultValue();
        ObjectHandle[] ahReturn = new ObjectHandle[5];
        ahReturn[0] = sName == null ? xNullable.NULL : xString.makeHandle(sName);
        ahReturn[1] = xRTTypeTemplate.makeHandle(frame.f_context.f_container, parameter.getType());
        ahReturn[2] = xBoolean.makeHandle(parameter.isTypeParameter());
        ahReturn[3] = xBoolean.makeHandle(fDefault);
        if (fDefault) {
            ObjectHandle hDefault = frame.getConstHandle(parameter.getDefaultValue());
            if (Op.isDeferred(hDefault)) {
                return hDefault.proceed(frame, frameCaller -> {
                    ahReturn[4] = frameCaller.popStack();
                    return frameCaller.assignValues(aiReturn, ahReturn);
                });
            }
            ahReturn[4] = hDefault;
        } else {
            ahReturn[4] = xNullable.NULL;
        }
        return frame.assignValues(aiReturn, ahReturn);
    }

    protected int invokeGetReturn(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hMethod, ObjectHandle.JavaLong hIndex, int[] aiReturn) {
        MethodStructure method = (MethodStructure)hMethod.getComponent();
        Parameter parameter = method.getReturn((int)hIndex.getValue());
        String sName = parameter.getName();
        ObjectHandle[] ahReturn = new ObjectHandle[]{sName == null ? xNullable.NULL : xString.makeHandle(sName), xRTTypeTemplate.makeHandle(frame.f_context.f_container, parameter.getType()), xBoolean.makeHandle(parameter.isConditionalReturn())};
        return frame.assignValues(aiReturn, ahReturn);
    }

    public static TypeComposition ensureMethodTemplateComposition() {
        TypeComposition clz = METHOD_TEMPLATE_COMP;
        if (clz == null) {
            xRTMethodTemplate templateRT = INSTANCE;
            ConstantPool pool = templateRT.pool();
            TypeConstant typeTemplate = pool.ensureEcstasyTypeConstant("reflect.MethodTemplate");
            METHOD_TEMPLATE_COMP = clz = templateRT.ensureClass(templateRT.f_container, typeTemplate);
            assert (clz != null);
        }
        return clz;
    }

    static xRTComponentTemplate.ComponentTemplateHandle makeHandle(MethodStructure method) {
        return new xRTComponentTemplate.ComponentTemplateHandle(xRTMethodTemplate.ensureMethodTemplateComposition(), method);
    }
}

