/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import java.util.Map;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.VersionTree;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTClassTemplate;
import org.xvm.runtime.template._native.reflect.xRTComponentTemplate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xNullable;

public class xRTModuleTemplate
extends xRTClassTemplate {
    public static xRTModuleTemplate INSTANCE;
    private static TypeConstant MODULE_TEMPLATE_TYPE;
    private static TypeConstant LISTMAP_TYPE;

    public xRTModuleTemplate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.f_container.getConstantPool();
        MODULE_TEMPLATE_TYPE = pool.ensureEcstasyTypeConstant("reflect.ModuleTemplate");
        this.markNativeProperty("qualifiedName");
        this.markNativeProperty("versionString");
        this.markNativeProperty("modulesByPath");
        this.markNativeProperty("resolved");
        this.invalidateTypeInfo();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hTemplate = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        switch (sPropName) {
            case "qualifiedName": {
                ModuleStructure module = (ModuleStructure)hTemplate.getComponent();
                return frame.assignValue(iReturn, xString.makeHandle(module.getIdentityConstant().getName()));
            }
            case "versionString": {
                VersionTree<Boolean> vtree;
                ModuleStructure module = (ModuleStructure)hTemplate.getComponent();
                String sVersion = module.isFingerprint() ? ((vtree = module.getFingerprintVersions()).isEmpty() ? null : vtree.findLowestVersion().toString()) : module.getVersionString();
                return frame.assignValue(iReturn, sVersion == null ? xNullable.NULL : xString.makeHandle(sVersion));
            }
            case "modulesByPath": {
                return this.getPropertyModulesByPath(frame, hTemplate, iReturn);
            }
            case "resolved": {
                ModuleStructure module = (ModuleStructure)hTemplate.getComponent();
                return frame.assignValue(iReturn, xBoolean.makeHandle(module.isLinked()));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    public int getPropertyModulesByPath(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hTemplate, int iReturn) {
        ModuleStructure module = (ModuleStructure)hTemplate.getComponent();
        Container container = frame.f_context.f_container;
        TypeComposition clzMap = container.resolveClass(xRTModuleTemplate.ensureListMapType());
        Map<ModuleConstant, String> mapModulePaths = module.collectDependencies();
        int cModules = mapModulePaths.size() - 1;
        xString.StringHandle[] ahPaths = new xString.StringHandle[cModules];
        ObjectHandle[] ahTemplate = new xRTComponentTemplate.ComponentTemplateHandle[cModules];
        int index = 0;
        for (Map.Entry<ModuleConstant, String> entry : mapModulePaths.entrySet()) {
            ModuleConstant idDep = entry.getKey();
            if (idDep.equals(module.getIdentityConstant())) continue;
            ModuleStructure moduleDep = module.getFileStructure().getModule(idDep);
            ahPaths[index] = xString.makeHandle(entry.getValue());
            ahTemplate[index] = xRTModuleTemplate.makeHandle(container, moduleDep);
            ++index;
        }
        xArray.ArrayHandle haPaths = xArray.makeStringArrayHandle(ahPaths);
        xArray.ArrayHandle haTemplates = xRTModuleTemplate.makeTemplateArrayHandle(container, ahTemplate);
        return Utils.constructListMap(frame, clzMap, haPaths, haTemplates, iReturn);
    }

    private static TypeConstant ensureListMapType() {
        TypeConstant type = LISTMAP_TYPE;
        if (type == null) {
            ConstantPool pool = INSTANCE.pool();
            LISTMAP_TYPE = type = pool.ensureParameterizedTypeConstant(pool.ensureEcstasyTypeConstant("maps.ListMap"), pool.typeString(), MODULE_TEMPLATE_TYPE);
        }
        return type;
    }

    private static xArray.ArrayHandle makeTemplateArrayHandle(Container container, ObjectHandle[] ahTemplate) {
        ClassComposition clzArray = container.ensureClassComposition(container.getConstantPool().ensureArrayType(MODULE_TEMPLATE_TYPE), xArray.INSTANCE);
        return xArray.makeArrayHandle(clzArray, ahTemplate.length, ahTemplate, xArray.Mutability.Constant);
    }

    public static xRTComponentTemplate.ComponentTemplateHandle makeHandle(Container container, ModuleStructure module) {
        TypeComposition clz = INSTANCE.ensureClass(container, INSTANCE.getCanonicalType(), MODULE_TEMPLATE_TYPE);
        return new xRTComponentTemplate.ComponentTemplateHandle(clz, module);
    }
}

