/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.PropertyClassTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;

public class xRTProperty
extends xConst {
    public static xRTProperty INSTANCE;
    private static ArrayConstant EMPTY_PROPERTY_ARRAY;

    public xRTProperty(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.pool();
        EMPTY_PROPERTY_ARRAY = pool.ensureArrayConstant(pool.ensureArrayType(pool.ensureEcstasyTypeConstant("reflect.Property")), Constant.NO_CONSTS);
        this.markNativeProperty("abstract");
        this.markNativeProperty("annotations");
        this.markNativeProperty("atomic");
        this.markNativeProperty("formal");
        this.markNativeProperty("hasField");
        this.markNativeProperty("hasUnreachableSetter");
        this.markNativeProperty("injected");
        this.markNativeProperty("lazy");
        this.markNativeProperty("name");
        this.markNativeProperty("readOnly");
        this.markNativeMethod("get", null, null);
        this.markNativeMethod("isConstant", null, null);
        this.markNativeMethod("of", null, null);
        this.markNativeMethod("set", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof PropertyClassTypeConstant) {
            PropertyInfo infoProp;
            PropertyClassTypeConstant constProp = (PropertyClassTypeConstant)constant;
            TypeConstant typeParent = constProp.getParentType();
            ObjectHandle hProperty = xRTProperty.makeHandle(frame, typeParent, infoProp = constProp.getPropertyInfo());
            return Op.isDeferred(hProperty) ? hProperty.proceed(frame, Utils.NEXT) : frame.pushStack(hProperty);
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        PropertyHandle hThis = (PropertyHandle)hTarget;
        switch (sPropName) {
            case "abstract": {
                return this.getPropertyAbstract(frame, hThis, iReturn);
            }
            case "annotations": {
                return this.getPropertyAnnotations(frame, hThis, iReturn);
            }
            case "atomic": {
                return this.getPropertyAtomic(frame, hThis, iReturn);
            }
            case "formal": {
                return this.getPropertyFormal(frame, hThis, iReturn);
            }
            case "hasField": {
                return this.getPropertyHasField(frame, hThis, iReturn);
            }
            case "hasUnreachableSetter": {
                return this.getPropertyHasUnreachableSetter(frame, hThis, iReturn);
            }
            case "injected": {
                return this.getPropertyInjected(frame, hThis, iReturn);
            }
            case "lazy": {
                return this.getPropertyLazy(frame, hThis, iReturn);
            }
            case "name": {
                return this.getPropertyName(frame, hThis, iReturn);
            }
            case "readOnly": {
                return this.getPropertyReadOnly(frame, hThis, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "of": {
                return this.invokeOf(frame, (PropertyHandle)hTarget, hArg, iReturn);
            }
            case "get": {
                return this.invokeGet(frame, (PropertyHandle)hTarget, hArg, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "set": {
                return this.invokeSet(frame, (PropertyHandle)hTarget, ahArg, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "isConstant": {
                return this.invokeIsConstant(frame, (PropertyHandle)hTarget, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    public static ObjectHandle makeHandle(Frame frame, TypeConstant typeTarget, PropertyInfo infoProp) {
        Annotation[] aAnno = infoProp.getPropertyAnnotations();
        TypeConstant typeProp = infoProp.getIdentity().getValueType(frame.poolContext(), typeTarget);
        if (aAnno != null && aAnno.length > 0) {
            typeProp = frame.poolContext().ensureAnnotatedTypeConstant(typeProp, aAnno);
            TypeComposition clzProp = INSTANCE.ensureClass(frame.f_context.f_container, typeProp);
            PropertyHandle hStruct = new PropertyHandle(clzProp.ensureAccess(Constants.Access.STRUCT));
            int iResult = INSTANCE.proceedConstruction(frame, null, true, hStruct, Utils.OBJECTS_NONE, -1);
            return frame.popResultImmutable(iResult);
        }
        return new PropertyHandle(INSTANCE.ensureClass(frame.f_context.f_container, typeProp));
    }

    public int getPropertyAbstract(Frame frame, PropertyHandle hProp, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hProp.getPropertyInfo().isAbstract()));
    }

    public int getPropertyAnnotations(Frame frame, PropertyHandle hProp, int iReturn) {
        PropertyInfo prop = hProp.getPropertyInfo();
        Annotation[] aAnno = prop.getPropertyAnnotations();
        return aAnno.length > 0 ? new Utils.CreateAnnos(aAnno, iReturn).doNext(frame) : frame.assignValue(iReturn, Utils.makeAnnoArrayHandle(frame.f_context.f_container, Utils.OBJECTS_NONE));
    }

    public int getPropertyAtomic(Frame frame, PropertyHandle hProp, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hProp.getPropertyInfo().isAtomic()));
    }

    public int getPropertyFormal(Frame frame, PropertyHandle hProp, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hProp.getPropertyInfo().isFormalType()));
    }

    public int getPropertyHasField(Frame frame, PropertyHandle hProp, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hProp.getPropertyInfo().hasField()));
    }

    public int getPropertyHasUnreachableSetter(Frame frame, PropertyHandle hProp, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hProp.getPropertyInfo().isSetterUnreachable()));
    }

    public int getPropertyInjected(Frame frame, PropertyHandle hProp, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hProp.getPropertyInfo().isInjected()));
    }

    public int getPropertyLazy(Frame frame, PropertyHandle hProp, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hProp.getPropertyInfo().isLazy()));
    }

    public int getPropertyName(Frame frame, PropertyHandle hProp, int iReturn) {
        return frame.assignValue(iReturn, xString.makeHandle(hProp.getPropertyConstant().getName()));
    }

    public int getPropertyReadOnly(Frame frame, PropertyHandle hProp, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(!hProp.getPropertyInfo().isVar()));
    }

    public int invokeIsConstant(Frame frame, PropertyHandle hProp, int[] aiReturn) {
        PropertyInfo info = hProp.getPropertyInfo();
        if (info.isConstant()) {
            PropertyConstant idProp = hProp.getPropertyConstant();
            SingletonConstant idSingleton = idProp.getConstantPool().ensureSingletonConstConstant(idProp);
            return frame.assignConditionalDeferredValue(aiReturn, frame.getConstHandle(idSingleton));
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    public int invokeOf(Frame frame, PropertyHandle hProp, ObjectHandle hTarget, int iReturn) {
        PropertyConstant idProp = hProp.getPropertyConstant();
        PropertyInfo infoProp = hProp.getPropertyInfo();
        Constants.Access access = hProp.getType().getParamType(0).getAccess();
        return hTarget.getTemplate().createPropertyRef(frame, hTarget.ensureAccess(access), idProp, !infoProp.isVar(), iReturn);
    }

    public int invokeGet(Frame frame, PropertyHandle hProp, ObjectHandle hTarget, int iReturn) {
        PropertyConstant idProp = hProp.getPropertyConstant();
        return hTarget.getTemplate().getPropertyValue(frame, hTarget, idProp, iReturn);
    }

    public int invokeSet(Frame frame, PropertyHandle hProp, ObjectHandle[] ahArg, int iReturn) {
        ObjectHandle hTarget = ahArg[0];
        PropertyConstant idProp = hProp.getPropertyConstant();
        ObjectHandle hValue = ahArg[1];
        return hTarget.getTemplate().setPropertyValue(frame, hTarget, idProp, hValue);
    }

    public static xArray.ArrayHandle ensureEmptyArray(Container container) {
        xArray.ArrayHandle haEmpty = (xArray.ArrayHandle)container.f_heap.getConstHandle(EMPTY_PROPERTY_ARRAY);
        if (haEmpty == null) {
            ConstantPool pool = container.getConstantPool();
            TypeComposition clz = container.resolveClass(pool.ensureArrayType(pool.typeProperty()));
            haEmpty = xArray.createImmutableArray(clz, Utils.OBJECTS_NONE);
            container.f_heap.saveConstHandle(EMPTY_PROPERTY_ARRAY, haEmpty);
        }
        return haEmpty;
    }

    public static TypeComposition ensureArrayComposition(Frame frame, TypeConstant typeTarget) {
        assert (typeTarget != null);
        ConstantPool pool = frame.poolContext();
        TypeConstant typePropertyArray = pool.ensureArrayType(pool.ensureParameterizedTypeConstant(pool.typeProperty(), typeTarget));
        return frame.f_context.f_container.resolveClass(typePropertyArray);
    }

    public static class PropertyHandle
    extends ObjectHandle.GenericHandle {
        protected PropertyHandle(TypeComposition clzProp) {
            super(clzProp);
            this.m_fMutable = clzProp.isStruct();
        }

        public TypeConstant getTargetType() {
            return this.getType().getParamType(0);
        }

        public TypeConstant getReferentType() {
            return this.getType().getParamType(1);
        }

        public TypeConstant getImplementationType() {
            return this.getType().getParamType(2);
        }

        public PropertyConstant getPropertyConstant() {
            return ((PropertyClassTypeConstant)this.getImplementationType()).getProperty();
        }

        public PropertyInfo getPropertyInfo() {
            return ((PropertyClassTypeConstant)this.getImplementationType()).getPropertyInfo();
        }
    }
}

