/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import java.util.ArrayList;
import java.util.List;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTClassTemplate;
import org.xvm.runtime.template._native.reflect.xRTComponentTemplate;
import org.xvm.runtime.template._native.reflect.xRTPropertyTemplate;
import org.xvm.runtime.template._native.reflect.xRTTypeTemplate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;

public class xRTPropertyClassTemplate
extends xRTComponentTemplate {
    public static xRTPropertyClassTemplate INSTANCE;
    private static TypeComposition PROPERTY_CLASS_TEMPLATE_COMP;

    public xRTPropertyClassTemplate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        if (this == INSTANCE) {
            TypeConstant typeMask = this.pool().ensureEcstasyTypeConstant("reflect.ClassTemplate");
            PROPERTY_CLASS_TEMPLATE_COMP = this.ensureClass(this.f_container, this.getCanonicalType(), typeMask);
            this.markNativeProperty("classes");
            this.markNativeProperty("contribs");
            this.markNativeProperty("multimethods");
            this.markNativeProperty("properties");
            this.markNativeProperty("singleton");
            this.markNativeProperty("sourceInfo");
            this.markNativeProperty("type");
            this.markNativeMethod("deannotate", null, null);
            this.markNativeMethod("fromProperty", null, null);
            super.initNative();
        }
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hComponent = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        switch (sPropName) {
            case "classes": {
                return this.getPropertyClasses(frame, hComponent, iReturn);
            }
            case "contribs": {
                return this.getPropertyContribs(frame, hComponent, iReturn);
            }
            case "multimethods": {
                return this.getPropertyMultimethods(frame, hComponent, iReturn);
            }
            case "properties": {
                return this.getPropertyProperties(frame, hComponent, iReturn);
            }
            case "singleton": {
                return this.getPropertySingleton(frame, hComponent, iReturn);
            }
            case "sourceInfo": {
                return this.getPropertySourceInfo(frame, hComponent, iReturn);
            }
            case "type": {
                return this.getPropertyType(frame, hComponent, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        xRTComponentTemplate.ComponentTemplateHandle hComponent = (xRTComponentTemplate.ComponentTemplateHandle)hTarget;
        switch (method.getName()) {
            case "deannotate": {
                return this.invokeDeannotate(frame, hComponent, aiReturn);
            }
            case "fromProperty": {
                return this.invokeFromProperty(frame, hComponent, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    public int getPropertyClasses(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        PropertyStructure prop = (PropertyStructure)hComponent.getComponent();
        if (!prop.getFileStructure().isLinked()) {
            return frame.raiseException(xException.illegalState(frame, "FileTemplate is not resolved"));
        }
        Container container = frame.f_context.f_container;
        ArrayList<xRTComponentTemplate.ComponentTemplateHandle> listTemplates = new ArrayList<xRTComponentTemplate.ComponentTemplateHandle>();
        for (Component component : prop.children()) {
            switch (component.getFormat()) {
                case CLASS: 
                case CONST: {
                    listTemplates.add(xRTClassTemplate.makeHandle(container, (ClassStructure)component));
                }
            }
        }
        xArray.ArrayHandle hArray = xArray.createImmutableArray(xRTClassTemplate.ensureClassTemplateArrayComposition(container), listTemplates.toArray(xRTClassTemplate.NO_TEMPLATES));
        return frame.assignValue(iReturn, hArray);
    }

    public int getPropertyContribs(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        PropertyStructure prop = (PropertyStructure)hComponent.getComponent();
        if (!prop.getFileStructure().isLinked()) {
            return frame.raiseException(xException.illegalState(frame, "FileTemplate is not resolved"));
        }
        List<Component.Contribution> listContrib = prop.getContributionsAsList();
        Utils.ValueSupplier supplier = (frameCaller, index) -> {
            Component.Contribution contrib = (Component.Contribution)listContrib.get(index);
            TypeConstant typeContrib = contrib.getTypeConstant();
            xEnum.EnumHandle hDelegatee = xNullable.NULL;
            xEnum.EnumHandle haNames = xNullable.NULL;
            xEnum.EnumHandle haTypes = xNullable.NULL;
            String sAction = switch (contrib.getComposition()) {
                case Component.Composition.Annotation -> "AnnotatedBy";
                case Component.Composition.Extends -> "Extends";
                case Component.Composition.Implements -> "Implements";
                default -> throw new IllegalStateException();
            };
            MethodStructure methodCreateContrib = xRTClassTemplate.CREATE_CONTRIB_METHOD;
            xEnum enumAction = xRTClassTemplate.ACTION_TEMPLATE;
            ObjectHandle[] ahVar = new ObjectHandle[methodCreateContrib.getMaxVars()];
            ahVar[0] = Utils.ensureInitializedEnum(frameCaller, enumAction.getEnumByName(sAction));
            ahVar[1] = typeContrib.ensureTypeHandle(frameCaller.f_context.f_container);
            ahVar[2] = hDelegatee;
            ahVar[3] = haNames;
            ahVar[4] = haTypes;
            return frameCaller.call1(methodCreateContrib, null, ahVar, -1);
        };
        return xArray.createAndFill(frame, xRTClassTemplate.ensureContribArrayComposition(frame.f_context.f_container), listContrib.size(), supplier, iReturn);
    }

    public int getPropertyMultimethods(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        PropertyStructure prop = (PropertyStructure)hComponent.getComponent();
        Object hArray = null;
        return frame.raiseException("Not implemented");
    }

    public int getPropertyProperties(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        PropertyStructure prop = (PropertyStructure)hComponent.getComponent();
        if (!prop.getFileStructure().isLinked()) {
            return frame.raiseException(xException.illegalState(frame, "FileTemplate is not resolved"));
        }
        ArrayList<xRTComponentTemplate.ComponentTemplateHandle> listProps = new ArrayList<xRTComponentTemplate.ComponentTemplateHandle>();
        for (Component component : prop.children()) {
            if (!(component instanceof PropertyStructure)) continue;
            listProps.add(xRTPropertyTemplate.makePropertyHandle((PropertyStructure)component));
        }
        ObjectHandle[] ahProp = listProps.toArray(xRTClassTemplate.NO_TEMPLATES);
        xArray.ArrayHandle arrayHandle = xArray.createImmutableArray(xRTPropertyTemplate.ensureArrayComposition(), ahProp);
        return frame.assignValue(iReturn, arrayHandle);
    }

    public int getPropertySingleton(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        PropertyStructure prop = (PropertyStructure)hComponent.getComponent();
        boolean fSingleton = prop.isStatic();
        return frame.assignValue(iReturn, xBoolean.makeHandle(fSingleton));
    }

    public int getPropertySourceInfo(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        PropertyStructure prop = (PropertyStructure)hComponent.getComponent();
        Object hInfo = null;
        return frame.raiseException("Not implemented");
    }

    public int getPropertyType(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int iReturn) {
        PropertyStructure prop = (PropertyStructure)hComponent.getComponent();
        if (!prop.getFileStructure().isLinked()) {
            return frame.raiseException(xException.illegalState(frame, "FileTemplate is not resolved"));
        }
        return frame.assignValue(iReturn, xRTTypeTemplate.makeHandle(frame.f_context.f_container, prop.getType()));
    }

    protected int invokeDeannotate(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int[] aiReturn) {
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected int invokeFromProperty(Frame frame, xRTComponentTemplate.ComponentTemplateHandle hComponent, int[] aiReturn) {
        PropertyStructure prop = (PropertyStructure)hComponent.getComponent();
        return frame.assignValues(aiReturn, xBoolean.TRUE, xRTPropertyTemplate.makePropertyHandle(prop));
    }

    public static xRTComponentTemplate.ComponentTemplateHandle makeHandle(PropertyStructure prop) {
        return new xRTComponentTemplate.ComponentTemplateHandle(PROPERTY_CLASS_TEMPLATE_COMP, prop);
    }
}

