/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Parameter;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.CallChain;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.reflect.xRTMethodTemplate;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xNullable;

public class xRTSignature
extends ClassTemplate {
    public static xRTSignature INSTANCE;
    private static TypeConstant RETURN_TYPE;
    private static TypeConstant PARAM_TYPE;
    private static TypeConstant RTRETURN_TYPE;
    private static TypeConstant RTPARAM_TYPE;
    private static xConst RTRETURN_TEMPLATE;
    private static xConst RTPARAM_TEMPLATE;
    private static TypeComposition RETURN_ARRAY;
    private static TypeComposition PARAM_ARRAY;

    public xRTSignature(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("name");
        this.markNativeProperty("params");
        this.markNativeProperty("returns");
        this.markNativeProperty("conditionalResult");
        this.markNativeProperty("futureResult");
        this.markNativeMethod("hasTemplate", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        SignatureHandle hFunc = (SignatureHandle)hTarget;
        switch (sPropName) {
            case "name": {
                return this.getPropertyName(frame, hFunc, iReturn);
            }
            case "params": {
                return this.getPropertyParams(frame, hFunc, iReturn);
            }
            case "returns": {
                return this.getPropertyReturns(frame, hFunc, iReturn);
            }
            case "conditionalResult": {
                return this.getPropertyConditionalResult(frame, hFunc, iReturn);
            }
            case "futureResult": {
                return this.getPropertyFutureResult(frame, hFunc, iReturn);
            }
            case "ParamTypes": {
                return this.getPropertyParamTypes(frame, hFunc, iReturn);
            }
            case "ReturnTypes": {
                return this.getPropertyReturnTypes(frame, hFunc, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        SignatureHandle hFunc = (SignatureHandle)hTarget;
        switch (method.getName()) {
            case "hasTemplate": {
                return this.invokeHasTemplate(frame, hFunc, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    protected int getPropertyName(Frame frame, SignatureHandle hFunc, int iReturn) {
        return frame.assignValue(iReturn, xString.makeHandle(hFunc.getName()));
    }

    protected int getPropertyParams(Frame frame, SignatureHandle hFunc, int iReturn) {
        return new RTArrayConstructor(hFunc, false, iReturn).doNext(frame);
    }

    protected int getPropertyReturns(Frame frame, SignatureHandle hFunc, int iReturn) {
        return new RTArrayConstructor(hFunc, true, iReturn).doNext(frame);
    }

    protected int getPropertyConditionalResult(Frame frame, SignatureHandle hFunc, int iReturn) {
        MethodStructure structFunc = hFunc.getMethod();
        xBoolean.BooleanHandle handle = xBoolean.makeHandle(structFunc.isConditionalReturn());
        return frame.assignValue(iReturn, handle);
    }

    protected int getPropertyFutureResult(Frame frame, SignatureHandle hFunc, int iReturn) {
        xBoolean.BooleanHandle handle = xBoolean.makeHandle(hFunc.isAsync());
        return frame.assignValue(iReturn, handle);
    }

    protected int getPropertyParamTypes(Frame frame, SignatureHandle hFunc, int iReturn) {
        int cParams = hFunc.getParamCount();
        ObjectHandle[] ahType = new ObjectHandle[cParams];
        TypeComposition clzArray = xRTType.ensureTypeArrayComposition(frame.f_context.f_container);
        for (int i = 0; i < cParams; ++i) {
            ahType[i] = hFunc.getParamType(i).ensureTypeHandle(frame.f_context.f_container);
        }
        return frame.assignValue(iReturn, xArray.createImmutableArray(clzArray, ahType));
    }

    protected int getPropertyReturnTypes(Frame frame, SignatureHandle hFunc, int iReturn) {
        int cReturns = hFunc.getReturnCount();
        ObjectHandle[] ahType = new ObjectHandle[cReturns];
        TypeComposition clzArray = xRTType.ensureTypeArrayComposition(frame.f_context.f_container);
        for (int i = 0; i < cReturns; ++i) {
            ahType[i] = hFunc.getReturnType(i).ensureTypeHandle(frame.f_context.f_container);
        }
        return frame.assignValue(iReturn, xArray.createImmutableArray(clzArray, ahType));
    }

    public int invokeHasTemplate(Frame frame, SignatureHandle hFunc, int[] aiReturn) {
        MethodStructure method = hFunc.getMethod();
        return method == null ? frame.assignValue(aiReturn[0], xBoolean.FALSE) : frame.assignValues(aiReturn, xBoolean.TRUE, xRTMethodTemplate.makeHandle(method));
    }

    public static TypeConstant ensureReturnType() {
        TypeConstant type = RETURN_TYPE;
        if (type == null) {
            ConstantPool pool = INSTANCE.pool();
            RETURN_TYPE = type = pool.ensureEcstasyTypeConstant("reflect.Return");
        }
        return type;
    }

    public static TypeConstant ensureRTReturnType() {
        TypeConstant type = RTRETURN_TYPE;
        if (type == null) {
            RTRETURN_TYPE = type = xRTSignature.INSTANCE.f_container.getClassStructure("_native.reflect.RTReturn").getIdentityConstant().getType();
        }
        return type;
    }

    public static TypeConstant ensureParamType() {
        TypeConstant type = PARAM_TYPE;
        if (type == null) {
            PARAM_TYPE = type = INSTANCE.pool().typeParameter();
        }
        return type;
    }

    public static TypeConstant ensureRTParamType() {
        TypeConstant type = RTPARAM_TYPE;
        if (type == null) {
            RTPARAM_TYPE = type = xRTSignature.INSTANCE.f_container.getClassStructure("_native.reflect.RTParameter").getIdentityConstant().getType();
        }
        return type;
    }

    public static xConst ensureRTReturnTemplate() {
        xConst template = RTRETURN_TEMPLATE;
        if (template == null) {
            RTRETURN_TEMPLATE = template = (xConst)xRTSignature.INSTANCE.f_container.getTemplate(xRTSignature.ensureRTReturnType());
        }
        return template;
    }

    public static xConst ensureRTParamTemplate() {
        xConst template = RTPARAM_TEMPLATE;
        if (template == null) {
            RTPARAM_TEMPLATE = template = (xConst)xRTSignature.INSTANCE.f_container.getTemplate(xRTSignature.ensureRTParamType());
        }
        return template;
    }

    public static TypeComposition ensureRTReturn(Frame frame, TypeConstant typeValue) {
        assert (typeValue != null);
        ConstantPool pool = frame.poolContext();
        TypeConstant type = pool.ensureParameterizedTypeConstant(xRTSignature.ensureReturnType(), typeValue);
        TypeConstant typeRT = pool.ensureParameterizedTypeConstant(xRTSignature.ensureRTReturnType(), typeValue);
        return xRTSignature.ensureRTReturnTemplate().ensureClass(frame.f_context.f_container, typeRT, type);
    }

    public static TypeComposition ensureRTParameter(Frame frame, TypeConstant typeValue, Annotation[] aAnno) {
        assert (typeValue != null);
        ConstantPool pool = frame.poolContext();
        TypeConstant type = pool.ensureParameterizedTypeConstant(xRTSignature.ensureParamType(), typeValue);
        TypeConstant typeRT = pool.ensureParameterizedTypeConstant(xRTSignature.ensureRTParamType(), typeValue);
        if (aAnno.length > 0) {
            type = pool.ensureAnnotatedTypeConstant(type, aAnno);
            typeRT = pool.ensureAnnotatedTypeConstant(typeRT, aAnno);
        }
        return xRTSignature.ensureRTParamTemplate().ensureClass(frame.f_context.f_container, typeRT, type);
    }

    public static TypeComposition ensureReturnArray() {
        TypeComposition clz = RETURN_ARRAY;
        if (clz == null) {
            TypeConstant typeReturnArray = INSTANCE.pool().ensureArrayType(xRTSignature.ensureReturnType());
            RETURN_ARRAY = clz = xRTSignature.INSTANCE.f_container.resolveClass(typeReturnArray);
        }
        return clz;
    }

    public static TypeComposition ensureParamArray() {
        TypeComposition clz = PARAM_ARRAY;
        if (clz == null) {
            TypeConstant typeParamArray = INSTANCE.pool().ensureArrayType(xRTSignature.ensureParamType());
            PARAM_ARRAY = clz = xRTSignature.INSTANCE.f_container.resolveClass(typeParamArray);
        }
        return clz;
    }

    public static abstract class SignatureHandle
    extends ObjectHandle.GenericHandle {
        protected final MethodConstant f_idMethod;
        protected final MethodStructure f_method;
        protected final TypeConstant f_type;
        protected final CallChain f_chain;
        protected final int f_nDepth;

        protected SignatureHandle(TypeComposition clz, MethodConstant idMethod, MethodStructure method, TypeConstant type) {
            super(clz);
            this.f_type = type;
            this.f_idMethod = idMethod;
            this.f_method = method;
            this.f_chain = null;
            this.f_nDepth = 0;
        }

        protected SignatureHandle(TypeComposition clz, CallChain chain, int nDepth) {
            super(clz);
            this.f_idMethod = chain.getMethod(nDepth).getIdentityConstant();
            this.f_type = this.f_idMethod.getSignature().asFunctionType();
            this.f_method = null;
            this.f_chain = chain;
            this.f_nDepth = nDepth;
        }

        @Override
        public TypeConstant getType() {
            return this.augmentType(this.f_type);
        }

        public MethodConstant getMethodId() {
            return this.f_idMethod;
        }

        public String getName() {
            MethodStructure method = this.getMethod();
            if (method != null) {
                return method.getName();
            }
            MethodConstant id = this.f_idMethod;
            if (id != null) {
                return id.getName();
            }
            return "native";
        }

        public MethodStructure getMethod() {
            return this.f_method == null ? (this.f_chain == null ? null : this.f_chain.getMethod(this.f_nDepth)) : this.f_method;
        }

        public int getParamCount() {
            MethodStructure method = this.getMethod();
            return method == null ? 0 : method.getParamCount();
        }

        public Parameter getParam(int iArg) {
            return this.getMethod().getParam(iArg);
        }

        public TypeConstant getParamType(int iArg) {
            TypeConstant typeFn = this.getType();
            return typeFn.getConstantPool().extractFunctionParams(typeFn)[iArg];
        }

        public TypeConstant[] getParamTypes() {
            TypeConstant typeFn = this.getType();
            return typeFn.getConstantPool().extractFunctionParams(typeFn);
        }

        public int getReturnCount() {
            MethodStructure method = this.getMethod();
            return method == null ? 0 : method.getReturnCount();
        }

        public Parameter getReturn(int iArg) {
            return this.getMethod().getReturn(iArg);
        }

        public TypeConstant getReturnType(int iArg) {
            TypeConstant typeFn = this.getType();
            return typeFn.getConstantPool().extractFunctionReturns(typeFn)[iArg];
        }

        public TypeConstant[] getReturnTypes() {
            TypeConstant typeFn = this.getType();
            return typeFn.getConstantPool().extractFunctionReturns(typeFn);
        }

        public int getVarCount() {
            MethodStructure method = this.getMethod();
            return method == null ? 0 : method.getMaxVars();
        }

        public boolean isAsync() {
            return false;
        }

        @Override
        public String toString() {
            return "Signature: " + String.valueOf(this.getMethod());
        }
    }

    static class RTArrayConstructor
    implements Frame.Continuation {
        private final SignatureHandle hMethod;
        private final int cElements;
        private final boolean fRetVals;
        private final ObjectHandle[] ahElement;
        private final xConst template;
        private final MethodStructure construct;
        private final ObjectHandle[] ahParams;
        private final int iReturn;
        private int index;
        private boolean fDeferred;

        protected RTArrayConstructor(SignatureHandle hMethod, boolean fRetVals, int iReturn) {
            this.hMethod = hMethod;
            this.fRetVals = fRetVals;
            this.template = fRetVals ? xRTSignature.ensureRTReturnTemplate() : xRTSignature.ensureRTParamTemplate();
            this.cElements = fRetVals ? hMethod.getReturnCount() : hMethod.getParamCount();
            this.ahElement = new ObjectHandle[this.cElements];
            this.construct = this.template.getStructure().findMethod("construct", fRetVals ? 2 : 5, new TypeConstant[0]);
            this.ahParams = new ObjectHandle[fRetVals ? 2 : 5];
            this.iReturn = iReturn;
            this.index = -1;
        }

        @Override
        public int proceed(Frame frameCaller) {
            if (this.fDeferred) {
                this.ahParams[4] = frameCaller.popStack();
                this.fDeferred = false;
            } else {
                this.ahElement[this.index] = frameCaller.popStack();
            }
            return this.doNext(frameCaller);
        }

        public int doNext(Frame frameCaller) {
            block5: while (++this.index < this.cElements) {
                Parameter param = this.fRetVals ? this.hMethod.getReturn(this.index) : this.hMethod.getParam(this.index);
                String sName = param.getName();
                this.ahParams[0] = xInt64.makeHandle(this.index);
                ObjectHandle objectHandle = this.ahParams[1] = sName == null ? xNullable.NULL : xString.makeHandle(sName);
                if (!this.fRetVals) {
                    this.ahParams[2] = xBoolean.makeHandle(param.isTypeParameter());
                    if (param.hasDefaultValue()) {
                        this.ahParams[3] = xBoolean.TRUE;
                        ObjectHandle hDefault = frameCaller.getConstHandle(param.getDefaultValue());
                        if (Op.isDeferred(hDefault)) {
                            --this.index;
                            this.fDeferred = true;
                            return hDefault.proceed(frameCaller, this);
                        }
                        this.ahParams[4] = hDefault;
                    } else {
                        this.ahParams[3] = xBoolean.FALSE;
                        this.ahParams[4] = xNullable.NULL;
                    }
                }
                TypeConstant type = this.fRetVals ? this.hMethod.getReturnType(this.index) : this.hMethod.getParamType(this.index);
                TypeComposition clz = this.fRetVals ? xRTSignature.ensureRTReturn(frameCaller, type) : xRTSignature.ensureRTParameter(frameCaller, type, param.getAnnotations());
                switch (this.template.construct(frameCaller, this.construct, clz, null, this.ahParams, -1)) {
                    case -1: {
                        this.ahElement[this.index] = frameCaller.popStack();
                        continue block5;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            xArray.ArrayHandle hArray = xArray.createImmutableArray(this.fRetVals ? xRTSignature.ensureReturnArray() : xRTSignature.ensureParamArray(), this.ahElement);
            return frameCaller.assignValue(this.iReturn, hArray);
        }
    }
}

