/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.ChildInfo;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.FormalTypeChildConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.PackageConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.RecursiveTypeConstant;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.RelationalTypeConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ProxyComposition;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.IndexSupport;
import org.xvm.runtime.template.Proxy;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template._native.reflect.xRTMethod;
import org.xvm.runtime.template._native.reflect.xRTProperty;
import org.xvm.runtime.template._native.reflect.xRTTypeTemplate;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.reflect.xClass;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xOrdered;
import org.xvm.util.ListMap;

public class xRTType
extends xConst
implements IndexSupport {
    public static xRTType INSTANCE;
    private static TypeConstant TYPE_ARRAY_TYPE;
    private static ArrayConstant EMPTY_TYPE_ARRAY;
    private static TypeConstant LISTMAP_TYPE;
    private static TypeComposition REGISTER_CLZCOMP;
    private static MethodStructure REGISTER_CONSTRUCT;
    private static PropertyConstant PROP_CALCULATE;
    private static PropertyConstant PROP_HASHER;

    public xRTType(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.f_container.getConstantPool();
        TYPE_ARRAY_TYPE = pool.ensureArrayType(pool.typeType());
        EMPTY_TYPE_ARRAY = pool.ensureArrayConstant(TYPE_ARRAY_TYPE, Constant.NO_CONSTS);
        PROP_CALCULATE = (PropertyConstant)pool.clzLazy().getComponent().getChild("calculate").getIdentityConstant();
        PROP_HASHER = (PropertyConstant)this.f_struct.getChild("hasher").getIdentityConstant();
        this.markNativeProperty("childTypes");
        this.markNativeProperty("constants");
        this.markNativeProperty("constructors");
        this.markNativeProperty("explicitlyImmutable");
        this.markNativeProperty("form");
        this.markNativeProperty("functions");
        this.markNativeProperty("methods");
        this.markNativeProperty("properties");
        this.markNativeProperty("recursive");
        this.markNativeProperty("template");
        this.markNativeProperty("typeSystem");
        this.markNativeProperty("underlyingTypes");
        this.markNativeMethod("accessSpecified", null, null);
        this.markNativeMethod("annotate", null, null);
        this.markNativeMethod("annotated", null, null);
        this.markNativeMethod("contained", null, null);
        this.markNativeMethod("fromClass", null, null);
        this.markNativeMethod("fromProperty", null, null);
        this.markNativeMethod("modifying", null, null);
        this.markNativeMethod("relational", null, null);
        this.markNativeMethod("named", null, null);
        this.markNativeMethod("parameterize", null, null);
        this.markNativeMethod("parameterized", null, null);
        this.markNativeMethod("purify", null, null);
        this.markNativeMethod("resolveFormalType", null, null);
        this.markNativeMethod("structConstructor", null, null);
        this.markNativeMethod("dump", null, null);
        String[] PARAM_TYPE = new String[]{"reflect.Type!<>"};
        String[] PARAM_METHODS = new String[]{"collections.Array<reflect.Method>"};
        String[] PARAM_PROPS = new String[]{"collections.Array<reflect.Property>"};
        this.markNativeMethod("add", PARAM_TYPE, null);
        this.markNativeMethod("add", PARAM_METHODS, null);
        this.markNativeMethod("add", PARAM_PROPS, null);
        this.markNativeMethod("sub", PARAM_TYPE, null);
        this.markNativeMethod("sub", PARAM_METHODS, null);
        this.markNativeMethod("sub", PARAM_PROPS, null);
        this.markNativeMethod("and", PARAM_TYPE, null);
        this.markNativeMethod("or", PARAM_TYPE, null);
        ClassStructure structType = (ClassStructure)this.pool().clzType().getComponent();
        structType.findMethod("equals", 3, new TypeConstant[0]).markNative();
        structType.findMethod("compare", 3, new TypeConstant[0]).markNative();
        structType.findMethod("hashCode", 2, new TypeConstant[0]).markNative();
        structType.findMethod("isA", 1, new TypeConstant[0]).markNative();
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        ConstantPool pool = this.pool();
        return pool.ensureParameterizedTypeConstant(pool.typeType(), pool.typeObject(), pool.typeObject());
    }

    @Override
    public TypeComposition ensureClass(Container container, TypeConstant typeActual) {
        return typeActual.equals(this.getCanonicalType()) ? this.getCanonicalClass(container) : this.getCanonicalClass(container).ensureCanonicalizedComposition(typeActual);
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof TypeConstant) {
            TypeConstant typeTarget = (TypeConstant)constant;
            ConstantPool pool = frame.poolContext();
            assert (typeTarget.isTypeOfType());
            TypeConstant typeData = typeTarget.getParamType(0);
            typeData = typeData.resolveGenerics(pool, frame.getGenericsResolver(typeData.containsDynamicType()));
            return frame.pushStack(typeData.normalizeParameters().ensureTypeHandle(frame.f_context.f_container));
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int createProxyHandle(Frame frame, ServiceContext ctxTarget, ObjectHandle hTarget, TypeConstant typeProxy) {
        return frame.assignValue(-1, xRTType.makeForeignHandle(((TypeHandle)hTarget).getUnsafeDataType()));
    }

    @Override
    public int getPropertyValue(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, int iReturn) {
        TypeHandle hType = (TypeHandle)hTarget;
        if (idProp instanceof FormalTypeChildConstant) {
            TypeConstant typeTarget = hType.getDataType();
            TypeConstant typeValue = "OuterType".equals(idProp.getName()) && typeTarget.isVirtualChild() ? typeTarget.getParentType() : typeTarget.resolveFormalType(idProp);
            return typeValue == null ? frame.raiseException(xException.invalidType(frame, "Unknown formal type: " + idProp.getName())) : frame.assignValue(iReturn, typeValue.ensureTypeHandle(frame.f_context.f_container));
        }
        if ("DataType".equals(idProp.getName())) {
            TypeConstant typeResult = hType.getUnsafeDataType();
            return frame.assignValue(iReturn, typeResult.ensureTypeHandle(frame.f_context.f_container));
        }
        return super.getPropertyValue(frame, hTarget, idProp, iReturn);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        TypeHandle hType = (TypeHandle)hTarget;
        switch (sPropName) {
            case "childTypes": {
                return this.getPropertyChildTypes(frame, hType, iReturn);
            }
            case "constants": {
                return this.getPropertyConstants(frame, hType, iReturn);
            }
            case "constructors": {
                return this.getPropertyConstructors(frame, hType, iReturn);
            }
            case "explicitlyImmutable": {
                return this.getPropertyExplicitlyImmutable(frame, hType, iReturn);
            }
            case "form": {
                return this.getPropertyForm(frame, hType, iReturn);
            }
            case "functions": {
                return this.getPropertyFunctions(frame, hType, iReturn);
            }
            case "methods": {
                return this.getPropertyMethods(frame, hType, iReturn);
            }
            case "properties": {
                return this.getPropertyProperties(frame, hType, iReturn);
            }
            case "recursive": {
                return this.getPropertyRecursive(frame, hType, iReturn);
            }
            case "template": {
                return this.getPropertyTemplate(frame, hType, iReturn);
            }
            case "typeSystem": {
                return this.getPropertyTypeSystem(frame, hType, iReturn);
            }
            case "underlyingTypes": {
                return this.getPropertyUnderlyingTypes(frame, hType, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        TypeHandle hType = (TypeHandle)hTarget;
        switch (method.getName()) {
            case "isA": {
                return this.invokeIsA(frame, hType, (TypeHandle)hArg, iReturn);
            }
            case "add": {
                return this.invokeAdd(frame, hType, hArg, iReturn);
            }
            case "annotate": {
                return this.invokeAnnotate(frame, hType, hArg, iReturn);
            }
            case "sub": {
                return this.invokeSub(frame, hType, hArg, iReturn);
            }
            case "and": {
                return this.invokeAnd(frame, hType, hArg, iReturn);
            }
            case "or": {
                return this.invokeOr(frame, hType, hArg, iReturn);
            }
            case "parameterize": {
                return this.invokeParameterize(frame, hType, hArg, iReturn);
            }
            case "purify": {
                return this.invokePurify(frame, hType, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        TypeHandle hType = (TypeHandle)hTarget;
        switch (method.getName()) {
            case "dump": {
                return frame.assignValue(iReturn, xString.makeHandle(hType.getUnsafeDataType().ensureTypeInfo().toString(true)));
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        TypeHandle hType = (TypeHandle)hTarget;
        switch (method.getName()) {
            case "accessSpecified": {
                return this.invokeAccessSpecified(frame, hType, aiReturn);
            }
            case "annotated": {
                return this.invokeAnnotated(frame, hType, aiReturn);
            }
            case "contained": {
                return this.invokeContained(frame, hType, aiReturn);
            }
            case "fromClass": {
                return this.invokeFromClass(frame, hType, aiReturn);
            }
            case "fromProperty": {
                return this.invokeFromProperty(frame, hType, aiReturn);
            }
            case "modifying": {
                return this.invokeModifying(frame, hType, aiReturn);
            }
            case "relational": {
                return this.invokeRelational(frame, hType, aiReturn);
            }
            case "named": {
                return this.invokeNamed(frame, hType, aiReturn);
            }
            case "parameterized": {
                return this.invokeParameterized(frame, hType, aiReturn);
            }
            case "resolveFormalType": {
                return this.invokeResolveFormalType(frame, hType, (xString.StringHandle)ahArg[0], aiReturn);
            }
            case "structConstructor": {
                return this.invokeStructConstructor(frame, hType, ahArg[0], aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    public int invokeAdd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        TypeHandle hTypeThis = (TypeHandle)hTarget;
        if (hArg instanceof TypeHandle) {
            TypeHandle hTypeThat = (TypeHandle)hArg;
            if (hTypeThis.getUnsafeDataType().isOnlyImmutable()) {
                return this.ensureImmutable(frame, hTypeThat, iReturn);
            }
            if (hTypeThat.getUnsafeDataType().isOnlyImmutable()) {
                return this.ensureImmutable(frame, hTypeThis, iReturn);
            }
            return this.makeRelationalType(frame, hTypeThis, hTypeThat, ConstantPool::ensureIntersectionTypeConstant, iReturn);
        }
        if (hArg instanceof xRTMethod.MethodHandle) {
            throw new UnsupportedOperationException();
        }
        if (hArg instanceof xRTProperty.PropertyHandle) {
            throw new UnsupportedOperationException();
        }
        return super.invokeAdd(frame, hTarget, hArg, iReturn);
    }

    private int ensureImmutable(Frame frame, TypeHandle hType, int iReturn) {
        TypeConstant type = hType.getUnsafeDataType();
        return type.isImmutabilitySpecified() ? frame.assignValue(iReturn, hType) : frame.assignValue(iReturn, type.freeze().ensureTypeHandle(frame.f_context.f_container));
    }

    @Override
    public int invokeSub(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        TypeHandle hTypeThis = (TypeHandle)hTarget;
        if (hArg instanceof TypeHandle) {
            TypeHandle hTypeThat = (TypeHandle)hArg;
            return this.makeRelationalType(frame, hTypeThis, hTypeThat, ConstantPool::ensureDifferenceTypeConstant, iReturn);
        }
        if (hArg instanceof xRTMethod.MethodHandle) {
            throw new UnsupportedOperationException();
        }
        if (hArg instanceof xRTProperty.PropertyHandle) {
            throw new UnsupportedOperationException();
        }
        return super.invokeAdd(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeAnd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return super.invokeOr(frame, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeOr(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        TypeHandle hTypeThis = (TypeHandle)hTarget;
        if (hArg instanceof TypeHandle) {
            TypeHandle hTypeThat = (TypeHandle)hArg;
            return this.makeRelationalType(frame, hTypeThis, hTypeThat, ConstantPool::ensureUnionTypeConstant, iReturn);
        }
        return super.invokeOr(frame, hTarget, hArg, iReturn);
    }

    @Override
    protected int callEqualsImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(((TypeHandle)hValue1).getUnsafeDataType().equals(((TypeHandle)hValue2).getUnsafeDataType())));
    }

    @Override
    protected int callCompareImpl(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xOrdered.makeHandle(((TypeHandle)hValue1).getUnsafeDataType().compareTo(((TypeHandle)hValue2).getUnsafeDataType())));
    }

    @Override
    protected int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        return frame.assignValue(iReturn, xInt64.makeHandle(((TypeHandle)hTarget).getUnsafeDataType().hashCode()));
    }

    @Override
    public long size(ObjectHandle hTarget) {
        TypeConstant type = ((TypeHandle)hTarget).getDataType();
        return type.getParamsCount();
    }

    @Override
    public int extractArrayValue(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        TypeConstant type = ((TypeHandle)hTarget).getDataType();
        int nIndex = (int)lIndex;
        return nIndex >= 0 && nIndex < type.getParamsCount() ? frame.assignValue(iReturn, type.getParamType(nIndex).ensureTypeHandle(frame.f_context.f_container)) : frame.raiseException(xException.outOfBounds(frame, lIndex, type.getParamsCount()));
    }

    @Override
    public int assignArrayValue(Frame frame, ObjectHandle hTarget, long lIndex, ObjectHandle hValue) {
        return frame.raiseException(xException.immutableObject(frame));
    }

    @Override
    public TypeConstant getElementType(Frame frame, ObjectHandle hTarget, long lIndex) throws ObjectHandle.ExceptionHandle.WrapperException {
        throw xException.unsupported(frame).getException();
    }

    public int getPropertyChildTypes(Frame frame, TypeHandle hType, int iReturn) {
        if (hType.isForeign()) {
            return this.getForeignChildTypes(frame, hType, iReturn);
        }
        Container container = frame.f_context.f_container;
        TypeComposition clzListMap = container.resolveClass(xRTType.ensureListMapType(container));
        ObjectHandle[][] aah = this.collectChildTypes(frame, hType);
        xString.StringHandle[] ahName = (xString.StringHandle[])aah[0];
        ObjectHandle[] ahType = (TypeHandle[])aah[1];
        return Utils.constructListMap(frame, clzListMap, xArray.makeStringArrayHandle(ahName), xArray.createImmutableArray(xRTType.ensureTypeArrayComposition(container), ahType), iReturn);
    }

    private ObjectHandle[][] collectChildTypes(Frame frame, TypeHandle hType) {
        PackageStructure pkg;
        IdentityConstant id;
        TypeConstant typeTarget = hType.getDataType();
        if (typeTarget.isSingleUnderlyingClass(false) && (id = typeTarget.getSingleUnderlyingClass(false)) instanceof PackageConstant && (pkg = (PackageStructure)id.getComponent()).isModuleImport()) {
            typeTarget = pkg.getImportedModule().getIdentityConstant().getType();
        }
        TypeInfo infoTarget = typeTarget.ensureTypeInfo();
        ConstantPool poolCtx = frame.poolContext();
        Container container = frame.f_context.f_container;
        ListMap<String, ChildInfo> mapInfos = infoTarget.getChildInfosByName();
        int cInfos = mapInfos.size();
        xString.StringHandle[] ahName = new xString.StringHandle[cInfos];
        TypeHandle[] ahType = new TypeHandle[cInfos];
        int ix = 0;
        for (String sName : mapInfos.keySet()) {
            ahName[ix] = xString.makeHandle(sName);
            ahType[ix++] = infoTarget.calculateChildType(poolCtx, sName).ensureTypeHandle(container);
        }
        return new ObjectHandle[][]{ahName, ahType};
    }

    private int getForeignChildTypes(Frame frame, TypeHandle hType, int iReturn) {
        final TypeConstant typeForeign = hType.getUnsafeDataType();
        Container container = frame.f_context.f_container;
        Container containerForeign = container.f_runtime.findContainer(typeForeign.getConstantPool());
        if (containerForeign != null) {
            Op opCall = new Op(this){
                final /* synthetic */ xRTType this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int process(Frame frame, int iPC) {
                    Container container = frame.f_context.f_container;
                    TypeHandle hType = typeForeign.ensureTypeHandle(container);
                    ObjectHandle[][] aah = this.this$0.collectChildTypes(frame, hType);
                    TypeComposition clzListMap = container.resolveClass(xRTType.ensureListMapType(container));
                    xString.StringHandle[] ahName = (xString.StringHandle[])aah[0];
                    ObjectHandle[] ahType = (TypeHandle[])aah[1];
                    int c = ahType.length;
                    for (int i = 0; i < c; ++i) {
                        ahType[i] = xRTType.makeHandle(null, ahType[i].getDataType(), false);
                    }
                    return Utils.constructListMap(frame, clzListMap, xArray.makeStringArrayHandle(ahName), xArray.createImmutableArray(xRTType.ensureTypeArrayComposition(container), ahType), 0);
                }

                @Override
                public String toString() {
                    return "getForeignChildTypes";
                }
            };
            return containerForeign.ensureServiceContext().sendOp1Request(frame, opCall, iReturn, new TypeConstant[0]);
        }
        return Utils.constructListMap(frame, container.resolveClass(xRTType.ensureListMapType(container)), xString.ensureEmptyArray(), xRTType.ensureEmptyTypeArray(container), iReturn);
    }

    public int getPropertyConstants(Frame frame, TypeHandle hType, int iReturn) {
        if (hType.isForeign()) {
            return this.getForeignConstants(frame, hType, iReturn);
        }
        TypeConstant typeTarget = hType.getDataType();
        TypeInfo infoTarget = typeTarget.ensureTypeInfo();
        Map<PropertyConstant, PropertyInfo> mapProps = infoTarget.getProperties();
        ArrayList<PropertyInfo> listInfo = new ArrayList<PropertyInfo>(mapProps.size());
        for (PropertyInfo infoProp : mapProps.values()) {
            if (!infoProp.isConstant()) continue;
            listInfo.add(infoProp);
        }
        return this.makePropertyArray(frame, typeTarget, listInfo, iReturn);
    }

    private int getForeignConstants(Frame frame, TypeHandle hType, int iReturn) {
        final TypeConstant typeForeign = hType.getUnsafeDataType();
        Container container = frame.f_context.f_container;
        Container containerForeign = container.f_runtime.findContainer(typeForeign.getConstantPool());
        if (containerForeign != null) {
            Op opCall = new Op(this){
                final /* synthetic */ xRTType this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int process(Frame frame, int iPC) {
                    TypeHandle hType = typeForeign.ensureTypeHandle(frame.f_context.f_container);
                    switch (this.this$0.getPropertyConstants(frame, hType, -1)) {
                        case -1: {
                            return this.this$0.createProxyArray(frame, (xArray.ArrayHandle)frame.popStack(), xRTFunction.INSTANCE.getCanonicalClass());
                        }
                        case -5: {
                            frame.m_frameNext.addContinuation(frameCaller -> this.this$0.createProxyArray(frameCaller, (xArray.ArrayHandle)frameCaller.popStack(), xRTFunction.INSTANCE.getCanonicalClass()));
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }

                @Override
                public String toString() {
                    return "getForeignConstants";
                }
            };
            return containerForeign.ensureServiceContext().sendOp1Request(frame, opCall, iReturn, new TypeConstant[0]);
        }
        return frame.assignValue(iReturn, xRTProperty.ensureEmptyArray(container));
    }

    public int getPropertyConstructors(Frame frame, TypeHandle hType, int iReturn) {
        ObjectHandle[] ahFunctions;
        if (hType.isForeign()) {
            return this.getForeignConstructors(frame, hType, iReturn);
        }
        TypeConstant typeTarget = hType.getDataType();
        TypeInfo infoTarget = typeTarget.ensureTypeInfo();
        TypeConstant typeParent = null;
        if (infoTarget.isVirtualChildClass()) {
            typeParent = hType.getOuterType();
            assert (typeParent != null);
            assert (!typeParent.equals(this.pool().typeObject()));
        }
        if (infoTarget.isNewable(false, ErrorListener.BLACKHOLE)) {
            ConstantPool pool = frame.poolContext();
            TypeComposition clzTarget = typeTarget.ensureClass(frame);
            ArrayList<ObjectHandle> listHandles = new ArrayList<ObjectHandle>();
            for (MethodConstant idConstr : infoTarget.findMethods("construct", -1, TypeInfo.MethodKind.Constructor)) {
                MethodInfo infoMethod = infoTarget.getMethodById(idConstr, true);
                MethodStructure constructor = infoMethod.getTopmostMethodStructure(infoTarget);
                Parameter[] aParams = constructor.getParamArray();
                TypeConstant[] atypeParams = infoMethod.getSignature().getRawParams();
                if (typeParent != null) {
                    int cParams = atypeParams.length;
                    assert (cParams == aParams.length);
                    TypeConstant[] atypeNew = new TypeConstant[cParams + 1];
                    atypeNew[0] = typeParent;
                    System.arraycopy(atypeParams, 0, atypeNew, 1, cParams);
                    Parameter[] aParamsNew = new Parameter[cParams + 1];
                    aParamsNew[0] = new Parameter(pool, typeParent, "0", null, false, 0, false);
                    for (int i = 0; i < cParams; ++i) {
                        Parameter param = aParams[i];
                        assert (!param.isTypeParameter());
                        aParamsNew[i + 1] = new Parameter(pool, param.getType(), param.getName(), param.getDefaultValue(), false, i + 1, false);
                    }
                    atypeParams = atypeNew;
                    aParams = aParamsNew;
                }
                TypeConstant typeConstructor = pool.buildFunctionType(atypeParams, typeTarget);
                listHandles.add(xRTFunction.makeConstructorHandle(frame, constructor, typeConstructor, clzTarget, aParams, typeParent != null));
            }
            ahFunctions = listHandles.toArray(Utils.OBJECTS_NONE);
        } else {
            ahFunctions = Utils.OBJECTS_NONE;
        }
        TypeComposition clzArray = xRTFunction.ensureConstructorArray(frame, typeTarget, typeParent);
        if (Op.anyDeferred(ahFunctions)) {
            ObjectHandle.DeferredArrayHandle hDeferred = new ObjectHandle.DeferredArrayHandle(clzArray, ahFunctions);
            return ((ObjectHandle)hDeferred).proceed(frame, frameCaller -> frameCaller.assignValue(iReturn, frameCaller.popStack()));
        }
        return frame.assignValue(iReturn, xArray.createImmutableArray(clzArray, ahFunctions));
    }

    private int getForeignConstructors(Frame frame, TypeHandle hType, int iReturn) {
        final TypeConstant typeForeign = hType.getUnsafeDataType();
        Container container = frame.f_context.f_container;
        Container containerForeign = container.f_runtime.findContainer(typeForeign.getConstantPool());
        if (containerForeign != null) {
            Op opCall = new Op(this){
                final /* synthetic */ xRTType this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int process(Frame frame, int iPC) {
                    TypeHandle hType = typeForeign.ensureTypeHandle(frame.f_context.f_container);
                    switch (this.this$0.getPropertyConstructors(frame, hType, -1)) {
                        case -1: {
                            return this.this$0.createProxyArray(frame, (xArray.ArrayHandle)frame.popStack(), xRTFunction.INSTANCE.getCanonicalClass());
                        }
                        case -5: {
                            frame.m_frameNext.addContinuation(frameCaller -> this.this$0.createProxyArray(frameCaller, (xArray.ArrayHandle)frameCaller.popStack(), xRTFunction.INSTANCE.getCanonicalClass()));
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }

                @Override
                public String toString() {
                    return "getForeignConstructors";
                }
            };
            return containerForeign.ensureServiceContext().sendOp1Request(frame, opCall, iReturn, new TypeConstant[0]);
        }
        return frame.assignValue(iReturn, xRTFunction.ensureEmptyArray(container));
    }

    public int getPropertyExplicitlyImmutable(Frame frame, TypeHandle hType, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hType.getDataType().isImmutabilitySpecified()));
    }

    public int getPropertyForm(Frame frame, TypeHandle hType, int iReturn) {
        return Utils.assignInitializedEnum(frame, xRTType.makeFormHandle(frame, hType.getUnsafeDataType()), iReturn);
    }

    public int getPropertyFunctions(Frame frame, TypeHandle hType, int iReturn) {
        Container container = frame.f_context.f_container;
        if (hType.isForeign()) {
            return this.getForeignFunctions(frame, hType, iReturn);
        }
        TypeConstant typeTarget = hType.getDataType();
        Map<MethodConstant, MethodInfo> mapMethods = typeTarget.ensureTypeInfo().getMethods();
        ArrayList<ObjectHandle> listHandles = new ArrayList<ObjectHandle>(mapMethods.size());
        boolean fDeferred = false;
        for (Map.Entry<MethodConstant, MethodInfo> entry : mapMethods.entrySet()) {
            MethodConstant id = entry.getKey();
            MethodInfo info = entry.getValue();
            if (!info.isFunction() || !id.isTopLevel()) continue;
            ObjectHandle hFn = xRTFunction.makeHandle(frame, info.getHead().getMethodStructure());
            fDeferred |= Op.isDeferred(hFn);
            listHandles.add(hFn);
        }
        TypeComposition clzArray = xRTFunction.ensureArrayComposition(container);
        ObjectHandle[] ahFunctions = listHandles.toArray(Utils.OBJECTS_NONE);
        if (fDeferred) {
            ObjectHandle.DeferredArrayHandle hDeferred = new ObjectHandle.DeferredArrayHandle(clzArray, ahFunctions);
            return ((ObjectHandle)hDeferred).proceed(frame, frameCaller -> frameCaller.assignValue(iReturn, frameCaller.popStack()));
        }
        return frame.assignValue(iReturn, xArray.createImmutableArray(clzArray, ahFunctions));
    }

    private int getForeignFunctions(Frame frame, TypeHandle hType, int iReturn) {
        final TypeConstant typeForeign = hType.getUnsafeDataType();
        Container container = frame.f_context.f_container;
        Container containerForeign = container.f_runtime.findContainer(typeForeign.getConstantPool());
        if (containerForeign != null) {
            Op opCall = new Op(this){
                final /* synthetic */ xRTType this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int process(Frame frame, int iPC) {
                    TypeHandle hType = typeForeign.ensureTypeHandle(frame.f_context.f_container);
                    switch (this.this$0.getPropertyFunctions(frame, hType, -1)) {
                        case -1: {
                            return this.this$0.createProxyArray(frame, (xArray.ArrayHandle)frame.popStack(), xRTFunction.INSTANCE.getCanonicalClass());
                        }
                        case -5: {
                            frame.m_frameNext.addContinuation(frameCaller -> this.this$0.createProxyArray(frameCaller, (xArray.ArrayHandle)frameCaller.popStack(), xRTFunction.INSTANCE.getCanonicalClass()));
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }

                @Override
                public String toString() {
                    return "getForeignFunctions";
                }
            };
            return containerForeign.ensureServiceContext().sendOp1Request(frame, opCall, iReturn, new TypeConstant[0]);
        }
        return frame.assignValue(iReturn, xRTFunction.ensureEmptyArray(container));
    }

    public int getPropertyMethods(Frame frame, TypeHandle hType, int iReturn) {
        if (hType.isForeign()) {
            return this.getForeignMethods(frame, hType, iReturn);
        }
        TypeConstant typeTarget = hType.getDataType();
        Map.Entry<MethodConstant, MethodInfo>[] aMethods = typeTarget.ensureTypeInfo().sortedMethods();
        ArrayList<ObjectHandle> listHandles = new ArrayList<ObjectHandle>(aMethods.length);
        for (Map.Entry<MethodConstant, MethodInfo> entry : aMethods) {
            MethodConstant idMethod = entry.getKey();
            MethodInfo info = entry.getValue();
            if (info.isCapped() || info.isFunction() || info.isConstructor() || !idMethod.isTopLevel()) continue;
            listHandles.add(xRTMethod.makeHandle(frame, typeTarget, info.getIdentity()));
        }
        TypeComposition clzArray = xRTMethod.ensureArrayComposition(frame, typeTarget);
        ObjectHandle[] ahMethods = listHandles.toArray(Utils.OBJECTS_NONE);
        if (Op.anyDeferred(ahMethods)) {
            ObjectHandle.DeferredArrayHandle hDeferred = new ObjectHandle.DeferredArrayHandle(clzArray, ahMethods);
            return ((ObjectHandle)hDeferred).proceed(frame, frameCaller -> frameCaller.assignValue(iReturn, frameCaller.popStack()));
        }
        return frame.assignValue(iReturn, xArray.createImmutableArray(clzArray, ahMethods));
    }

    private int getForeignMethods(Frame frame, TypeHandle hType, int iReturn) {
        final TypeConstant typeForeign = hType.getUnsafeDataType();
        Container container = frame.f_context.f_container;
        Container containerForeign = container.f_runtime.findContainer(typeForeign.getConstantPool());
        if (containerForeign != null) {
            Op opCall = new Op(this){
                final /* synthetic */ xRTType this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int process(Frame frame, int iPC) {
                    TypeHandle hType = typeForeign.ensureTypeHandle(frame.f_context.f_container);
                    switch (this.this$0.getPropertyMethods(frame, hType, -1)) {
                        case -1: {
                            return this.this$0.createProxyArray(frame, (xArray.ArrayHandle)frame.popStack(), xRTMethod.INSTANCE.getCanonicalClass());
                        }
                        case -5: {
                            frame.m_frameNext.addContinuation(frameCaller -> this.this$0.createProxyArray(frameCaller, (xArray.ArrayHandle)frameCaller.popStack(), xRTMethod.INSTANCE.getCanonicalClass()));
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }

                @Override
                public String toString() {
                    return "getForeignMethods";
                }
            };
            return containerForeign.ensureServiceContext().sendOp1Request(frame, opCall, iReturn, new TypeConstant[0]);
        }
        return frame.assignValue(iReturn, xRTMethod.ensureEmptyArray(container));
    }

    public int getPropertyProperties(Frame frame, TypeHandle hType, int iReturn) {
        if (hType.isForeign()) {
            return this.getForeignProperties(frame, hType, iReturn);
        }
        TypeConstant typeTarget = hType.getDataType();
        Map.Entry<PropertyConstant, PropertyInfo>[] aProps = typeTarget.ensureTypeInfo().sortedProperties();
        ArrayList<PropertyInfo> listProps = new ArrayList<PropertyInfo>(aProps.length);
        for (Map.Entry<PropertyConstant, PropertyInfo> entry : aProps) {
            PropertyConstant idProp = entry.getKey();
            PropertyInfo infoProp = entry.getValue();
            if (infoProp.isConstant() || !idProp.isTopLevel()) continue;
            listProps.add(infoProp);
        }
        return this.makePropertyArray(frame, typeTarget, listProps, iReturn);
    }

    private int getForeignProperties(Frame frame, TypeHandle hType, int iReturn) {
        final TypeConstant typeForeign = hType.getUnsafeDataType();
        Container container = frame.f_context.f_container;
        Container containerForeign = container.f_runtime.findContainer(typeForeign.getConstantPool());
        if (containerForeign != null) {
            Op opCall = new Op(this){
                final /* synthetic */ xRTType this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int process(Frame frame, int iPC) {
                    TypeHandle hType = typeForeign.ensureTypeHandle(frame.f_context.f_container);
                    switch (this.this$0.getPropertyProperties(frame, hType, -1)) {
                        case -1: {
                            return this.this$0.createProxyArray(frame, (xArray.ArrayHandle)frame.popStack(), xRTProperty.INSTANCE.getCanonicalClass());
                        }
                        case -5: {
                            frame.m_frameNext.addContinuation(frameCaller -> this.this$0.createProxyArray(frameCaller, (xArray.ArrayHandle)frameCaller.popStack(), xRTProperty.INSTANCE.getCanonicalClass()));
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }

                @Override
                public String toString() {
                    return "getForeignProperties";
                }
            };
            return containerForeign.ensureServiceContext().sendOp1Request(frame, opCall, iReturn, new TypeConstant[0]);
        }
        return frame.assignValue(iReturn, xRTProperty.ensureEmptyArray(container));
    }

    public int getPropertyRecursive(Frame frame, TypeHandle hType, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(hType.getDataType().containsRecursiveType()));
    }

    public int getPropertyTemplate(Frame frame, TypeHandle hType, int iReturn) {
        return frame.assignValue(iReturn, xRTTypeTemplate.makeHandle(frame.f_context.f_container, hType.getDataType()));
    }

    public int getPropertyTypeSystem(Frame frame, TypeHandle hType, int iReturn) {
        if (hType.isForeign()) {
            throw new UnsupportedOperationException("create a proxy");
        }
        return frame.f_context.f_container.ensureTypeSystemHandle(frame, iReturn);
    }

    public int getPropertyUnderlyingTypes(Frame frame, TypeHandle hType, int iReturn) {
        Container container = frame.f_context.f_container;
        if (hType.isForeign()) {
            return this.getForeignUnderlyingTypes(frame, hType, iReturn);
        }
        TypeConstant typeTarget = hType.getDataType();
        TypeConstant[] aUnderlying = TypeConstant.NO_TYPES;
        if (typeTarget.isModifyingType()) {
            aUnderlying = new TypeConstant[]{typeTarget.getUnderlyingType()};
        } else if (typeTarget.isRelationalType()) {
            aUnderlying = new TypeConstant[]{typeTarget.getUnderlyingType(), typeTarget.getUnderlyingType2()};
        } else if (typeTarget.isFormalTypeSequence()) {
            aUnderlying = new TypeConstant[]{typeTarget};
        }
        ObjectHandle[] ahTypes = new TypeHandle[aUnderlying.length];
        int c = ahTypes.length;
        for (int i = 0; i < c; ++i) {
            ahTypes[i] = aUnderlying[i].ensureTypeHandle(container);
        }
        xArray.ArrayHandle hArray = xArray.createImmutableArray(xRTType.ensureTypeArrayComposition(container), ahTypes);
        return frame.assignValue(iReturn, hArray);
    }

    private int getForeignUnderlyingTypes(Frame frame, TypeHandle hType, int iReturn) {
        final TypeConstant typeForeign = hType.getUnsafeDataType();
        Container container = frame.f_context.f_container;
        Container containerForeign = container.f_runtime.findContainer(typeForeign.getConstantPool());
        if (containerForeign != null) {
            Op opCall = new Op(this){
                final /* synthetic */ xRTType this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int process(Frame frame, int iPC) {
                    TypeHandle hType = typeForeign.ensureTypeHandle(frame.f_context.f_container);
                    switch (this.this$0.getForeignUnderlyingTypes(frame, hType, -1)) {
                        case -1: {
                            return this.this$0.createProxyArray(frame, (xArray.ArrayHandle)frame.popStack(), xRTProperty.INSTANCE.getCanonicalClass());
                        }
                        case -5: {
                            frame.m_frameNext.addContinuation(frameCaller -> this.this$0.createProxyArray(frameCaller, (xArray.ArrayHandle)frameCaller.popStack(), xRTProperty.INSTANCE.getCanonicalClass()));
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }

                @Override
                public String toString() {
                    return "getForeignUnderlyingTypes";
                }
            };
            return containerForeign.ensureServiceContext().sendOp1Request(frame, opCall, iReturn, new TypeConstant[0]);
        }
        return frame.assignValue(iReturn, xRTType.ensureEmptyTypeArray(container));
    }

    protected int invokeAccessSpecified(Frame frame, TypeHandle hType, int[] aiReturn) {
        TypeConstant type = hType.getUnsafeDataType();
        if (type.isAccessSpecified()) {
            ObjectHandle hEnum = Utils.ensureInitializedEnum(frame, xRTType.makeAccessHandle(frame, type.getAccess()));
            return frame.assignConditionalDeferredValue(aiReturn, hEnum);
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected int invokeAnnotate(Frame frame, TypeHandle hType, ObjectHandle hArg, int iReturn) {
        TypeConstant typeForeign;
        TypeConstant typeAnno;
        ConstantPool pool = frame.poolContext();
        TypeConstant typeThis = hType.getDataType();
        ObjectHandle.GenericHandle hAnno = (ObjectHandle.GenericHandle)hArg;
        ObjectHandle hMixin = hAnno.getField(frame, "annoClass");
        if (hMixin instanceof xClass.ClassHandle) {
            xClass.ClassHandle hClass = (xClass.ClassHandle)hMixin;
            xArray.ArrayHandle hArgs = (xArray.ArrayHandle)hAnno.getField(frame, "arguments");
            if (xArray.INSTANCE.size(hArgs) > 0L) {
                return frame.raiseException(xException.notImplemented(frame, "Annotation arguments are not yet supported"));
            }
            typeAnno = hClass.getType().getParamType(0);
            if (typeThis.isShared(pool) && typeAnno.isShared(pool)) {
                return this.makeAnnotated(frame, typeThis, typeAnno, iReturn);
            }
        } else if (hMixin instanceof Proxy.ProxyHandle) {
            Proxy.ProxyHandle hProxy = (Proxy.ProxyHandle)hMixin;
            typeAnno = hProxy.getTarget().getUnsafeType();
            if (typeThis.isShared(pool) && typeAnno.isShared(pool)) {
                return this.makeAnnotated(frame, typeThis, typeAnno, iReturn);
            }
        } else {
            return frame.raiseException(xException.unsupported(frame, "Unsupported type: " + String.valueOf(hMixin.getType())));
        }
        TypeConstant typeConstant = typeForeign = typeAnno.isShared(pool) ? typeThis : typeAnno;
        if (typeForeign.isA(pool.typeClass()) || typeForeign.isTypeOfType()) {
            typeForeign = typeForeign.getParamType(0);
        }
        return frame.raiseException(xException.invalidType(frame, "Type \"" + typeForeign.getValueString() + "\" is not shared with the TypeSystem of module \"" + frame.f_context.f_container.getModule().getName() + "\""));
    }

    private int makeAnnotated(Frame frame, TypeConstant typeThis, TypeConstant typeAnno, int iReturn) {
        ConstantPool pool = frame.poolContext();
        ClassConstant clzAnno = (ClassConstant)typeAnno.getDefiningConstant();
        Annotation anno = pool.ensureAnnotation(clzAnno, new Constant[0]);
        AnnotatedTypeConstant typeResult = pool.ensureAnnotatedTypeConstant(typeThis, anno);
        return frame.assignValue(iReturn, typeResult.ensureTypeHandle(frame.f_context.f_container));
    }

    protected int invokeAnnotated(Frame frame, TypeHandle hType, int[] aiReturn) {
        if (hType.isForeign()) {
            return this.invokeForeignAnnotated(frame, hType, aiReturn);
        }
        TypeConstant typeThis = hType.getDataType();
        if (typeThis.isAnnotated()) {
            ObjectHandle[] ahArg;
            Annotation annotation = typeThis.getAnnotations()[0];
            IdentityConstant idClass = (IdentityConstant)annotation.getAnnotationClass();
            Constant[] aconstArg = annotation.getParams();
            ObjectHandle hClass = frame.getConstHandle(idClass);
            int cArgs = aconstArg.length;
            if (cArgs == 0) {
                ahArg = Utils.OBJECTS_NONE;
            } else {
                ahArg = new ObjectHandle[cArgs];
                for (int i = 0; i < cArgs; ++i) {
                    ObjectHandle objectHandle;
                    Constant constArg = aconstArg[i];
                    if (constArg instanceof RegisterConstant) {
                        RegisterConstant constReg = (RegisterConstant)constArg;
                        objectHandle = this.makeRegisterHandle(frame, constReg.getRegisterIndex());
                    } else {
                        objectHandle = xRTType.makeArgumentHandle(frame, constArg);
                    }
                    ahArg[i] = objectHandle;
                }
            }
            return Op.isDeferred(hClass) ? hClass.proceed(frame, frameCaller -> this.resolveInvokeAnnotatedArgs(frameCaller, (xClass.ClassHandle)frameCaller.popStack(), ahArg, aiReturn)) : this.resolveInvokeAnnotatedArgs(frame, (xClass.ClassHandle)hClass, ahArg, aiReturn);
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    private int invokeForeignAnnotated(Frame frame, TypeHandle hType, int[] aiReturn) {
        final TypeConstant typeForeign = hType.getUnsafeDataType();
        Container container = frame.f_context.f_container;
        Container containerForeign = container.f_runtime.findContainer(typeForeign.getConstantPool());
        if (containerForeign != null) {
            Op opCall = new Op(this){
                final /* synthetic */ xRTType this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int process(Frame frame, int iPC) {
                    TypeHandle hType = typeForeign.ensureTypeHandle(frame.f_context.f_container);
                    return this.this$0.invokeAnnotated(frame, hType, new int[]{0, 1});
                }

                @Override
                public String toString() {
                    return "invokeForeignAnnotated";
                }
            };
            return containerForeign.ensureServiceContext().sendOpNRequest(frame, opCall, aiReturn, new TypeConstant[0]);
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    private int resolveInvokeAnnotatedArgs(Frame frame, xClass.ClassHandle hClass, ObjectHandle[] ahArg, int[] aiReturn) {
        if (Op.anyDeferred(ahArg)) {
            Frame.Continuation stepNext = frameCaller -> this.completeInvokeAnnotated(frameCaller, hClass, ahArg, aiReturn);
            return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
        }
        return this.completeInvokeAnnotated(frame, hClass, ahArg, aiReturn);
    }

    private int completeInvokeAnnotated(Frame frame, xClass.ClassHandle hClass, ObjectHandle[] ahArg, int[] aiReturn) {
        frame.assignValue(aiReturn[0], xBoolean.TRUE);
        return Utils.constructAnnotation(frame, hClass, ahArg, aiReturn[1]);
    }

    protected int invokeContained(Frame frame, TypeHandle hType, int[] aiReturn) {
        TypeConstant typeTarget = hType.getUnsafeDataType();
        if (typeTarget.isVirtualChild() || typeTarget.isAnonymousClass()) {
            TypeHandle hParent = typeTarget.getParentType().ensureTypeHandle(frame.f_context.f_container);
            return frame.assignValues(aiReturn, xBoolean.TRUE, hParent);
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected int invokeFromClass(Frame frame, TypeHandle hType, int[] aiReturn) {
        TypeConstant typeTarget;
        if (!hType.isForeign() && (typeTarget = hType.getDataType()).isExplicitClassIdentity(true)) {
            typeTarget = typeTarget.removeAccess().removeImmutable().resolveAutoNarrowingBase();
            IdentityConstant idClz = frame.poolContext().ensureClassConstant(typeTarget);
            return frame.assignConditionalDeferredValue(aiReturn, frame.getConstHandle(idClz));
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected int invokeFromProperty(Frame frame, TypeHandle hType, int[] aiReturn) {
        Constant constDef;
        TypeConstant type;
        if (!hType.isForeign() && (type = hType.getDataType()).isSingleDefiningConstant() && (constDef = type.getDefiningConstant()) instanceof PropertyConstant) {
            PropertyConstant idProp = (PropertyConstant)constDef;
            TypeConstant typeParent = idProp.getParentConstant().getType();
            PropertyInfo infoProp = frame.poolContext().ensureAccessTypeConstant(typeParent, Constants.Access.PRIVATE).ensureTypeInfo().findProperty(idProp, true);
            if (infoProp != null) {
                ObjectHandle hProp = xRTProperty.makeHandle(frame, typeParent, infoProp);
                return Op.isDeferred(hProp) ? hProp.proceed(frame, frameCaller -> frameCaller.assignValues(aiReturn, xBoolean.TRUE, frameCaller.popStack())) : frame.assignValues(aiReturn, xBoolean.TRUE, hProp);
            }
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected int invokeModifying(Frame frame, TypeHandle hType, int[] aiReturn) {
        TypeConstant type = hType.getUnsafeDataType();
        return type.isModifyingType() ? frame.assignValues(aiReturn, xBoolean.TRUE, type.getUnderlyingType().ensureTypeHandle(frame.f_context.f_container)) : frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected int invokeNamed(Frame frame, TypeHandle hType, int[] aiReturn) {
        String sName = null;
        TypeConstant type = hType.getUnsafeDataType();
        if (type.isSingleDefiningConstant()) {
            Constant id = type.getDefiningConstant();
            switch (id.getFormat()) {
                case Module: 
                case Package: 
                case Class: 
                case NativeClass: 
                case Property: 
                case TypeParameter: 
                case FormalTypeChild: 
                case Typedef: {
                    sName = ((IdentityConstant)id).getName();
                    break;
                }
                case ThisClass: 
                case ParentClass: 
                case ChildClass: {
                    sName = ((PseudoConstant)id).getDeclarationLevelClass().getName();
                }
            }
        } else if (type instanceof RecursiveTypeConstant) {
            RecursiveTypeConstant typeRecursive = (RecursiveTypeConstant)type;
            sName = typeRecursive.getTypedef().getName();
        }
        return sName == null ? frame.assignValue(aiReturn[0], xBoolean.FALSE) : frame.assignValues(aiReturn, xBoolean.TRUE, xString.makeHandle(sName));
    }

    protected int invokeParameterized(Frame frame, TypeHandle hType, int[] aiReturn) {
        TypeConstant type = hType.getUnsafeDataType();
        if (!type.isParamsSpecified()) {
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        TypeConstant[] atypes = type.getParamTypesArray();
        int cTypes = atypes.length;
        ObjectHandle[] ahTypes = new TypeHandle[cTypes];
        for (int i = 0; i < cTypes; ++i) {
            ahTypes[i] = atypes[i].normalizeParameters().ensureTypeHandle(frame.f_context.f_container);
        }
        xArray.ArrayHandle hArray = xArray.createImmutableArray(xRTType.ensureTypeArrayComposition(frame.f_context.f_container), ahTypes);
        return frame.assignValues(aiReturn, xBoolean.TRUE, hArray);
    }

    protected int invokeParameterize(Frame frame, TypeHandle hType, ObjectHandle hArg, int iReturn) {
        int cFormalTypes;
        ObjectHandle[] ahFormalTypes;
        if (hType.isForeign()) {
            return frame.raiseException(xException.invalidType(frame, "Pure type " + hType.getDataType().getValueString()));
        }
        if (hArg instanceof xArray.ArrayHandle) {
            xArray template = (xArray)hArg.getTemplate();
            try {
                ahFormalTypes = template.toArray(frame, hArg);
                cFormalTypes = (int)template.size(hArg);
            }
            catch (ObjectHandle.ExceptionHandle.WrapperException e) {
                return frame.raiseException(e);
            }
        } else if (hArg == ObjectHandle.DEFAULT) {
            ahFormalTypes = Utils.OBJECTS_NONE;
            cFormalTypes = 0;
        } else {
            throw new UnsupportedOperationException();
        }
        ConstantPool pool = frame.poolContext();
        TypeConstant typeThis = hType.getDataType();
        TypeConstant[] atypeParams = new TypeConstant[cFormalTypes];
        for (int i = 0; i < cFormalTypes; ++i) {
            TypeHandle hTypeParam = (TypeHandle)ahFormalTypes[i];
            TypeConstant typeParam = hTypeParam.getUnsafeDataType();
            if (hTypeParam.isForeign()) {
                pool = typeParam.getConstantPool();
            }
            atypeParams[i] = typeParam;
        }
        try {
            TypeConstant typeResult = typeThis.adoptParameters(pool, atypeParams);
            return frame.assignValue(iReturn, typeResult.ensureTypeHandle(frame.f_context.f_container));
        }
        catch (RuntimeException e) {
            return frame.raiseException(xException.invalidType(frame, "No common TypeSystem for (" + typeThis.getValueString() + " and " + atypeParams[0].getValueString() + ")"));
        }
    }

    protected int invokePurify(Frame frame, TypeHandle hType, int iReturn) {
        return frame.assignValue(iReturn, hType);
    }

    protected int invokeRelational(Frame frame, TypeHandle hType, int[] aiReturn) {
        Container container = frame.f_context.f_container;
        TypeConstant type = hType.getUnsafeDataType();
        return type.isRelationalType() ? frame.assignValues(aiReturn, xBoolean.TRUE, type.getUnderlyingType().ensureTypeHandle(container), type.getUnderlyingType2().ensureTypeHandle(container)) : frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    protected int invokeIsA(Frame frame, TypeHandle hThis, TypeHandle hThat, int iReturn) {
        TypeConstant typeThis = hThis.getUnsafeDataType();
        TypeConstant typeThat = hThat.getUnsafeDataType();
        return frame.assignValue(iReturn, xBoolean.makeHandle(typeThis.isA(typeThat)));
    }

    public int invokeResolveFormalType(Frame frame, TypeHandle hType, xString.StringHandle hName, int[] aiReturn) {
        TypeConstant type = hType.getUnsafeType().getParamType(0);
        TypeConstant typeR = type.resolveGenericType(hName.getStringValue());
        return typeR == null ? frame.assignValue(aiReturn[0], xBoolean.FALSE) : frame.assignValues(aiReturn, xBoolean.TRUE, typeR.ensureTypeHandle(frame.f_context.f_container));
    }

    public int invokeStructConstructor(Frame frame, TypeHandle hType, ObjectHandle hOuter, int[] aiReturn) {
        Parameter[] aParams;
        TypeConstant[] atypeParams;
        TypeConstant typeTarget = hType.getDataType();
        TypeInfo infoTarget = typeTarget.ensureTypeInfo();
        if (hOuter == ObjectHandle.DEFAULT) {
            hOuter = xNullable.NULL;
        }
        TypeConstant typeParent = null;
        if (infoTarget.isVirtualChildClass()) {
            if (hOuter == xNullable.NULL) {
                return frame.raiseException(xException.illegalArgument(frame, "Parent is not specified"));
            }
            typeParent = hType.getOuterType();
            assert (typeParent != null);
            assert (!typeParent.equals(this.pool().typeObject()));
        }
        if (!infoTarget.isNewable(false, ErrorListener.BLACKHOLE)) {
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        ConstantPool pool = frame.poolContext();
        TypeConstant typeStruct = pool.ensureAccessTypeConstant(typeTarget, Constants.Access.STRUCT);
        TypeComposition clzTarget = typeTarget.ensureClass(frame);
        if (typeParent == null) {
            atypeParams = new TypeConstant[]{typeStruct};
            aParams = new Parameter[]{new Parameter(pool, typeStruct, "0", null, false, 0, false)};
        } else {
            atypeParams = new TypeConstant[]{typeParent, typeStruct};
            aParams = new Parameter[]{new Parameter(pool, typeParent, "0", null, false, 0, false), new Parameter(pool, typeStruct, "1", null, false, 1, false)};
        }
        TypeConstant typeConstructor = pool.buildFunctionType(atypeParams, typeTarget);
        xRTFunction.FunctionHandle hConstructor = (xRTFunction.FunctionHandle)xRTFunction.makeConstructorHandle(frame, null, typeConstructor, clzTarget, aParams, typeParent != null);
        if (typeParent != null) {
            hConstructor = hConstructor.bind(frame, 0, hOuter);
        }
        return frame.assignValues(aiReturn, xBoolean.TRUE, hConstructor);
    }

    public static xEnum.EnumHandle makeAccessHandle(Frame frame, Constants.Access access) {
        xEnum enumAccess = (xEnum)xRTType.INSTANCE.f_container.getTemplate("reflect.Access");
        return switch (access) {
            default -> throw new MatchException(null, null);
            case Constants.Access.PUBLIC -> enumAccess.getEnumByName("Public");
            case Constants.Access.PROTECTED -> enumAccess.getEnumByName("Protected");
            case Constants.Access.PRIVATE -> enumAccess.getEnumByName("Private");
            case Constants.Access.STRUCT -> enumAccess.getEnumByName("Struct");
        };
    }

    protected static xEnum.EnumHandle makeFormHandle(Frame frame, TypeConstant type) {
        xEnum enumForm = (xEnum)xRTType.INSTANCE.f_container.getTemplate("reflect.Type.Form");
        switch (type.getFormat()) {
            case TerminalType: {
                if (!type.isShared(frame.poolContext())) {
                    return enumForm.getEnumByName("Pure");
                }
                if (type.isSingleDefiningConstant()) {
                    return switch (type.getDefiningConstant().getFormat()) {
                        case Constant.Format.NativeClass -> enumForm.getEnumByName("Pure");
                        case Constant.Format.Module, Constant.Format.Package, Constant.Format.Class, Constant.Format.ThisClass, Constant.Format.ParentClass, Constant.Format.ChildClass, Constant.Format.IsClass, Constant.Format.IsConst, Constant.Format.IsEnum, Constant.Format.IsModule, Constant.Format.IsPackage -> enumForm.getEnumByName("Class");
                        case Constant.Format.Property -> enumForm.getEnumByName("FormalProperty");
                        case Constant.Format.TypeParameter -> enumForm.getEnumByName("FormalParameter");
                        case Constant.Format.FormalTypeChild -> enumForm.getEnumByName("FormalChild");
                        default -> throw new IllegalStateException("unsupported format: " + String.valueOf((Object)type.getDefiningConstant().getFormat()));
                    };
                }
                return enumForm.getEnumByName("Typedef");
            }
            case ImmutableType: {
                return enumForm.getEnumByName("Immutable");
            }
            case AccessType: {
                return enumForm.getEnumByName("Access");
            }
            case AnnotatedType: {
                return enumForm.getEnumByName("Annotated");
            }
            case ServiceType: {
                return enumForm.getEnumByName("Service");
            }
            case ParameterizedType: {
                return xRTType.makeFormHandle(frame, type.getUnderlyingType());
            }
            case TurtleType: {
                return enumForm.getEnumByName("Sequence");
            }
            case VirtualChildType: {
                return enumForm.getEnumByName("Child");
            }
            case InnerChildType: 
            case AnonymousClassType: {
                return enumForm.getEnumByName("Class");
            }
            case PropertyClassType: {
                return enumForm.getEnumByName("Property");
            }
            case UnionType: {
                return enumForm.getEnumByName("Union");
            }
            case IntersectionType: {
                return enumForm.getEnumByName("Intersection");
            }
            case DifferenceType: {
                return enumForm.getEnumByName("Difference");
            }
            case RecursiveType: {
                return enumForm.getEnumByName("Typedef");
            }
        }
        throw new IllegalStateException("unsupported type: " + String.valueOf(type));
    }

    private int makePropertyArray(Frame frame, TypeConstant typeTarget, ArrayList<PropertyInfo> listInfo, int iReturn) {
        if (listInfo.size() > 1) {
            listInfo.sort(Comparator.comparingInt(PropertyInfo::getRank));
        }
        ArrayList<ObjectHandle> listProps = new ArrayList<ObjectHandle>(listInfo.size());
        for (PropertyInfo infoProp : listInfo) {
            listProps.add(xRTProperty.makeHandle(frame, typeTarget, infoProp));
        }
        ObjectHandle[] ahProps = listProps.toArray(Utils.OBJECTS_NONE);
        TypeComposition clzArray = xRTProperty.ensureArrayComposition(frame, typeTarget);
        if (Op.anyDeferred(ahProps)) {
            ObjectHandle.DeferredArrayHandle hDeferred = new ObjectHandle.DeferredArrayHandle(clzArray, ahProps);
            return ((ObjectHandle)hDeferred).proceed(frame, frameCaller -> frameCaller.assignValue(iReturn, frameCaller.popStack()));
        }
        return frame.assignValue(iReturn, xArray.createImmutableArray(clzArray, ahProps));
    }

    public static ObjectHandle makeArgumentHandle(Frame frame, Constant constArg) {
        ObjectHandle hArg = frame.getConstHandle(constArg);
        int iResult = Op.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> {
            ObjectHandle hValue = frameCaller.popStack();
            return Utils.constructArgument(frameCaller, hValue.getType(), hValue, null);
        }) : Utils.constructArgument(frame, hArg.getType(), hArg, null);
        return frame.popResult(iResult);
    }

    private ObjectHandle makeRegisterHandle(Frame frame, int nRegister) {
        TypeComposition clz = REGISTER_CLZCOMP;
        MethodStructure ctor = REGISTER_CONSTRUCT;
        if (clz == null) {
            TypeConstant typeReg = this.pool().ensureEcstasyTypeConstant("reflect.Register");
            REGISTER_CLZCOMP = clz = typeReg.ensureClass(frame);
            REGISTER_CONSTRUCT = ctor = REGISTER_CLZCOMP.getTemplate().getStructure().findMethod("construct", 1, new TypeConstant[0]);
        }
        ObjectHandle[] ahArg = new ObjectHandle[ctor.getMaxVars()];
        ahArg[0] = xInt64.makeHandle(nRegister);
        switch (clz.getTemplate().construct(frame, ctor, clz, null, ahArg, -1)) {
            case -1: {
                return frame.popStack();
            }
            case -5: {
                ObjectHandle.DeferredCallHandle hDeferred = new ObjectHandle.DeferredCallHandle(frame.m_frameNext);
                hDeferred.addContinuation(frameCaller -> Utils.constructArgument(frameCaller, REGISTER_CLZCOMP.getType(), frameCaller.popStack(), null));
                return hDeferred;
            }
            case -3: {
                return new ObjectHandle.DeferredCallHandle(frame.m_hException);
            }
        }
        throw new IllegalStateException();
    }

    private int createProxyArray(Frame frame, xArray.ArrayHandle hArray, TypeComposition clzElement) {
        TypeConstant typeElement = clzElement.getType();
        TypeComposition clzArray = frame.f_context.f_container.resolveClass(frame.poolContext().ensureArrayType(typeElement));
        ProxyComposition clzProxy = new ProxyComposition(clzElement, typeElement);
        int cValues = (int)hArray.m_hDelegate.m_cSize;
        ObjectHandle[] ahValue = new ObjectHandle[cValues];
        block4: for (int i = 0; i < cValues; ++i) {
            switch (hArray.getTemplate().extractArrayValue(frame, hArray, i, -1)) {
                case -1: {
                    ObjectHandle.GenericHandle genericHandle;
                    ObjectHandle hElement = frame.popStack();
                    if (hElement instanceof TypeHandle) {
                        TypeHandle hType = (TypeHandle)hElement;
                        genericHandle = xRTType.makeForeignHandle(hType.getUnsafeType());
                    } else {
                        genericHandle = Proxy.makeHandle(clzProxy, frame.f_context, hElement, false);
                    }
                    ahValue[i] = genericHandle;
                    continue block4;
                }
                case -3: {
                    return -3;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return frame.assignValue(0, xArray.createImmutableArray(clzArray, ahValue));
    }

    public static TypeComposition ensureTypeArrayComposition(Container container) {
        return container.ensureClassComposition(TYPE_ARRAY_TYPE, xArray.INSTANCE);
    }

    public static xArray.ArrayHandle ensureEmptyTypeArray(Container container) {
        xArray.ArrayHandle haEmpty = (xArray.ArrayHandle)container.f_heap.getConstHandle(EMPTY_TYPE_ARRAY);
        if (haEmpty == null) {
            haEmpty = xArray.createImmutableArray(xRTType.ensureTypeArrayComposition(container), Utils.OBJECTS_NONE);
            container.f_heap.saveConstHandle(EMPTY_TYPE_ARRAY, haEmpty);
        }
        return haEmpty;
    }

    public static TypeConstant ensureListMapType(Container container) {
        TypeConstant type = LISTMAP_TYPE;
        if (type == null) {
            ConstantPool pool = container.getConstantPool();
            type = pool.ensureEcstasyTypeConstant("maps.ListMap");
            type = pool.ensureParameterizedTypeConstant(type, pool.typeString(), pool.typeType());
            LISTMAP_TYPE = type = pool.ensureImmutableTypeConstant(type);
        }
        return type;
    }

    public static TypeHandle makeHandle(Container container, TypeConstant type, boolean fShared) {
        TypeHandle hType = fShared ? new TypeHandle(INSTANCE.ensureClass(container, type.getType()), null) : new TypeHandle(INSTANCE.getCanonicalClass(), type.getType());
        ObjectHandle.GenericHandle hMulti = (ObjectHandle.GenericHandle)hType.getField(null, "multimethods");
        hMulti.setField(null, "$outer", (ObjectHandle)hType);
        hMulti.setField(null, PROP_CALCULATE, (ObjectHandle)xNullable.NULL);
        ObjectHandle.GenericHandle hHasher = (ObjectHandle.GenericHandle)hType.getField(null, PROP_HASHER);
        hHasher.setField(null, "$outer", (ObjectHandle)hType);
        hHasher.setField(null, PROP_CALCULATE, (ObjectHandle)xNullable.NULL);
        ObjectHandle.GenericHandle hIter = (ObjectHandle.GenericHandle)hType.getField(null, "emptyIterator");
        hIter.setField(null, "$outer", (ObjectHandle)hType);
        hIter.setField(null, PROP_CALCULATE, (ObjectHandle)xNullable.NULL);
        return hType;
    }

    public static TypeHandle makeForeignHandle(TypeConstant type) {
        return xRTType.makeHandle(null, type, false);
    }

    private int makeRelationalType(Frame frame, TypeHandle hType1, TypeHandle hType2, RelationalOperation op, int iReturn) {
        ConstantPool pool;
        TypeConstant type2;
        TypeConstant type1 = hType1.getUnsafeDataType();
        if (type1.isShared((type2 = hType2.getUnsafeDataType()).getConstantPool())) {
            pool = type2.getConstantPool();
        } else if (type2.isShared(type1.getConstantPool())) {
            pool = type1.getConstantPool();
        } else {
            return frame.raiseException(xException.invalidType(frame, "No common TypeSystem for " + type1.getValueString() + " and " + type2.getValueString()));
        }
        TypeConstant typeResult = op.makeRelational(pool, type1, type2);
        if (typeResult instanceof RelationalTypeConstant) {
            RelationalTypeConstant typeRel = (RelationalTypeConstant)typeResult;
            typeResult = typeRel.simplify(pool);
        }
        return frame.assignValue(iReturn, typeResult.ensureTypeHandle(frame.f_context.f_container));
    }

    public static class TypeHandle
    extends ObjectHandle.GenericHandle {
        private final TypeConstant f_typeForeign;

        protected TypeHandle(TypeComposition clazz, TypeConstant typeForeign) {
            super(clazz);
            this.f_typeForeign = typeForeign;
            this.m_fMutable = false;
        }

        @Override
        public ObjectHandle revealOrigin() {
            return this;
        }

        public TypeConstant getDataType() {
            return this.getType().getParamType(0);
        }

        public TypeConstant getOuterType() {
            return this.getType().getParamType(1);
        }

        public boolean isForeign() {
            return this.f_typeForeign != null;
        }

        @Override
        public TypeConstant getUnsafeType() {
            return this.f_typeForeign == null ? super.getType() : this.f_typeForeign;
        }

        public TypeConstant getUnsafeDataType() {
            return this.getUnsafeType().getParamType(0);
        }

        @Override
        public boolean isNativeEqual() {
            return true;
        }

        @Override
        public int compareTo(ObjectHandle obj) {
            int n;
            if (obj instanceof TypeHandle) {
                TypeHandle that = (TypeHandle)obj;
                n = this.getUnsafeDataType().compareTo(that.getUnsafeDataType());
            } else {
                n = 1;
            }
            return n;
        }

        @Override
        public int hashCode() {
            return this.getUnsafeDataType().hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof TypeHandle)) return false;
            TypeHandle that = (TypeHandle)obj;
            if (!this.getUnsafeDataType().equals(that.getUnsafeDataType())) return false;
            return true;
        }

        @Override
        public String toString() {
            return "(Type) " + this.getDataType().getValueString();
        }
    }

    @FunctionalInterface
    static interface RelationalOperation {
        public TypeConstant makeRelational(ConstantPool var1, TypeConstant var2, TypeConstant var3);
    }
}

