/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.reflect;

import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.Parameter;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.HandleConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.reflect.xRTClassTemplate;
import org.xvm.runtime.template._native.reflect.xRTComponentTemplate;
import org.xvm.runtime.template._native.reflect.xRTProperty;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;

public class xRTTypeTemplate
extends xConst {
    public static xRTTypeTemplate INSTANCE;
    private static TypeConstant TEMPLATE_ARRAY_TYPE;
    private static MethodStructure CREATE_COMPOSITION_METHOD;

    public xRTTypeTemplate(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.f_container.getConstantPool();
        TEMPLATE_ARRAY_TYPE = pool.ensureArrayType(pool.ensureEcstasyTypeConstant("reflect.TypeTemplate"));
        CREATE_COMPOSITION_METHOD = this.f_struct.findMethod("createComposition", 2, new TypeConstant[0]);
        this.markNativeProperty("desc");
        this.markNativeProperty("explicitlyImmutable");
        this.markNativeProperty("form");
        this.markNativeProperty("name");
        this.markNativeProperty("recursive");
        this.markNativeProperty("underlyingTypes");
        this.markNativeMethod("accessSpecified", null, null);
        this.markNativeMethod("annotated", null, null);
        this.markNativeMethod("contained", null, null);
        this.markNativeMethod("fromClass", null, null);
        this.markNativeMethod("fromProperty", null, null);
        this.markNativeMethod("isA", null, null);
        this.markNativeMethod("modifying", null, null);
        this.markNativeMethod("relational", null, null);
        this.markNativeMethod("parameterized", null, null);
        this.markNativeMethod("purify", null, null);
        this.markNativeMethod("parameterize", null, null);
        this.markNativeMethod("annotate", null, null);
        this.markNativeMethod("resolveFormalType", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        TypeTemplateHandle hType = (TypeTemplateHandle)hTarget;
        switch (sPropName) {
            case "desc": {
                return this.getPropertyDesc(frame, hType, iReturn);
            }
            case "explicitlyImmutable": {
                return this.getPropertyExplicitlyImmutable(frame, hType, iReturn);
            }
            case "form": {
                return this.getPropertyForm(frame, hType, iReturn);
            }
            case "name": {
                return this.getPropertyName(frame, hType, iReturn);
            }
            case "recursive": {
                return this.getPropertyRecursive(frame, hType, iReturn);
            }
            case "underlyingTypes": {
                return this.getPropertyUnderlyingTypes(frame, hType, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        TypeTemplateHandle hType = (TypeTemplateHandle)hTarget;
        switch (method.getName()) {
            case "isA": {
                return this.invokeIsA(frame, hType, (TypeTemplateHandle)hArg, iReturn);
            }
            case "parameterize": {
                return this.invokeParameterize(frame, hType, (xArray.ArrayHandle)hArg, iReturn);
            }
            case "annotate": {
                return this.invokeAnnotate(frame, hType, (ObjectHandle.GenericHandle)hArg, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        TypeTemplateHandle hType = (TypeTemplateHandle)hTarget;
        switch (method.getName()) {
            case "purify": {
                return this.invokePurify(frame, hType, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        TypeTemplateHandle hType = (TypeTemplateHandle)hTarget;
        switch (method.getName()) {
            case "accessSpecified": {
                return this.invokeAccessSpecified(frame, hType, aiReturn);
            }
            case "annotated": {
                return this.invokeAnnotated(frame, hType, aiReturn);
            }
            case "contained": {
                return this.invokeContained(frame, hType, aiReturn);
            }
            case "fromClass": {
                return this.invokeFromClass(frame, hType, aiReturn);
            }
            case "fromProperty": {
                return this.invokeFromProperty(frame, hType, aiReturn);
            }
            case "modifying": {
                return this.invokeModifying(frame, hType, aiReturn);
            }
            case "relational": {
                return this.invokeRelational(frame, hType, aiReturn);
            }
            case "parameterized": {
                return this.invokeParameterized(frame, hType, aiReturn);
            }
            case "resolveFormalType": {
                return this.invokeResolveFormalType(frame, hType, (xString.StringHandle)ahArg[0], aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    public static TypeTemplateHandle makeHandle(Container container, TypeConstant type) {
        ConstantPool pool = INSTANCE.pool();
        TypeComposition clz = INSTANCE.ensureClass(container, INSTANCE.getCanonicalType(), pool.ensureEcstasyTypeConstant("reflect.TypeTemplate"));
        return new TypeTemplateHandle(clz, type);
    }

    public int getPropertyDesc(Frame frame, TypeTemplateHandle hType, int iReturn) {
        TypeConstant type = hType.getDataType();
        String sDesc = type.getValueString();
        return frame.assignValue(iReturn, xString.makeHandle(sDesc));
    }

    public int getPropertyExplicitlyImmutable(Frame frame, TypeTemplateHandle hType, int iReturn) {
        TypeConstant type = hType.getDataType();
        return frame.assignValue(iReturn, xBoolean.makeHandle(type.isImmutabilitySpecified()));
    }

    public int getPropertyForm(Frame frame, TypeTemplateHandle hType, int iReturn) {
        TypeConstant type = hType.getDataType();
        xEnum.EnumHandle hForm = this.makeFormHandle(frame, type);
        return Utils.assignInitializedEnum(frame, hForm, iReturn);
    }

    public int getPropertyName(Frame frame, TypeTemplateHandle hType, int iReturn) {
        Constant constant;
        String sName = null;
        TypeConstant type = hType.getDataType();
        if (type.isSingleDefiningConstant() && (constant = type.getDefiningConstant()) instanceof ClassConstant) {
            ClassConstant idClz = (ClassConstant)constant;
            sName = type.isVirtualChild() ? idClz.getName() : idClz.getPathString();
        }
        return frame.assignValue(iReturn, sName == null ? xNullable.NULL : xString.makeHandle(sName));
    }

    public int getPropertyRecursive(Frame frame, TypeTemplateHandle hType, int iReturn) {
        TypeConstant type = hType.getDataType();
        boolean fRecur = type.containsRecursiveType();
        return frame.assignValue(iReturn, xBoolean.makeHandle(fRecur));
    }

    public int getPropertyUnderlyingTypes(Frame frame, TypeTemplateHandle hType, int iReturn) {
        TypeConstant typeTarget = hType.getDataType();
        TypeConstant[] aUnderlying = TypeConstant.NO_TYPES;
        if (typeTarget.isModifyingType()) {
            aUnderlying = new TypeConstant[]{typeTarget.getUnderlyingType()};
        } else if (typeTarget.isRelationalType()) {
            aUnderlying = new TypeConstant[]{typeTarget.getUnderlyingType(), typeTarget.getUnderlyingType2()};
        } else if (typeTarget.isFormalTypeSequence()) {
            aUnderlying = new TypeConstant[]{typeTarget};
        }
        ObjectHandle[] ahTypes = new TypeTemplateHandle[aUnderlying.length];
        int c = ahTypes.length;
        for (int i = 0; i < c; ++i) {
            ahTypes[i] = xRTTypeTemplate.makeHandle(frame.f_context.f_container, aUnderlying[i]);
        }
        xArray.ArrayHandle hArray = xArray.createImmutableArray(xRTTypeTemplate.ensureArrayClassComposition(frame.f_context.f_container), ahTypes);
        return frame.assignValue(iReturn, hArray);
    }

    public int invokeAccessSpecified(Frame frame, TypeTemplateHandle hType, int[] aiReturn) {
        TypeConstant type = hType.getDataType();
        if (type.isAccessSpecified()) {
            ObjectHandle hEnum = Utils.ensureInitializedEnum(frame, this.makeAccessHandle(frame, type.getAccess()));
            return frame.assignConditionalDeferredValue(aiReturn, hEnum);
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    public int invokeAnnotated(Frame frame, TypeTemplateHandle hType, int[] aiReturn) {
        TypeConstant type = hType.getDataType();
        if (type.isAnnotated()) {
            ObjectHandle[] ahArg;
            Annotation annotation = type.getAnnotations()[0];
            IdentityConstant idClass = (IdentityConstant)annotation.getAnnotationClass();
            Constant[] aconstArg = annotation.getParams();
            int cArgs = aconstArg.length;
            xRTComponentTemplate.ComponentTemplateHandle hClass = xRTComponentTemplate.makeComponentHandle(frame.f_context.f_container, idClass.getComponent());
            if (cArgs == 0) {
                ahArg = Utils.OBJECTS_NONE;
            } else {
                ahArg = new ObjectHandle[cArgs];
                for (int i = 0; i < cArgs; ++i) {
                    ahArg[i] = xRTType.makeArgumentHandle(frame, aconstArg[i]);
                }
            }
            if (Op.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> {
                    frameCaller.assignValue(aiReturn[0], xBoolean.TRUE);
                    return Utils.constructAnnotationTemplate(frame, hClass, ahArg, aiReturn[1]);
                };
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            frame.assignValue(aiReturn[0], xBoolean.TRUE);
            return Utils.constructAnnotationTemplate(frame, hClass, ahArg, aiReturn[1]);
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    public int invokeContained(Frame frame, TypeTemplateHandle hType, int[] aiReturn) {
        TypeConstant typeTarget = hType.getDataType();
        if (typeTarget.isVirtualChild() || typeTarget.isAnonymousClass()) {
            TypeTemplateHandle hParent = xRTTypeTemplate.makeHandle(frame.f_context.f_container, typeTarget.getParentType());
            return frame.assignValues(aiReturn, xBoolean.TRUE, hParent);
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    public int invokeFromClass(Frame frame, TypeTemplateHandle hType, int[] aiReturn) {
        TypeConstant type = hType.getDataType();
        if (!type.isExplicitClassIdentity(true)) {
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        IdentityConstant idClz = type.getSingleUnderlyingClass(true);
        ClassStructure clz = (ClassStructure)idClz.getComponent();
        if (clz == null) {
            return frame.raiseException(xException.invalidType(frame, "Unknown type " + type.getValueString()));
        }
        xRTComponentTemplate.ComponentTemplateHandle hClass = xRTComponentTemplate.makeComponentHandle(frame.f_context.f_container, clz);
        return type.isAnnotated() ? new CreateAnnotationComposition(hClass, type.getAnnotations(), aiReturn).doNext(frame) : frame.assignValues(aiReturn, xBoolean.TRUE, hClass);
    }

    public int invokeFromProperty(Frame frame, TypeTemplateHandle hType, int[] aiReturn) {
        Constant constDef;
        TypeConstant type = hType.getDataType();
        if (type.isSingleDefiningConstant() && (constDef = type.getDefiningConstant()) instanceof PropertyConstant) {
            TypeInfo infoTarget;
            PropertyInfo infoProp;
            PropertyConstant idProp = (PropertyConstant)constDef;
            TypeConstant typeTarget = idProp.getClassIdentity().getType();
            ObjectHandle hProperty = xRTProperty.makeHandle(frame, typeTarget, infoProp = (infoTarget = typeTarget.ensureTypeInfo()).findProperty(idProp, true));
            return Op.isDeferred(hProperty) ? hProperty.proceed(frame, frameCaller -> frameCaller.assignValues(aiReturn, xBoolean.TRUE, frameCaller.popStack())) : frame.assignValues(aiReturn, xBoolean.TRUE, hProperty);
        }
        return frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    public int invokeIsA(Frame frame, TypeTemplateHandle hType, TypeTemplateHandle hThat, int iReturn) {
        TypeConstant typeThis = hType.getDataType();
        TypeConstant typeThat = hThat.getDataType();
        return frame.assignValue(iReturn, xBoolean.makeHandle(typeThis.isA(typeThat)));
    }

    public int invokeModifying(Frame frame, TypeTemplateHandle hType, int[] aiReturn) {
        TypeConstant type = hType.getDataType();
        return type.isModifyingType() ? frame.assignValues(aiReturn, xBoolean.TRUE, xRTTypeTemplate.makeHandle(frame.f_context.f_container, type.getUnderlyingType())) : frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    public int invokeRelational(Frame frame, TypeTemplateHandle hType, int[] aiReturn) {
        TypeConstant type = hType.getDataType();
        Container container = frame.f_context.f_container;
        return type.isRelationalType() ? frame.assignValues(aiReturn, xBoolean.TRUE, xRTTypeTemplate.makeHandle(container, type.getUnderlyingType()), xRTTypeTemplate.makeHandle(container, type.getUnderlyingType2())) : frame.assignValue(aiReturn[0], xBoolean.FALSE);
    }

    public int invokeParameterized(Frame frame, TypeTemplateHandle hType, int[] aiReturn) {
        TypeConstant type = hType.getDataType();
        if (!type.isParamsSpecified()) {
            return frame.assignValue(aiReturn[0], xBoolean.FALSE);
        }
        TypeConstant[] atypes = type.getParamTypesArray();
        int cTypes = atypes.length;
        ObjectHandle[] ahTypes = new TypeTemplateHandle[cTypes];
        for (int i = 0; i < cTypes; ++i) {
            ahTypes[i] = xRTTypeTemplate.makeHandle(frame.f_context.f_container, atypes[i]);
        }
        xArray.ArrayHandle hArray = xArray.createImmutableArray(xRTTypeTemplate.ensureArrayClassComposition(frame.f_context.f_container), ahTypes);
        return frame.assignValues(aiReturn, xBoolean.TRUE, hArray);
    }

    public int invokePurify(Frame frame, TypeTemplateHandle hType, int iReturn) {
        return frame.assignValue(iReturn, hType);
    }

    public int invokeParameterize(Frame frame, TypeTemplateHandle hType, xArray.ArrayHandle hArray, int iReturn) {
        TypeConstant typeThis = hType.getDataType();
        if (typeThis.isParamsSpecified()) {
            return frame.raiseException(xException.invalidType(frame, "Already parameterized: " + typeThis.getValueString()));
        }
        int cTypes = (int)hArray.m_hDelegate.m_cSize;
        TypeConstant[] aTypes = new TypeConstant[cTypes];
        for (int i = 0; i < cTypes; ++i) {
            int iResult = hArray.getTemplate().extractArrayValue(frame, hArray, i, -1);
            if (iResult != -1) {
                return frame.raiseException(xException.invalidType(frame, "Invalid type array argument"));
            }
            aTypes[i] = ((TypeTemplateHandle)frame.popStack()).getDataType();
        }
        return frame.assignValue(iReturn, xRTTypeTemplate.makeHandle(frame.f_context.f_container, frame.poolContext().ensureParameterizedTypeConstant(typeThis, aTypes)));
    }

    public int invokeAnnotate(Frame frame, TypeTemplateHandle hType, ObjectHandle.GenericHandle hAnno, int iReturn) {
        TypeConstant typeThis = hType.getDataType();
        xRTComponentTemplate.ComponentTemplateHandle hTemplate = (xRTComponentTemplate.ComponentTemplateHandle)hAnno.getField(frame, "template");
        ClassStructure clzMixin = (ClassStructure)hTemplate.getComponent();
        IdentityConstant idMixin = clzMixin.getIdentityConstant();
        TypeConstant typeInto = clzMixin.getTypeInto();
        if (clzMixin.getFormat() == Component.Format.ANNOTATION) {
            ConstantPool pool = frame.poolContext();
            if (typeThis.isA(typeInto) || pool.ensureParameterizedTypeConstant(pool.typeClass(), typeThis).isA(typeInto)) {
                Constant[] aconst;
                xArray.ArrayHandle haArgs = (xArray.ArrayHandle)hAnno.getField(frame, "arguments");
                xRTDelegate.GenericArrayDelegate haDelegate = (xRTDelegate.GenericArrayDelegate)haArgs.m_hDelegate;
                int cArgs = (int)haDelegate.m_cSize;
                if (cArgs > 0) {
                    aconst = new Constant[cArgs];
                    for (int i = 0; i < cArgs; ++i) {
                        ObjectHandle.GenericHandle hArg = (ObjectHandle.GenericHandle)haDelegate.get(i);
                        ObjectHandle hValue = hArg.getField(frame, "value");
                        aconst[i] = new HandleConstant(hValue);
                    }
                } else {
                    aconst = Constant.NO_CONSTS;
                }
                AnnotatedTypeConstant typeAnno = pool.ensureAnnotatedTypeConstant(idMixin, aconst, typeThis);
                return frame.assignValue(iReturn, xRTTypeTemplate.makeHandle(frame.f_context.f_container, typeAnno));
            }
        }
        return frame.raiseException("Invalid annotation: " + idMixin.getValueString());
    }

    public int invokeResolveFormalType(Frame frame, TypeTemplateHandle hType, xString.StringHandle hName, int[] aiReturn) {
        TypeConstant type = hType.getDataType();
        TypeConstant typeR = type.resolveGenericType(hName.getStringValue());
        return typeR == null ? frame.assignValue(aiReturn[0], xBoolean.FALSE) : frame.assignValues(aiReturn, xBoolean.TRUE, xRTTypeTemplate.makeHandle(frame.f_context.f_container, typeR));
    }

    public static TypeComposition ensureArrayClassComposition(Container container) {
        return container.ensureClassComposition(TEMPLATE_ARRAY_TYPE, xArray.INSTANCE);
    }

    public xEnum.EnumHandle makeAccessHandle(Frame frame, Constants.Access access) {
        xEnum enumAccess = (xEnum)this.f_container.getTemplate("reflect.Access");
        switch (access) {
            case PUBLIC: {
                return enumAccess.getEnumByName("Public");
            }
            case PROTECTED: {
                return enumAccess.getEnumByName("Protected");
            }
            case PRIVATE: {
                return enumAccess.getEnumByName("Private");
            }
            case STRUCT: {
                return enumAccess.getEnumByName("Struct");
            }
        }
        throw new IllegalStateException("unknown access value: " + String.valueOf((Object)access));
    }

    protected xEnum.EnumHandle makeFormHandle(Frame frame, TypeConstant type) {
        xEnum enumForm = (xEnum)this.f_container.getTemplate("reflect.TypeTemplate.Form");
        switch (type.getFormat()) {
            case ParameterizedType: 
            case TerminalType: {
                if (type.isSingleDefiningConstant()) {
                    switch (type.getDefiningConstant().getFormat()) {
                        case NativeClass: {
                            return enumForm.getEnumByName("Pure");
                        }
                        case Module: 
                        case Package: 
                        case Class: 
                        case ThisClass: 
                        case ParentClass: 
                        case ChildClass: {
                            return enumForm.getEnumByName("Class");
                        }
                        case Property: {
                            return enumForm.getEnumByName("FormalProperty");
                        }
                        case TypeParameter: {
                            return enumForm.getEnumByName("FormalParameter");
                        }
                        case FormalTypeChild: {
                            return enumForm.getEnumByName("FormalChild");
                        }
                    }
                    throw new IllegalStateException("unsupported format: " + String.valueOf((Object)type.getDefiningConstant().getFormat()));
                }
                return enumForm.getEnumByName("Typedef");
            }
            case ImmutableType: {
                return enumForm.getEnumByName("Immutable");
            }
            case AccessType: {
                return enumForm.getEnumByName("Access");
            }
            case AnnotatedType: {
                return enumForm.getEnumByName("Annotated");
            }
            case TurtleType: {
                return enumForm.getEnumByName("Sequence");
            }
            case VirtualChildType: {
                return enumForm.getEnumByName("Child");
            }
            case InnerChildType: 
            case AnonymousClassType: {
                return enumForm.getEnumByName("Class");
            }
            case PropertyClassType: {
                return enumForm.getEnumByName("Property");
            }
            case UnionType: {
                return enumForm.getEnumByName("Union");
            }
            case IntersectionType: {
                return enumForm.getEnumByName("Intersection");
            }
            case DifferenceType: {
                return enumForm.getEnumByName("Difference");
            }
            case RecursiveType: {
                return enumForm.getEnumByName("Typedef");
            }
        }
        throw new IllegalStateException("unsupported type: " + String.valueOf(type));
    }

    public static class TypeTemplateHandle
    extends ObjectHandle.GenericHandle {
        private final TypeConstant f_type;

        protected TypeTemplateHandle(TypeComposition clz, TypeConstant type) {
            super(clz);
            this.f_type = type;
            this.m_fMutable = false;
        }

        public TypeConstant getDataType() {
            return this.f_type;
        }

        @Override
        public String toString() {
            return super.toString() + " " + String.valueOf(this.f_type);
        }
    }

    public static class CreateAnnotationComposition
    implements Frame.Continuation {
        private Stage stageNext;
        private final xRTComponentTemplate.ComponentTemplateHandle hClass;
        private final Annotation[] aAnno;
        private final int[] aiReturn;
        private final ObjectHandle[] ahAnno;
        private int iAnno = -1;
        private int iArg = -1;
        private ObjectHandle[] ahAnnoArg;
        private ObjectHandle[] ahValue;
        private MethodStructure constructor;

        public CreateAnnotationComposition(xRTComponentTemplate.ComponentTemplateHandle hClass, Annotation[] aAnno, int[] aiReturn) {
            this.hClass = hClass;
            this.aAnno = aAnno;
            this.ahAnno = new ObjectHandle[aAnno.length];
            this.aiReturn = aiReturn;
            this.stageNext = Stage.ArgValue;
        }

        @Override
        public int proceed(Frame frameCaller) {
            switch (this.stageNext.ordinal()) {
                case 0: {
                    this.stageNext = Stage.Argument;
                    break;
                }
                case 1: {
                    assert (this.iArg >= 0);
                    this.ahAnnoArg[this.iArg] = frameCaller.popStack();
                    break;
                }
                case 2: {
                    assert (this.iAnno >= 0);
                    this.ahAnno[this.iAnno] = frameCaller.popStack();
                    this.stageNext = Stage.ArgValue;
                }
            }
            return this.doNext(frameCaller);
        }

        public int doNext(Frame frameCaller) {
            switch (this.stageNext.ordinal()) {
                case 0: {
                    if (++this.iAnno == this.aAnno.length) break;
                    assert (this.ahAnnoArg == null && this.ahValue == null);
                    Annotation anno = this.aAnno[this.iAnno];
                    Constant[] aArg = anno.getParams();
                    int cArgs = aArg.length;
                    if (cArgs > 0) {
                        ClassConstant idAnno = (ClassConstant)anno.getAnnotationClass();
                        ClassStructure clzAnno = (ClassStructure)idAnno.getComponent();
                        this.constructor = clzAnno.findMethod("construct", cArgs, new TypeConstant[0]);
                        if (this.constructor == null) {
                            return frameCaller.raiseException("missing annotation constructor " + idAnno.getValueString() + " with " + String.valueOf(clzAnno) + " parameters");
                        }
                        this.ahValue = new ObjectHandle[cArgs];
                        this.ahAnnoArg = new ObjectHandle[cArgs];
                        for (int i = 0; i < cArgs; ++i) {
                            this.ahValue[i] = frameCaller.getConstHandle(aArg[i]);
                        }
                        if (Op.anyDeferred(this.ahValue)) {
                            return new Utils.GetArguments(this.ahValue, this).doNext(frameCaller);
                        }
                    } else {
                        this.ahValue = Utils.OBJECTS_NONE;
                        this.ahAnnoArg = Utils.OBJECTS_NONE;
                    }
                    this.stageNext = Stage.Argument;
                }
                case 1: {
                    assert (this.ahValue != null && this.ahAnnoArg != null);
                    int cArgs = this.ahAnnoArg.length;
                    if (cArgs > 0) {
                        if (++this.iArg != cArgs) {
                            ObjectHandle hValue = this.ahValue[this.iArg];
                            if (hValue.isMutable()) {
                                return frameCaller.raiseException("argument is not a const");
                            }
                            Parameter param = this.constructor.getParam(this.iArg);
                            int iResult = Utils.constructArgument(frameCaller, param.getType().freeze(), hValue, param.getName());
                            if (iResult == -5) {
                                frameCaller.m_frameNext.addContinuation(this);
                            } else assert (iResult == -3);
                            return iResult;
                        }
                    } else {
                        this.ahAnnoArg = Utils.OBJECTS_NONE;
                    }
                    this.iArg = -1;
                    this.ahValue = null;
                    this.stageNext = Stage.Template;
                }
                case 2: {
                    assert (this.ahAnnoArg != null);
                    Annotation anno = this.aAnno[this.iAnno];
                    ClassConstant idAnno = (ClassConstant)anno.getAnnotationClass();
                    ClassStructure clzAnno = (ClassStructure)idAnno.getComponent();
                    xRTComponentTemplate.ComponentTemplateHandle hAnnoClass = xRTComponentTemplate.makeComponentHandle(frameCaller.f_context.f_container, clzAnno);
                    int iResult = Utils.constructAnnotationTemplate(frameCaller, hAnnoClass, this.ahAnnoArg, -1);
                    if (iResult == -5) {
                        frameCaller.m_frameNext.addContinuation(this);
                        this.ahAnnoArg = null;
                    } else assert (iResult == -3);
                    return iResult;
                }
            }
            TypeComposition clzArray = xRTClassTemplate.ensureAnnotationTemplateArrayComposition(frameCaller.f_context.f_container);
            ObjectHandle[] ahVar = new ObjectHandle[CREATE_COMPOSITION_METHOD.getMaxVars()];
            ahVar[0] = this.hClass;
            ahVar[1] = xArray.createImmutableArray(clzArray, this.ahAnno);
            return frameCaller.callN(CREATE_COMPOSITION_METHOD, null, ahVar, this.aiReturn);
        }

        static enum Stage {
            ArgValue,
            Argument,
            Template;

        }
    }
}

