/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.temporal;

import java.util.Timer;
import java.util.TimerTask;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.WeakCallback;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template._native.temporal.xNanosTimer;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.BaseInt128;
import org.xvm.runtime.template.numbers.LongLong;
import org.xvm.runtime.template.numbers.xInt128;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xService;

public class xLocalClock
extends xService {
    public static xLocalClock INSTANCE;
    public static Timer TIMER;
    private TypeComposition m_clzTime;
    private ObjectHandle.GenericHandle m_hTimeZone;
    private ObjectHandle m_hLocalClock;

    public xLocalClock(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeProperty("now");
        this.markNativeProperty("timezone");
        this.markNativeMethod("schedule", new String[]{"temporal.Duration", "temporal.Clock.Alarm", "Boolean"}, null);
        this.markNativeMethod("schedule", new String[]{"temporal.Time", "temporal.Clock.Alarm", "Boolean"}, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        return this.pool().ensureEcstasyTypeConstant("temporal.Clock");
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        switch (sPropName) {
            case "now": {
                return frame.assignValue(iReturn, this.timeNow(frame));
            }
            case "timezone": {
                return frame.assignValue(iReturn, this.timezone(frame));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "schedule": {
                long ldtWakeup;
                long cDelay;
                xBoolean.BooleanHandle hB;
                ObjectHandle.GenericHandle hWakeup = (ObjectHandle.GenericHandle)ahArg[0];
                xRTFunction.FunctionHandle hAlarm = (xRTFunction.FunctionHandle)ahArg[1];
                ObjectHandle objectHandle = ahArg[2];
                xBoolean.BooleanHandle hKeep = objectHandle instanceof xBoolean.BooleanHandle ? (hB = (xBoolean.BooleanHandle)objectHandle) : xBoolean.FALSE;
                long ldtNow = frame.f_context.f_container.currentTimeMillis();
                if (hWakeup.getType().equals(frame.poolContext().typeDuration())) {
                    LongLong llPicos = ((BaseInt128.LongLongHandle)hWakeup.getField(null, "picoseconds")).getValue();
                    cDelay = llPicos.divUnsigned(1000000000L).getLowValue();
                    ldtWakeup = ldtNow + cDelay;
                } else {
                    LongLong llEpoch = ((BaseInt128.LongLongHandle)hWakeup.getField(null, "epochPicos")).getValue();
                    ldtWakeup = llEpoch.divUnsigned(1000000000L).getLowValue();
                    cDelay = Math.max(0L, ldtWakeup - ldtNow);
                }
                return this.invokeSchedule(frame, ldtWakeup, cDelay, hAlarm, hKeep, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    private int invokeSchedule(Frame frame, long ldtWakeup, long cDelay, xRTFunction.FunctionHandle hAlarm, xBoolean.BooleanHandle hKeepAlive, int iReturn) {
        Alarm alarm = new Alarm(new WeakCallback(frame, hAlarm), ldtWakeup, hKeepAlive.get());
        try {
            TIMER.schedule((TimerTask)alarm.getTrigger(), cDelay);
        }
        catch (Exception e) {
            alarm.cancel();
            return frame.raiseException(e.getMessage());
        }
        xRTFunction.NativeFunctionHandle hCancel = new xRTFunction.NativeFunctionHandle((_frame, _ah, _iReturn) -> {
            alarm.cancel();
            return -1;
        });
        return frame.assignValue(iReturn, hCancel);
    }

    public ObjectHandle ensureLocalClock(Frame frame, ObjectHandle hOpts) {
        ObjectHandle hClock = this.m_hLocalClock;
        if (hClock == null) {
            this.m_hLocalClock = hClock = this.createServiceHandle(this.f_container.createServiceContext("LocalClock"), this.getCanonicalClass(), this.getCanonicalType());
        }
        return hClock;
    }

    public ObjectHandle ensureDefaultClock(Frame frame, ObjectHandle hOpts) {
        return this.ensureLocalClock(frame, hOpts);
    }

    public ObjectHandle ensureUTCClock(Frame frame, ObjectHandle hOpts) {
        return this.ensureLocalClock(frame, hOpts);
    }

    protected ObjectHandle.GenericHandle timeNow(Frame frame) {
        TypeComposition clzTime = this.ensureTimeClass();
        ObjectHandle.GenericHandle hTime = new ObjectHandle.GenericHandle(clzTime);
        LongLong llNow = new LongLong(frame.f_context.f_container.currentTimeMillis()).mul(xNanosTimer.PICOS_PER_MILLI_LL);
        hTime.setField(frame, "epochPicos", (ObjectHandle)xInt128.INSTANCE.makeHandle(llNow));
        hTime.setField(frame, "timezone", (ObjectHandle)this.timezone(frame));
        hTime.makeImmutable();
        return hTime;
    }

    protected ObjectHandle.GenericHandle timezone(Frame frame) {
        ObjectHandle.GenericHandle hTimeZone = this.m_hTimeZone;
        if (hTimeZone == null) {
            ConstantPool pool = this.pool();
            ClassStructure structTimeZone = this.f_container.getClassStructure("temporal.TimeZone");
            TypeConstant typeTimeZone = structTimeZone.getCanonicalType();
            TypeComposition clzTimeZone = typeTimeZone.ensureClass(frame);
            ClassStructure structRule = (ClassStructure)structTimeZone.getChild("Rule");
            TypeConstant typeRule = structRule.getCanonicalType();
            TypeConstant typeRuleArray = pool.ensureArrayType(typeRule);
            TypeComposition clzRuleArray = typeRuleArray.ensureClass(frame);
            this.m_hTimeZone = hTimeZone = new ObjectHandle.GenericHandle(clzTimeZone);
            long lOffset = 0L;
            hTimeZone.setField(frame, "picos", (ObjectHandle)xInt64.makeHandle(lOffset));
            hTimeZone.setField(frame, "name", (ObjectHandle)xNullable.NULL);
            hTimeZone.setField(frame, "rules", (ObjectHandle)xArray.createEmptyArray(clzRuleArray, 0, xArray.Mutability.Mutable));
            hTimeZone.makeImmutable();
        }
        return hTimeZone;
    }

    protected TypeComposition ensureTimeClass() {
        TypeComposition clz = this.m_clzTime;
        if (clz == null) {
            clz = this.m_clzTime = this.f_container.getTemplate("temporal.Time").getCanonicalClass();
        }
        return clz;
    }

    static {
        TIMER = new Timer("ecstasy:LocalClock", true);
    }

    protected static class Alarm {
        private final WeakCallback f_refCallback;
        private final long f_ldtWakeup;
        private final boolean f_Registered;
        private Trigger m_trigger;

        protected Alarm(WeakCallback refCallback, long ldtWakeUp, boolean fKeepAlive) {
            this.f_refCallback = refCallback;
            this.f_ldtWakeup = ldtWakeUp;
            this.m_trigger = new Trigger(this);
            this.f_Registered = fKeepAlive;
            if (fKeepAlive) {
                ((ServiceContext)refCallback.get()).f_container.registerNativeCallback();
            }
        }

        public Trigger getTrigger() {
            return this.m_trigger;
        }

        public void run() {
            ServiceContext context = (ServiceContext)this.f_refCallback.get();
            if (context != null) {
                Container container = context.f_container;
                if (container.isTimeFrozen()) {
                    this.m_trigger = new Trigger(this);
                    TIMER.schedule((TimerTask)this.m_trigger, 1000L);
                    return;
                }
                long ldtNow = container.currentTimeMillis();
                if (ldtNow >= this.f_ldtWakeup) {
                    WeakCallback.Callback callback = this.f_refCallback.extractCallback();
                    context.callLater(callback.frame(), callback.functionHandle(), Utils.OBJECTS_NONE);
                    if (this.f_Registered) {
                        container.unregisterNativeCallback();
                    }
                } else {
                    this.m_trigger = new Trigger(this);
                    TIMER.schedule((TimerTask)this.m_trigger, this.f_ldtWakeup - ldtNow);
                }
            }
        }

        public boolean cancel() {
            boolean fCancelled = this.m_trigger.cancel();
            ServiceContext context = (ServiceContext)this.f_refCallback.get();
            if (context != null && fCancelled && this.f_Registered) {
                context.f_container.unregisterNativeCallback();
            }
            return fCancelled;
        }

        protected static class Trigger
        extends TimerTask {
            private final Alarm f_alarm;

            protected Trigger(Alarm alarm) {
                this.f_alarm = alarm;
            }

            @Override
            public void run() {
                this.f_alarm.run();
            }
        }
    }
}

