/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.temporal;

import java.util.TimerTask;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.WeakCallback;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template._native.temporal.xLocalClock;
import org.xvm.runtime.template.numbers.BaseInt128;
import org.xvm.runtime.template.numbers.LongLong;
import org.xvm.runtime.template.numbers.xInt128;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xService;
import org.xvm.util.ListSet;

public class xNanosTimer
extends xService {
    public static xNanosTimer INSTANCE;
    public static final long PICOS_PER_MILLI = 1000000000L;
    public static final long PICOS_PER_NANO = 1000L;
    public static final LongLong PICOS_PER_MILLI_LL;
    public static final LongLong PICOS_PER_NANO_LL;
    public static final long NANOS_PER_MILLI = 1000000L;
    private static TypeComposition s_clzDuration;

    public xNanosTimer(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        s_clzDuration = this.f_container.getTemplate("temporal.Duration").getCanonicalClass();
        this.markNativeProperty("elapsed");
        this.markNativeMethod("start", VOID, null);
        this.markNativeMethod("stop", VOID, null);
        this.markNativeMethod("reset", VOID, null);
        this.markNativeMethod("schedule", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        return this.pool().ensureEcstasyTypeConstant("temporal.Timer");
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        TimerHandle hTimer = (TimerHandle)hTarget;
        switch (sPropName) {
            case "elapsed": {
                return frame.assignValue(iReturn, hTimer.elapsedDuration(frame));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        TimerHandle hTimer = (TimerHandle)hTarget;
        switch (method.getName()) {
            case "start": {
                hTimer.start(frame);
                return frame.assignValue(iReturn, hTimer);
            }
            case "stop": {
                hTimer.stop(frame);
                return frame.assignValue(iReturn, hTimer);
            }
            case "reset": {
                hTimer.reset(frame);
                return frame.assignValue(iReturn, hTimer);
            }
            case "schedule": {
                xBoolean.BooleanHandle hB;
                ObjectHandle.GenericHandle hDuration = (ObjectHandle.GenericHandle)ahArg[0];
                xRTFunction.FunctionHandle hAlarm = (xRTFunction.FunctionHandle)ahArg[1];
                ObjectHandle objectHandle = ahArg[2];
                xBoolean.BooleanHandle hKeep = objectHandle instanceof xBoolean.BooleanHandle ? (hB = (xBoolean.BooleanHandle)objectHandle) : xBoolean.FALSE;
                return this.invokeSchedule(frame, hTimer, hDuration, hAlarm, hKeep, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public xService.ServiceHandle createServiceHandle(ServiceContext context, ClassComposition clz, TypeConstant typeMask) {
        TimerHandle hTimer = new TimerHandle(clz.maskAs(typeMask), context);
        context.setService(hTimer);
        return hTimer;
    }

    public ObjectHandle ensureTimer(Frame frame, ObjectHandle hOpts) {
        return this.createServiceHandle(this.f_container.createServiceContext("Timer"), this.getCanonicalClass(), this.getCanonicalType());
    }

    public static long millisFromDuration(ObjectHandle hDuration) {
        ObjectHandle hPicos = ((ObjectHandle.GenericHandle)hDuration).getField(null, "picoseconds");
        return ((BaseInt128.LongLongHandle)hPicos).getValue().div(PICOS_PER_MILLI_LL).getLowValue();
    }

    private int invokeSchedule(Frame frame, TimerHandle hTimer, ObjectHandle.GenericHandle hDuration, xRTFunction.FunctionHandle hAlarm, xBoolean.BooleanHandle hKeepAlive, int iReturn) {
        BaseInt128.LongLongHandle llPicos = (BaseInt128.LongLongHandle)hDuration.getField(frame, "picoseconds");
        long cNanos = Math.max(0L, llPicos.getValue().divUnsigned(1000L).getLowValue());
        return frame.assignValue(iReturn, hTimer.addAlarm(cNanos, new WeakCallback(frame, hAlarm), hKeepAlive.get()));
    }

    static {
        PICOS_PER_MILLI_LL = new LongLong(1000000000L);
        PICOS_PER_NANO_LL = new LongLong(1000L);
    }

    public static class TimerHandle
    extends xService.ServiceHandle {
        private final long[] f_acNanos = new long[2];
        private static final int START = 0;
        private static final int PREV = 1;
        private final ListSet<Alarm> f_setAlarms = new ListSet();

        protected TimerHandle(TypeComposition clazz, ServiceContext context) {
            super(clazz, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void start(Frame frame) {
            if (this.f_acNanos[0] == 0L) {
                this.f_acNanos[0] = frame.f_context.f_container.nanoTime();
            }
            ListSet<Alarm> listSet = this.f_setAlarms;
            synchronized (listSet) {
                for (Alarm alarm : this.f_setAlarms) {
                    alarm.start();
                }
            }
        }

        public boolean isRunning() {
            return this.f_acNanos[0] != 0L;
        }

        public synchronized long elapsed(Frame frame) {
            long cAdd;
            long cNanosTotal = this.f_acNanos[1];
            if (this.f_acNanos[0] != 0L && (cAdd = frame.f_context.f_container.nanoTime() - this.f_acNanos[0]) > 0L) {
                cNanosTotal += cAdd;
            }
            return cNanosTotal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void stop(Frame frame) {
            if (this.f_acNanos[0] != 0L) {
                long cAdd = frame.f_context.f_container.nanoTime() - this.f_acNanos[0];
                if (cAdd > 0L) {
                    this.f_acNanos[1] = this.f_acNanos[1] + cAdd;
                }
                this.f_acNanos[0] = 0L;
                ListSet<Alarm> listSet = this.f_setAlarms;
                synchronized (listSet) {
                    for (Alarm alarm : this.f_setAlarms) {
                        alarm.stop();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void reset(Frame frame) {
            this.f_acNanos[1] = 0L;
            if (this.f_acNanos[0] != 0L) {
                this.f_acNanos[0] = frame.f_context.f_container.nanoTime();
            }
            ListSet<Alarm> listSet = this.f_setAlarms;
            synchronized (listSet) {
                for (Alarm alarm : this.f_setAlarms) {
                    alarm.reset();
                }
            }
        }

        public ObjectHandle.GenericHandle elapsedDuration(Frame frame) {
            ObjectHandle.GenericHandle hDuration = new ObjectHandle.GenericHandle(s_clzDuration);
            LongLong llPicos = new LongLong(this.elapsed(frame)).mul(PICOS_PER_NANO_LL);
            hDuration.setField(null, "picoseconds", (ObjectHandle)xInt128.INSTANCE.makeHandle(llPicos));
            hDuration.makeImmutable();
            return hDuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public xRTFunction.FunctionHandle addAlarm(long cNanos, WeakCallback refCallback, boolean fKeepAlive) {
            Alarm alarm = new Alarm(cNanos, refCallback, fKeepAlive);
            ListSet<Alarm> listSet = this.f_setAlarms;
            synchronized (listSet) {
                this.f_setAlarms.add(alarm);
            }
            if (this.isRunning()) {
                alarm.start();
            }
            return new xRTFunction.NativeFunctionHandle((_frame, _ah, _iReturn) -> {
                alarm.cancel();
                return -1;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAlarm(Alarm alarm) {
            boolean fUnregistered;
            ListSet<Alarm> listSet = this.f_setAlarms;
            synchronized (listSet) {
                fUnregistered = this.f_setAlarms.remove(alarm);
            }
            assert (fUnregistered);
        }

        public class Alarm {
            private final WeakCallback f_refCallback;
            private final long f_cNanosAlarm;
            private final boolean f_fRegistered;
            private long m_cNanosStart;
            private long m_cNanosBurnt;
            private volatile boolean m_fDead;
            private volatile Trigger m_trigger;

            public Alarm(long cNanosDelay, WeakCallback refCallback, boolean fKeepAlive) {
                this.f_cNanosAlarm = cNanosDelay + ((ServiceContext)refCallback.get()).f_container.nanoTime();
                this.f_refCallback = refCallback;
                this.f_fRegistered = fKeepAlive;
            }

            public synchronized void start() {
                if (this.m_fDead || this.m_trigger != null) {
                    return;
                }
                Container container = ((ServiceContext)this.f_refCallback.get()).f_container;
                this.m_cNanosStart = container.nanoTime();
                Trigger trigger = this.createTrigger();
                try {
                    if (this.f_fRegistered) {
                        container.registerNativeCallback();
                    }
                    long cDelay = (this.f_cNanosAlarm - this.m_cNanosStart - this.m_cNanosBurnt) / 1000000L;
                    xLocalClock.TIMER.schedule((TimerTask)trigger, Math.max(1L, cDelay));
                }
                catch (Throwable e) {
                    this.cancelTrigger();
                }
            }

            public synchronized void stop() {
                if (this.m_fDead) {
                    return;
                }
                if (this.m_trigger != null) {
                    this.cancelTrigger();
                    Container container = ((ServiceContext)this.f_refCallback.get()).f_container;
                    long cNanosAdd = container.nanoTime() - this.m_cNanosStart;
                    if (cNanosAdd > 0L) {
                        this.m_cNanosBurnt += cNanosAdd;
                    }
                    this.m_cNanosStart = 0L;
                }
            }

            public synchronized void reset() {
                if (this.m_fDead) {
                    return;
                }
                if (this.m_trigger != null) {
                    this.cancelTrigger();
                    this.m_cNanosStart = 0L;
                    this.m_cNanosBurnt = 0L;
                    if (TimerHandle.this.isRunning()) {
                        this.start();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Alarm alarm = this;
                synchronized (alarm) {
                    if (this.m_fDead) {
                        return;
                    }
                    this.m_fDead = true;
                    this.m_trigger = null;
                }
                ServiceContext context = (ServiceContext)this.f_refCallback.get();
                if (context != null) {
                    WeakCallback.Callback callback = this.f_refCallback.extractCallback();
                    context.callLater(callback.frame(), callback.functionHandle(), Utils.OBJECTS_NONE);
                    if (this.f_fRegistered) {
                        context.f_container.unregisterNativeCallback();
                    }
                }
                TimerHandle.this.removeAlarm(this);
            }

            public void unregister() {
                ServiceContext context = (ServiceContext)this.f_refCallback.get();
                if (context != null && this.f_fRegistered) {
                    context.f_container.unregisterNativeCallback();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancel() {
                Alarm alarm = this;
                synchronized (alarm) {
                    if (this.m_fDead) {
                        return;
                    }
                    this.m_fDead = true;
                    this.cancelTrigger();
                }
                TimerHandle.this.removeAlarm(this);
            }

            protected Trigger createTrigger() {
                this.m_trigger = new Trigger(this);
                return this.m_trigger;
            }

            protected void cancelTrigger() {
                if (this.m_trigger != null) {
                    this.m_trigger.cancel();
                    this.m_trigger = null;
                }
            }

            protected long checkReadyMillis() {
                ServiceContext context = (ServiceContext)this.f_refCallback.get();
                if (context == null) {
                    return 0L;
                }
                Container container = context.f_container;
                return container.isTimeFrozen() ? 1000L : Math.max(0L, (this.f_cNanosAlarm - container.nanoTime()) / 1000000L);
            }

            protected static class Trigger
            extends TimerTask {
                private Alarm m_alarm;

                protected Trigger(Alarm alarm) {
                    this.m_alarm = alarm;
                }

                @Override
                public void run() {
                    Alarm alarm = this.m_alarm;
                    long cExtraMillis = alarm.checkReadyMillis();
                    if (cExtraMillis == 0L) {
                        this.m_alarm = null;
                        alarm.run();
                    } else {
                        xLocalClock.TIMER.schedule((TimerTask)alarm.createTrigger(), cExtraMillis);
                    }
                }

                @Override
                public boolean cancel() {
                    boolean fCancelled = super.cancel();
                    Alarm alarm = this.m_alarm;
                    if (alarm != null && fCancelled) {
                        alarm.unregister();
                        this.m_alarm = null;
                    }
                    return fCancelled;
                }
            }
        }
    }
}

