/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.web;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTStringDelegate;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xService;

public class xRTConnector
extends xService {
    public static xRTConnector INSTANCE;
    private static String s_sAgent;
    private TypeConstant m_typeCanonical;

    public xRTConnector(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
            s_sAgent = "Mozilla/5.0 (compatible; Ecstasy/" + structure.getFileStructure().getModule().getVersionString() + ")";
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("getDefaultHeaders", null, null);
        this.markNativeMethod("sendRequest", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        TypeConstant type = this.m_typeCanonical;
        if (type == null) {
            ConstantPool pool = this.pool();
            ClassConstant idClient = pool.ensureClassConstant(pool.ensureModuleConstant("web.xtclang.org"), "Client");
            this.m_typeCanonical = type = pool.ensureTerminalTypeConstant(pool.ensureClassConstant(idClient, "Connector"));
        }
        return type;
    }

    public ObjectHandle ensureConnector(Frame frame, ObjectHandle hOpts) {
        ServiceContext context = this.f_container.createServiceContext("Connector");
        try {
            CookieHandler cookieHandler = xRTConnector.createCookieHandler();
            SSLContext sslContext = xRTConnector.createSSLContext();
            ConnectorHandle hConnector = new ConnectorHandle(this.getCanonicalClass(this.f_container), context, cookieHandler, sslContext);
            context.setService(hConnector);
            return hConnector;
        }
        catch (GeneralSecurityException e) {
            return xException.makeObscure(frame, e.getMessage());
        }
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "getDefaultHeaders": {
                return this.invokeGetDefaultHeaders(frame, aiReturn);
            }
            case "sendRequest": {
                ConnectorHandle hConnector = (ConnectorHandle)hTarget;
                return frame.f_context == hConnector.f_context ? this.invokeSendRequest(frame, hConnector, (xString.StringHandle)ahArg[0], (xString.StringHandle)ahArg[1], (xArray.ArrayHandle)ahArg[2], (xArray.ArrayHandle)ahArg[3], (xArray.ArrayHandle)ahArg[4], aiReturn) : xRTFunction.makeAsyncNativeHandle(method).callN(frame, hConnector, ahArg, aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    private int invokeGetDefaultHeaders(Frame frame, int[] aiReturn) {
        xArray.ArrayHandle hNames = xString.makeArrayHandle(new String[]{"User-Agent"});
        xArray.ArrayHandle hValues = xString.makeArrayHandle(new String[]{s_sAgent});
        return frame.assignValues(aiReturn, hNames, hValues);
    }

    private int invokeSendRequest(Frame frame, ConnectorHandle hConn, xString.StringHandle hMethod, xString.StringHandle hUrl, xArray.ArrayHandle hHeaderNames, xArray.ArrayHandle hHeaderValues, xArray.ArrayHandle hBytes, int[] aiReturn) {
        xRTStringDelegate.StringArrayHandle haNames = (xRTStringDelegate.StringArrayHandle)hHeaderNames.m_hDelegate;
        xRTStringDelegate.StringArrayHandle haValues = (xRTStringDelegate.StringArrayHandle)hHeaderValues.m_hDelegate;
        ByteBasedDelegate.ByteArrayHandle haBytes = (ByteBasedDelegate.ByteArrayHandle)hBytes.m_hDelegate;
        try {
            long ldtTimeout = frame.f_fiber.getTimeoutStamp();
            long cTimeoutMillis = ldtTimeout > 0L ? Math.max(1L, ldtTimeout - frame.f_context.f_container.currentTimeMillis()) : 0L;
            HttpRequest.Builder builderRequest = HttpRequest.newBuilder(new URI(hUrl.getStringValue()));
            int c = (int)haNames.m_cSize;
            for (int i = 0; i < c; ++i) {
                builderRequest.header(haNames.get(i), haValues.get(i));
            }
            if (cTimeoutMillis > 0L) {
                builderRequest.timeout(Duration.ofMillis(cTimeoutMillis));
            }
            byte[] abData = haBytes.m_cSize > 0L ? ((ByteBasedDelegate)haBytes.getTemplate()).getBytes(haBytes, 0L, haBytes.m_cSize, false) : null;
            builderRequest.method(hMethod.getStringValue(), abData == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofByteArray(abData));
            HttpClient client = hConn.selectClient(cTimeoutMillis);
            HttpRequest request = builderRequest.build();
            Callable<HttpResponse> task = () -> client.send(request, HttpResponse.BodyHandlers.ofByteArray());
            CompletableFuture<HttpResponse> cfSend = frame.f_context.f_container.scheduleIO(task);
            Frame.Continuation continuation = frameCaller -> {
                try {
                    return this.processResponse(frameCaller, (HttpResponse)cfSend.get(), aiReturn);
                }
                catch (Throwable e) {
                    return frameCaller.raiseException(xException.ioException(frameCaller, e.getMessage()));
                }
            };
            return frame.waitForIO(cfSend, continuation);
        }
        catch (Exception e) {
            return frame.raiseException(xException.ioException(frame, e.getMessage()));
        }
    }

    private int processResponse(Frame frame, HttpResponse<byte[]> response, int[] aiReturn) {
        try {
            int nResponseCode = response.statusCode();
            Map<String, List<String>> mapResponseHeaders = response.headers().map();
            int cResponseHeaders = mapResponseHeaders.size();
            ArrayList<String> listResponseNames = new ArrayList<String>(cResponseHeaders);
            ArrayList<String> listResponseValues = new ArrayList<String>(cResponseHeaders);
            Iterator<Map.Entry<String, List<String>>> it = mapResponseHeaders.entrySet().iterator();
            for (int i = 0; i < cResponseHeaders; ++i) {
                Map.Entry<String, List<String>> entry = it.next();
                String sName = entry.getKey();
                if (sName == null) continue;
                List<String> listValue = entry.getValue();
                for (String sValue : listValue) {
                    assert (sValue != null);
                    listResponseNames.add(sName);
                    listResponseValues.add(sValue);
                }
            }
            String[] asResponseNames = listResponseNames.toArray(Utils.NO_NAMES);
            String[] asResponseValues = listResponseValues.toArray(Utils.NO_NAMES);
            byte[] abResponse = response.body();
            xArray.ArrayHandle hResponseBytes = abResponse == null || abResponse.length == 0 ? xArray.ensureEmptyByteArray() : xArray.makeByteArrayHandle(abResponse, xArray.Mutability.Constant);
            return frame.assignValues(aiReturn, xInt64.makeHandle(nResponseCode), xString.makeArrayHandle(asResponseNames), xString.makeArrayHandle(asResponseValues), hResponseBytes);
        }
        catch (Exception e) {
            return frame.raiseException(xException.ioException(frame, e.getMessage()));
        }
    }

    private static CookieHandler createCookieHandler() {
        return new CookieManager(null, CookiePolicy.ACCEPT_ALL);
    }

    private static SSLContext createSSLContext() throws GeneralSecurityException {
        TrustManager[] aTrustMgr = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, aTrustMgr, new SecureRandom());
        return context;
    }

    protected static class ConnectorHandle
    extends xService.ServiceHandle {
        protected final CookieHandler f_cookieHandler;
        protected SSLContext f_sslContext;
        private final HttpClient[] f_clientPool = new HttpClient[5];

        protected ConnectorHandle(TypeComposition clazz, ServiceContext context, CookieHandler cookieHandler, SSLContext sslContext) {
            super(clazz, context);
            this.f_cookieHandler = cookieHandler;
            this.f_sslContext = sslContext;
        }

        protected HttpClient selectClient(long cTimeoutMillis) {
            int nSlot;
            Duration timeout;
            if (cTimeoutMillis == 0L) {
                timeout = null;
                nSlot = 0;
            } else {
                int cApprox = Integer.highestOneBit((int)cTimeoutMillis / 1000);
                timeout = Duration.ofSeconds(cApprox);
                nSlot = Math.min(this.f_clientPool.length - 1, 1 + Integer.numberOfTrailingZeros(cApprox));
            }
            HttpClient client = this.f_clientPool[nSlot];
            if (client == null) {
                HttpClient.Builder builderClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).cookieHandler(this.f_cookieHandler).sslContext(this.f_sslContext);
                if (timeout != null) {
                    builderClient.connectTimeout(timeout);
                }
                this.f_clientPool[nSlot] = client = builderClient.build();
            }
            return client;
        }

        @Override
        public String toString() {
            return "Connector";
        }
    }
}

