/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native.web;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsExchange;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509ExtendedKeyManager;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.collections.arrays.xRTStringDelegate;
import org.xvm.runtime.template._native.crypto.xRTKeyStore;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xByteArray;
import org.xvm.runtime.template.numbers.xUInt16;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xObject;
import org.xvm.runtime.template.xService;
import org.xvm.util.Auto;

public class xRTServer
extends xService {
    public static xRTServer INSTANCE;
    private TypeConstant m_typeCanonical;

    public xRTServer(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("bindImpl", null, VOID);
        this.markNativeMethod("addRouteImpl", null, VOID);
        this.markNativeMethod("removeRouteImpl", null, VOID);
        this.markNativeMethod("replaceRouteImpl", null, BOOLEAN);
        this.markNativeMethod("setHeaders", null, VOID);
        this.markNativeMethod("setBodyBytes", null, VOID);
        this.markNativeMethod("closeImpl", VOID, VOID);
        this.markNativeMethod("getReceivedAtAddress", null, null);
        this.markNativeMethod("getReceivedFromAddress", null, null);
        this.markNativeMethod("getHostInfo", null, null);
        this.markNativeMethod("getProtocolString", null, null);
        this.markNativeMethod("getHeaderNames", null, null);
        this.markNativeMethod("getHeaderValuesForName", null, null);
        this.markNativeMethod("readBody", null, null);
        this.markNativeMethod("containsNestedBodies", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        TypeConstant type = this.m_typeCanonical;
        if (type == null) {
            this.m_typeCanonical = type = this.f_struct.getChild("HttpServer").getIdentityConstant().getType();
        }
        return type;
    }

    public ObjectHandle ensureServer(Frame frame, ObjectHandle hOpts) {
        ClassComposition clz = this.getCanonicalClass();
        MethodStructure ctor = this.getStructure().findConstructor(new TypeConstant[0]);
        ServiceContext context = this.f_container.createServiceContext("HttpServer");
        int iResult = context.sendConstructRequest(frame, clz, ctor, null, new ObjectHandle[ctor.getMaxVars()], -1);
        return frame.popResult(iResult);
    }

    @Override
    protected xService.ServiceHandle createStructHandle(TypeComposition clazz, ServiceContext context) {
        return new HttpServerHandle(clazz.ensureAccess(Constants.Access.STRUCT), context);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "getProtocolString": {
                return this.invokeGetProtocol(frame, (HttpContextHandle)hArg, iReturn);
            }
            case "getHeaderNames": {
                return this.invokeGetHeaderNames(frame, (HttpContextHandle)hArg, iReturn);
            }
            case "containsNestedBodies": {
                return this.invokeContainsBodies(frame, (HttpContextHandle)hArg, iReturn);
            }
            case "removeRouteImpl": {
                return this.invokeRemoveRoute(frame, (HttpServerHandle)hTarget, (xString.StringHandle)hArg);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        HttpServerHandle hServer = (HttpServerHandle)hTarget;
        switch (method.getName()) {
            case "bindImpl": {
                assert (frame.f_context == hServer.f_context);
                return this.invokeBind(frame, hServer, ahArg);
            }
            case "addRouteImpl": {
                assert (frame.f_context == hServer.f_context);
                return this.invokeAddRoute(frame, hServer, ahArg);
            }
            case "replaceRouteImpl": {
                assert (frame.f_context == hServer.f_context);
                return this.invokeReplaceRoute(frame, hServer, ahArg, iReturn);
            }
            case "setHeaders": {
                return frame.f_context == hServer.f_context ? this.invokeSetHeaders(frame, ahArg) : xRTFunction.makeAsyncNativeHandle(method).call1(frame, hServer, ahArg, iReturn);
            }
            case "setBodyBytes": {
                return frame.f_context == hServer.f_context ? this.invokeSetBodyBytes(frame, ahArg) : xRTFunction.makeAsyncNativeHandle(method).call1(frame, hServer, ahArg, iReturn);
            }
            case "readBody": {
                return frame.f_context == hServer.f_context ? this.invokeReadBody(frame, ahArg, iReturn) : xRTFunction.makeAsyncNativeHandle(method).call1(frame, hServer, ahArg, iReturn);
            }
            case "closeImpl": {
                assert (frame.f_context == hServer.f_context);
                return this.invokeClose(hServer);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "getReceivedAtAddress": {
                return this.invokeGetReceivedAtAddress(frame, (HttpContextHandle)ahArg[0], aiReturn);
            }
            case "getReceivedFromAddress": {
                return this.invokeGetReceivedFromAddress(frame, (HttpContextHandle)ahArg[0], aiReturn);
            }
            case "getHostInfo": {
                return this.invokeGetHostInfo(frame, (HttpContextHandle)ahArg[0], aiReturn);
            }
            case "getHeaderValuesForName": {
                return this.invokeGetHeaderValues(frame, (HttpContextHandle)ahArg[0], (xString.StringHandle)ahArg[1], aiReturn);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    private int invokeBind(Frame frame, HttpServerHandle hServer, ObjectHandle[] ahArg) {
        if (hServer.getHttpServer() != null) {
            return frame.raiseException(xException.illegalState(frame, "Server is already configured"));
        }
        ObjectHandle hBinding = ahArg[0];
        String sBindAddr = ((xString.StringHandle)ahArg[1]).getStringValue();
        int nHttpPort = (int)((ObjectHandle.JavaLong)ahArg[2]).getValue();
        int nHttpsPort = (int)((ObjectHandle.JavaLong)ahArg[3]).getValue();
        try {
            this.configureHttpServer(hServer, new InetSocketAddress(sBindAddr, nHttpPort));
            this.configureHttpsServer(hServer, new InetSocketAddress(sBindAddr, nHttpsPort));
            this.configureBinding(hServer, hBinding);
            HttpServer httpServer = hServer.getHttpServer();
            HttpsServer httpsServer = hServer.getHttpsServer();
            String sName = "HttpHandler";
            ThreadGroup group = new ThreadGroup(sName);
            ThreadFactory factory = r -> {
                Thread thread = new Thread(group, r);
                thread.setDaemon(true);
                thread.setName(sName + "@" + thread.hashCode());
                return thread;
            };
            ExecutorService executor = Executors.newCachedThreadPool(factory);
            httpServer.setExecutor(executor);
            httpServer.start();
            httpsServer.setExecutor(executor);
            httpsServer.start();
            hServer.f_context.f_container.registerNativeCallback();
            Router router = hServer.getRouter();
            httpServer.createContext("/", router);
            httpsServer.createContext("/", router);
            return -1;
        }
        catch (Exception e) {
            frame.f_context.f_container.terminate(hServer.f_context);
            return frame.raiseException(xException.obscureIoException(frame, e.getMessage()));
        }
    }

    private void configureHttpServer(HttpServerHandle hServer, InetSocketAddress addr) throws IOException {
        hServer.setHttpServer(HttpServer.create(addr, 0));
    }

    private void configureHttpsServer(HttpServerHandle hServer, InetSocketAddress addr) throws IOException, GeneralSecurityException {
        HttpsServer httpsServer = HttpsServer.create(addr, 0);
        SSLContext ctxSSL = SSLContext.getInstance("TLS");
        KeyManager[] aKeyManagers = new KeyManager[]{new SimpleKeyManager(hServer)};
        ctxSSL.init(aKeyManagers, null, null);
        httpsServer.setHttpsConfigurator(new HttpsConfigurator(this, ctxSSL){

            @Override
            public void configure(HttpsParameters params) {
                try {
                    SSLContext ctxSSL = this.getSSLContext();
                    SSLEngine engine = ctxSSL.createSSLEngine();
                    SSLParameters paramsSSL = ctxSSL.getSupportedSSLParameters();
                    paramsSSL.setNeedClientAuth(false);
                    paramsSSL.setCipherSuites(engine.getEnabledCipherSuites());
                    paramsSSL.setProtocols(engine.getEnabledProtocols());
                    params.setSSLParameters(paramsSSL);
                }
                catch (Exception ex) {
                    throw new RuntimeException("failed to initialize the SSL context", ex);
                }
            }
        });
        hServer.setHttpsServer(httpsServer);
    }

    private void configureBinding(HttpServerHandle hServer, ObjectHandle hBinding) {
        hServer.setBinding(hBinding);
    }

    private int invokeAddRoute(Frame frame, HttpServerHandle hServer, ObjectHandle[] ahArg) {
        String string;
        xRTKeyStore.KeyStoreHandle hK;
        String sHostName = ((xString.StringHandle)ahArg[0]).getStringValue();
        int nHttpPort = (int)((ObjectHandle.JavaLong)ahArg[1]).getValue();
        int nHttpsPort = (int)((ObjectHandle.JavaLong)ahArg[2]).getValue();
        xService.ServiceHandle hWrapper = (xService.ServiceHandle)ahArg[3];
        ObjectHandle objectHandle = ahArg[4];
        xRTKeyStore.KeyStoreHandle hKeystore = objectHandle instanceof xRTKeyStore.KeyStoreHandle ? (hK = (xRTKeyStore.KeyStoreHandle)objectHandle) : null;
        ObjectHandle objectHandle2 = ahArg[5];
        if (objectHandle2 instanceof xString.StringHandle) {
            xString.StringHandle hS = (xString.StringHandle)objectHandle2;
            string = hS.getStringValue();
        } else {
            string = null;
        }
        String sTlsKey = string;
        Router router = hServer.getRouter();
        if (hKeystore != null) {
            KeyStore keystore = hKeystore.f_keyStore;
            if (sTlsKey != null && !this.isValidPair(hKeystore, sTlsKey)) {
                return frame.raiseException("Invalid or missing entry for Tls key: \"" + sTlsKey + "\"");
            }
            if (sTlsKey == null && router.mapRoutes.isEmpty()) {
                try {
                    Enumeration<String> it = keystore.aliases();
                    while (it.hasMoreElements()) {
                        String sName = it.nextElement();
                        if (!this.isValidPair(hKeystore, sName)) continue;
                        sTlsKey = sName;
                        break;
                    }
                }
                catch (KeyStoreException it) {
                    // empty catch block
                }
                if (sTlsKey == null) {
                    return frame.raiseException("The Tls key name must be specified");
                }
            }
        }
        RequestHandler handler = this.createRequestHandler(frame, hWrapper, hServer);
        RouteInfo route = new RouteInfo(handler, nHttpPort, nHttpsPort, hKeystore, sTlsKey);
        if (hServer.getHttpServer().getAddress().getHostName().equals(sHostName)) {
            router.setDirectRoute(route);
        }
        router.mapRoutes.put(sHostName, route);
        return -1;
    }

    private boolean isValidPair(xRTKeyStore.KeyStoreHandle hKeystore, String sName) {
        KeyStore keystore = hKeystore.f_keyStore;
        try {
            return keystore.isKeyEntry(sName) && hKeystore.getKey(sName) instanceof PrivateKey && keystore.getCertificate(sName) != null;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    private int invokeReplaceRoute(Frame frame, HttpServerHandle hServer, ObjectHandle[] ahArg, int iResult) {
        String sHostName = ((xString.StringHandle)ahArg[0]).getStringValue();
        xService.ServiceHandle hWrapper = (xService.ServiceHandle)ahArg[1];
        Router router = hServer.getRouter();
        RouteInfo info = router.mapRoutes.get(sHostName);
        if (info == null) {
            return frame.assignValue(iResult, xBoolean.FALSE);
        }
        RequestHandler handler = this.createRequestHandler(frame, hWrapper, hServer);
        router.mapRoutes.put(sHostName, new RouteInfo(handler, info.nHttpPort, info.nHttpPort, info.hKeyStore, info.sTlsKey));
        return frame.assignValue(iResult, xBoolean.TRUE);
    }

    private RequestHandler createRequestHandler(Frame frame, xService.ServiceHandle hWrapper, HttpServerHandle hServer) {
        ClassStructure clzHandler = hWrapper.getTemplate().getStructure();
        MethodStructure method = clzHandler.findMethodDeep("handle", m -> m.getParamCount() == 5);
        assert (method != null);
        xRTFunction.FunctionHandle hFunction = xRTFunction.makeInternalHandle(frame, method).bindTarget(frame, hWrapper);
        return new RequestHandler(hWrapper.f_context, hFunction, hServer);
    }

    private int invokeRemoveRoute(Frame frame, HttpServerHandle hServer, xString.StringHandle hHostName) {
        hServer.getRouter().mapRoutes.remove(hHostName.getStringValue());
        return -1;
    }

    private int invokeGetReceivedAtAddress(Frame frame, HttpContextHandle hCtx, int[] aiResult) {
        InetSocketAddress addr = hCtx.f_exchange.getLocalAddress();
        byte[] ab = addr.getAddress().getAddress();
        int nPort = addr.getPort();
        return frame.assignValues(aiResult, xByteArray.makeByteArrayHandle(ab, xArray.Mutability.Constant), xUInt16.INSTANCE.makeJavaLong(nPort));
    }

    private int invokeGetReceivedFromAddress(Frame frame, HttpContextHandle hCtx, int[] aiResult) {
        InetSocketAddress addr = hCtx.f_exchange.getRemoteAddress();
        byte[] ab = addr.getAddress().getAddress();
        int nPort = addr.getPort();
        return frame.assignValues(aiResult, xByteArray.makeByteArrayHandle(ab, xArray.Mutability.Constant), xUInt16.INSTANCE.makeJavaLong(nPort));
    }

    private int invokeGetHostInfo(Frame frame, HttpContextHandle hCtx, int[] aiResult) {
        HttpExchange exchange = hCtx.f_exchange;
        String sHost = exchange.getRequestHeaders().getFirst("Host");
        String sName = xRTServer.extractHostName(sHost);
        int nPort = xRTServer.extractHostPort(sHost, exchange);
        return sName == null ? frame.assignValue(aiResult[0], xBoolean.FALSE) : frame.assignValues(aiResult, xBoolean.TRUE, xString.makeHandle(sName), xUInt16.INSTANCE.makeJavaLong(nPort));
    }

    private int invokeGetProtocol(Frame frame, HttpContextHandle hCtx, int iResult) {
        String sProtocol = hCtx.f_exchange.getProtocol();
        return frame.assignValue(iResult, xString.makeHandle(sProtocol));
    }

    private int invokeGetHeaderNames(Frame frame, HttpContextHandle hCtx, int iResult) {
        Headers headers = hCtx.f_exchange.getRequestHeaders();
        return frame.assignValue(iResult, xString.makeArrayHandle(headers.keySet().toArray(Utils.NO_NAMES)));
    }

    private int invokeGetHeaderValues(Frame frame, HttpContextHandle hCtx, xString.StringHandle hName, int[] aiResult) {
        String sName;
        Headers headers = hCtx.f_exchange.getRequestHeaders();
        Object listValues = headers.get(sName = hName.getStringValue());
        if (listValues == null) {
            return frame.assignValue(aiResult[0], xBoolean.FALSE);
        }
        return frame.assignValues(aiResult, xBoolean.TRUE, xString.makeArrayHandle(listValues.toArray(Utils.NO_NAMES)));
    }

    private int invokeReadBody(Frame frame, ObjectHandle[] ahArg, int iResult) {
        HttpContextHandle hCtx = (HttpContextHandle)ahArg[0];
        long cb = ((ObjectHandle.JavaLong)ahArg[1]).getValue();
        try {
            InputStream in = hCtx.f_exchange.getRequestBody();
            byte[] ab = in.readNBytes((int)Math.min(cb, Integer.MAX_VALUE));
            return frame.assignValue(iResult, ab.length == 0 ? xByteArray.ensureEmptyByteArray() : xByteArray.makeByteArrayHandle(ab, xArray.Mutability.Constant));
        }
        catch (IOException e) {
            return frame.raiseException(xException.obscureIoException(frame, e.getMessage()));
        }
    }

    private int invokeContainsBodies(Frame frame, HttpContextHandle hCtx, int iResult) {
        return frame.assignValue(iResult, xBoolean.FALSE);
    }

    private int invokeClose(HttpServerHandle hServer) {
        HttpServer httpServer = hServer.getHttpServer();
        HttpsServer httpsServer = hServer.getHttpsServer();
        if (httpServer != null) {
            if (httpServer.getExecutor() == null) {
                httpServer.start();
                httpServer.stop(0);
                httpsServer.start();
                httpsServer.stop(0);
            } else {
                httpServer.removeContext("/");
                httpServer.stop(0);
                httpsServer.removeContext("/");
                httpsServer.stop(0);
                ((ExecutorService)httpServer.getExecutor()).shutdown();
                hServer.f_context.f_container.unregisterNativeCallback();
            }
            hServer.getRouter().mapRoutes.clear();
            hServer.clear();
        }
        return -1;
    }

    private int invokeSetHeaders(Frame frame, ObjectHandle[] ahArg) {
        HttpExchange exchange = ((HttpContextHandle)ahArg[0]).f_exchange;
        long nStatus = ((ObjectHandle.JavaLong)ahArg[1]).getValue();
        xRTStringDelegate.StringArrayHandle hHeaderNames = (xRTStringDelegate.StringArrayHandle)((xArray.ArrayHandle)ahArg[2]).m_hDelegate;
        xRTStringDelegate.StringArrayHandle hHeaderValues = (xRTStringDelegate.StringArrayHandle)((xArray.ArrayHandle)ahArg[3]).m_hDelegate;
        long nLength = ((ObjectHandle.JavaLong)ahArg[4]).getValue();
        Headers headers = exchange.getResponseHeaders();
        long c = hHeaderNames.m_cSize;
        for (long i = 0L; i < c; ++i) {
            headers.add(hHeaderNames.get(i), hHeaderValues.get(i));
        }
        try {
            exchange.sendResponseHeaders((int)nStatus, (int)nLength);
            return -1;
        }
        catch (IOException e) {
            return frame.raiseException(xException.obscureIoException(frame, e.getMessage()));
        }
    }

    private int invokeSetBodyBytes(Frame frame, ObjectHandle[] ahArg) {
        HttpExchange exchange = ((HttpContextHandle)ahArg[0]).f_exchange;
        xArray.ArrayHandle hBody = (xArray.ArrayHandle)ahArg[1];
        boolean fFinal = ((xBoolean.BooleanHandle)ahArg[2]).get();
        byte[] abBody = xByteArray.getBytes(hBody);
        if (abBody.length > 0) {
            try (OutputStream out = exchange.getResponseBody();){
                out.write(abBody);
            }
            catch (Throwable e) {
                exchange.close();
                return frame.raiseException(xException.makeObscure(frame, e.getMessage()));
            }
        }
        if (fFinal) {
            exchange.close();
        }
        return -1;
    }

    protected static String extractHostName(String sHost) {
        int ofPort;
        if (sHost != null && (ofPort = sHost.lastIndexOf(58)) >= 0) {
            sHost = sHost.substring(0, ofPort);
        }
        return sHost;
    }

    protected static int extractHostPort(String sHost, HttpExchange exchange) {
        if (sHost == null) {
            return exchange.getRemoteAddress().getPort();
        }
        int ofPort = sHost.lastIndexOf(58);
        return ofPort >= 0 ? Integer.valueOf(sHost.substring(ofPort + 1)) : (exchange instanceof HttpsExchange ? 443 : 80);
    }

    protected static class HttpServerHandle
    extends xService.ServiceHandle {
        private final Object[] f_aoNative = new Object[3];

        protected HttpServerHandle(TypeComposition clazz, ServiceContext context) {
            super(clazz, context);
            this.f_aoNative[0] = new Router();
        }

        protected Router getRouter() {
            return (Router)this.f_aoNative[0];
        }

        protected void setRouter(Router router) {
            Router routerPrev = this.getRouter();
            if (router == routerPrev) {
                return;
            }
            ObjectHandle binding = this.getBinding();
            if (binding != null) {
                this.setBinding(null);
            }
            if (router != null) {
                router.setBinding(binding);
            }
            this.f_aoNative[0] = router;
        }

        protected HttpServer getHttpServer() {
            return (HttpServer)this.f_aoNative[1];
        }

        protected void setHttpServer(HttpServer httpServer) {
            this.f_aoNative[1] = httpServer;
        }

        protected HttpsServer getHttpsServer() {
            return (HttpsServer)this.f_aoNative[2];
        }

        protected void setHttpsServer(HttpsServer httpsServer) {
            this.f_aoNative[2] = httpsServer;
        }

        protected ObjectHandle getBinding() {
            Router router = this.getRouter();
            return router == null ? null : router.getBinding();
        }

        protected void setBinding(ObjectHandle binding) {
            Router router = this.getRouter();
            if (router == null) {
                assert (binding == null);
            } else {
                router.setBinding(binding);
            }
        }

        protected void clear() {
            this.setRouter(null);
            this.setHttpServer(null);
            this.setHttpsServer(null);
        }

        @Override
        public String toString() {
            return "HttpServer" + (String)(this.getHttpServer() == null ? "" : "@" + this.getHttpServer().getAddress().getHostString());
        }
    }

    protected static class HttpContextHandle
    extends ObjectHandle {
        public final HttpExchange f_exchange;

        public HttpContextHandle(HttpExchange exchange) {
            super(xObject.INSTANCE.getCanonicalClass());
            this.f_exchange = exchange;
            this.m_fMutable = false;
        }
    }

    protected static class Router
    implements HttpHandler {
        public final Map<String, RouteInfo> mapRoutes = new ConcurrentHashMap<String, RouteInfo>();
        private ObjectHandle m_hBinding;
        private RouteInfo m_routeDirect;

        protected Router() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String sHost = exchange.getRequestHeaders().getFirst("Host");
            String sName = xRTServer.extractHostName(sHost);
            int nPort = xRTServer.extractHostPort(sHost, exchange);
            boolean fTls = exchange instanceof HttpsExchange;
            RouteInfo route = this.mapRoutes.get(sName);
            if (route == null || nPort != (fTls ? route.nHttpsPort : route.nHttpPort)) {
                System.err.println("*** Request for unregistered route: " + (fTls ? "https://" : "http://") + sHost + String.valueOf(exchange.getRequestURI()));
                exchange.sendResponseHeaders(421, -1L);
            } else {
                route.handler.handle(exchange);
            }
        }

        protected ObjectHandle getBinding() {
            return this.m_hBinding;
        }

        protected void setBinding(ObjectHandle binding) {
            this.m_hBinding = binding;
        }

        protected RouteInfo getDirectRoute() {
            return this.m_routeDirect;
        }

        protected void setDirectRoute(RouteInfo route) {
            this.m_routeDirect = route;
        }
    }

    protected static class SimpleKeyManager
    extends X509ExtendedKeyManager {
        private final HttpServerHandle f_hServer;
        private final ThreadLocal<xRTKeyStore.KeyStoreHandle> f_tloKeyStore = new ThreadLocal();

        public SimpleKeyManager(HttpServerHandle hServer) {
            this.f_hServer = hServer;
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String chooseEngineClientAlias(String[] asKeyType, Principal[] issuers, SSLEngine engine) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String chooseClientAlias(String[] asKeyType, Principal[] issuers, Socket socket) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            RouteInfo route;
            SSLSession session = engine.getHandshakeSession();
            if (!(session instanceof ExtendedSSLSession)) {
                System.err.println("*** Handshake from unknown session");
                return null;
            }
            ExtendedSSLSession sessionEx = (ExtendedSSLSession)session;
            List<SNIServerName> listNames = sessionEx.getRequestedServerNames();
            String sHost = listNames.isEmpty() ? null : ((SNIHostName)listNames.get(0)).getAsciiName();
            RouteInfo routeInfo = route = sHost == null ? this.f_hServer.getRouter().getDirectRoute() : this.f_hServer.getRouter().mapRoutes.get(sHost);
            if (route == null) {
                System.err.println("*** Handshake with unknown host: " + sHost);
                return null;
            }
            this.f_tloKeyStore.set(route.hKeyStore);
            return route.sTlsKey;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            throw new UnsupportedOperationException();
        }

        @Override
        public X509Certificate[] getCertificateChain(String sAlias) {
            try {
                Certificate[] aCerts = this.f_tloKeyStore.get().f_keyStore.getCertificateChain(sAlias);
                if (aCerts instanceof X509Certificate[]) {
                    X509Certificate[] aX509Certs = (X509Certificate[])aCerts;
                    return aX509Certs;
                }
                int cCerts = aCerts.length;
                X509Certificate[] aX509Certs = new X509Certificate[cCerts];
                System.arraycopy(aCerts, 0, aX509Certs, 0, cCerts);
                return aX509Certs;
            }
            catch (KeyStoreException e) {
                return new X509Certificate[0];
            }
        }

        @Override
        public PrivateKey getPrivateKey(String sAlias) {
            try {
                xRTKeyStore.KeyStoreHandle hKeyStore = this.f_tloKeyStore.get();
                return (PrivateKey)hKeyStore.getKey(sAlias);
            }
            catch (GeneralSecurityException e) {
                return null;
            }
        }
    }

    protected static class RequestHandler
    implements HttpHandler {
        private final ServiceContext f_context;
        private final xRTFunction.FunctionHandle f_hFunction;
        private final HttpServerHandle f_hServer;

        public RequestHandler(ServiceContext context, xRTFunction.FunctionHandle hFunction, HttpServerHandle hServer) {
            this.f_context = context;
            this.f_hFunction = hFunction;
            this.f_hServer = hServer;
        }

        @Override
        public void handle(HttpExchange exchange) {
            try (Auto ignore = ConstantPool.withPool(this.f_context.f_pool);){
                ObjectHandle[] hArgs = this.createArguments(exchange);
                this.f_context.postRequest(null, this.f_hFunction, hArgs, 0).handle((T response, U err) -> {
                    if (err != null) {
                        this.sendError(exchange, (Throwable)err);
                    }
                    return null;
                });
            }
            catch (Throwable t) {
                this.sendError(exchange, t);
            }
        }

        private ObjectHandle[] createArguments(HttpExchange exchange) {
            ObjectHandle hBinding = this.f_hServer.getBinding();
            HttpContextHandle hContext = new HttpContextHandle(exchange);
            xString.StringHandle hURI = xString.makeHandle(exchange.getRequestURI().toASCIIString());
            xString.StringHandle hMethod = xString.makeHandle(exchange.getRequestMethod());
            xBoolean.BooleanHandle hTls = xBoolean.makeHandle(exchange instanceof HttpsExchange);
            return new ObjectHandle[]{hBinding, hContext, hURI, hMethod, hTls};
        }

        private void sendError(HttpExchange exchange, Throwable t) {
            t.printStackTrace();
            try {
                exchange.sendResponseHeaders(500, -1L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected record RouteInfo(RequestHandler handler, int nHttpPort, int nHttpsPort, xRTKeyStore.KeyStoreHandle hKeyStore, String sTlsKey) {
    }
}

