/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template._native;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xService;

public class xRTServiceControl
extends ClassTemplate {
    public static xRTServiceControl INSTANCE;
    protected static xEnum SERVICE_STATUS;
    private TypeComposition m_clzControl;

    public xRTServiceControl(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    public void initNative() {
        TypeConstant typeInception = this.getCanonicalType();
        TypeConstant typeMask = this.pool().ensureEcstasyTypeConstant("Service.ServiceControl");
        this.m_clzControl = this.ensureClass(this.f_container, typeInception, typeMask);
        SERVICE_STATUS = (xEnum)this.f_container.getTemplate("Service.ServiceStatus");
        this.markNativeProperty("statusIndicator");
        this.markNativeProperty("upTime");
        this.markNativeProperty("cpuTime");
        this.markNativeProperty("contended");
        this.markNativeMethod("gc", VOID, VOID);
        this.markNativeMethod("shutdown", VOID, VOID);
        this.markNativeMethod("kill", VOID, VOID);
        typeInception.invalidateTypeInfo();
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        ControlHandle hControl = (ControlHandle)hTarget;
        switch (method.getName()) {
            case "shutdown": {
                ServiceContext context = hControl.getContext();
                xService.ServiceHandle hService = context.getService();
                if (hService == null) {
                    return -1;
                }
                return frame.f_context == context ? context.shutdown(frame) : xRTFunction.makeAsyncNativeHandle(method).call1(frame, hService, ahArg, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        ControlHandle hControl = (ControlHandle)hTarget;
        switch (sPropName) {
            case "contended": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(hControl.getContext().isContended()));
            }
            case "statusIndicator": {
                xEnum.EnumHandle hStatus = SERVICE_STATUS.getEnumByName(hControl.getContext().getStatus().name());
                return Utils.assignInitializedEnum(frame, hStatus, iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    public static ObjectHandle makeHandle(ServiceContext context) {
        return new ControlHandle(xRTServiceControl.INSTANCE.m_clzControl, context);
    }

    protected static class ControlHandle
    extends ObjectHandle {
        protected final ServiceContext f_context;

        protected ControlHandle(TypeComposition clazz, ServiceContext context) {
            super(clazz);
            this.f_context = context;
        }

        public ServiceContext getContext() {
            return this.f_context;
        }
    }
}

