/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.annotations;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.annotations.xAtomicInt128;
import org.xvm.runtime.template.annotations.xAtomicIntNumber;
import org.xvm.runtime.template.numbers.xInt128;
import org.xvm.runtime.template.numbers.xInt16;
import org.xvm.runtime.template.numbers.xInt32;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.numbers.xInt8;
import org.xvm.runtime.template.numbers.xUInt128;
import org.xvm.runtime.template.numbers.xUInt16;
import org.xvm.runtime.template.numbers.xUInt32;
import org.xvm.runtime.template.numbers.xUInt64;
import org.xvm.runtime.template.numbers.xUInt8;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.reflect.xVar;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;

public class xAtomic
extends xVar {
    public static xAtomic INSTANCE;
    protected static Map<TypeConstant, xAtomic> NUMBER_TEMPLATES;

    public xAtomic(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.markNativeMethod("exchange", null, null);
        this.markNativeMethod("replaceFailed", null, null);
        ConstantPool pool = this.f_container.getConstantPool();
        HashMap<TypeConstant, xAtomic> mapTemplates = new HashMap<TypeConstant, xAtomic>();
        mapTemplates.put(pool.typeInt128(), new xAtomicInt128(xInt128.INSTANCE));
        mapTemplates.put(pool.typeUInt128(), new xAtomicInt128(xUInt128.INSTANCE));
        mapTemplates.put(pool.typeInt8(), new xAtomicIntNumber(xInt8.INSTANCE));
        mapTemplates.put(pool.typeInt16(), new xAtomicIntNumber(xInt16.INSTANCE));
        mapTemplates.put(pool.typeInt32(), new xAtomicIntNumber(xInt32.INSTANCE));
        mapTemplates.put(pool.typeInt64(), new xAtomicIntNumber(xInt64.INSTANCE));
        mapTemplates.put(pool.typeUInt8(), new xAtomicIntNumber(xUInt8.INSTANCE));
        mapTemplates.put(pool.typeUInt16(), new xAtomicIntNumber(xUInt16.INSTANCE));
        mapTemplates.put(pool.typeUInt32(), new xAtomicIntNumber(xUInt32.INSTANCE));
        mapTemplates.put(pool.typeUInt64(), new xAtomicIntNumber(xUInt64.INSTANCE));
        NUMBER_TEMPLATES = mapTemplates;
        this.invalidateTypeInfo();
    }

    @Override
    public ClassTemplate getTemplate(TypeConstant type) {
        ClassTemplate templateAtomicInt = NUMBER_TEMPLATES.get(type.getParamType(0));
        return templateAtomicInt == null ? this : templateAtomicInt;
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "exchange": {
                AtomicHandle hThis = (AtomicHandle)hTarget;
                return frame.assignValue(iReturn, hThis.f_atomic.getAndSet(hArg));
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "replaceFailed": {
                AtomicHandle hThis = (AtomicHandle)hTarget;
                ObjectHandle hExpect = ahArg[0];
                ObjectHandle hNew = ahArg[1];
                AtomicReference<ObjectHandle> atomic = hThis.f_atomic;
                if (atomic.compareAndSet(hExpect, hNew)) {
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                TypeConstant type = hThis.getType().resolveGenericType("Referent");
                return new ReplaceFailed(type, atomic, hExpect, hNew, aiReturn).doNext(frame);
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    public xRef.RefHandle createRefHandle(Frame frame, TypeComposition clazz, String sName) {
        return new AtomicHandle(clazz.ensureAccess(Constants.Access.PUBLIC), sName, null);
    }

    @Override
    protected int getReferentImpl(Frame frame, xRef.RefHandle hTarget, boolean fNative, int iReturn) {
        AtomicHandle hAtomic = (AtomicHandle)hTarget;
        ObjectHandle hValue = hAtomic.f_atomic.get();
        return hValue == null ? frame.raiseException(xException.unassignedReference(frame)) : frame.assignValue(iReturn, hValue);
    }

    @Override
    protected int setReferentImpl(Frame frame, xRef.RefHandle hTarget, boolean fNative, ObjectHandle hValue) {
        AtomicHandle hAtomic = (AtomicHandle)hTarget;
        hAtomic.f_atomic.set(hValue);
        return -1;
    }

    public static class AtomicHandle
    extends xRef.RefHandle {
        protected final AtomicReference<ObjectHandle> f_atomic = new AtomicReference();

        protected AtomicHandle(TypeComposition clazz, String sName, ObjectHandle hValue) {
            super(clazz, sName);
            if (hValue != null) {
                this.f_atomic.set(hValue);
            }
        }

        @Override
        public boolean isAssigned() {
            return this.f_atomic.get() != null;
        }

        @Override
        public String toString() {
            return String.valueOf(this.m_clazz) + " -> " + String.valueOf(this.f_atomic.get());
        }
    }

    protected static class ReplaceFailed
    implements Frame.Continuation {
        private final TypeConstant type;
        private final AtomicReference<ObjectHandle> atomic;
        private ObjectHandle hExpect;
        private final ObjectHandle hNew;
        private final int[] aiReturn;

        public ReplaceFailed(TypeConstant type, AtomicReference<ObjectHandle> atomic, ObjectHandle hExpect, ObjectHandle hNew, int[] aiReturn) {
            this.type = type;
            this.atomic = atomic;
            this.hExpect = hExpect;
            this.hNew = hNew;
            this.aiReturn = aiReturn;
        }

        @Override
        public int proceed(Frame frameCaller) {
            if (frameCaller.popStack() == xBoolean.FALSE) {
                return frameCaller.assignValues(this.aiReturn, xBoolean.TRUE, this.hExpect);
            }
            if (this.atomic.compareAndSet(this.hExpect, this.hNew)) {
                return frameCaller.assignValue(this.aiReturn[0], xBoolean.FALSE);
            }
            return this.doNext(frameCaller);
        }

        public int doNext(Frame frameCaller) {
            block5: while (true) {
                ObjectHandle hCurrent = this.atomic.get();
                switch (this.type.callEquals(frameCaller, hCurrent, this.hExpect, -1)) {
                    case -1: {
                        if (frameCaller.popStack() == xBoolean.FALSE) {
                            return frameCaller.assignValues(this.aiReturn, xBoolean.TRUE, hCurrent);
                        }
                        if (this.atomic.compareAndSet(hCurrent, this.hNew)) {
                            return frameCaller.assignValue(this.aiReturn[0], xBoolean.FALSE);
                        }
                        this.hExpect = hCurrent;
                        continue block5;
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        this.hExpect = hCurrent;
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
    }
}

