/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.annotations;

import java.util.concurrent.atomic.AtomicReference;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.annotations.xAtomic;
import org.xvm.runtime.template.annotations.xAtomicIntNumber;
import org.xvm.runtime.template.numbers.BaseInt128;
import org.xvm.runtime.template.numbers.LongLong;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;

public class xAtomicInt128
extends xAtomic {
    private final BaseInt128 f_templateReferent;

    public xAtomicInt128(BaseInt128 templateIntBase) {
        super(templateIntBase.f_container, xAtomicIntNumber.INSTANCE.getStructure(), false);
        this.f_templateReferent = templateIntBase;
    }

    @Override
    public xRef.RefHandle createRefHandle(Frame frame, TypeComposition clazz, String sName) {
        return new AtomicLongLongHandle(clazz.ensureAccess(Constants.Access.PUBLIC), sName);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "exchange": {
                AtomicLongLongHandle hThis = (AtomicLongLongHandle)hTarget;
                AtomicReference<LongLong> atomic = hThis.m_atomicValue;
                if (atomic == null) {
                    return frame.raiseException(xException.unassignedReference(frame));
                }
                LongLong llNew = ((BaseInt128.LongLongHandle)hArg).getValue();
                LongLong llOld = atomic.getAndSet(llNew);
                return frame.assignValue(iReturn, this.f_templateReferent.makeHandle(llOld));
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "replaceFailed": {
                LongLong llCur;
                AtomicLongLongHandle hThis = (AtomicLongLongHandle)hTarget;
                AtomicReference<LongLong> atomic = hThis.m_atomicValue;
                if (atomic == null) {
                    return frame.raiseException(xException.unassignedReference(frame));
                }
                LongLong llExpect = ((BaseInt128.LongLongHandle)ahArg[0]).getValue();
                LongLong llNew = ((BaseInt128.LongLongHandle)ahArg[1]).getValue();
                while ((llCur = atomic.get()).equals(llExpect)) {
                    if (!atomic.compareAndSet(llCur, llNew)) continue;
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                return frame.assignValues(aiReturn, xBoolean.TRUE, this.f_templateReferent.makeHandle(llCur));
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    protected int invokeGetReferent(Frame frame, xRef.RefHandle hTarget, int iReturn) {
        return this.getReferentImpl(frame, hTarget, false, iReturn);
    }

    @Override
    protected int invokeSetReferent(Frame frame, xRef.RefHandle hTarget, ObjectHandle hValue) {
        return this.setReferentImpl(frame, hTarget, false, hValue);
    }

    @Override
    protected int getReferentImpl(Frame frame, xRef.RefHandle hTarget, boolean fNative, int iReturn) {
        AtomicLongLongHandle hThis = (AtomicLongLongHandle)hTarget;
        AtomicReference<LongLong> atomic = hThis.m_atomicValue;
        return atomic == null ? frame.raiseException(xException.unassignedReference(frame)) : frame.assignValue(iReturn, this.f_templateReferent.makeHandle(atomic.get()));
    }

    @Override
    protected int setReferentImpl(Frame frame, xRef.RefHandle hTarget, boolean fNative, ObjectHandle hValue) {
        AtomicLongLongHandle hThis = (AtomicLongLongHandle)hTarget;
        AtomicReference<LongLong> atomic = hThis.m_atomicValue;
        LongLong llValue = ((BaseInt128.LongLongHandle)hValue).getValue();
        if (atomic == null) {
            hThis.m_atomicValue = new AtomicReference<LongLong>(llValue);
        } else {
            atomic.set(llValue);
        }
        return -1;
    }

    public static class AtomicLongLongHandle
    extends xRef.RefHandle {
        protected AtomicReference<LongLong> m_atomicValue;

        protected AtomicLongLongHandle(TypeComposition clazz, String sName) {
            super(clazz, sName);
        }

        @Override
        public boolean isAssigned() {
            return this.m_atomicValue != null;
        }

        @Override
        public String toString() {
            return "(Atomic " + this.m_clazz.getTemplate().f_sName + ")" + String.valueOf(this.m_atomicValue == null ? "unassigned" : this.m_atomicValue.get());
        }
    }
}

