/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.annotations;

import java.util.concurrent.atomic.AtomicLong;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.annotations.xAtomic;
import org.xvm.runtime.template.numbers.xConstrainedInteger;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;

public class xAtomicIntNumber
extends xAtomic {
    public static xAtomicIntNumber INSTANCE;
    private final xConstrainedInteger f_templateReferent;

    public xAtomicIntNumber(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
        this.f_templateReferent = null;
    }

    public xAtomicIntNumber(xConstrainedInteger templateIntNumber) {
        super(templateIntNumber.f_container, xAtomicIntNumber.INSTANCE.f_struct, false);
        this.f_templateReferent = templateIntNumber;
    }

    @Override
    public void initNative() {
    }

    @Override
    public xRef.RefHandle createRefHandle(Frame frame, TypeComposition clazz, String sName) {
        return new AtomicJavaLongHandle(clazz.ensureAccess(Constants.Access.PUBLIC), sName);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        AtomicJavaLongHandle hThis = (AtomicJavaLongHandle)hTarget;
        switch (method.getName()) {
            case "exchange": {
                AtomicLong atomic = hThis.m_atomicValue;
                if (atomic == null) {
                    return frame.raiseException(xException.unassignedReference(frame));
                }
                long lNew = ((ObjectHandle.JavaLong)hArg).getValue();
                long lOld = atomic.getAndSet(lNew);
                return frame.assignValue(iReturn, this.f_templateReferent.makeJavaLong(lOld));
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "replaceFailed": {
                long lCur;
                AtomicJavaLongHandle hThis = (AtomicJavaLongHandle)hTarget;
                AtomicLong atomic = hThis.m_atomicValue;
                if (atomic == null) {
                    return frame.raiseException(xException.unassignedReference(frame));
                }
                long lExpect = ((ObjectHandle.JavaLong)ahArg[0]).getValue();
                long lNew = ((ObjectHandle.JavaLong)ahArg[1]).getValue();
                while ((lCur = atomic.get()) == lExpect) {
                    if (!atomic.compareAndSet(lCur, lNew)) continue;
                    return frame.assignValue(aiReturn[0], xBoolean.FALSE);
                }
                return frame.assignValues(aiReturn, xBoolean.TRUE, this.f_templateReferent.makeJavaLong(lCur));
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    protected int invokeGetReferent(Frame frame, xRef.RefHandle hTarget, int iReturn) {
        return this.getReferentImpl(frame, hTarget, false, iReturn);
    }

    @Override
    protected int invokeSetReferent(Frame frame, xRef.RefHandle hTarget, ObjectHandle hValue) {
        return this.setReferentImpl(frame, hTarget, false, hValue);
    }

    @Override
    protected int getReferentImpl(Frame frame, xRef.RefHandle hTarget, boolean fNative, int iReturn) {
        AtomicJavaLongHandle hAtomic = (AtomicJavaLongHandle)hTarget;
        AtomicLong atomic = hAtomic.m_atomicValue;
        return atomic == null ? frame.raiseException(xException.unassignedReference(frame)) : frame.assignValue(iReturn, this.f_templateReferent.makeJavaLong(atomic.get()));
    }

    @Override
    protected int setReferentImpl(Frame frame, xRef.RefHandle hTarget, boolean fNative, ObjectHandle hValue) {
        AtomicJavaLongHandle hAtomic = (AtomicJavaLongHandle)hTarget;
        AtomicLong atomic = hAtomic.m_atomicValue;
        long lValue = ((ObjectHandle.JavaLong)hValue).getValue();
        if (atomic == null) {
            hAtomic.m_atomicValue = new AtomicLong(lValue);
        } else {
            atomic.set(lValue);
        }
        return -1;
    }

    public static class AtomicJavaLongHandle
    extends xRef.RefHandle {
        protected AtomicLong m_atomicValue;

        protected AtomicJavaLongHandle(TypeComposition clazz, String sName) {
            super(clazz, sName);
        }

        @Override
        public boolean isAssigned() {
            return this.m_atomicValue != null;
        }

        @Override
        public String toString() {
            return "(AtomicIntNumber) " + String.valueOf(this.m_atomicValue == null ? "unassigned" : Long.valueOf(this.m_atomicValue.get()));
        }
    }
}

