/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.annotations;

import java.util.concurrent.CompletableFuture;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.reflect.xVar;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xNullable;
import org.xvm.runtime.template.xService;

public class xFuture
extends xVar {
    public static xFuture INSTANCE;
    public static TypeConstant TYPE;
    public static xEnum COMPLETION;

    public xFuture(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.pool();
        ClassConstant idMixin = (ClassConstant)this.f_struct.getIdentityConstant();
        Annotation anno = pool.ensureAnnotation(idMixin, new Constant[0]);
        TypeConstant typeVar = xVar.INSTANCE.getCanonicalType();
        TYPE = pool.ensureAnnotatedTypeConstant(typeVar, anno);
        COMPLETION = (xEnum)this.f_container.getTemplate("annotations.Future.Completion");
        this.markNativeMethod("thenDo", null, null);
        this.markNativeMethod("passTo", null, null);
        this.markNativeMethod("transform", null, null);
        this.markNativeMethod("handle", null, null);
        this.markNativeMethod("transformOrHandle", null, null);
        this.markNativeMethod("whenComplete", null, null);
        this.markNativeMethod("and", null, null);
        this.markNativeMethod("or", null, null);
        this.markNativeMethod("get", VOID, null);
        this.markNativeMethod("set", null, VOID);
        this.markNativeMethod("complete", null, VOID);
        this.markNativeMethod("completeExceptionally", null, VOID);
        this.markNativeProperty("assigned");
        this.markNativeProperty("completion");
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        return TYPE;
    }

    @Override
    public TypeComposition ensureClass(Container container, TypeConstant typeActual) {
        if (!typeActual.isAnnotated()) {
            ConstantPool pool = typeActual.getConstantPool();
            assert (typeActual.getDefiningConstant().equals(pool.clzFuture()));
            typeActual = pool.ensureFuture(typeActual.getParamType(0));
        }
        return super.ensureClass(container, typeActual);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        FutureHandle hThis = (FutureHandle)hTarget;
        switch (sPropName) {
            case "assigned": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(hThis.isAssigned()));
            }
            case "failure": {
                return frame.assignValue(iReturn, hThis.getException());
            }
            case "completion": {
                xEnum.EnumHandle hValue = hThis.isAssigned() ? (hThis.getFuture().isCompletedExceptionally() ? COMPLETION.getEnumByName("Error") : COMPLETION.getEnumByName("Result")) : COMPLETION.getEnumByName("Pending");
                return Utils.assignInitializedEnum(frame, hValue, iReturn);
            }
            case "notify": {
                return frame.assignValue(iReturn, xNullable.NULL);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        FutureHandle hThis = (FutureHandle)hTarget;
        switch (method.getName()) {
            case "complete": {
                return hThis.complete(hArg, null);
            }
            case "completeExceptionally": {
                return hThis.complete(null, (ObjectHandle.ExceptionHandle)hArg);
            }
            case "thenDo": {
                return this.invokeThenDo(frame, hThis, (xRTFunction.FunctionHandle)hArg, iReturn);
            }
            case "passTo": {
                return this.invokePassTo(frame, hThis, (xRTFunction.FunctionHandle)hArg, iReturn);
            }
            case "handle": {
                return this.invokeHandle(frame, hThis, (xRTFunction.FunctionHandle)hArg, iReturn);
            }
            case "or": {
                return this.invokeOrFuture(frame, hThis, (FutureHandle)hArg, iReturn);
            }
            case "whenComplete": {
                return this.invokeWhenComplete(frame, hThis, (xRTFunction.FunctionHandle)hArg, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        FutureHandle hThis = (FutureHandle)hTarget;
        switch (method.getName()) {
            case "transform": {
                return this.invokeTransform(frame, hThis, (xRTType.TypeHandle)ahArg[0], (xRTFunction.FunctionHandle)ahArg[1], iReturn);
            }
            case "transformOrHandle": {
                return this.invokeTransformOrHandle(frame, hThis, (xRTType.TypeHandle)ahArg[0], (xRTFunction.FunctionHandle)ahArg[1], iReturn);
            }
            case "and": {
                return this.invokeAndFuture(frame, hThis, (xRTType.TypeHandle)ahArg[0], (xRTType.TypeHandle)ahArg[1], (FutureHandle)ahArg[2], (xRTFunction.FunctionHandle)ahArg[3], iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        FutureHandle hVar1 = (FutureHandle)hValue1;
        FutureHandle hVar2 = (FutureHandle)hValue2;
        return frame.assignValue(iReturn, xBoolean.makeHandle(hVar1.getFuture() == hVar2.getFuture()));
    }

    protected int invokeThenDo(Frame frame, FutureHandle hThis, xRTFunction.FunctionHandle hRun, int iReturn) {
        CompletableFuture<ObjectHandle> cfThis = hThis.getFuture();
        if (cfThis.isDone()) {
            ObjectHandle[] ahR = this.extractResult(frame, cfThis);
            if (ahR[1] != xNullable.NULL) {
                return frame.raiseException((ObjectHandle.ExceptionHandle)ahR[1]);
            }
            switch (hRun.call1(frame, null, Utils.OBJECTS_NONE, -2)) {
                case -1: {
                    return frame.assignValue(iReturn, hThis);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, hThis));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        FutureHandle hThen = xFuture.makeHandle(hThis.getComposition(), new CompletableFuture<ObjectHandle>());
        cfThis.whenComplete((hR, ex) -> {
            if (ex == null) {
                CompletableFuture<ObjectHandle> cfThen = frame.f_context.postRequest(frame, hRun, Utils.OBJECTS_NONE, 0);
                cfThen.whenComplete((hVoid, exThen) -> hThen.complete((ObjectHandle)hR, Utils.translate(exThen)));
            } else {
                hThen.complete(null, Utils.translate(ex));
            }
        });
        return frame.assignValue(iReturn, hThen);
    }

    protected int invokePassTo(Frame frame, FutureHandle hThis, xRTFunction.FunctionHandle hConsume, int iReturn) {
        CompletableFuture<ObjectHandle> cfThis = hThis.getFuture();
        if (cfThis.isDone()) {
            ObjectHandle[] ahR = this.extractResult(frame, cfThis);
            if (ahR[1] != xNullable.NULL) {
                return frame.raiseException((ObjectHandle.ExceptionHandle)ahR[1]);
            }
            ahR[1] = null;
            switch (hConsume.call1(frame, null, ahR, -2)) {
                case -1: {
                    return frame.assignValue(iReturn, hThis);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, hThis));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        FutureHandle hPass = xFuture.makeHandle(hThis.getComposition(), new CompletableFuture<ObjectHandle>());
        cfThis.whenComplete((hR, ex) -> {
            if (ex == null) {
                CompletableFuture<ObjectHandle> cfPass = frame.f_context.postRequest(frame, hConsume, new ObjectHandle[]{hR}, 0);
                cfPass.whenComplete((hVoid, exPass) -> hPass.complete((ObjectHandle)hR, Utils.translate(exPass)));
            } else {
                hPass.complete(null, Utils.translate(ex));
            }
        });
        return frame.assignValue(iReturn, hPass);
    }

    protected int invokeTransform(Frame frame, FutureHandle hThis, xRTType.TypeHandle hNewType, xRTFunction.FunctionHandle hConvert, int iReturn) {
        CompletableFuture<ObjectHandle> cfThis = hThis.getFuture();
        TypeComposition clzTrans = this.ensureComposition(frame.f_context.f_container, hNewType.getDataType());
        if (cfThis.isDone()) {
            ObjectHandle[] ahR = this.extractResult(frame, cfThis);
            if (ahR[1] != xNullable.NULL) {
                return frame.raiseException((ObjectHandle.ExceptionHandle)ahR[1]);
            }
            ahR[1] = null;
            switch (hConvert.call1(frame, null, ahR, -1)) {
                case -1: {
                    return frame.assignValue(iReturn, xFuture.makeHandle(clzTrans, CompletableFuture.completedFuture(frame.popStack())));
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, xFuture.makeHandle(clzTrans, CompletableFuture.completedFuture(frameCaller.popStack()))));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        FutureHandle hTrans = xFuture.makeHandle(clzTrans, new CompletableFuture<ObjectHandle>());
        cfThis.whenComplete((hR, ex) -> {
            if (ex == null) {
                CompletableFuture<ObjectHandle> cfTrans = frame.f_context.postRequest(frame, hConvert, new ObjectHandle[]{hR}, 1);
                cfTrans.whenComplete((hNew, exTrans) -> hTrans.complete((ObjectHandle)hNew, Utils.translate(exTrans)));
            } else {
                hTrans.complete(null, Utils.translate(ex));
            }
        });
        return frame.assignValue(iReturn, hTrans);
    }

    protected int invokeHandle(Frame frame, FutureHandle hThis, xRTFunction.FunctionHandle hConvert, int iReturn) {
        CompletableFuture<ObjectHandle> cfThis = hThis.getFuture();
        TypeComposition clzHandle = hThis.getComposition();
        if (cfThis.isDone()) {
            if (!cfThis.isCompletedExceptionally()) {
                return frame.assignValue(iReturn, hThis);
            }
            ObjectHandle[] ahR = this.extractResult(frame, cfThis);
            assert (ahR[0] == xNullable.NULL);
            ahR[0] = ahR[1];
            ahR[1] = null;
            switch (hConvert.call1(frame, null, ahR, -1)) {
                case -1: {
                    return frame.assignValue(iReturn, xFuture.makeHandle(clzHandle, CompletableFuture.completedFuture(frame.popStack())));
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, xFuture.makeHandle(clzHandle, CompletableFuture.completedFuture(frameCaller.popStack()))));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        FutureHandle hHandle = xFuture.makeHandle(clzHandle, new CompletableFuture<ObjectHandle>());
        cfThis.whenComplete((hR, ex) -> {
            if (ex == null) {
                hHandle.complete((ObjectHandle)hR, null);
            } else {
                ObjectHandle.ExceptionHandle hEx = Utils.translate(ex);
                CompletableFuture<ObjectHandle> cfTrans = frame.f_context.postRequest(frame, hConvert, new ObjectHandle[]{hEx}, 1);
                cfTrans.whenComplete((hNew, exTrans) -> hHandle.complete((ObjectHandle)hNew, Utils.translate(exTrans)));
            }
        });
        return frame.assignValue(iReturn, hHandle);
    }

    protected int invokeTransformOrHandle(Frame frame, FutureHandle hThis, xRTType.TypeHandle hNewType, xRTFunction.FunctionHandle hConvert, int iReturn) {
        CompletableFuture<ObjectHandle> cfThis = hThis.getFuture();
        TypeComposition clzTrans = this.ensureComposition(frame.f_context.f_container, hNewType.getDataType());
        if (cfThis.isDone()) {
            ObjectHandle[] ahR = this.extractResult(frame, cfThis);
            switch (hConvert.call1(frame, null, ahR, -1)) {
                case -1: {
                    return frame.assignValue(iReturn, xFuture.makeHandle(clzTrans, CompletableFuture.completedFuture(frame.popStack())));
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, xFuture.makeHandle(clzTrans, CompletableFuture.completedFuture(frameCaller.popStack()))));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        FutureHandle hTrans = xFuture.makeHandle(clzTrans, new CompletableFuture<ObjectHandle>());
        cfThis.whenComplete((hR, ex) -> {
            CompletableFuture<ObjectHandle> cfTrans = frame.f_context.postRequest(frame, hConvert, this.combineResult((ObjectHandle)hR, (Throwable)ex), 1);
            cfTrans.whenComplete((hNew, exTrans) -> hTrans.complete((ObjectHandle)hNew, Utils.translate(exTrans)));
        });
        return frame.assignValue(iReturn, hTrans);
    }

    protected int invokeAndFuture(Frame frame, FutureHandle hThis, xRTType.TypeHandle hOtherType, xRTType.TypeHandle hNewType, FutureHandle hThat, xRTFunction.FunctionHandle hCombine, int iReturn) {
        CompletableFuture<ObjectHandle> cfThis = hThis.getFuture();
        CompletableFuture<ObjectHandle> cfThat = hThat.getFuture();
        TypeComposition clzAnd = this.ensureComposition(frame.f_context.f_container, hNewType.getDataType());
        if (cfThis.isDone() && cfThat.isDone()) {
            ObjectHandle[] ahRThis = this.extractResult(frame, cfThis);
            ObjectHandle[] ahRThat = this.extractResult(frame, cfThis);
            if (ahRThis[1] != xNullable.NULL) {
                return frame.raiseException((ObjectHandle.ExceptionHandle)ahRThis[1]);
            }
            if (ahRThat[1] != xNullable.NULL) {
                return frame.raiseException((ObjectHandle.ExceptionHandle)ahRThat[1]);
            }
            ObjectHandle[] ahArg = new ObjectHandle[]{ahRThis[0], ahRThat[0]};
            switch (hCombine.call1(frame, null, ahArg, -1)) {
                case -1: {
                    return frame.assignValue(iReturn, xFuture.makeHandle(clzAnd, CompletableFuture.completedFuture(frame.popStack())));
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, xFuture.makeHandle(clzAnd, CompletableFuture.completedFuture(frameCaller.popStack()))));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        FutureHandle hAnd = xFuture.makeHandle(clzAnd, new CompletableFuture<ObjectHandle>());
        CompletableFuture.allOf(cfThis, cfThat).whenComplete((_null, ex) -> {
            if (ex == null) {
                ObjectHandle[] ahArg;
                block4: {
                    ahArg = new ObjectHandle[2];
                    try {
                        ahArg[0] = (ObjectHandle)cfThis.get();
                        ahArg[1] = (ObjectHandle)cfThat.get();
                    }
                    catch (Throwable e) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
                CompletableFuture<ObjectHandle> cfAnd = frame.f_context.postRequest(frame, hCombine, ahArg, 1);
                cfAnd.whenComplete((hNew, exTrans) -> hAnd.complete((ObjectHandle)hNew, Utils.translate(exTrans)));
            } else {
                hAnd.complete(null, Utils.translate(ex));
            }
        });
        return frame.assignValue(iReturn, hAnd);
    }

    protected int invokeOrFuture(Frame frame, FutureHandle hThis, FutureHandle hThat, int iReturn) {
        CompletableFuture<ObjectHandle> cfThis = hThis.getFuture();
        CompletableFuture<ObjectHandle> cfThat = hThat.getFuture();
        if (cfThis.isDone()) {
            return frame.assignValue(iReturn, hThis);
        }
        if (cfThat.isDone()) {
            return frame.assignValue(iReturn, hThat);
        }
        CompletableFuture<Object> cfAny = CompletableFuture.anyOf(cfThis, cfThat);
        return frame.assignValue(iReturn, xFuture.makeHandle(hThis.getComposition(), cfAny));
    }

    protected int invokeWhenComplete(Frame frame, FutureHandle hThis, xRTFunction.FunctionHandle hNotify, int iReturn) {
        CompletableFuture<ObjectHandle> cfThis = hThis.getFuture();
        if (cfThis.isDone()) {
            ObjectHandle[] ahR = this.extractResult(frame, cfThis);
            switch (hNotify.call1(frame, null, ahR, -2)) {
                case -1: {
                    return frame.assignValue(iReturn, hThis);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(iReturn, hThis));
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        FutureHandle hWhen = xFuture.makeHandle(hThis.getComposition(), new CompletableFuture<ObjectHandle>());
        cfThis.whenComplete((hR, ex) -> {
            CompletableFuture<ObjectHandle> cfWhen = frame.f_context.postRequest(frame, hNotify, this.combineResult((ObjectHandle)hR, (Throwable)ex), 0);
            cfWhen.whenComplete((hVoid, exWhen) -> {
                if (exWhen == null && ex == null) {
                    hWhen.complete((ObjectHandle)hR, null);
                } else {
                    hWhen.complete(null, Utils.translate(exWhen == null ? ex : exWhen));
                }
            });
        });
        return frame.assignValue(iReturn, hWhen);
    }

    protected ObjectHandle[] extractResult(Frame frame, CompletableFuture<ObjectHandle> cf) {
        ObjectHandle[] ahR = new ObjectHandle[2];
        try {
            ahR[0] = cf.get();
            ahR[1] = xNullable.NULL;
        }
        catch (Throwable e) {
            ahR[0] = xNullable.NULL;
            ahR[1] = Utils.translate(e);
        }
        return ahR;
    }

    protected ObjectHandle[] combineResult(ObjectHandle hResult, Throwable exception) {
        ObjectHandle[] ahArg = new ObjectHandle[]{hResult == null ? xNullable.NULL : hResult, exception == null ? xNullable.NULL : Utils.translate(exception)};
        return ahArg;
    }

    @Override
    public xRef.RefHandle createRefHandle(Frame frame, TypeComposition clazz, String sName) {
        return new FutureHandle(clazz.ensureAccess(Constants.Access.PUBLIC), sName, new CompletableFuture<ObjectHandle>());
    }

    @Override
    protected int invokeNativeGetReferent(Frame frame, xRef.RefHandle hRef, int iReturn) {
        return this.invokeGetReferent(frame, hRef, iReturn);
    }

    @Override
    protected int invokeGetReferent(Frame frame, xRef.RefHandle hRef, int iReturn) {
        return this.getReferentImpl(frame, hRef, true, iReturn);
    }

    @Override
    protected int getReferentImpl(Frame frame, xRef.RefHandle hRef, boolean fNative, int iReturn) {
        ObjectHandle hHolder;
        if (hRef.isProperty() && (hHolder = hRef.getReferentHolder()).isService()) {
            xService.ServiceHandle hService = hHolder.getService();
            if (frame.f_context != hService.f_context) {
                return hService.f_context.sendProperty01Request(frame, hRef, null, iReturn, (frameCaller, hTarget, idProp_, iRet) -> this.getReferentImpl(frameCaller, (xRef.RefHandle)hTarget, true, iRet));
            }
        }
        return ((FutureHandle)hRef).waitAndAssign(frame, iReturn);
    }

    @Override
    protected int invokeSetReferent(Frame frame, xRef.RefHandle hTarget, ObjectHandle hValue) {
        return this.setReferentImpl(frame, hTarget, true, hValue);
    }

    @Override
    protected int setReferentImpl(Frame frame, xRef.RefHandle hRef, boolean fNative, ObjectHandle hValue) {
        ObjectHandle hHolder;
        if (hRef.isProperty() && (hHolder = hRef.getReferentHolder()).isService()) {
            xService.ServiceHandle hService = hHolder.getService();
            if (frame.f_context != hService.f_context) {
                return hService.f_context.sendProperty10Request(frame, hRef, null, hValue, (frameCaller, hTarget, null_, hVal) -> this.setReferentImpl(frameCaller, (xRef.RefHandle)hTarget, true, hVal));
            }
        }
        CompletableFuture<ObjectHandle> cfThis = ((FutureHandle)hRef).getFuture();
        assert (hValue != null);
        if (hValue instanceof FutureHandle) {
            FutureHandle hFuture = (FutureHandle)hValue;
            CompletableFuture<ObjectHandle> cfThat = hFuture.getFuture();
            cfThat.whenComplete((r, e) -> {
                if (e == null) {
                    cfThis.complete((ObjectHandle)r);
                } else {
                    cfThis.completeExceptionally((Throwable)e);
                }
            });
            return -1;
        }
        if (cfThis.isDone()) {
            return frame.raiseException("Future has already been set");
        }
        cfThis.complete(hValue);
        return -1;
    }

    private TypeComposition ensureComposition(Container container, TypeConstant typeReferent) {
        return this.ensureClass(container, typeReferent.getConstantPool().ensureFuture(typeReferent));
    }

    public static int assignCompleted(Frame frame, CompletableFuture<ObjectHandle> cf, int iReturn) {
        try {
            ObjectHandle hValue = cf.get();
            return hValue == ObjectHandle.DEFAULT ? -1 : frame.assignValue(iReturn, hValue);
        }
        catch (Throwable e) {
            return frame.raiseException(Utils.translate(e));
        }
    }

    public static FutureHandle makeHandle(CompletableFuture<ObjectHandle> future) {
        return xFuture.makeHandle(INSTANCE.getCanonicalClass(), future);
    }

    public static FutureHandle makeHandle(TypeComposition clz, CompletableFuture<ObjectHandle> future) {
        return new FutureHandle(clz, null, future);
    }

    public static class FutureHandle
    extends xRef.RefHandle {
        private final CompletableFuture<ObjectHandle> f_future;

        protected FutureHandle(TypeComposition clazz, String sName, CompletableFuture<ObjectHandle> future) {
            super(clazz, sName);
            this.f_future = future;
        }

        @Override
        public boolean isAssigned() {
            return this.getFuture().isDone();
        }

        @Override
        public ObjectHandle getReferent() {
            CompletableFuture<ObjectHandle> future = this.getFuture();
            if (future != null && future.isDone()) {
                try {
                    return future.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public CompletableFuture<ObjectHandle> getFuture() {
            return this.f_future;
        }

        public ObjectHandle.ExceptionHandle getException() {
            CompletableFuture<ObjectHandle> future = this.getFuture();
            if (future.isCompletedExceptionally()) {
                try {
                    future.get();
                    throw new IllegalStateException();
                }
                catch (Exception e) {
                    return Utils.translate(e);
                }
            }
            return null;
        }

        public int complete(ObjectHandle hValue, ObjectHandle.ExceptionHandle hException) {
            CompletableFuture<ObjectHandle> cf = this.getFuture();
            if (!cf.isDone()) {
                if (hException == null) {
                    assert (hValue != null);
                    cf.complete(hValue);
                } else {
                    cf.completeExceptionally(hException.getException());
                }
            }
            return -1;
        }

        public int waitAndAssign(Frame frame, int iReturn) {
            return this.isAssigned() ? this.assign(frame, iReturn) : frame.call(frame.createWaitFrame(this, iReturn));
        }

        protected int assign(Frame frame, int iReturn) {
            CompletableFuture<ObjectHandle> cf = this.getFuture();
            assert (cf.isDone());
            return xFuture.assignCompleted(frame, cf, iReturn);
        }

        @Override
        public String toString() {
            return "(" + String.valueOf(this.m_clazz) + ") " + (String)(this.getFuture().isDone() ? "Completed: " + this.toSafeString() : "Not completed");
        }

        protected String toSafeString() {
            try {
                return String.valueOf(this.getFuture().get());
            }
            catch (Throwable e) {
                return Utils.translate(e).toString();
            }
        }
    }

    public static class FutureTupleHandle
    extends FutureHandle {
        private final ObjectHandle[] f_ahValue;

        public FutureTupleHandle(TypeComposition clazz, ObjectHandle[] ahValue) {
            super(clazz, (String)null, (CompletableFuture<ObjectHandle>)null);
            this.f_ahValue = ahValue;
        }

        @Override
        public CompletableFuture<ObjectHandle> getFuture() {
            CompletableFuture<ObjectHandle> cfLast = null;
            for (ObjectHandle hValue : this.f_ahValue) {
                FutureHandle hFuture;
                if (hValue instanceof FutureHandle && !(cfLast = (hFuture = (FutureHandle)hValue).getFuture()).isDone()) break;
            }
            return cfLast;
        }

        @Override
        protected int assign(Frame frame, int iReturn) {
            for (ObjectHandle hValue : this.f_ahValue) {
                if (!(hValue instanceof FutureHandle)) continue;
                FutureHandle hFuture = (FutureHandle)hValue;
                assert (hFuture.isAssigned());
                try {
                    this.f_ahValue[i] = hFuture.getFuture().get();
                }
                catch (Throwable e) {
                    return frame.raiseException(Utils.translate(e));
                }
            }
            TypeComposition clzTuple = this.getType().getParamType(0).ensureClass(frame);
            return frame.assignValue(iReturn, xTuple.makeHandle(clzTuple, this.f_ahValue));
        }
    }
}

