/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.annotations;

import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.Constants;
import org.xvm.asm.Op;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xNullable;

public class xInject
extends xRef {
    public static xInject INSTANCE;

    public xInject(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
    }

    @Override
    public ClassTemplate getTemplate(TypeConstant type) {
        return this;
    }

    @Override
    public xRef.RefHandle createRefHandle(Frame frame, TypeComposition clazz, String sName) {
        String sResource;
        Constant constName;
        if (sName == null) {
            throw new IllegalArgumentException("Name is not present");
        }
        Annotation anno = clazz.getType().getAnnotations()[0];
        Constant[] aParams = anno.getParams();
        Constant constant = constName = aParams.length == 0 ? null : aParams[0];
        if (constName instanceof StringConstant) {
            StringConstant constString = (StringConstant)constName;
            v1 = constString.getValue();
        } else {
            v1 = sResource = sName;
        }
        if (aParams.length < 2) {
            InjectedHandle hInject = new InjectedHandle(clazz.ensureAccess(Constants.Access.PUBLIC), sName, sResource);
            hInject.setField(frame, "resourceName", (ObjectHandle)xString.makeHandle(sResource));
            hInject.setField(frame, "opts", (ObjectHandle)xNullable.NULL);
            hInject.makeImmutable();
            return hInject;
        }
        assert (clazz.isStruct());
        return new InjectedHandle(clazz, sName, sResource);
    }

    @Override
    protected int postValidate(Frame frame, ObjectHandle hStruct) {
        if (hStruct.isMutable()) {
            hStruct.makeImmutable();
        }
        return -1;
    }

    @Override
    public int getReferent(Frame frame, xRef.RefHandle hTarget, int iReturn) {
        InjectedHandle hInjected = (InjectedHandle)hTarget;
        ObjectHandle hValue = hInjected.getReferent();
        if (hValue == null) {
            ObjectHandle hOpts;
            TypeConstant typeResource = hInjected.getType().resolveGenericType("Referent");
            String sResource = hInjected.getResourceName();
            hValue = frame.getInjected(sResource, typeResource, hOpts = hInjected.getField(frame, "opts"));
            if (hValue == null) {
                return frame.raiseException(xException.unknownInjectable(frame, typeResource, sResource));
            }
            if (Op.isDeferred(hValue)) {
                return hValue.proceed(frame, frameCaller -> {
                    ObjectHandle hVal = frameCaller.popStack();
                    hInjected.setReferent(hVal);
                    return frameCaller.assignValue(iReturn, hVal);
                });
            }
            hInjected.setReferent(hValue);
        }
        return frame.assignValue(iReturn, hValue);
    }

    @Override
    protected int getPropertyAssigned(Frame frame, xRef.RefHandle hRef, int iReturn) {
        switch (this.getReferent(frame, hRef, -1)) {
            case -1: {
                frame.popStack();
                return frame.assignValue(iReturn, xBoolean.TRUE);
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> {
                    if (frameCaller.clearException() == null) {
                        frameCaller.popStack();
                        return frameCaller.assignValue(iReturn, xBoolean.TRUE);
                    }
                    return frameCaller.assignValue(iReturn, xBoolean.FALSE);
                });
                return -5;
            }
            case -3: {
                frame.clearException();
                return frame.assignValue(iReturn, xBoolean.FALSE);
            }
        }
        throw new IllegalStateException();
    }

    public static class InjectedHandle
    extends xRef.RefHandle {
        private final String f_sResource;

        protected InjectedHandle(TypeComposition clazz, String sVarName, String sResourceName) {
            super(clazz, sVarName);
            this.f_sResource = sResourceName;
        }

        public String getResourceName() {
            return this.f_sResource;
        }

        @Override
        public ObjectHandle getReferent() {
            return this.m_hReferent;
        }

        @Override
        public void setReferent(ObjectHandle hReferent) {
            assert (this.m_hReferent == null);
            this.m_hReferent = hReferent;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.f_sResource;
        }
    }
}

