/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.collections;

import java.util.HashMap;
import java.util.Map;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.IndexSupport;
import org.xvm.runtime.template._native.collections.arrays.BitBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTBitDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTBooleanDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTCharDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTUInt8Delegate;
import org.xvm.runtime.template._native.collections.arrays.xRTViewToBit;
import org.xvm.runtime.template._native.reflect.xRTFunction;
import org.xvm.runtime.template.collections.xBitArray;
import org.xvm.runtime.template.collections.xByteArray;
import org.xvm.runtime.template.collections.xNibbleArray;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.util.Handy;

public class xArray
extends ClassTemplate
implements IndexSupport {
    public static xArray INSTANCE;
    public static xEnum MUTABILITY;
    private static final MethodConstant[] CONSTRUCTORS;
    protected static final String[] ELEMENT_TYPE;
    private static TypeComposition OBJECT_ARRAY_CLZ;
    private static TypeComposition STRING_ARRAY_CLZ;
    private static TypeComposition BIT_ARRAY_CLZ;
    private static TypeComposition BOOLEAN_ARRAY_CLZ;
    private static TypeComposition BYTE_ARRAY_CLZ;
    private static TypeComposition CHAR_ARRAY_CLZ;
    private static MethodStructure CREATE_LIST_SET;
    private static MethodStructure FILL_FROM_ITERABLE;
    private static MethodStructure LIST_INDEX_OF;
    private static Map<TypeConstant, xArray> ARRAY_TEMPLATES;
    private static ArrayHandle EMPTY_BYTE_ARRAY;

    public xArray(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void registerNativeTemplates() {
        if (this == INSTANCE) {
            this.registerNativeTemplate(new xBitArray(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xByteArray(this.f_container, this.f_struct, true));
            this.registerNativeTemplate(new xNibbleArray(this.f_container, this.f_struct, true));
        }
    }

    @Override
    public void initNative() {
        ConstantPool pool = this.f_container.getConstantPool();
        HashMap<TypeConstant, xArray> mapTemplates = new HashMap<TypeConstant, xArray>();
        mapTemplates.put(pool.typeBit(), xBitArray.INSTANCE);
        mapTemplates.put(pool.typeByte(), xByteArray.INSTANCE);
        ARRAY_TEMPLATES = mapTemplates;
        for (MethodStructure method : ((MultiMethodStructure)this.getStructure().getChild("construct")).methods()) {
            if (method.getAccess() == Constants.Access.PUBLIC) {
                TypeConstant typeParam0 = method.getParam(0).getType();
                if (method.getParamCount() == 1) {
                    if (typeParam0.equals(pool.typeInt64())) {
                        xArray.CONSTRUCTORS[0] = method.getIdentityConstant();
                        continue;
                    }
                    xArray.CONSTRUCTORS[3] = method.getIdentityConstant();
                    continue;
                }
                if (typeParam0.equals(pool.typeInt64())) {
                    xArray.CONSTRUCTORS[1] = method.getIdentityConstant();
                    continue;
                }
                xArray.CONSTRUCTORS[2] = method.getIdentityConstant();
                continue;
            }
            xArray.CONSTRUCTORS[4] = method.getIdentityConstant();
        }
        FILL_FROM_ITERABLE = xRTDelegate.INSTANCE.getStructure().findMethod("fillFromIterable", 4, new TypeConstant[0]);
        CREATE_LIST_SET = Utils.CONST_HELPER.findMethod("createListSet", 2, new TypeConstant[0]);
        MUTABILITY = (xEnum)this.f_container.getTemplate("collections.Array.Mutability");
        OBJECT_ARRAY_CLZ = this.f_container.resolveClass(pool.ensureArrayType(pool.typeObject()));
        STRING_ARRAY_CLZ = this.f_container.resolveClass(pool.ensureArrayType(pool.typeString()));
        BOOLEAN_ARRAY_CLZ = this.f_container.resolveClass(pool.ensureArrayType(pool.typeBoolean()));
        CHAR_ARRAY_CLZ = this.f_container.resolveClass(pool.ensureArrayType(pool.typeChar()));
        BIT_ARRAY_CLZ = this.f_container.resolveClass(pool.typeBitArray());
        BYTE_ARRAY_CLZ = this.f_container.resolveClass(pool.typeByteArray());
        ClassStructure clzList = this.f_container.getTemplate("collections.List").getStructure();
        LIST_INDEX_OF = clzList.findMethod("indexOf", m -> m.getParamCount() == 2 && m.getParam(0).getType().isA(pool.typeList()));
        this.markNativeProperty("delegate");
        this.markNativeProperty("mutability");
        this.markNativeMethod("clear", VOID, THIS);
        this.markNativeMethod("getElement", INT, ELEMENT_TYPE);
        this.markNativeMethod("setElement", null, VOID);
        this.markNativeMethod("elementAt", INT, null);
        this.markNativeMethod("slice", null, THIS);
        this.markNativeMethod("deleteAll", null, THIS);
        this.markNativeMethod("indexOf", new String[]{"collections.List", "numbers.Int64"}, new String[]{"Boolean", "numbers.Int64"});
        ClassTemplate mixinNumber = this.f_container.getTemplate("collections.arrays.NumberArray");
        mixinNumber.markNativeMethod("asBitArray", VOID, null);
        this.invalidateTypeInfo();
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    public TypeComposition ensureParameterizedClass(Container container, TypeConstant ... atypeParams) {
        assert (atypeParams.length == 1);
        xArray template = ARRAY_TEMPLATES.get(atypeParams[0]);
        return template == null ? super.ensureParameterizedClass(container, atypeParams) : template.getCanonicalClass();
    }

    @Override
    public ClassTemplate getTemplate(TypeConstant type) {
        xArray template = ARRAY_TEMPLATES.get(type.getParamType(0));
        return template == null ? this : template;
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        Frame.Continuation stepNext;
        ArrayConstant constArray = (ArrayConstant)constant;
        boolean fSet = switch (constArray.getFormat()) {
            case Constant.Format.Array -> false;
            case Constant.Format.Set -> true;
            default -> throw new IllegalStateException();
        };
        TypeConstant typeArray = constArray.getType();
        Constant[] aconst = constArray.getValue();
        int cSize = aconst.length;
        ObjectHandle[] ahValue = new ObjectHandle[cSize];
        boolean fDeferred = false;
        for (int i = 0; i < cSize; ++i) {
            ObjectHandle hValue = frame.getConstHandle(aconst[i]);
            if (Op.isDeferred(hValue)) {
                fDeferred = true;
            }
            ahValue[i] = hValue;
        }
        if (typeArray.containsFormalType(true)) {
            typeArray = typeArray.resolveGenerics(frame.poolContext(), frame.getGenericsResolver(typeArray.containsDynamicType()));
        }
        if (fSet) {
            TypeConstant typeEl = typeArray.getParamType(0);
            if (fDeferred) {
                stepNext = frameCaller -> this.createListSet(frameCaller, typeEl, ahValue);
                return new Utils.GetArguments(ahValue, stepNext).doNext(frame);
            }
            return this.createListSet(frame, typeEl, ahValue);
        }
        TypeComposition clzArray = frame.f_context.f_container.resolveClass(typeArray);
        if (fDeferred) {
            stepNext = frameCaller -> frameCaller.pushStack(xArray.createImmutableArray(clzArray, ahValue));
            return new Utils.GetArguments(ahValue, stepNext).doNext(frame);
        }
        return frame.pushStack(xArray.createImmutableArray(clzArray, ahValue));
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clzArray, ObjectHandle hParent, ObjectHandle[] ahVar, int iReturn) {
        int nScenario;
        MethodConstant idConstruct = constructor.getIdentityConstant();
        for (nScenario = 0; nScenario < 4 && !CONSTRUCTORS[nScenario].equals(idConstruct); ++nScenario) {
        }
        return switch (nScenario) {
            case 0 -> this.construct0(frame, clzArray, ahVar, iReturn);
            case 1 -> this.construct1(frame, clzArray, ahVar, iReturn);
            case 2 -> this.construct2(frame, clzArray, ahVar, iReturn);
            case 3 -> this.construct3(frame, clzArray, ahVar, iReturn);
            case 4 -> this.construct4(frame, clzArray, ahVar, iReturn);
            default -> frame.raiseException("Unknown constructor: " + ((Constant)idConstruct).getValueString());
        };
    }

    private int construct0(Frame frame, TypeComposition clzArray, ObjectHandle[] ahVar, int iReturn) {
        long cCapacity;
        ObjectHandle hCapacity = ahVar[0];
        long l = cCapacity = hCapacity == ObjectHandle.DEFAULT ? 0L : ((ObjectHandle.JavaLong)hCapacity).getValue();
        if (cCapacity < 0L || cCapacity > Integer.MAX_VALUE) {
            return frame.raiseException(xException.illegalArgument(frame, "Invalid array size: " + cCapacity));
        }
        ArrayHandle hArray = xArray.createEmptyArray(clzArray, (int)cCapacity, Mutability.Mutable);
        return frame.assignValue(iReturn, hArray);
    }

    private int construct1(Frame frame, TypeComposition clzArray, ObjectHandle[] ahVar, int iReturn) {
        ObjectHandle.JavaLong hCapacity = (ObjectHandle.JavaLong)ahVar[0];
        long cCapacity = hCapacity.getValue();
        if (cCapacity < 0L || cCapacity > Integer.MAX_VALUE) {
            return frame.raiseException(xException.illegalArgument(frame, "Invalid array size: " + cCapacity));
        }
        ArrayHandle hArray = xArray.createEmptyArray(clzArray, (int)cCapacity, Mutability.Fixed);
        int cSize = (int)cCapacity;
        if (cSize > 0) {
            hArray.m_hDelegate.m_cSize = cSize;
            ObjectHandle hValue = ahVar[1];
            TypeConstant typeEl = clzArray.getType().getParamType(0);
            if (hValue == ObjectHandle.DEFAULT) {
                hValue = frame.getConstHandle(typeEl.getDefaultValue());
                if (Op.isDeferred(hValue)) {
                    return hValue.proceed(frame, frameCaller -> this.fill(frameCaller, hArray, cSize, frameCaller.popStack(), iReturn));
                }
            } else {
                TypeConstant[] atypeRet;
                TypeConstant[] atypeParam;
                ConstantPool pool = frame.poolContext();
                TypeConstant typeValue = hValue.getType();
                if (typeValue.isA(pool.typeFunction()) && (atypeParam = pool.extractFunctionParams(typeValue)).length == 1 && atypeParam[0].equals(pool.typeInt64()) && (atypeRet = pool.extractFunctionReturns(typeValue)).length == 1 && atypeRet[0].isA(typeEl)) {
                    xRTFunction.FunctionHandle hfnSupplier = (xRTFunction.FunctionHandle)hValue;
                    int cArgs = hfnSupplier.getVarCount();
                    ObjectHandle[] ahArg = new ObjectHandle[cArgs];
                    Utils.ValueSupplier supplier = (frameCaller, index) -> {
                        ahArg[0] = xInt64.makeHandle(index);
                        return hfnSupplier.call1(frameCaller, null, ahArg, -1);
                    };
                    return new Utils.FillArray(hArray, cSize, supplier, iReturn).doNext(frame);
                }
            }
            return this.fill(frame, hArray, cSize, hValue, iReturn);
        }
        return frame.assignValue(iReturn, hArray);
    }

    private int construct2(Frame frame, TypeComposition clzArray, ObjectHandle[] ahVar, int iReturn) {
        int n;
        ObjectHandle hMutability = ahVar[0];
        ObjectHandle hIterable = ahVar[1];
        if (hIterable instanceof ArrayHandle) {
            ArrayHandle hA = (ArrayHandle)hIterable;
            n = (int)hA.m_hDelegate.m_cSize;
        } else {
            n = 0;
        }
        int cCapacity = n;
        ArrayHandle hArray = xArray.createEmptyArray(clzArray, cCapacity, Mutability.Mutable);
        ObjectHandle[] ahArg = new ObjectHandle[FILL_FROM_ITERABLE.getMaxVars()];
        ahArg[0] = clzArray.getType().getParamType(0).ensureTypeHandle(frame.f_context.f_container);
        ahArg[1] = hArray;
        ahArg[2] = hIterable;
        ahArg[3] = hMutability;
        return frame.call1(FILL_FROM_ITERABLE, null, ahArg, iReturn);
    }

    private int construct3(Frame frame, TypeComposition clzArray, ObjectHandle[] ahVar, int iReturn) {
        ArrayHandle hThat = (ArrayHandle)ahVar[0];
        Mutability mutability = hThat.getMutability();
        if (hThat.isMutable() && (mutability == Mutability.Mutable || mutability == Mutability.Fixed)) {
            ObjectHandle[] ahArg = new ObjectHandle[]{MUTABILITY.getEnumByOrdinal(mutability.ordinal()), hThat};
            return this.construct2(frame, clzArray, ahArg, iReturn);
        }
        ObjectHandle[] ahArg = new ObjectHandle[]{hThat.m_hDelegate, MUTABILITY.getEnumByOrdinal(mutability.ordinal())};
        return this.construct4(frame, clzArray, ahArg, iReturn);
    }

    private int construct4(Frame frame, TypeComposition clzArray, ObjectHandle[] ahVar, int iReturn) {
        ObjectHandle hTarget = ahVar[0];
        if (!(hTarget instanceof xRTDelegate.DelegateHandle)) {
            return frame.raiseException(xException.unsupported(frame));
        }
        xRTDelegate.DelegateHandle hDelegate = (xRTDelegate.DelegateHandle)hTarget;
        ObjectHandle hMutability = ahVar[1];
        ArrayHandle hArray = new ArrayHandle(clzArray, hDelegate, Mutability.values()[((xEnum.EnumHandle)hMutability).getOrdinal()]);
        if (hArray.m_mutability == Mutability.Constant) {
            hArray.makeImmutable();
        }
        return frame.assignValue(iReturn, hArray);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        switch (sPropName) {
            case "delegate": {
                return frame.assignValue(iReturn, hArray.m_hDelegate);
            }
            case "mutability": {
                return Utils.assignInitializedEnum(frame, MUTABILITY.getEnumByOrdinal(hArray.m_mutability.ordinal()), iReturn);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNativeSet(Frame frame, ObjectHandle hTarget, String sPropName, ObjectHandle hValue) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        switch (sPropName) {
            case "mutability": {
                Mutability mutability = Mutability.values()[((xEnum.EnumHandle)hValue).getOrdinal()];
                if (mutability.compareTo(hArray.m_mutability) > 0) {
                    return frame.raiseException(xException.illegalState(frame, hArray.m_mutability.toString()));
                }
                hArray.setMutability(mutability);
                return -1;
            }
        }
        return super.invokeNativeSet(frame, hTarget, sPropName, hValue);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "elementAt": {
                return this.makeRef(frame, hTarget, ((ObjectHandle.JavaLong)hArg).getValue(), false, iReturn);
            }
            case "getElement": {
                return this.extractArrayValue(frame, hTarget, ((ObjectHandle.JavaLong)hArg).getValue(), iReturn);
            }
            case "slice": {
                ObjectHandle.GenericHandle hInterval = (ObjectHandle.GenericHandle)hArg;
                long ixFrom = ((ObjectHandle.JavaLong)hInterval.getField(frame, "lowerBound")).getValue();
                long ixTo = ((ObjectHandle.JavaLong)hInterval.getField(frame, "upperBound")).getValue();
                boolean fExLower = ((xBoolean.BooleanHandle)hInterval.getField(frame, "lowerExclusive")).get();
                boolean fExUpper = ((xBoolean.BooleanHandle)hInterval.getField(frame, "upperExclusive")).get();
                boolean fReverse = ((xBoolean.BooleanHandle)hInterval.getField(frame, "descending")).get();
                return this.invokeSlice(frame, hTarget, ixFrom, fExLower, ixTo, fExUpper, fReverse, iReturn);
            }
            case "deleteAll": {
                ObjectHandle.GenericHandle hInterval = (ObjectHandle.GenericHandle)hArg;
                long ixFrom = ((ObjectHandle.JavaLong)hInterval.getField(frame, "lowerBound")).getValue();
                long ixTo = ((ObjectHandle.JavaLong)hInterval.getField(frame, "upperBound")).getValue();
                boolean fExLower = ((xBoolean.BooleanHandle)hInterval.getField(frame, "lowerExclusive")).get();
                boolean fExUpper = ((xBoolean.BooleanHandle)hInterval.getField(frame, "upperExclusive")).get();
                return this.invokeDeleteAll(frame, hTarget, ixFrom, fExLower, ixTo, fExUpper, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "asBitArray": {
                ArrayHandle hArray = (ArrayHandle)hTarget;
                Mutability mutability = hArray.m_mutability == Mutability.Constant || hArray.m_mutability == Mutability.Persistent ? Mutability.Constant : Mutability.Fixed;
                xRTDelegate.DelegateHandle hView = xRTViewToBit.INSTANCE.createBitViewDelegate(hArray.m_hDelegate, mutability);
                return frame.assignValue(iReturn, new ArrayHandle(xBitArray.INSTANCE.getCanonicalClass(), hView, mutability));
            }
            case "clear": {
                ArrayHandle hArray = (ArrayHandle)hTarget;
                Mutability mutability = hArray.m_mutability;
                if (hArray.m_hDelegate.m_cSize > 0L) {
                    switch (mutability.ordinal()) {
                        case 3: {
                            hArray.m_hDelegate = xArray.makeDelegate(hArray.getComposition(), 0, Utils.OBJECTS_NONE, mutability);
                            break;
                        }
                        case 2: {
                            return frame.raiseException(xException.readOnly(frame, mutability));
                        }
                        case 0: 
                        case 1: {
                            hArray = xArray.createEmptyArray(hArray.getComposition(), 0, mutability);
                        }
                    }
                }
                return frame.assignValue(iReturn, hArray);
            }
            case "setElement": {
                return this.assignArrayValue(frame, hTarget, ((ObjectHandle.JavaLong)ahArg[0]).getValue(), ahArg[1]);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (ahArg.length) {
            case 2: {
                switch (method.getName()) {
                    case "indexOf": {
                        ArrayHandle hThis = (ArrayHandle)hTarget;
                        ObjectHandle objectHandle = ahArg[0];
                        if (objectHandle instanceof ArrayHandle) {
                            ArrayHandle hThat = (ArrayHandle)objectHandle;
                            xRTDelegate.DelegateHandle hDelegateThis = hThis.m_hDelegate;
                            xRTDelegate.DelegateHandle hDelegateThat = hThat.m_hDelegate;
                            ClassTemplate classTemplate = hDelegateThis.getTemplate();
                            if (classTemplate instanceof xRTDelegate) {
                                ObjectHandle hStart;
                                int ofStart;
                                int iResult;
                                xRTDelegate templateThat;
                                xRTDelegate templateThis = (xRTDelegate)classTemplate;
                                classTemplate = hDelegateThat.getTemplate();
                                if (classTemplate instanceof xRTDelegate && templateThis == (templateThat = (xRTDelegate)classTemplate) && (iResult = templateThis.invokeIndexOf(frame, hDelegateThis, hDelegateThat, ofStart = (hStart = ahArg[1]) == ObjectHandle.DEFAULT ? 0 : (int)((ObjectHandle.JavaLong)hStart).getValue(), aiReturn)) < 0) {
                                    return iResult;
                                }
                            }
                        }
                        return frame.callN(LIST_INDEX_OF, hTarget, Utils.ensureSize(ahArg, LIST_INDEX_OF.getMaxVars()), aiReturn);
                    }
                }
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    public int createPropertyRef(Frame frame, ObjectHandle hTarget, PropertyConstant idProp, boolean fRO, int iReturn) {
        if ("delegate".equals(idProp.getName())) {
            ArrayHandle hArray = (ArrayHandle)hTarget;
            xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
            ConstantPool pool = frame.poolContext();
            TypeConstant typeRef = pool.ensureParameterizedTypeConstant(pool.typeVar(), hDelegate.getType());
            ClassComposition clzRef = frame.f_context.f_container.ensureClassComposition(typeRef, xRef.INSTANCE);
            xRef.RefHandle hRef = new xRef.RefHandle((TypeComposition)clzRef, "delegate", hDelegate);
            return frame.assignValue(iReturn, hRef);
        }
        return super.createPropertyRef(frame, hTarget, idProp, fRO, iReturn);
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        if (super.compareIdentity(hValue1, hValue2)) {
            return true;
        }
        ArrayHandle hArray1 = (ArrayHandle)hValue1;
        ArrayHandle hArray2 = (ArrayHandle)hValue2;
        return !hArray1.isMutable() && !hArray2.isMutable() && hArray1.m_hDelegate.getTemplate().compareIdentity(hArray1.m_hDelegate, hArray2.m_hDelegate);
    }

    @Override
    public int extractArrayValue(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        return ((xRTDelegate)hDelegate.getTemplate()).extractArrayValue(frame, hDelegate, lIndex, iReturn);
    }

    @Override
    public int assignArrayValue(Frame frame, ObjectHandle hTarget, long lIndex, ObjectHandle hValue) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        return ((xRTDelegate)hDelegate.getTemplate()).assignArrayValue(frame, hDelegate, lIndex, hValue);
    }

    @Override
    public TypeConstant getElementType(Frame frame, ObjectHandle hTarget, long lIndex) {
        return hTarget.getType().resolveGenericType("Element");
    }

    @Override
    public long size(ObjectHandle hTarget) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        return hArray.m_hDelegate.m_cSize;
    }

    @Override
    public int invokePreInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        return ((xRTDelegate)hDelegate.getTemplate()).invokePreInc(frame, (ObjectHandle)hDelegate, lIndex, iReturn);
    }

    @Override
    public int invokePostInc(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        return ((xRTDelegate)hDelegate.getTemplate()).invokePostInc(frame, (ObjectHandle)hDelegate, lIndex, iReturn);
    }

    @Override
    public int invokePreDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        return ((xRTDelegate)hDelegate.getTemplate()).invokePreDec(frame, (ObjectHandle)hDelegate, lIndex, iReturn);
    }

    @Override
    public int invokePostDec(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        return ((xRTDelegate)hDelegate.getTemplate()).invokePostDec(frame, (ObjectHandle)hDelegate, lIndex, iReturn);
    }

    @Override
    public ObjectHandle[] toArray(Frame frame, ObjectHandle hTarget) throws ObjectHandle.ExceptionHandle.WrapperException {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        return ((xRTDelegate)hDelegate.getTemplate()).toArray(frame, hDelegate);
    }

    private int createListSet(Frame frame, TypeConstant typeEl, ObjectHandle[] ahValue) {
        TypeConstant typeArray = frame.poolContext().ensureArrayType(typeEl);
        TypeComposition clzArray = frame.f_context.f_container.resolveClass(typeArray);
        return xArray.createListSet(frame, xArray.createImmutableArray(clzArray, ahValue), -1);
    }

    public static int createListSet(Frame frame, ArrayHandle hArray, int iResult) {
        ObjectHandle[] ahVar = new ObjectHandle[CREATE_LIST_SET.getMaxVars()];
        ahVar[0] = hArray.getType().getParamType(0).ensureTypeHandle(frame.f_context.f_container);
        ahVar[1] = hArray;
        return frame.call1(CREATE_LIST_SET, null, ahVar, iResult);
    }

    protected int invokeSlice(Frame frame, ObjectHandle hTarget, long ixLower, boolean fExLower, long ixUpper, boolean fExUpper, boolean fReverse, int iReturn) {
        int cSize;
        ArrayHandle hArray = (ArrayHandle)hTarget;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        xRTDelegate template = (xRTDelegate)hDelegate.getTemplate();
        if (fExLower) {
            ++ixLower;
        }
        if (ixLower < 0L) {
            return frame.raiseException(xException.outOfBounds(frame, ixLower, 0L));
        }
        if (fExUpper) {
            --ixUpper;
        }
        if (ixUpper >= (long)(cSize = (int)hDelegate.m_cSize)) {
            return frame.raiseException(xException.outOfBounds(frame, ixUpper, cSize));
        }
        xRTDelegate.DelegateHandle hSlice = template.slice(hDelegate, ixLower, ixUpper - ixLower + 1L, fReverse);
        if (hSlice != hDelegate) {
            Mutability mutability = hArray.m_mutability;
            if (mutability == Mutability.Mutable) {
                mutability = Mutability.Fixed;
            }
            hArray = new ArrayHandle(hArray.getComposition(), hSlice, mutability);
        }
        return frame.assignValue(iReturn, hArray);
    }

    protected int invokeDeleteAll(Frame frame, ObjectHandle hTarget, long ixLower, boolean fExLower, long ixUpper, boolean fExUpper, int iReturn) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        xRTDelegate template = (xRTDelegate)hDelegate.getTemplate();
        if (fExLower) {
            ++ixLower;
        }
        if (ixLower < 0L) {
            return frame.raiseException(xException.outOfBounds(frame, ixLower, 0L));
        }
        if (fExUpper) {
            --ixUpper;
        }
        int cSize = (int)hDelegate.m_cSize;
        if (ixUpper < 0L || ixUpper >= (long)cSize) {
            return frame.raiseException(xException.outOfBounds(frame, ixUpper, cSize));
        }
        Mutability mutability = hArray.m_mutability;
        if (mutability == Mutability.Fixed) {
            return frame.raiseException(xException.sizeLimited(frame, "Fixed size array"));
        }
        xRTDelegate.DelegateHandle hDelegateNew = template.deleteRange(hDelegate, ixLower, ixUpper - ixLower + 1L);
        if (hDelegateNew != hDelegate) {
            if (hDelegateNew == null) {
                return frame.raiseException(xException.readOnly(frame, mutability));
            }
            hArray = new ArrayHandle(hArray.getComposition(), hDelegateNew, mutability);
        }
        return frame.assignValue(iReturn, hArray);
    }

    protected int fill(Frame frame, ObjectHandle hTarget, int cSize, ObjectHandle hValue, int iReturn) {
        ArrayHandle hArray = (ArrayHandle)hTarget;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        xRTDelegate template = (xRTDelegate)hDelegate.getTemplate();
        xRTDelegate.DelegateHandle hDelegateNew = template.fill(hDelegate, cSize, hValue);
        if (hDelegateNew != hDelegate) {
            if (hDelegateNew == null) {
                return frame.raiseException(xException.readOnly(frame, hArray.m_mutability));
            }
            hArray = new ArrayHandle(hArray.getComposition(), hDelegateNew, hArray.m_mutability);
        }
        return frame.assignValue(iReturn, hArray);
    }

    public static int createAndFill(Frame frame, TypeComposition clzArray, int cSize, Utils.ValueSupplier supplier, int iReturn) {
        ArrayHandle hArray = xArray.createEmptyArray(clzArray, cSize, Mutability.Fixed);
        switch (new Utils.FillArray(hArray, cSize, supplier, iReturn).doNext(frame)) {
            case -1: {
                hArray.setMutability(Mutability.Constant);
                return -1;
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> {
                    hArray.setMutability(Mutability.Constant);
                    return -1;
                });
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    public static TypeComposition getBooleanArrayComposition() {
        return BOOLEAN_ARRAY_CLZ;
    }

    public static ArrayHandle createImmutableArray(TypeComposition clzArray, ObjectHandle[] ahArg) {
        return xArray.makeArrayHandle(clzArray, ahArg.length, ahArg, Mutability.Constant);
    }

    public static ArrayHandle createEmptyArray(TypeComposition clzArray, int cCapacity, Mutability mutability) {
        return xArray.makeArrayHandle(clzArray, cCapacity, Utils.OBJECTS_NONE, mutability);
    }

    public static ArrayHandle makeStringArrayHandle(xString.StringHandle[] ahValue) {
        return xArray.makeArrayHandle(STRING_ARRAY_CLZ, ahValue.length, ahValue, Mutability.Constant);
    }

    public static ArrayHandle makeBitArrayHandle(byte[] abValue, int cBits, Mutability mutability) {
        BitBasedDelegate.BitArrayHandle hDelegate = xRTBitDelegate.INSTANCE.makeHandle(abValue, cBits, mutability);
        return new ArrayHandle(BIT_ARRAY_CLZ, hDelegate, mutability);
    }

    public static ArrayHandle makeBooleanArrayHandle(byte[] abValue, int cBits, Mutability mutability) {
        BitBasedDelegate.BitArrayHandle hDelegate = xRTBooleanDelegate.INSTANCE.makeHandle(abValue, cBits, mutability);
        return new ArrayHandle(BOOLEAN_ARRAY_CLZ, hDelegate, mutability);
    }

    public static ArrayHandle makeByteArrayHandle(byte[] abValue, Mutability mutability) {
        return xArray.makeByteArrayHandle(abValue, abValue.length, mutability);
    }

    public static ArrayHandle makeByteArrayHandle(byte[] abValue, int cBytes, Mutability mutability) {
        if (abValue.length == 0 && mutability == Mutability.Constant) {
            return xArray.ensureEmptyByteArray();
        }
        ByteBasedDelegate.ByteArrayHandle hDelegate = xRTUInt8Delegate.INSTANCE.makeHandle(abValue, cBytes, mutability);
        return new ArrayHandle(BYTE_ARRAY_CLZ, hDelegate, mutability);
    }

    public static ArrayHandle ensureEmptyByteArray() {
        if (EMPTY_BYTE_ARRAY == null) {
            ByteBasedDelegate.ByteArrayHandle hDelegate = xRTUInt8Delegate.INSTANCE.makeHandle(Handy.EMPTY_BYTE_ARRAY, 0L, Mutability.Constant);
            EMPTY_BYTE_ARRAY = new ArrayHandle(BYTE_ARRAY_CLZ, hDelegate, Mutability.Constant);
        }
        return EMPTY_BYTE_ARRAY;
    }

    public static ArrayHandle makeCharArrayHandle(char[] achValue, Mutability mutability) {
        xRTCharDelegate.CharArrayHandle hDelegate = xRTCharDelegate.INSTANCE.makeHandle(achValue, mutability);
        return new ArrayHandle(CHAR_ARRAY_CLZ, hDelegate, mutability);
    }

    public static ArrayHandle makeObjectArrayHandle(ObjectHandle[] ahValue, Mutability mutability) {
        return xArray.makeArrayHandle(OBJECT_ARRAY_CLZ, ahValue.length, ahValue, mutability);
    }

    public static ArrayHandle makeArrayHandle(TypeComposition clzArray, int cCapacity, ObjectHandle[] ahValue, Mutability mutability) {
        xRTDelegate.DelegateHandle hDelegate = xArray.makeDelegate(clzArray, cCapacity, ahValue, mutability);
        return new ArrayHandle(clzArray, hDelegate, mutability);
    }

    protected static xRTDelegate.DelegateHandle makeDelegate(TypeComposition clzArray, int cCapacity, ObjectHandle[] ahValue, Mutability mutability) {
        TypeConstant typeElement = clzArray.getType().getParamType(0);
        xRTDelegate templateDelegate = xRTDelegate.getArrayTemplate(typeElement);
        if (mutability != Mutability.Fixed) {
            cCapacity = ahValue.length;
        }
        return templateDelegate.createDelegate(clzArray.getContainer(), typeElement, cCapacity, ahValue, mutability);
    }

    static {
        CONSTRUCTORS = new MethodConstant[5];
        ELEMENT_TYPE = new String[]{"Element"};
    }

    public static class ArrayHandle
    extends ObjectHandle {
        protected Mutability m_mutability;
        public xRTDelegate.DelegateHandle m_hDelegate;

        protected ArrayHandle(TypeComposition clzArray, xRTDelegate.DelegateHandle hDelegate, Mutability mutability) {
            super(clzArray);
            this.m_hDelegate = hDelegate;
            this.m_fMutable = mutability != Mutability.Constant;
            this.m_mutability = mutability;
        }

        public Mutability getMutability() {
            return this.m_mutability;
        }

        public void setMutability(Mutability mutability) {
            assert (mutability.compareTo(this.m_mutability) <= 0);
            this.m_mutability = mutability;
            this.m_hDelegate.setMutability(mutability);
        }

        @Override
        public xArray getTemplate() {
            return (xArray)super.getTemplate();
        }

        @Override
        public boolean makeImmutable() {
            this.setMutability(Mutability.Constant);
            super.makeImmutable();
            return this.m_hDelegate.makeImmutable();
        }

        @Override
        public boolean isShared(Container container, Map<ObjectHandle, Boolean> mapVisited) {
            return this.m_hDelegate.isShared(container, mapVisited);
        }

        @Override
        public String toString() {
            return super.toString() + String.valueOf((Object)this.m_mutability) + " " + this.m_hDelegate.toString();
        }
    }

    public static enum Mutability {
        Constant,
        Persistent,
        Fixed,
        Mutable;

    }
}

