/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.collections;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.collections.arrays.BitView;
import org.xvm.runtime.template._native.collections.arrays.xRTBitDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTSlicingDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromBitToBoolean;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromBitToByte;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromBitToNibble;
import org.xvm.runtime.template.collections.BitBasedArray;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.collections.xByteArray;
import org.xvm.runtime.template.collections.xNibbleArray;
import org.xvm.runtime.template.numbers.xBit;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;

public class xBitArray
extends BitBasedArray {
    public static xBitArray INSTANCE;

    public xBitArray(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ClassTemplate mixin = this.f_container.getTemplate("collections.arrays.BitArray");
        mixin.markNativeProperty("Zero");
        mixin.markNativeProperty("One");
        mixin.markNativeMethod("asBooleanArray", VOID, null);
        mixin.markNativeMethod("asByteArray", VOID, null);
        mixin.markNativeMethod("asNibbleArray", VOID, null);
        mixin.markNativeMethod("toByteArray", null, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        return this.pool().typeBitArray();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        switch (sPropName) {
            case "Zero": {
                return frame.assignValue(iReturn, xBit.ZERO);
            }
            case "One": {
                return frame.assignValue(iReturn, xBit.ONE);
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "toByteArray": {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)hTarget;
                long cBits = hArray.m_hDelegate.m_cSize;
                if (cBits % 8L != 0L) {
                    return frame.raiseException(xException.illegalArgument(frame, "Invalid array size: " + cBits));
                }
                xArray.Mutability mutability = hArg == ObjectHandle.DEFAULT ? xArray.Mutability.Constant : xArray.Mutability.values()[((xEnum.EnumHandle)hArg).getOrdinal()];
                byte[] aBits = xBitArray.getBits(hArray);
                return frame.assignValue(iReturn, xArray.makeByteArrayHandle(aBits, mutability));
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "asBooleanArray": {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)hTarget;
                long cBits = hArray.m_hDelegate.m_cSize;
                if (cBits % 8L != 0L) {
                    return frame.raiseException(xException.outOfBounds(frame, "Invalid array size: " + cBits));
                }
                xArray.Mutability mutability = hArray.m_mutability;
                xRTDelegate.DelegateHandle hDelegate = xRTViewFromBitToBoolean.INSTANCE.createBitViewDelegate(hArray.m_hDelegate, mutability);
                return frame.assignValue(iReturn, new xArray.ArrayHandle(xArray.getBooleanArrayComposition(), hDelegate, mutability));
            }
            case "asByteArray": {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)hTarget;
                long cBits = hArray.m_hDelegate.m_cSize;
                if (cBits % 8L != 0L) {
                    return frame.raiseException(xException.outOfBounds(frame, "Invalid array size: " + cBits));
                }
                xArray.Mutability mutability = hArray.m_mutability;
                xRTDelegate.DelegateHandle hDelegate = xRTViewFromBitToByte.INSTANCE.createBitViewDelegate(hArray.m_hDelegate, mutability);
                return frame.assignValue(iReturn, new xArray.ArrayHandle(xByteArray.INSTANCE.getCanonicalClass(), hDelegate, mutability));
            }
            case "asNibbleArray": {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)hTarget;
                long cBits = hArray.m_hDelegate.m_cSize;
                if (cBits % 4L != 0L) {
                    return frame.raiseException(xException.outOfBounds(frame, "Invalid array size: " + cBits));
                }
                xArray.Mutability mutability = hArray.m_mutability;
                xRTDelegate.DelegateHandle hDelegate = xRTViewFromBitToNibble.INSTANCE.createBitViewDelegate(hArray.m_hDelegate, mutability);
                return frame.assignValue(iReturn, new xArray.ArrayHandle(xNibbleArray.INSTANCE.getCanonicalClass(), hDelegate, mutability));
            }
            case "toByteArray": {
                return this.invokeNative1(frame, method, hTarget, ObjectHandle.DEFAULT, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    public static byte[] getBits(xArray.ArrayHandle hArray) {
        ClassTemplate tDelegate;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        long cSize = hDelegate.m_cSize;
        long ofStart = 0L;
        boolean fReverse = false;
        if (hDelegate instanceof xRTSlicingDelegate.SliceHandle) {
            xRTSlicingDelegate.SliceHandle hSlice = (xRTSlicingDelegate.SliceHandle)hDelegate;
            hDelegate = hSlice.f_hSource;
            ofStart = hSlice.f_ofStart;
            fReverse = hSlice.f_fReverse;
        }
        if ((tDelegate = hDelegate.getTemplate()) instanceof BitView) {
            BitView tView = (BitView)((Object)tDelegate);
            return tView.getBits(hDelegate, ofStart, cSize, fReverse);
        }
        throw new UnsupportedOperationException();
    }

    public static void setBits(xArray.ArrayHandle hArray, byte[] abVal, long cSize) {
        ClassTemplate tDelegate;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        long ofStart = 0L;
        if (hDelegate instanceof xRTSlicingDelegate.SliceHandle) {
            xRTSlicingDelegate.SliceHandle hSlice = (xRTSlicingDelegate.SliceHandle)hDelegate;
            hDelegate = hSlice.f_hSource;
            ofStart = hSlice.f_ofStart;
        }
        if ((tDelegate = hDelegate.getTemplate()) instanceof BitView) {
            BitView tView = (BitView)((Object)tDelegate);
            for (long i = 0L; i < cSize; ++i) {
                tView.assignBit(hDelegate, ofStart + i, xRTBitDelegate.getBit(abVal, i));
            }
            return;
        }
        throw new UnsupportedOperationException();
    }
}

