/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.collections;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.UInt8ArrayConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.collections.arrays.ByteBasedDelegate;
import org.xvm.runtime.template._native.collections.arrays.ByteView;
import org.xvm.runtime.template._native.collections.arrays.xRTDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTSlicingDelegate;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromByteToFloat64;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromByteToInt16;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromByteToInt64;
import org.xvm.runtime.template._native.collections.arrays.xRTViewFromByteToInt8;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.xException;

public class xByteArray
extends xArray {
    public static xByteArray INSTANCE;
    private static TypeComposition INT8_ARRAY_CLZ;
    private static TypeComposition INT16_ARRAY_CLZ;
    private static TypeComposition INT64_ARRAY_CLZ;
    private static TypeComposition FLOAT64_ARRAY_CLZ;

    public xByteArray(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        ClassTemplate mixin = this.f_container.getTemplate("collections.arrays.ByteArray");
        mixin.markNativeMethod("asByteArray", VOID, null);
        mixin.markNativeMethod("asInt8Array", VOID, null);
        mixin.markNativeMethod("asInt16Array", VOID, null);
        mixin.markNativeMethod("asInt64Array", VOID, null);
        mixin.markNativeMethod("asFloat64Array", VOID, null);
        this.invalidateTypeInfo();
    }

    @Override
    public TypeConstant getCanonicalType() {
        return this.pool().typeByteArray();
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof UInt8ArrayConstant) {
            UInt8ArrayConstant constBytes = (UInt8ArrayConstant)constant;
            return frame.pushStack(xByteArray.makeByteArrayHandle(constBytes.getValue(), xArray.Mutability.Constant));
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "asByteArray": {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)hTarget;
                if (hArray.m_hDelegate instanceof ByteBasedDelegate.ByteArrayHandle) {
                    return frame.assignValue(iReturn, hArray);
                }
                return frame.raiseException(xException.notImplemented(frame, "Not implemented"));
            }
            case "asInt8Array": {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)hTarget;
                xArray.Mutability mutability = hArray.m_mutability;
                xRTDelegate.DelegateHandle hView = xRTViewFromByteToInt8.INSTANCE.createByteView(hArray.m_hDelegate, mutability, 1);
                return frame.assignValue(iReturn, new xArray.ArrayHandle(this.getInt8ArrayComposition(), hView, mutability));
            }
            case "asInt16Array": {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)hTarget;
                if (hArray.m_hDelegate.m_cSize % 2L != 0L) {
                    return frame.raiseException(xException.illegalArgument(frame, "Invalid array size: " + hArray.m_hDelegate.m_cSize));
                }
                xArray.Mutability mutability = hArray.m_mutability;
                xRTDelegate.DelegateHandle hView = xRTViewFromByteToInt16.INSTANCE.createByteView(hArray.m_hDelegate, mutability, 2);
                return frame.assignValue(iReturn, new xArray.ArrayHandle(this.getInt16ArrayComposition(), hView, mutability));
            }
            case "asInt64Array": {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)hTarget;
                if (hArray.m_hDelegate.m_cSize % 8L != 0L) {
                    return frame.raiseException(xException.illegalArgument(frame, "Invalid array size: " + hArray.m_hDelegate.m_cSize));
                }
                xArray.Mutability mutability = hArray.m_mutability;
                xRTDelegate.DelegateHandle hView = xRTViewFromByteToInt64.INSTANCE.createByteView(hArray.m_hDelegate, mutability, 8);
                return frame.assignValue(iReturn, new xArray.ArrayHandle(this.getInt64ArrayComposition(), hView, mutability));
            }
            case "asFloat64Array": {
                xArray.ArrayHandle hArray = (xArray.ArrayHandle)hTarget;
                if (hArray.m_hDelegate.m_cSize % 8L != 0L) {
                    return frame.raiseException(xException.illegalArgument(frame, "Invalid array size: " + hArray.m_hDelegate.m_cSize));
                }
                xArray.Mutability mutability = hArray.m_mutability;
                xRTDelegate.DelegateHandle hView = xRTViewFromByteToFloat64.INSTANCE.createByteView(hArray.m_hDelegate, mutability, 8);
                return frame.assignValue(iReturn, new xArray.ArrayHandle(this.getFloat64ArrayComposition(), hView, mutability));
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    public static byte[] getBytes(xArray.ArrayHandle hArray) {
        ClassTemplate tDelegate;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        long cSize = hDelegate.m_cSize;
        long ofStart = 0L;
        boolean fReverse = false;
        if (hDelegate instanceof xRTSlicingDelegate.SliceHandle) {
            xRTSlicingDelegate.SliceHandle hSlice = (xRTSlicingDelegate.SliceHandle)hDelegate;
            hDelegate = hSlice.f_hSource;
            ofStart = hSlice.f_ofStart;
            fReverse = hSlice.f_fReverse;
        }
        if ((tDelegate = hDelegate.getTemplate()) instanceof ByteView) {
            ByteView hView = (ByteView)((Object)tDelegate);
            return hView.getBytes(hDelegate, ofStart, cSize, fReverse);
        }
        throw new UnsupportedOperationException();
    }

    public static void setBytes(xArray.ArrayHandle hArray, byte[] abVal) {
        ClassTemplate tDelegate;
        xRTDelegate.DelegateHandle hDelegate = hArray.m_hDelegate;
        long ofStart = 0L;
        if (hDelegate instanceof xRTSlicingDelegate.SliceHandle) {
            xRTSlicingDelegate.SliceHandle hSlice = (xRTSlicingDelegate.SliceHandle)hDelegate;
            hDelegate = hSlice.f_hSource;
            ofStart = hSlice.f_ofStart;
        }
        if ((tDelegate = hDelegate.getTemplate()) instanceof ByteView) {
            ByteView tView = (ByteView)((Object)tDelegate);
            int c = abVal.length;
            for (int i = 0; i < c; ++i) {
                tView.assignByte(hDelegate, ofStart + (long)i, abVal[i]);
            }
            return;
        }
        throw new UnsupportedOperationException();
    }

    private TypeComposition getInt8ArrayComposition() {
        TypeComposition clz = INT8_ARRAY_CLZ;
        if (clz == null) {
            TypeConstant typeInt8 = this.pool().typeInt8();
            INT8_ARRAY_CLZ = clz = this.f_container.resolveClass(this.pool().ensureArrayType(typeInt8));
        }
        return clz;
    }

    private TypeComposition getInt16ArrayComposition() {
        TypeComposition clz = INT16_ARRAY_CLZ;
        if (clz == null) {
            TypeConstant typeInt16 = this.pool().typeInt16();
            INT16_ARRAY_CLZ = clz = this.f_container.resolveClass(this.pool().ensureArrayType(typeInt16));
        }
        return clz;
    }

    private TypeComposition getInt64ArrayComposition() {
        TypeComposition clz = INT64_ARRAY_CLZ;
        if (clz == null) {
            INT64_ARRAY_CLZ = clz = this.f_container.resolveClass(this.pool().ensureArrayType(this.pool().typeInt64()));
        }
        return clz;
    }

    private TypeComposition getFloat64ArrayComposition() {
        TypeComposition clz = FLOAT64_ARRAY_CLZ;
        if (clz == null) {
            FLOAT64_ARRAY_CLZ = clz = this.f_container.resolveClass(this.pool().ensureArrayType(this.pool().typeFloat64()));
        }
        return clz;
    }
}

