/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.collections;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.NativeRebaseConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.ServiceContext;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.IndexSupport;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xObject;

public class xTuple
extends ClassTemplate
implements IndexSupport {
    public static xTuple INSTANCE;
    public static ClassConstant INCEPTION_CLASS;
    public static TupleHandle H_VOID;

    public xTuple(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
            INCEPTION_CLASS = new NativeRebaseConstant((ClassConstant)structure.getIdentityConstant());
        }
    }

    @Override
    public void initNative() {
        H_VOID = xTuple.makeImmutableHandle(this.getCanonicalClass(), Utils.OBJECTS_NONE);
    }

    @Override
    public TypeComposition ensureClass(Container container, TypeConstant typeActual) {
        return typeActual.getParamsCount() == 0 ? this.getCanonicalClass() : this.getCanonicalClass(container).ensureCanonicalizedComposition(typeActual);
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    protected ClassConstant getInceptionClassConstant() {
        return INCEPTION_CLASS;
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        ArrayConstant constTuple = (ArrayConstant)constant;
        assert (constTuple.getFormat() == Constant.Format.Tuple);
        Constant[] aconst = constTuple.getValue();
        int c = aconst.length;
        if (c == 0) {
            return frame.pushStack(H_VOID);
        }
        TypeConstant typeTuple = constTuple.getType();
        typeTuple = typeTuple.resolveGenerics(frame.poolContext(), frame.getGenericsResolver(typeTuple.containsDynamicType()));
        ObjectHandle[] ahValue = new ObjectHandle[c];
        boolean fDeferred = false;
        for (int i = 0; i < c; ++i) {
            ObjectHandle hValue = frame.getConstHandle(aconst[i]);
            if (Op.isDeferred(hValue)) {
                fDeferred = true;
            }
            ahValue[i] = hValue;
        }
        TypeComposition clzTuple = this.ensureClass(frame.f_context.f_container, typeTuple);
        if (fDeferred) {
            Frame.Continuation stepNext = frameCaller -> frameCaller.pushStack(xTuple.makeImmutableHandle(clzTuple, ahValue));
            return new Utils.GetArguments(ahValue, stepNext).doNext(frame);
        }
        return frame.pushStack(xTuple.makeImmutableHandle(clzTuple, ahValue));
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahVar, int iReturn) {
        ObjectHandle hSequence = ahVar[0];
        IndexSupport support = (IndexSupport)((Object)hSequence.getOpSupport());
        try {
            ObjectHandle[] ahValue = support.toArray(frame, hSequence);
            return frame.assignValue(iReturn, xTuple.makeHandle(clazz, ahValue));
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public int createProxyHandle(Frame frame, ServiceContext ctxTarget, ObjectHandle hTarget, TypeConstant typeProxy) {
        TupleHandle hTuple = (TupleHandle)hTarget;
        ObjectHandle[] ahValue = (ObjectHandle[])hTuple.m_ahValue.clone();
        switch (frame.f_context.validatePassThrough(frame, ctxTarget, null, ahValue)) {
            case -1: {
                return frame.assignValue(-1, xTuple.makeHandle(hTuple.getComposition(), ahValue));
            }
            case -5: {
                frame.m_frameNext.addContinuation(frameCaller -> frameCaller.assignValue(-1, xTuple.makeHandle(hTuple.getComposition(), ahValue)));
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        TupleHandle hTuple = (TupleHandle)hTarget;
        switch (sPropName) {
            case "size": {
                return frame.assignValue(iReturn, xInt64.makeHandle(hTuple.m_ahValue.length));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "addAll": {
                TupleHandle hTuple = (TupleHandle)hTarget;
                TupleHandle hThat = (TupleHandle)hArg;
                return this.invokeAddAll(frame, hTuple, hThat, iReturn);
            }
            case "elementAt": {
                return this.makeRef(frame, hTarget, ((ObjectHandle.JavaLong)hArg).getValue(), false, iReturn);
            }
            case "freeze": {
                TupleHandle hTuple = (TupleHandle)hTarget;
                boolean fInPlace = hArg != ObjectHandle.DEFAULT && ((xBoolean.BooleanHandle)hArg).get();
                return this.invokeFreeze(frame, hTuple, fInPlace, iReturn);
            }
            case "getElement": {
                return this.extractArrayValue(frame, hTarget, ((ObjectHandle.JavaLong)hArg).getValue(), iReturn);
            }
            case "remove": 
            case "removeAll": {
                throw new UnsupportedOperationException();
            }
            case "slice": {
                ObjectHandle.GenericHandle hInterval = (ObjectHandle.GenericHandle)hArg;
                long ixFrom = ((ObjectHandle.JavaLong)hInterval.getField(frame, "lowerBound")).getValue();
                long ixTo = ((ObjectHandle.JavaLong)hInterval.getField(frame, "upperBound")).getValue();
                boolean fExLower = ((xBoolean.BooleanHandle)hInterval.getField(frame, "lowerExclusive")).get();
                boolean fExUpper = ((xBoolean.BooleanHandle)hInterval.getField(frame, "upperExclusive")).get();
                boolean fReverse = ((xBoolean.BooleanHandle)hInterval.getField(frame, "descending")).get();
                return this.invokeSlice(frame, (TupleHandle)hTarget, ixFrom, fExLower, ixTo, fExUpper, fReverse, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "add": {
                TupleHandle hTuple = (TupleHandle)hTarget;
                xRTType.TypeHandle hType = (xRTType.TypeHandle)ahArg[0];
                ObjectHandle hValue = ahArg[1];
                return this.invokeAdd(frame, hTuple, hType, hValue, iReturn);
            }
            case "replace": {
                TupleHandle hTuple = (TupleHandle)hTarget;
                long lIndex = ((ObjectHandle.JavaLong)ahArg[0]).getValue();
                ObjectHandle hValue = ahArg[1];
                return this.invokeReplace(frame, hTuple, lIndex, hValue, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        TupleHandle hTuple1 = (TupleHandle)hValue1;
        TupleHandle hTuple2 = (TupleHandle)hValue2;
        if (hTuple1.isMutable() || hTuple2.isMutable()) {
            return false;
        }
        ObjectHandle[] ah1 = hTuple1.m_ahValue;
        ObjectHandle[] ah2 = hTuple2.m_ahValue;
        if (ah1 == ah2) {
            return true;
        }
        if (ah1.length != ah2.length) {
            return false;
        }
        int c = ah1.length;
        for (int i = 0; i < c; ++i) {
            ObjectHandle hV1 = ah1[i];
            ObjectHandle hV2 = ah2[i];
            ClassTemplate template = hV1.getTemplate();
            if (template == hV2.getTemplate() && template.compareIdentity(hV1, hV2)) continue;
            return false;
        }
        return true;
    }

    protected int invokeAdd(Frame frame, TupleHandle hThis, xRTType.TypeHandle hType, ObjectHandle hValue, int iReturn) {
        TypeConstant[] atypeNew;
        ObjectHandle[] ahValue = hThis.m_ahValue;
        int cValues = ahValue.length;
        TypeConstant[] atype = hThis.getType().getParamTypesArray();
        int cTypes = atype.length;
        int cNew = cValues + 1;
        ObjectHandle[] ahNew = new ObjectHandle[cNew];
        System.arraycopy(ahValue, 0, ahNew, 0, cValues);
        ahNew[cValues] = hValue;
        if (cTypes != cValues) {
            atypeNew = TypeConstant.NO_TYPES;
        } else {
            atypeNew = new TypeConstant[cNew];
            System.arraycopy(atype, 0, atypeNew, 0, cTypes);
            atypeNew[cTypes] = hType.getDataType();
        }
        TypeConstant typeTupleNew = frame.poolContext().ensureTupleType(atypeNew);
        TypeComposition clzTupleNew = this.ensureClass(frame.f_context.f_container, typeTupleNew);
        TupleHandle hTupleNew = xTuple.makeHandle(clzTupleNew, ahNew);
        return frame.assignValue(iReturn, hTupleNew);
    }

    protected int invokeAddAll(Frame frame, TupleHandle hThis, TupleHandle hThat, int iReturn) {
        TypeConstant[] atypeNew;
        ObjectHandle[] ahValue = hThis.m_ahValue;
        int cValues = ahValue.length;
        if (cValues == 0) {
            return frame.assignValue(iReturn, hThat);
        }
        ObjectHandle[] ahValueAdd = hThat.m_ahValue;
        int cValuesAdd = ahValueAdd.length;
        if (cValuesAdd == 0) {
            return frame.assignValue(iReturn, hThis);
        }
        TypeConstant[] atype = hThis.getType().getParamTypesArray();
        int cTypes = atype.length;
        TypeConstant[] atypeAdd = hThat.getType().getParamTypesArray();
        int cTypesAdd = atypeAdd.length;
        int cNew = cValues + cValuesAdd;
        ObjectHandle[] ahNew = new ObjectHandle[cNew];
        System.arraycopy(ahValue, 0, ahNew, 0, cValues);
        System.arraycopy(ahValueAdd, 0, ahNew, cValues, cValuesAdd);
        if (cTypes != cValues || cTypesAdd != cValuesAdd) {
            atypeNew = TypeConstant.NO_TYPES;
        } else {
            atypeNew = new TypeConstant[cNew];
            System.arraycopy(atype, 0, atypeNew, 0, cTypes);
            System.arraycopy(atypeAdd, 0, atypeNew, cTypes, cTypesAdd);
        }
        TypeConstant typeTupleNew = frame.poolContext().ensureTupleType(atypeNew);
        TypeComposition clzTupleNew = this.ensureClass(frame.f_context.f_container, typeTupleNew);
        TupleHandle hTupleNew = xTuple.makeHandle(clzTupleNew, ahNew);
        return frame.assignValue(iReturn, hTupleNew);
    }

    protected int invokeReplace(Frame frame, TupleHandle hThis, long lIndex, ObjectHandle hValue, int iReturn) {
        int cValues;
        ObjectHandle[] ahValue = hThis.m_ahValue;
        int n = cValues = ahValue == null ? 0 : ahValue.length;
        if (lIndex < 0L || lIndex >= (long)cValues) {
            return frame.raiseException(xException.outOfBounds(frame, lIndex, cValues));
        }
        TypeComposition clzThis = hThis.getComposition();
        if (!hValue.getUnsafeType().isA(clzThis.getType().getParamType((int)lIndex))) {
            return frame.raiseException(xException.typeMismatch(frame, hValue.getType().getValueString()));
        }
        ahValue = (ObjectHandle[])ahValue.clone();
        ahValue[(int)lIndex] = hValue;
        return frame.assignValue(iReturn, xTuple.makeHandle(clzThis, ahValue));
    }

    protected int invokeFreeze(Frame frame, TupleHandle hTuple, boolean fInPlace, int iReturn) {
        if (hTuple.isMutable()) {
            Frame.Continuation stepNext;
            ObjectHandle[] ahValue;
            if (fInPlace) {
                ahValue = hTuple.m_ahValue;
                stepNext = frameCaller -> {
                    hTuple.makeImmutable();
                    return frameCaller.assignValue(iReturn, hTuple);
                };
            } else {
                ahValue = (ObjectHandle[])hTuple.m_ahValue.clone();
                stepNext = frameCaller -> frameCaller.assignValue(iReturn, xTuple.makeHandle(hTuple.getComposition(), ahValue));
            }
            switch (this.freezeValues(frame, ahValue, fInPlace, 0)) {
                case -1: {
                    return stepNext.proceed(frame);
                }
                case -5: {
                    frame.m_frameNext.addContinuation(stepNext);
                    return -5;
                }
                case -3: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
        return -1;
    }

    private int freezeValues(Frame frame, ObjectHandle[] ahValue, boolean fInPlace, int index) {
        int c = ahValue.length;
        for (int i = index; i < c; ++i) {
            ObjectHandle hValue = ahValue[i];
            if (hValue.isPassThrough(null)) continue;
            if (hValue.getType().isA(frame.poolContext().typeFreezable())) {
                int ix = i;
                return Utils.callFreeze(frame, hValue, fInPlace, frameCaller -> {
                    ahValue[ix] = frameCaller.popStack();
                    return this.freezeValues(frameCaller, ahValue, fInPlace, ix + 1);
                });
            }
            return frame.raiseException("Tuple element [" + i + "] of type \"" + hValue.getType().removeAccess().getValueString() + "\" is not freezable");
        }
        return -1;
    }

    protected int invokeSlice(Frame frame, TupleHandle hTuple, long ixLower, boolean fExLower, long ixUpper, boolean fExUpper, boolean fReverse, int iReturn) {
        if (fExLower) {
            ++ixLower;
        }
        if (!fExUpper) {
            ++ixUpper;
        }
        ObjectHandle[] ahValue = hTuple.m_ahValue;
        TypeConstant[] atype = hTuple.getType().getParamTypesArray();
        int cTypes = atype.length;
        if (cTypes > 0 && cTypes < ahValue.length) {
            atype = TypeConstant.NO_TYPES;
        }
        try {
            TypeConstant[] atypeNew;
            ObjectHandle[] ahNew;
            if (ixLower >= ixUpper) {
                ahNew = Utils.OBJECTS_NONE;
                atypeNew = TypeConstant.NO_TYPES;
            } else if (fReverse) {
                int cNew = (int)(ixUpper - ixLower);
                ahNew = new ObjectHandle[cNew];
                atypeNew = new TypeConstant[cNew];
                for (int i = 0; i < cNew; ++i) {
                    int iOrig = (int)ixUpper - i - 1;
                    ahNew[i] = ahValue[iOrig];
                    atypeNew[i] = atype[iOrig];
                }
            } else {
                ahNew = Arrays.copyOfRange(ahValue, (int)ixLower, (int)ixUpper);
                atypeNew = Arrays.copyOfRange(atype, (int)ixLower, (int)ixUpper);
            }
            TypeConstant typeTupleNew = frame.poolContext().ensureTupleType(atypeNew);
            TypeComposition clzTupleNew = this.ensureClass(frame.f_context.f_container, typeTupleNew);
            TupleHandle hTupleNew = xTuple.makeHandle(clzTupleNew, ahNew);
            return frame.assignValue(iReturn, hTupleNew);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            long c = ahValue.length;
            return frame.raiseException(xException.outOfBounds(frame, ixLower < 0L || ixLower >= c ? ixLower : ixUpper, c));
        }
    }

    @Override
    public int extractArrayValue(Frame frame, ObjectHandle hTarget, long lIndex, int iReturn) {
        int cElements;
        TupleHandle hTuple = (TupleHandle)hTarget;
        ObjectHandle[] ahValue = hTuple.m_ahValue;
        int n = cElements = ahValue == null ? 0 : ahValue.length;
        if (lIndex < 0L || lIndex >= (long)cElements) {
            return frame.raiseException(xException.outOfBounds(frame, lIndex, cElements));
        }
        ObjectHandle hValue = hTuple.m_ahValue[(int)lIndex];
        return Op.isDeferred(hValue) ? frame.assignDeferredValue(iReturn, hValue) : frame.assignValue(iReturn, hValue);
    }

    @Override
    public int assignArrayValue(Frame frame, ObjectHandle hTarget, long lIndex, ObjectHandle hValue) {
        return frame.raiseException(xException.unsupported(frame));
    }

    @Override
    public TypeConstant getElementType(Frame frame, ObjectHandle hTarget, long lIndex) throws ObjectHandle.ExceptionHandle.WrapperException {
        int cElements;
        TupleHandle hTuple = (TupleHandle)hTarget;
        ObjectHandle[] ahValue = hTuple.m_ahValue;
        int n = cElements = ahValue == null ? 0 : ahValue.length;
        if (lIndex < 0L || lIndex >= (long)cElements) {
            throw xException.outOfBounds(frame, lIndex, cElements).getException();
        }
        return hTuple.getType().getParamType((int)lIndex);
    }

    @Override
    public long size(ObjectHandle hTarget) {
        TupleHandle hTuple = (TupleHandle)hTarget;
        return hTuple.m_ahValue.length;
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        TupleHandle hTuple1 = (TupleHandle)hValue1;
        TupleHandle hTuple2 = (TupleHandle)hValue2;
        ObjectHandle[] ah1 = hTuple1.m_ahValue;
        int cElements = ah1.length;
        ObjectHandle[] ah2 = hTuple2.m_ahValue;
        if (cElements != ah2.length) {
            return frame.assignValue(iReturn, xBoolean.FALSE);
        }
        TypeConstant[] atypeCommon = clazz.getType().getParamTypesArray();
        int cCommon = atypeCommon.length;
        if (cCommon < cElements) {
            TypeConstant[] atype1 = hTuple1.getType().getParamTypesArray();
            TypeConstant[] atype2 = hTuple2.getType().getParamTypesArray();
            if (cCommon == 0) {
                atypeCommon = atype1;
            } else {
                TypeConstant[] atypeC = (TypeConstant[])atype1.clone();
                System.arraycopy(atypeCommon, 0, atypeC, 0, cCommon);
                atypeCommon = atypeC;
            }
            for (int i = cCommon; i < cElements; ++i) {
                if (atype1[i].equals(atype2[i])) continue;
                return frame.assignValue(iReturn, xBoolean.FALSE);
            }
        }
        return new Equals(hTuple1, hTuple2, cElements, atypeCommon, iReturn).doNext(frame);
    }

    public static TupleHandle makeImmutableHandle(TypeComposition clazz, ObjectHandle ... ahValue) {
        return new TupleHandle(clazz, ahValue, false);
    }

    public static TupleHandle makeHandle(TypeComposition clazz, ObjectHandle ... ahValue) {
        return new TupleHandle(clazz, ahValue, !clazz.getType().isImmutable());
    }

    public static class TupleHandle
    extends ObjectHandle {
        public ObjectHandle[] m_ahValue;

        protected TupleHandle(TypeComposition clazz, ObjectHandle[] ahValue, boolean fMutable) {
            super(clazz);
            this.m_ahValue = ahValue;
            this.m_fMutable = fMutable;
        }

        @Override
        public boolean makeImmutable() {
            if (this.m_fMutable) {
                ObjectHandle[] ahValue = this.m_ahValue;
                int c = ahValue.length;
                for (int i = 0; i < c; ++i) {
                    ObjectHandle hValue = ahValue[i];
                    if (hValue == null) {
                        assert (i > 0 && ahValue[0] == xBoolean.FALSE);
                        continue;
                    }
                    if (hValue.isService() || hValue.makeImmutable()) continue;
                    return false;
                }
                return super.makeImmutable();
            }
            return true;
        }

        @Override
        protected TypeConstant augmentType(TypeConstant type) {
            ObjectHandle[] ahValue = this.m_ahValue;
            TypeConstant[] atypeOrig = type.getParamTypesArray();
            TypeConstant[] atypeActual = null;
            int c = Math.min(ahValue.length, atypeOrig.length);
            for (int i = 0; i < c; ++i) {
                TypeConstant typeResolved;
                TypeConstant typeOrig;
                ObjectHandle hValue = ahValue[i];
                if (hValue == null) {
                    assert (i > 0 && ahValue[0] == xBoolean.FALSE);
                    return type;
                }
                TypeConstant typeVal = hValue.getType();
                if (typeVal.equals(typeOrig = atypeOrig[i]) || (typeResolved = typeVal.widenEnumValueTypes()) == typeOrig) continue;
                if (atypeActual == null) {
                    atypeActual = (TypeConstant[])atypeOrig.clone();
                }
                atypeActual[i] = typeResolved;
            }
            return super.augmentType(atypeActual == null ? type : type.getConstantPool().ensureTupleType(atypeActual));
        }

        @Override
        public boolean isShared(Container container, Map<ObjectHandle, Boolean> mapVisited) {
            if (mapVisited == null) {
                mapVisited = new IdentityHashMap<ObjectHandle, Boolean>();
            }
            return mapVisited.put(this, Boolean.TRUE) != null || TupleHandle.areShared(this.m_ahValue, container, mapVisited);
        }

        @Override
        public String toString() {
            return "Tuple: " + Arrays.toString(this.m_ahValue);
        }
    }

    protected static class Equals
    implements Frame.Continuation {
        private final TupleHandle hTuple1;
        private final TupleHandle hTuple2;
        private final int cElements;
        private final TypeConstant[] atype;
        private final int iReturn;
        private int index = -1;

        public Equals(TupleHandle h1, TupleHandle h2, int cElements, TypeConstant[] aType, int iReturn) {
            this.hTuple1 = h1;
            this.hTuple2 = h2;
            this.cElements = cElements;
            this.atype = aType;
            this.iReturn = iReturn;
        }

        @Override
        public int proceed(Frame frameCaller) {
            ObjectHandle hResult = frameCaller.popStack();
            if (hResult == xBoolean.FALSE) {
                return frameCaller.assignValue(this.iReturn, hResult);
            }
            return this.doNext(frameCaller);
        }

        public int doNext(Frame frameCaller) {
            int cTypes = this.atype.length;
            block5: while (++this.index < this.cElements) {
                ObjectHandle h1 = this.hTuple1.m_ahValue[this.index];
                ObjectHandle h2 = this.hTuple2.m_ahValue[this.index];
                int iResult = this.index < cTypes ? this.atype[this.index].callEquals(frameCaller, h1, h2, -1) : xObject.INSTANCE.callEquals(frameCaller, xObject.CLASS, h1, h2, -1);
                switch (iResult) {
                    case -1: {
                        ObjectHandle hResult = frameCaller.popStack();
                        if (hResult != xBoolean.FALSE) continue block5;
                        return frameCaller.assignValue(this.iReturn, hResult);
                    }
                    case -5: {
                        frameCaller.m_frameNext.addContinuation(this);
                        return -5;
                    }
                    case -3: {
                        return -3;
                    }
                }
                throw new IllegalStateException();
            }
            return frameCaller.assignValue(this.iReturn, xBoolean.TRUE);
        }
    }
}

