/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.maps;

import java.util.Map;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.constants.MapConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xArray;

public class xListMap
extends ClassTemplate {
    public static xListMap INSTANCE;
    private static MethodStructure CONSTRUCTOR;

    public xListMap(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    public void initNative() {
        this.ensureConstructor();
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof MapConstant) {
            MapConstant constMap = (MapConstant)constant;
            TypeConstant typeMap = constant.getType();
            if (typeMap.containsFormalType(true)) {
                typeMap = typeMap.resolveGenerics(frame.poolContext(), frame.getGenericsResolver(typeMap.containsDynamicType()));
            }
            Object mapValues = constMap.getValue();
            int cEntries = mapValues.size();
            ObjectHandle[] ahKey = new ObjectHandle[cEntries];
            ObjectHandle[] ahVal = new ObjectHandle[cEntries];
            boolean fDeferredKey = false;
            boolean fDeferredVal = false;
            int ix = 0;
            for (Map.Entry entry : mapValues.entrySet()) {
                ObjectHandle hKey = frame.getConstHandle((Constant)entry.getKey());
                ObjectHandle hVal = frame.getConstHandle((Constant)entry.getValue());
                fDeferredKey |= Op.isDeferred(hKey);
                fDeferredVal |= Op.isDeferred(hVal);
                ahKey[ix] = hKey;
                ahVal[ix] = hVal;
                ++ix;
            }
            return this.constructMap(frame, typeMap, ahKey, ahVal, fDeferredKey, fDeferredVal, -1);
        }
        return super.createConstHandle(frame, constant);
    }

    public int constructMap(Frame frame, TypeConstant typeMap, ObjectHandle[] ahKey, ObjectHandle[] ahVal, boolean fDeferredKey, boolean fDeferredVal, int iReturn) {
        ConstantPool pool = frame.poolContext();
        TypeConstant typeKey = typeMap.resolveGenericType("Key");
        TypeConstant typeVal = typeMap.resolveGenericType("Value");
        TypeConstant typeKeyArray = pool.ensureArrayType(typeKey);
        TypeConstant typeValArray = pool.ensureArrayType(typeVal);
        TypeComposition clzKeyArray = typeKeyArray.ensureClass(frame);
        TypeComposition clzValArray = typeValArray.ensureClass(frame);
        TypeComposition clzMap = this.ensureClass(frame.f_context.f_container, pool.ensureParameterizedTypeConstant(this.getClassConstant().getType(), typeKey, typeVal));
        ObjectHandle haKeys = fDeferredKey ? new ObjectHandle.DeferredArrayHandle(clzKeyArray, ahKey) : xArray.createImmutableArray(clzKeyArray, ahKey);
        ObjectHandle haVals = fDeferredVal ? new ObjectHandle.DeferredArrayHandle(clzValArray, ahVal) : xArray.createImmutableArray(clzValArray, ahVal);
        ObjectHandle[] ahArg = new ObjectHandle[CONSTRUCTOR.getMaxVars()];
        ahArg[0] = haKeys;
        ahArg[1] = haVals;
        if (fDeferredKey || fDeferredVal) {
            Frame.Continuation stepNext = frameCaller -> this.construct(frameCaller, CONSTRUCTOR, clzMap, null, ahArg, iReturn);
            return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
        }
        return this.construct(frame, CONSTRUCTOR, clzMap, null, ahArg, iReturn);
    }

    public MethodStructure ensureConstructor() {
        if (CONSTRUCTOR == null) {
            CONSTRUCTOR = this.getStructure().findMethod("construct", m -> m.getParamCount() == 3);
        }
        return CONSTRUCTOR;
    }
}

