/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import java.math.BigDecimal;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.BaseFP;
import org.xvm.runtime.template.numbers.xConstrainedInteger;
import org.xvm.runtime.template.numbers.xDec64;
import org.xvm.runtime.template.numbers.xFloat32;
import org.xvm.runtime.template.numbers.xFloat64;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xOrdered;

public abstract class BaseBinaryFP
extends BaseFP {
    public static final long SIGN_MASK = Long.MIN_VALUE;
    public static final long EXP_MASK = 0x7FF0000000000000L;
    public static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;

    public BaseBinaryFP(Container container, ClassStructure structure, int cBits) {
        super(container, structure, cBits);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        double d = ((FloatHandle)hTarget).getValue();
        switch (sPropName) {
            case "bits": {
                return frame.assignValue(iReturn, xArray.makeBitArrayHandle(this.getBits(d), this.f_cBits, xArray.Mutability.Constant));
            }
            case "infinity": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(Double.isInfinite(d)));
            }
            case "NaN": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(Double.isNaN(d)));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "add": {
                return this.invokeAdd(frame, hTarget, hArg, iReturn);
            }
            case "sub": {
                return this.invokeSub(frame, hTarget, hArg, iReturn);
            }
            case "mul": {
                return this.invokeMul(frame, hTarget, hArg, iReturn);
            }
            case "div": {
                return this.invokeDiv(frame, hTarget, hArg, iReturn);
            }
            case "mod": {
                return this.invokeMod(frame, hTarget, hArg, iReturn);
            }
            case "pow": {
                double d1 = ((FloatHandle)hTarget).getValue();
                double d2 = ((FloatHandle)hArg).getValue();
                return frame.assignValue(iReturn, this.makeHandle(Math.pow(d1, d2)));
            }
            case "round": {
                double d = ((FloatHandle)hTarget).getValue();
                int i = hArg == ObjectHandle.DEFAULT ? 0 : ((xEnum.EnumHandle)hArg).getOrdinal();
                double r = new BigDecimal(d).setScale(0, BaseFP.Rounding.values()[i].getMode()).doubleValue();
                return frame.assignValue(iReturn, this.makeHandle(r));
            }
            case "scaleByPow": {
                double d = ((FloatHandle)hTarget).getValue();
                long l = ((ObjectHandle.JavaLong)hArg).getValue();
                return frame.assignValue(iReturn, this.makeHandle(Math.pow(d, l)));
            }
            case "atan2": {
                double d1 = ((FloatHandle)hTarget).getValue();
                double d2 = ((FloatHandle)hArg).getValue();
                return frame.assignValue(iReturn, this.makeHandle(Math.atan2(d1, d2)));
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        double d = hTarget == null ? 0.0 : ((FloatHandle)hTarget).getValue();
        switch (method.getName()) {
            case "abs": {
                return frame.assignValue(iReturn, this.makeHandle(Math.abs(d)));
            }
            case "toInt64": {
                boolean fCheckBound = ahArg[0] == xBoolean.TRUE;
                BaseFP.Rounding rounding = BaseFP.Rounding.values()[ahArg[1] == ObjectHandle.DEFAULT ? 0 : ((xEnum.EnumHandle)ahArg[1]).getOrdinal()];
                if (fCheckBound && !Double.isFinite(d)) {
                    return this.overflow(frame);
                }
                long l = switch (rounding) {
                    default -> throw new MatchException(null, null);
                    case BaseFP.Rounding.TiesToEven -> (long)d;
                    case BaseFP.Rounding.TiesToAway -> {
                        if (d < 0.0) {
                            yield -Math.round(-d);
                        }
                        yield Math.round(d);
                    }
                    case BaseFP.Rounding.TowardPositive -> (long)Math.ceil(d);
                    case BaseFP.Rounding.TowardZero -> (long)(d < 0.0 ? Math.ceil(d) : Math.floor(d));
                    case BaseFP.Rounding.TowardNegative -> (long)Math.floor(d);
                };
                return frame.assignValue(iReturn, xInt64.INSTANCE.makeJavaLong(l));
            }
            case "toDec64": {
                return frame.assignValue(iReturn, xDec64.INSTANCE.makeHandle(d));
            }
            case "toFloat32": {
                return frame.assignValue(iReturn, xFloat32.INSTANCE.makeHandle(d));
            }
            case "toFloat64": {
                return frame.assignValue(iReturn, xFloat64.INSTANCE.makeHandle(d));
            }
            case "toIntN": 
            case "toUIntN": 
            case "toFloatN": 
            case "toDecN": {
                throw new UnsupportedOperationException();
            }
            case "neg": {
                return frame.assignValue(iReturn, this.makeHandle(-d));
            }
            case "floor": {
                return frame.assignValue(iReturn, this.makeHandle(Math.floor(d)));
            }
            case "ceil": {
                return frame.assignValue(iReturn, this.makeHandle(Math.ceil(d)));
            }
            case "exp": {
                return frame.assignValue(iReturn, this.makeHandle(Math.exp(d)));
            }
            case "log": {
                return frame.assignValue(iReturn, this.makeHandle(Math.log(d)));
            }
            case "log2": {
                return frame.assignValue(iReturn, this.makeHandle(Math.log10(d) * LOG2_10));
            }
            case "log10": {
                return frame.assignValue(iReturn, this.makeHandle(Math.log10(d)));
            }
            case "sqrt": {
                return frame.assignValue(iReturn, this.makeHandle(Math.sqrt(d)));
            }
            case "cbrt": {
                return frame.assignValue(iReturn, this.makeHandle(Math.cbrt(d)));
            }
            case "sin": {
                return frame.assignValue(iReturn, this.makeHandle(Math.sin(d)));
            }
            case "tan": {
                return frame.assignValue(iReturn, this.makeHandle(Math.tan(d)));
            }
            case "asin": {
                return frame.assignValue(iReturn, this.makeHandle(Math.asin(d)));
            }
            case "acos": {
                return frame.assignValue(iReturn, this.makeHandle(Math.acos(d)));
            }
            case "atan": {
                return frame.assignValue(iReturn, this.makeHandle(Math.atan(d)));
            }
            case "sinh": {
                return frame.assignValue(iReturn, this.makeHandle(Math.sinh(d)));
            }
            case "cosh": {
                return frame.assignValue(iReturn, this.makeHandle(Math.cosh(d)));
            }
            case "tanh": {
                return frame.assignValue(iReturn, this.makeHandle(Math.tanh(d)));
            }
            case "asinh": {
                return frame.assignValue(iReturn, this.makeHandle(Math.log(d + Math.sqrt(d * d + 1.0))));
            }
            case "acosh": {
                return frame.assignValue(iReturn, this.makeHandle(Math.log(d + Math.sqrt(d * d - 1.0))));
            }
            case "atanh": {
                return frame.assignValue(iReturn, this.makeHandle(0.5 * Math.log((d + 1.0) / (d - 1.0))));
            }
            case "deg2rad": {
                return frame.assignValue(iReturn, this.makeHandle(Math.toRadians(d)));
            }
            case "rad2deg": {
                return frame.assignValue(iReturn, this.makeHandle(Math.toDegrees(d)));
            }
            case "nextUp": {
                return frame.assignValue(iReturn, this.makeHandle(Math.nextUp(d)));
            }
            case "nextDown": {
                return frame.assignValue(iReturn, this.makeHandle(Math.nextDown(d)));
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "split": {
                double d = ((FloatHandle)hTarget).getValue();
                long l = Double.doubleToRawLongBits(d);
                boolean fSign = (l & Long.MIN_VALUE) != 0L;
                int iExp = Math.getExponent(d);
                long lMantissa = l & 0xFFFFFFFFFFFFFL;
                return frame.assignValues(aiReturn, xBoolean.makeHandle(fSign), xInt64.makeHandle(lMantissa), xInt64.makeHandle(iExp));
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    public int invokeAdd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        double d1 = ((FloatHandle)hTarget).getValue();
        double d2 = ((FloatHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(d1 + d2));
    }

    @Override
    public int invokeSub(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        double d1 = ((FloatHandle)hTarget).getValue();
        double d2 = ((FloatHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(d1 - d2));
    }

    @Override
    public int invokeMul(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        double d1 = ((FloatHandle)hTarget).getValue();
        double d2 = ((FloatHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(d1 * d2));
    }

    @Override
    public int invokeDiv(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        double d1 = ((FloatHandle)hTarget).getValue();
        double d2 = ((FloatHandle)hArg).getValue();
        if (d2 == 0.0) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(d1 / d2));
    }

    @Override
    public int invokeMod(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        double d1 = ((FloatHandle)hTarget).getValue();
        double d2 = ((FloatHandle)hArg).getValue();
        if (d2 == 0.0) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(d1 % d2));
    }

    @Override
    public int invokeNeg(Frame frame, ObjectHandle hTarget, int iReturn) {
        double d = ((FloatHandle)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeHandle(-d));
    }

    @Override
    public int callCompare(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        FloatHandle h1 = (FloatHandle)hValue1;
        FloatHandle h2 = (FloatHandle)hValue2;
        return frame.assignValue(iReturn, xOrdered.makeHandle(Double.compare(h1.getValue(), h2.getValue())));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        return ((FloatHandle)hValue1).getValue() == ((FloatHandle)hValue2).getValue();
    }

    @Override
    protected int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        double d = ((FloatHandle)hTarget).getValue();
        return frame.assignValue(iReturn, xInt64.makeHandle(Double.hashCode(d)));
    }

    @Override
    protected int callEstimateLength(Frame frame, ObjectHandle hTarget, int iReturn) {
        double d = ((FloatHandle)hTarget).getValue();
        return frame.assignValue(iReturn, xInt64.makeHandle(this.toString(d).length()));
    }

    @Override
    protected int callAppendTo(Frame frame, ObjectHandle hTarget, ObjectHandle hAppender, int iReturn) {
        double d = ((FloatHandle)hTarget).getValue();
        return xString.callAppendTo(frame, xString.makeHandle(this.toString(d)), hAppender, iReturn);
    }

    @Override
    protected int buildStringValue(Frame frame, ObjectHandle hTarget, int iReturn) {
        double d = ((FloatHandle)hTarget).getValue();
        return frame.assignValue(iReturn, xString.makeHandle(this.toString(d)));
    }

    public int convertLong(Frame frame, long lValue, int iReturn) {
        return frame.assignValue(iReturn, this.makeHandle(lValue));
    }

    protected abstract byte[] getBits(double var1);

    protected abstract double fromLong(long var1);

    protected abstract String toString(double var1);

    @Override
    protected ObjectHandle makeHandle(byte[] aBytes, int cBytes) {
        return this.makeHandle(this.fromLong(xConstrainedInteger.fromByteArray(aBytes, cBytes, false)));
    }

    @Override
    public FloatHandle makeHandle(double dValue) {
        return new FloatHandle(this.getCanonicalClass(), dValue);
    }

    public static class FloatHandle
    extends ObjectHandle {
        private final double f_dValue;

        protected FloatHandle(ClassComposition clz, double dValue) {
            super(clz);
            this.f_dValue = dValue;
        }

        public double getValue() {
            return this.f_dValue;
        }
    }
}

