/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import java.math.BigInteger;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.DecimalAutoConstant;
import org.xvm.asm.constants.DecimalConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.BaseFP;
import org.xvm.runtime.template.numbers.xFloat64;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xEnum;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xOrdered;
import org.xvm.type.Decimal;

public abstract class BaseDecFP
extends BaseFP {
    public BaseDecFP(Container container, ClassStructure structure, int cBits) {
        super(container, structure, cBits);
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof DecimalConstant) {
            DecimalConstant constDec = (DecimalConstant)constant;
            return frame.pushStack(this.makeHandle(constDec.getValue()));
        }
        if (constant instanceof DecimalAutoConstant) {
            DecimalAutoConstant constDec = (DecimalAutoConstant)constant;
            return frame.pushStack(this.makeHandle(constDec.getValue()));
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        Decimal dec = ((DecimalHandle)hTarget).getValue();
        switch (sPropName) {
            case "bits": {
                return frame.assignValue(iReturn, xArray.makeBitArrayHandle(dec.toByteArray(), this.f_cBits, xArray.Mutability.Constant));
            }
            case "infinity": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(!dec.isFinite()));
            }
            case "NaN": {
                return frame.assignValue(iReturn, xBoolean.makeHandle(dec.isNaN()));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "add": {
                return this.invokeAdd(frame, hTarget, hArg, iReturn);
            }
            case "sub": {
                return this.invokeSub(frame, hTarget, hArg, iReturn);
            }
            case "mul": {
                return this.invokeMul(frame, hTarget, hArg, iReturn);
            }
            case "div": {
                return this.invokeDiv(frame, hTarget, hArg, iReturn);
            }
            case "mod": {
                return this.invokeMod(frame, hTarget, hArg, iReturn);
            }
            case "pow": {
                Decimal dec1 = ((DecimalHandle)hTarget).getValue();
                Decimal dec2 = ((DecimalHandle)hArg).getValue();
                return frame.assignValue(iReturn, this.makeHandle(dec1.pow(dec2)));
            }
            case "round": {
                Decimal dec = ((DecimalHandle)hTarget).getValue();
                int iMode = hArg == ObjectHandle.DEFAULT ? 0 : ((xEnum.EnumHandle)hArg).getOrdinal();
                return frame.assignValue(iReturn, this.makeHandle(dec.round(BaseFP.Rounding.values()[iMode].getMode())));
            }
            case "scaleByPow": {
                Decimal dec = ((DecimalHandle)hTarget).getValue();
                long lPow = ((ObjectHandle.JavaLong)hArg).getValue();
                return frame.assignValue(iReturn, this.makeHandle(dec.pow((int)lPow)));
            }
            case "atan2": {
                Decimal dec1 = ((DecimalHandle)hTarget).getValue();
                Decimal dec2 = ((DecimalHandle)hArg).getValue();
                return frame.assignValue(iReturn, this.makeHandle(dec1.atan2(dec2)));
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        Decimal dec = hTarget == null ? null : ((DecimalHandle)hTarget).getValue();
        switch (method.getName()) {
            case "abs": {
                return frame.assignValue(iReturn, this.makeHandle(dec.abs()));
            }
            case "toFloat64": {
                return dec.isFinite() ? frame.assignValue(iReturn, xFloat64.INSTANCE.makeHandle(dec.toBigDecimal().doubleValue())) : this.overflow(frame);
            }
            case "toInt64": {
                ObjectHandle hTrunc = ahArg[0];
                ObjectHandle hRound = ahArg[1];
                if (dec.isFinite()) {
                    int iMode = hRound == ObjectHandle.DEFAULT ? 3 : ((xEnum.EnumHandle)hRound).getOrdinal();
                    BigInteger n = (dec = dec.round(BaseFP.Rounding.values()[iMode].getMode())).toBigDecimal().unscaledValue();
                    int cb = (n.bitLength() + 7) / 8;
                    if (cb <= 8) {
                        return frame.assignValue(iReturn, xInt64.makeHandle(n.longValue()));
                    }
                }
                return frame.raiseException(xException.outOfBounds(frame, "Decimal value out of Int range: " + String.valueOf(dec)));
            }
            case "toIntN": 
            case "toUIntN": 
            case "toFloatN": 
            case "toDecN": {
                throw new UnsupportedOperationException();
            }
            case "neg": {
                return frame.assignValue(iReturn, this.makeHandle(dec.neg()));
            }
            case "floor": {
                return frame.assignValue(iReturn, this.makeHandle(dec.floor()));
            }
            case "ceil": {
                return frame.assignValue(iReturn, this.makeHandle(dec.ceil()));
            }
            case "exp": {
                return frame.assignValue(iReturn, this.makeHandle(dec.exp()));
            }
            case "log": {
                return frame.assignValue(iReturn, this.makeHandle(dec.log()));
            }
            case "log2": {
                return frame.assignValue(iReturn, this.makeHandle(dec.log2()));
            }
            case "log10": {
                return frame.assignValue(iReturn, this.makeHandle(dec.log10()));
            }
            case "sqrt": {
                return frame.assignValue(iReturn, this.makeHandle(dec.sqrt()));
            }
            case "cbrt": {
                return frame.assignValue(iReturn, this.makeHandle(dec.cbrt()));
            }
            case "sin": {
                return frame.assignValue(iReturn, this.makeHandle(dec.sin()));
            }
            case "tan": {
                return frame.assignValue(iReturn, this.makeHandle(dec.tan()));
            }
            case "asin": {
                return frame.assignValue(iReturn, this.makeHandle(dec.asin()));
            }
            case "acos": {
                return frame.assignValue(iReturn, this.makeHandle(dec.acos()));
            }
            case "atan": {
                return frame.assignValue(iReturn, this.makeHandle(dec.atan()));
            }
            case "sinh": {
                return frame.assignValue(iReturn, this.makeHandle(dec.sinh()));
            }
            case "cosh": {
                return frame.assignValue(iReturn, this.makeHandle(dec.cosh()));
            }
            case "tanh": {
                return frame.assignValue(iReturn, this.makeHandle(dec.tanh()));
            }
            case "asinh": {
                return frame.assignValue(iReturn, this.makeHandle(dec.asinh()));
            }
            case "acosh": {
                return frame.assignValue(iReturn, this.makeHandle(dec.acosh()));
            }
            case "atanh": {
                return frame.assignValue(iReturn, this.makeHandle(dec.atanh()));
            }
            case "deg2rad": {
                return frame.assignValue(iReturn, this.makeHandle(dec.deg2rad()));
            }
            case "rad2deg": {
                return frame.assignValue(iReturn, this.makeHandle(dec.rad2deg()));
            }
            case "nextUp": {
                return frame.assignValue(iReturn, this.makeHandle(dec.nextUp()));
            }
            case "nextDown": {
                return frame.assignValue(iReturn, this.makeHandle(dec.nextDown()));
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeNativeNN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int[] aiReturn) {
        switch (method.getName()) {
            case "split": {
                Decimal dec = ((DecimalHandle)hTarget).getValue();
                boolean fSign = dec.isSigned();
                int iExp = 0;
                long lMantissa = 0L;
                return frame.assignValues(aiReturn, xBoolean.makeHandle(fSign), xInt64.makeHandle(lMantissa), xInt64.makeHandle(iExp));
            }
        }
        return super.invokeNativeNN(frame, method, hTarget, ahArg, aiReturn);
    }

    @Override
    public int invokeAdd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        Decimal dec1 = ((DecimalHandle)hTarget).getValue();
        Decimal dec2 = ((DecimalHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(dec1.add(dec2)));
    }

    @Override
    public int invokeSub(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        Decimal dec1 = ((DecimalHandle)hTarget).getValue();
        Decimal dec2 = ((DecimalHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(dec1.subtract(dec2)));
    }

    @Override
    public int invokeMul(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        Decimal dec1 = ((DecimalHandle)hTarget).getValue();
        Decimal dec2 = ((DecimalHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(dec1.multiply(dec2)));
    }

    @Override
    public int invokeDiv(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        Decimal dec1 = ((DecimalHandle)hTarget).getValue();
        Decimal dec2 = ((DecimalHandle)hArg).getValue();
        if (dec2.getSignum() == 0) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(dec1.divide(dec2)));
    }

    @Override
    public int invokeMod(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        Decimal dec1 = ((DecimalHandle)hTarget).getValue();
        Decimal dec2 = ((DecimalHandle)hArg).getValue();
        if (dec2.getSignum() <= 0) {
            return dec2.getSignum() == 0 ? this.overflow(frame) : frame.raiseException("Modulus is negative: " + String.valueOf(dec2));
        }
        return frame.assignValue(iReturn, this.makeHandle(dec1.mod(dec2)));
    }

    @Override
    public int invokeNeg(Frame frame, ObjectHandle hTarget, int iReturn) {
        Decimal dec = ((DecimalHandle)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeHandle(dec.neg()));
    }

    @Override
    public int callCompare(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        DecimalHandle h1 = (DecimalHandle)hValue1;
        DecimalHandle h2 = (DecimalHandle)hValue2;
        return frame.assignValue(iReturn, xOrdered.makeHandle(h1.getValue().compareForObjectOrder(h2.getValue())));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        return ((DecimalHandle)hValue1).getValue().equals(((DecimalHandle)hValue2).getValue());
    }

    @Override
    protected int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        Decimal dec = ((DecimalHandle)hTarget).getValue();
        return frame.assignValue(iReturn, xInt64.makeHandle(dec.hashCode()));
    }

    @Override
    protected int callEstimateLength(Frame frame, ObjectHandle hTarget, int iReturn) {
        Decimal dec = ((DecimalHandle)hTarget).getValue();
        return frame.assignValue(iReturn, xInt64.makeHandle(dec.toString().length()));
    }

    @Override
    protected int callAppendTo(Frame frame, ObjectHandle hTarget, ObjectHandle hAppender, int iReturn) {
        Decimal dec = ((DecimalHandle)hTarget).getValue();
        return xString.callAppendTo(frame, xString.makeHandle(dec.toString()), hAppender, iReturn);
    }

    @Override
    protected int buildStringValue(Frame frame, ObjectHandle hTarget, int iReturn) {
        Decimal dec = ((DecimalHandle)hTarget).getValue();
        return frame.assignValue(iReturn, xString.makeHandle(dec.toString()));
    }

    public int convertLong(Frame frame, long lValue, int iReturn) {
        return frame.assignValue(iReturn, this.makeHandle(lValue));
    }

    protected abstract Decimal fromDouble(double var1);

    @Override
    public DecimalHandle makeHandle(double d) {
        return this.makeHandle(this.fromDouble(d));
    }

    public DecimalHandle makeHandle(Decimal decValue) {
        return new DecimalHandle(this.getCanonicalClass(), decValue);
    }

    public static class DecimalHandle
    extends ObjectHandle {
        private final Decimal f_decValue;

        protected DecimalHandle(ClassComposition clz, Decimal decValue) {
            super(clz);
            this.f_decValue = decValue;
        }

        public Decimal getValue() {
            return this.f_decValue;
        }

        @Override
        public int hashCode() {
            return this.f_decValue.hashCode();
        }

        @Override
        public int compareTo(ObjectHandle that) {
            return this.f_decValue.compareForObjectOrder(((DecimalHandle)that).f_decValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof DecimalHandle)) return false;
            DecimalHandle that = (DecimalHandle)obj;
            if (this.f_decValue.compareForObjectOrder(that.f_decValue) != 0) return false;
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + String.valueOf(this.f_decValue);
        }
    }
}

