/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import java.math.RoundingMode;
import org.xvm.asm.ClassStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.numbers.xNumber;
import org.xvm.runtime.template.xException;

public abstract class BaseFP
extends xNumber {
    public static final double LOG2_10 = 1.0 / Math.log10(2.0);
    protected final int f_cBits;

    public BaseFP(Container container, ClassStructure structure, int cBits) {
        super(container, structure, false);
        this.f_cBits = cBits;
    }

    @Override
    public void initNative() {
        super.initNative();
        this.markNativeProperty("infinity");
        this.markNativeProperty("NaN");
        this.markNativeMethod("abs", VOID, THIS);
        this.markNativeMethod("add", THIS, THIS);
        this.markNativeMethod("sub", THIS, THIS);
        this.markNativeMethod("mul", THIS, THIS);
        this.markNativeMethod("div", THIS, THIS);
        this.markNativeMethod("mod", THIS, THIS);
        this.markNativeMethod("neg", VOID, THIS);
        this.markNativeMethod("pow", THIS, THIS);
        this.markNativeMethod("split", VOID, null);
        this.markNativeMethod("round", null, THIS);
        this.markNativeMethod("floor", VOID, THIS);
        this.markNativeMethod("ceil", VOID, THIS);
        this.markNativeMethod("exp", VOID, THIS);
        this.markNativeMethod("scaleByPow", INT, THIS);
        this.markNativeMethod("log", VOID, THIS);
        this.markNativeMethod("log2", VOID, THIS);
        this.markNativeMethod("log10", VOID, THIS);
        this.markNativeMethod("sqrt", VOID, THIS);
        this.markNativeMethod("cbrt", VOID, THIS);
        this.markNativeMethod("sin", VOID, THIS);
        this.markNativeMethod("tan", VOID, THIS);
        this.markNativeMethod("asin", VOID, THIS);
        this.markNativeMethod("acos", VOID, THIS);
        this.markNativeMethod("atan", VOID, THIS);
        this.markNativeMethod("atan2", THIS, THIS);
        this.markNativeMethod("asinh", VOID, THIS);
        this.markNativeMethod("sinh", VOID, THIS);
        this.markNativeMethod("cosh", VOID, THIS);
        this.markNativeMethod("tanh", VOID, THIS);
        this.markNativeMethod("asinh", VOID, THIS);
        this.markNativeMethod("acosh", VOID, THIS);
        this.markNativeMethod("atanh", VOID, THIS);
        this.markNativeMethod("deg2rad", VOID, THIS);
        this.markNativeMethod("rad2deg", VOID, THIS);
        this.markNativeMethod("nextUp", VOID, THIS);
        this.markNativeMethod("nextDown", VOID, THIS);
        this.invalidateTypeInfo();
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    protected int constructFromString(Frame frame, String sText, int iReturn) {
        try {
            return frame.assignValue(-1, this.makeHandle(Double.valueOf(sText)));
        }
        catch (NumberFormatException e) {
            return frame.raiseException(xException.illegalArgument(frame, "Invalid number \"" + sText + "\""));
        }
    }

    @Override
    protected int constructFromBytes(Frame frame, byte[] ab, int cBytes, int iReturn) {
        return cBytes == this.f_cBits / 8 ? frame.assignValue(iReturn, this.makeHandle(ab, cBytes)) : frame.raiseException(xException.illegalArgument(frame, "Invalid byte count: " + cBytes));
    }

    @Override
    protected int constructFromBits(Frame frame, byte[] ab, int cBits, int iReturn) {
        return cBits == this.f_cBits ? frame.assignValue(iReturn, this.makeHandle(ab, cBits >>> 3)) : frame.raiseException(xException.illegalArgument(frame, "Invalid bit count: " + cBits));
    }

    protected abstract ObjectHandle makeHandle(byte[] var1, int var2);

    protected abstract ObjectHandle makeHandle(double var1);

    static enum Rounding {
        TiesToEven(RoundingMode.HALF_EVEN),
        TiesToAway(RoundingMode.UP),
        TowardPositive(RoundingMode.CEILING),
        TowardZero(RoundingMode.DOWN),
        TowardNegative(RoundingMode.FLOOR);

        private final RoundingMode f_mode;

        private Rounding(RoundingMode mode) {
            this.f_mode = mode;
        }

        public RoundingMode getMode() {
            return this.f_mode;
        }
    }
}

