/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import java.math.BigInteger;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.runtime.template.numbers.LongLong;
import org.xvm.runtime.template.numbers.xConstrainedInteger;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.numbers.xIntLiteral;
import org.xvm.runtime.template.numbers.xIntNumber;
import org.xvm.runtime.template.numbers.xUnconstrainedInteger;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xOrdered;
import org.xvm.util.PackedInteger;

public abstract class BaseInt128
extends xIntNumber {
    public final boolean f_fSigned;
    public final boolean f_fChecked;

    public BaseInt128(Container container, ClassStructure structure, boolean fSigned) {
        super(container, structure, false);
        this.f_fSigned = fSigned;
        this.f_fChecked = false;
    }

    @Override
    public void initNative() {
        super.initNative();
        this.markNativeProperty("leadingZeroCount");
        this.markNativeMethod("abs", null, null);
        this.markNativeMethod("add", THIS, THIS);
        this.markNativeMethod("sub", THIS, THIS);
        this.markNativeMethod("mul", THIS, THIS);
        this.markNativeMethod("div", THIS, THIS);
        this.markNativeMethod("mod", THIS, THIS);
        this.markNativeMethod("neg", VOID, THIS);
        this.markNativeMethod("and", THIS, THIS);
        this.markNativeMethod("or", THIS, THIS);
        this.markNativeMethod("xor", THIS, THIS);
        this.markNativeMethod("not", VOID, THIS);
        this.markNativeMethod("shiftLeft", INT, THIS);
        this.markNativeMethod("shiftRight", INT, THIS);
        this.markNativeMethod("shiftAllRight", INT, THIS);
        this.invalidateTypeInfo();
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof IntConstant) {
            IntConstant constInt = (IntConstant)constant;
            PackedInteger piValue = constInt.getValue();
            return frame.pushStack(this.makeHandle(LongLong.fromBigInteger(piValue.getBigInteger())));
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    protected int constructFromString(Frame frame, String sText, int iReturn) {
        BigInteger big;
        try {
            big = xIntLiteral.parseBigInteger(sText);
        }
        catch (NumberFormatException e) {
            return frame.raiseException(xException.illegalArgument(frame, "Invalid number \"" + sText + "\""));
        }
        int cBits = big.bitLength();
        if (cBits > 127) {
            return frame.raiseException(xException.outOfBounds(frame, "Overflow: " + sText));
        }
        long lLo = big.longValue();
        if (cBits < 64) {
            return this.convertLong(frame, lLo, iReturn, this.f_fSigned);
        }
        long lHi = big.shiftRight(64).longValue();
        return frame.assignValue(iReturn, this.makeHandle(new LongLong(lLo, lHi)));
    }

    @Override
    protected int constructFromBytes(Frame frame, byte[] ab, int cBytes, int iReturn) {
        if (cBytes != 16) {
            return frame.raiseException(xException.illegalArgument(frame, "Invalid byte count: " + cBytes));
        }
        long lLo = xConstrainedInteger.fromByteArray(ab, 0, 8, false);
        long lHi = xConstrainedInteger.fromByteArray(ab, 8, 8, this.f_fSigned);
        return frame.assignValue(iReturn, this.makeHandle(new LongLong(lLo, lHi)));
    }

    @Override
    protected int constructFromBits(Frame frame, byte[] ab, int cBits, int iReturn) {
        if (cBits != 128) {
            return frame.raiseException(xException.illegalArgument(frame, "Invalid bit count: " + cBits));
        }
        long lLo = xConstrainedInteger.fromByteArray(ab, 0, 8, false);
        long lHi = xConstrainedInteger.fromByteArray(ab, 8, 8, this.f_fSigned);
        return frame.assignValue(iReturn, this.makeHandle(new LongLong(lLo, lHi)));
    }

    @Override
    public int invokeNativeGet(Frame frame, String sPropName, ObjectHandle hTarget, int iReturn) {
        switch (sPropName) {
            case "bits": {
                LongLong ll = ((LongLongHandle)hTarget).getValue();
                return frame.assignValue(iReturn, xArray.makeBitArrayHandle(BaseInt128.toByteArray(ll), 128, xArray.Mutability.Constant));
            }
            case "bitCount": {
                LongLong ll = ((LongLongHandle)hTarget).getValue();
                return frame.assignValue(iReturn, xInt64.makeHandle(Long.bitCount(ll.getLowValue()) + Long.bitCount(ll.getHighValue())));
            }
            case "bitLength": {
                return frame.assignValue(iReturn, xInt64.makeHandle(128L));
            }
            case "leftmostBit": {
                LongLong ll = ((LongLongHandle)hTarget).getValue();
                long lH = ll.getHighValue();
                return frame.assignValue(iReturn, xInt64.makeHandle(lH == 0L ? Long.highestOneBit(ll.getLowValue()) : Long.highestOneBit(lH) + 64L));
            }
            case "rightmostBit": {
                LongLong ll = ((LongLongHandle)hTarget).getValue();
                long lLow = ll.getLowValue();
                return frame.assignValue(iReturn, xInt64.makeHandle(lLow == 0L ? 64L + Long.lowestOneBit(ll.getHighValue()) : Long.lowestOneBit(lLow)));
            }
            case "leadingZeroCount": {
                LongLong ll = ((LongLongHandle)hTarget).getValue();
                long lH = ll.getHighValue();
                return frame.assignValue(iReturn, xInt64.makeHandle(lH == 0L ? (long)(64 + Long.numberOfLeadingZeros(ll.getLowValue())) : (long)Long.numberOfLeadingZeros(lH)));
            }
            case "trailingZeroCount": {
                LongLong ll = ((LongLongHandle)hTarget).getValue();
                long lLow = ll.getLowValue();
                return frame.assignValue(iReturn, xInt64.makeHandle(lLow == 0L ? (long)(64 + Long.numberOfTrailingZeros(ll.getHighValue())) : (long)Long.numberOfTrailingZeros(lLow)));
            }
        }
        return super.invokeNativeGet(frame, sPropName, hTarget, iReturn);
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "add": {
                return this.invokeAdd(frame, hTarget, hArg, iReturn);
            }
            case "sub": {
                return this.invokeSub(frame, hTarget, hArg, iReturn);
            }
            case "mul": {
                return this.invokeMul(frame, hTarget, hArg, iReturn);
            }
            case "div": {
                return this.invokeDiv(frame, hTarget, hArg, iReturn);
            }
            case "mod": {
                return this.invokeMod(frame, hTarget, hArg, iReturn);
            }
            case "neg": {
                return this.invokeNeg(frame, hTarget, iReturn);
            }
            case "and": {
                return this.invokeAnd(frame, hTarget, hArg, iReturn);
            }
            case "or": {
                return this.invokeOr(frame, hTarget, hArg, iReturn);
            }
            case "xor": {
                return this.invokeXor(frame, hTarget, hArg, iReturn);
            }
            case "not": {
                return this.invokeCompl(frame, hTarget, iReturn);
            }
            case "shiftLeft": {
                return this.invokeShl(frame, hTarget, hArg, iReturn);
            }
            case "shiftRight": {
                return this.invokeShr(frame, hTarget, hArg, iReturn);
            }
            case "shiftAllRight": {
                return this.invokeShrAll(frame, hTarget, hArg, iReturn);
            }
            case "toInt8": 
            case "toInt16": 
            case "toInt32": 
            case "toInt64": 
            case "toInt128": 
            case "toUInt8": 
            case "toUInt16": 
            case "toUInt32": 
            case "toUInt64": 
            case "toUInt128": 
            case "toIntN": 
            case "toUIntN": {
                TypeConstant typeRet = method.getReturn(0).getType();
                ClassTemplate template = this.f_container.getTemplate(typeRet);
                if (template == this) {
                    return frame.assignValue(iReturn, hTarget);
                }
                boolean fCheckBounds = hArg == xBoolean.TRUE;
                LongLong llValue = ((LongLongHandle)hTarget).getValue();
                if (template instanceof xConstrainedInteger) {
                    xConstrainedInteger templateTo = (xConstrainedInteger)template;
                    return this.convertToConstrainedType(frame, templateTo, llValue, fCheckBounds, iReturn);
                }
                if (template instanceof xUnconstrainedInteger) {
                    xUnconstrainedInteger templateTo = (xUnconstrainedInteger)template;
                    PackedInteger piValue = new PackedInteger(this.f_fSigned ? llValue.toBigInteger() : llValue.toUnsignedBigInteger());
                    return !templateTo.f_fSigned && piValue.isNegative() ? this.overflow(frame) : frame.assignValue(iReturn, templateTo.makeInt(piValue));
                }
                if (!(template instanceof BaseInt128)) break;
                BaseInt128 templateTo = (BaseInt128)template;
                if (fCheckBounds) {
                    if (this.f_fSigned && llValue.signum() < 0 && !templateTo.f_fSigned) {
                        return this.overflow(frame);
                    }
                    if (!this.f_fSigned && llValue.getHighValue() < 0L && templateTo.f_fSigned) {
                        return this.overflow(frame);
                    }
                }
                return frame.assignValue(iReturn, templateTo.makeHandle(llValue));
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "abs": {
                return this.invokeAbs(frame, hTarget, iReturn);
            }
            case "toInt8": 
            case "toInt16": 
            case "toInt32": 
            case "toInt64": 
            case "toInt128": 
            case "toUInt8": 
            case "toUInt16": 
            case "toUInt32": 
            case "toUInt64": 
            case "toUInt128": 
            case "toIntN": 
            case "toUIntN": {
                return this.invokeNative1(frame, method, hTarget, xBoolean.FALSE, iReturn);
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    protected int invokeAbs(Frame frame, ObjectHandle hTarget, int iReturn) {
        if (!this.f_fSigned) {
            return frame.assignValue(iReturn, hTarget);
        }
        LongLong ll = ((LongLongHandle)hTarget).getValue();
        if (ll.signum() >= 0) {
            return frame.assignValue(iReturn, hTarget);
        }
        LongLong llr = ll.negate();
        if (this.f_fChecked && llr == LongLong.OVERFLOW) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(llr));
    }

    @Override
    public int invokeNeg(Frame frame, ObjectHandle hTarget, int iReturn) {
        if (this.f_fChecked && !this.f_fSigned) {
            return this.overflow(frame);
        }
        LongLong ll = ((LongLongHandle)hTarget).getValue();
        LongLong llr = ll.negate();
        if (this.f_fChecked && llr == LongLong.OVERFLOW) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(llr));
    }

    @Override
    public int invokeAdd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong llr;
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        LongLong ll2 = ((LongLongHandle)hArg).getValue();
        LongLong longLong = llr = this.f_fSigned ? ll1.add(ll2) : ll1.addUnsigned(ll2);
        if (this.f_fChecked && llr == LongLong.OVERFLOW) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(llr));
    }

    @Override
    public int invokeSub(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong llr;
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        LongLong ll2 = ((LongLongHandle)hArg).getValue();
        LongLong longLong = llr = this.f_fSigned ? ll1.sub(ll2) : ll1.subUnassigned(ll2);
        if (this.f_fChecked && llr == LongLong.OVERFLOW) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(llr));
    }

    @Override
    public int invokeMul(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong llr;
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        LongLong ll2 = ((LongLongHandle)hArg).getValue();
        LongLong longLong = llr = this.f_fSigned ? ll1.mul(ll2) : ll1.mulUnsigned(ll2);
        if (this.f_fChecked && llr == LongLong.OVERFLOW) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(llr));
    }

    @Override
    public int invokePrev(Frame frame, ObjectHandle hTarget, int iReturn) {
        LongLong ll = ((LongLongHandle)hTarget).getValue();
        LongLong llr = ll.prev(this.f_fSigned);
        if (this.f_fChecked && llr == LongLong.OVERFLOW) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(llr));
    }

    @Override
    public int invokeNext(Frame frame, ObjectHandle hTarget, int iReturn) {
        LongLong ll = ((LongLongHandle)hTarget).getValue();
        LongLong llr = ll.next(this.f_fSigned);
        if (this.f_fChecked && llr == LongLong.OVERFLOW) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(llr));
    }

    @Override
    public int invokeDiv(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong llDiv;
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        LongLong ll2 = ((LongLongHandle)hArg).getValue();
        LongLong longLong = llDiv = this.f_fSigned ? ll1.div(ll2) : ll1.divUnsigned(ll2);
        if (this.f_fChecked && llDiv == LongLong.OVERFLOW) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(llDiv));
    }

    @Override
    public int invokeMod(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong llMod;
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        LongLong ll2 = ((LongLongHandle)hArg).getValue();
        LongLong longLong = llMod = this.f_fSigned ? ll1.mod(ll2) : ll1.modUnsigned(ll2);
        if (this.f_fChecked && llMod == LongLong.OVERFLOW) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeHandle(llMod));
    }

    @Override
    public int invokeDivRem(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int[] aiReturn) {
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        LongLong ll2 = ((LongLongHandle)hArg).getValue();
        LongLong[] allQuoRem = this.f_fSigned ? ll1.divrem(ll2) : ll1.divremUnsigned(ll2);
        LongLong llDiv = allQuoRem[0];
        LongLong llRem = allQuoRem[1];
        if (this.f_fChecked && llDiv == LongLong.OVERFLOW) {
            return this.overflow(frame);
        }
        return frame.assignValues(aiReturn, this.makeHandle(llDiv), this.makeHandle(llRem));
    }

    @Override
    public int invokeShl(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        int c = (int)((ObjectHandle.JavaLong)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(ll1.shl(c)));
    }

    @Override
    public int invokeShr(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        int c = (int)((ObjectHandle.JavaLong)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(ll1.shr(c)));
    }

    @Override
    public int invokeShrAll(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        int c = (int)((ObjectHandle.JavaLong)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(ll1.ushr(c)));
    }

    @Override
    public int invokeAnd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        LongLong ll2 = ((LongLongHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(ll1.and(ll2)));
    }

    @Override
    public int invokeOr(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        LongLong ll2 = ((LongLongHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(ll1.or(ll2)));
    }

    @Override
    public int invokeXor(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        LongLong ll1 = ((LongLongHandle)hTarget).getValue();
        LongLong ll2 = ((LongLongHandle)hArg).getValue();
        return frame.assignValue(iReturn, this.makeHandle(ll1.xor(ll2)));
    }

    @Override
    public int invokeCompl(Frame frame, ObjectHandle hTarget, int iReturn) {
        LongLong ll = ((LongLongHandle)hTarget).getValue();
        return frame.assignValue(iReturn, this.makeHandle(ll.complement()));
    }

    @Override
    public int callCompare(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        LongLongHandle h1 = (LongLongHandle)hValue1;
        LongLongHandle h2 = (LongLongHandle)hValue2;
        return frame.assignValue(iReturn, xOrdered.makeHandle(this.f_fSigned ? (long)h1.getValue().compare(h2.getValue()) : (long)h1.getValue().compareUnsigned(h2.getValue())));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        return ((LongLongHandle)hValue1).getValue().equals(((LongLongHandle)hValue2).getValue());
    }

    @Override
    public int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        LongLong ll = ((LongLongHandle)hTarget).getValue();
        return frame.assignValue(iReturn, xInt64.makeHandle(ll.hashCode()));
    }

    @Override
    protected int buildStringValue(Frame frame, ObjectHandle hTarget, int iReturn) {
        LongLong ll = ((LongLongHandle)hTarget).getValue();
        return frame.assignValue(iReturn, xString.makeHandle(this.f_fSigned ? ll.toBigInteger().toString() : ll.toUnsignedBigInteger().toString()));
    }

    public static byte[] toByteArray(LongLong ll) {
        byte[] ab = new byte[16];
        xConstrainedInteger.copyAsBytes(ll.getHighValue(), ab, 0);
        xConstrainedInteger.copyAsBytes(ll.getLowValue(), ab, 8);
        return ab;
    }

    protected int convertLong(Frame frame, long lValue, int iReturn, boolean fFromSigned) {
        return frame.assignValue(iReturn, this.makeHandle(new LongLong(lValue, fFromSigned)));
    }

    protected abstract int convertToConstrainedType(Frame var1, xConstrainedInteger var2, LongLong var3, boolean var4, int var5);

    public LongLongHandle makeHandle(LongLong ll) {
        return new LongLongHandle(this.getCanonicalClass(), ll);
    }

    public static class LongLongHandle
    extends ObjectHandle {
        protected LongLong m_llValue;

        public LongLongHandle(TypeComposition clazz, LongLong ll) {
            super(clazz);
            this.m_llValue = ll;
        }

        public LongLong getValue() {
            return this.m_llValue;
        }

        @Override
        public int hashCode() {
            return this.m_llValue.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof LongLongHandle)) return false;
            LongLongHandle that = (LongLongHandle)obj;
            if (!this.m_llValue.equals(that.m_llValue)) return false;
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + String.valueOf(this.m_llValue);
        }
    }
}

