/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import java.math.BigInteger;

public class LongLong {
    public static final LongLong OVERFLOW = new Overflow();
    public static final LongLong ZERO = new LongLong(0L, 0L);
    public static final LongLong ONE = new LongLong(1L, 0L);
    public static final LongLong MAX_VALUE = new LongLong(-1L, Long.MAX_VALUE);
    public static final LongLong MIN_VALUE = new LongLong(0L, Long.MIN_VALUE);
    public static final LongLong[] ZEROx2 = new LongLong[]{ZERO, ZERO};
    public static final LongLong[] OVERFLOWx2 = new LongLong[]{OVERFLOW, OVERFLOW};
    protected static final BigInteger BIG_MASK64 = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    protected final long m_lLow;
    protected final long m_lHigh;

    public LongLong(long lLow, long lHigh) {
        this.m_lLow = lLow;
        this.m_lHigh = lHigh;
    }

    public LongLong(long lValue) {
        this(lValue, lValue >= 0L ? 0L : -1L);
    }

    public LongLong(long lValue, boolean fSigned) {
        this(lValue, lValue >= 0L || !fSigned ? 0L : -1L);
    }

    public boolean isSmall(boolean fSigned) {
        return fSigned ? (this.m_lLow >= 0L ? this.m_lHigh == 0L : this.m_lHigh == -1L) : this.m_lHigh == 0L;
    }

    public LongLong add(LongLong ll) {
        long l1L = this.m_lLow;
        long l1H = this.m_lHigh;
        long l2L = ll.m_lLow;
        long l2H = ll.m_lHigh;
        long lrL = l1L + l2L;
        long lrH = l1H + l2H;
        if (((l1H ^ lrH) & (l2H ^ lrH)) < 0L) {
            return OVERFLOW;
        }
        if ((l1L & l2L | (l1L | l2L) & (lrL ^ 0xFFFFFFFFFFFFFFFFL)) < 0L) {
            if (lrH == Long.MAX_VALUE) {
                return OVERFLOW;
            }
            ++lrH;
        }
        return new LongLong(lrL, lrH);
    }

    public LongLong addUnsigned(LongLong ll) {
        long l1L = this.m_lLow;
        long l1H = this.m_lHigh;
        long l2L = ll.m_lLow;
        long l2H = ll.m_lHigh;
        long lrL = l1L + l2L;
        long lrH = l1H + l2H;
        if ((l1H & l2H | (l1H | l2H) & (lrH ^ 0xFFFFFFFFFFFFFFFFL)) < 0L) {
            return OVERFLOW;
        }
        if ((l1L & l2L | (l1L | l2L) & (lrL ^ 0xFFFFFFFFFFFFFFFFL)) < 0L) {
            if (lrH == -1L) {
                return OVERFLOW;
            }
            ++lrH;
        }
        return new LongLong(lrL, lrH);
    }

    public LongLong sub(LongLong ll) {
        long l1L = this.m_lLow;
        long l1H = this.m_lHigh;
        long l2L = ll.m_lLow;
        long l2H = ll.m_lHigh;
        long lrL = l1L - l2L;
        long lrH = l1H - l2H;
        if (((l1H ^ l2H) & (l1H ^ lrH)) < 0L) {
            return OVERFLOW;
        }
        if (((l1L ^ 0xFFFFFFFFFFFFFFFFL) & l2L | (l1L ^ 0xFFFFFFFFFFFFFFFFL | l2L) & lrL) < 0L) {
            if (lrH == Long.MIN_VALUE) {
                return OVERFLOW;
            }
            --lrH;
        }
        return new LongLong(lrL, lrH);
    }

    public LongLong subUnassigned(LongLong ll) {
        long l1L = this.m_lLow;
        long l1H = this.m_lHigh;
        long l2L = ll.m_lLow;
        long l2H = ll.m_lHigh;
        long lrL = l1L - l2L;
        long lrH = l1H - l2H;
        if (((l1H ^ 0xFFFFFFFFFFFFFFFFL) & l2H | (l1H ^ 0xFFFFFFFFFFFFFFFFL | l2H) & lrH) < 0L) {
            return OVERFLOW;
        }
        if (((l1L ^ 0xFFFFFFFFFFFFFFFFL) & l2L | (l1L ^ 0xFFFFFFFFFFFFFFFFL | l2L) & lrL) < 0L) {
            if (lrH == 0L) {
                return OVERFLOW;
            }
            --lrH;
        }
        return new LongLong(lrL, lrH);
    }

    public LongLong mul(LongLong ll) {
        BigInteger bi2;
        BigInteger bi1 = this.toBigInteger();
        BigInteger bir = bi1.multiply(bi2 = ll.toBigInteger());
        return bir.bitLength() <= 127 ? LongLong.fromBigInteger(bir) : OVERFLOW;
    }

    public LongLong mulUnsigned(LongLong ll) {
        BigInteger bi2;
        BigInteger bi1 = this.toUnsignedBigInteger();
        BigInteger bir = bi1.multiply(bi2 = ll.toUnsignedBigInteger());
        return bir.bitLength() <= 128 ? LongLong.fromBigInteger(bir) : OVERFLOW;
    }

    public LongLong div(LongLong ll) {
        long l2L = ll.m_lLow;
        long l2H = ll.m_lHigh;
        if (l2H == 0L) {
            if (l2L == 0L) {
                return OVERFLOW;
            }
            if (l2L > 0L) {
                return this.div(l2L);
            }
        } else if (l2H == -1L && l2L < 0L) {
            return this.div(l2L);
        }
        BigInteger bi1 = this.toBigInteger();
        BigInteger bi2 = ll.toBigInteger();
        BigInteger bir = bi1.divide(bi2);
        return LongLong.fromBigInteger(bir);
    }

    public LongLong div(long l) {
        long l1L = this.m_lLow;
        long l1H = this.m_lHigh;
        if (l1H == 0L) {
            if (l1L == 0L) {
                return ZERO;
            }
            if (l1L > 0L) {
                return new LongLong(l1L / l);
            }
        } else if (l1H == -1L && l1L < 0L) {
            return new LongLong(l1L / l);
        }
        BigInteger bi1 = this.toBigInteger();
        BigInteger bi2 = BigInteger.valueOf(l);
        BigInteger bir = bi1.divide(bi2);
        return LongLong.fromBigInteger(bir);
    }

    public LongLong divUnsigned(LongLong ll) {
        long l2L = ll.m_lLow;
        long l2H = ll.m_lHigh;
        if (l2H == 0L) {
            if (l2L == 0L) {
                return OVERFLOW;
            }
            if (l2L > 0L) {
                return this.divUnsigned(l2L);
            }
        }
        BigInteger bi1 = this.toUnsignedBigInteger();
        BigInteger bi2 = ll.toUnsignedBigInteger();
        BigInteger bir = bi1.divide(bi2);
        return LongLong.fromBigInteger(bir);
    }

    public LongLong divUnsigned(long l) {
        long l1L = this.m_lLow;
        long l1H = this.m_lHigh;
        if (l1H == 0L) {
            if (l1L == 0L) {
                return ZERO;
            }
            if (l1L > 0L) {
                return new LongLong(l1L / l);
            }
        }
        BigInteger bi1 = this.toUnsignedBigInteger();
        BigInteger bi2 = LongLong.toUnsignedBigInteger(l);
        BigInteger bir = bi1.divide(bi2);
        return LongLong.fromBigInteger(bir);
    }

    public LongLong[] divrem(LongLong ll) {
        long l2L = ll.m_lLow;
        long l2H = ll.m_lHigh;
        if (l2H == 0L) {
            if (l2L == 0L) {
                return OVERFLOWx2;
            }
            if (l2L > 0L) {
                return this.divrem(l2L);
            }
        } else if (l2H == -1L && l2L < 0L) {
            return this.divrem(l2L);
        }
        BigInteger bi1 = this.toBigInteger();
        BigInteger bi2 = ll.toBigInteger();
        BigInteger[] abir = bi1.divideAndRemainder(bi2);
        return LongLong.fromBigIntegers(abir);
    }

    public LongLong[] divrem(long l) {
        long l1L = this.m_lLow;
        long l1H = this.m_lHigh;
        if (l1H == 0L) {
            if (l1L == 0L) {
                return ZEROx2;
            }
            if (l1L > 0L) {
                return new LongLong[]{new LongLong(l1L / l), new LongLong(l1L % l)};
            }
        } else if (l1H == -1L && l1L < 0L) {
            return new LongLong[]{new LongLong(l1L / l), new LongLong(l1H % l)};
        }
        BigInteger bi1 = this.toBigInteger();
        BigInteger bi2 = BigInteger.valueOf(l);
        BigInteger[] abir = bi1.divideAndRemainder(bi2);
        return LongLong.fromBigIntegers(abir);
    }

    public LongLong[] divremUnsigned(LongLong ll) {
        long l2L = ll.m_lLow;
        long l2H = ll.m_lHigh;
        if (l2H == 0L) {
            if (l2L == 0L) {
                return OVERFLOWx2;
            }
            if (l2L > 0L) {
                return this.divremUnsigned(l2L);
            }
        }
        BigInteger bi1 = this.toUnsignedBigInteger();
        BigInteger bi2 = ll.toUnsignedBigInteger();
        BigInteger[] abir = bi1.divideAndRemainder(bi2);
        return LongLong.fromBigIntegers(abir);
    }

    public LongLong[] divremUnsigned(long l) {
        long l1L = this.m_lLow;
        long l1H = this.m_lHigh;
        if (l1H == 0L) {
            if (l1L == 0L) {
                return ZEROx2;
            }
            if (l1L > 0L) {
                return new LongLong[]{new LongLong(l1L / l), new LongLong(l1L % l)};
            }
        }
        BigInteger bi1 = this.toUnsignedBigInteger();
        BigInteger bi2 = LongLong.toUnsignedBigInteger(l);
        BigInteger[] abir = bi1.divideAndRemainder(bi2);
        return LongLong.fromBigIntegers(abir);
    }

    public LongLong mod(LongLong ll) {
        BigInteger bi1 = this.toBigInteger();
        BigInteger bi2 = ll.toBigInteger();
        BigInteger bir = bi1.mod(bi2);
        return LongLong.fromBigInteger(bir);
    }

    public LongLong modUnsigned(LongLong ll) {
        BigInteger bi1 = this.toUnsignedBigInteger();
        BigInteger bi2 = ll.toUnsignedBigInteger();
        BigInteger bir = bi1.mod(bi2);
        return LongLong.fromBigInteger(bir);
    }

    public LongLong next(boolean fSigned) {
        if (this.m_lLow == -1L) {
            if (this.m_lHigh == (fSigned ? Long.MAX_VALUE : -1L)) {
                return OVERFLOW;
            }
            return new LongLong(0L, this.m_lHigh + 1L);
        }
        return new LongLong(this.m_lLow + 1L, this.m_lHigh);
    }

    public LongLong prev(boolean fSigned) {
        if (this.m_lLow == 0L) {
            if (this.m_lHigh == (fSigned ? Long.MIN_VALUE : 0L)) {
                return OVERFLOW;
            }
            return new LongLong(-1L, this.m_lHigh - 1L);
        }
        return new LongLong(this.m_lLow - 1L, this.m_lHigh);
    }

    public LongLong negate() {
        if (this.m_lHigh == Long.MIN_VALUE && this.m_lLow == 0L) {
            return OVERFLOW;
        }
        return this.complement().next(true);
    }

    public LongLong and(LongLong ll) {
        return new LongLong(this.m_lLow & ll.m_lLow, this.m_lHigh & ll.m_lHigh);
    }

    public LongLong or(LongLong ll) {
        return new LongLong(this.m_lLow | ll.m_lLow, this.m_lHigh | ll.m_lHigh);
    }

    public LongLong xor(LongLong ll) {
        return new LongLong(this.m_lLow ^ ll.m_lLow, this.m_lHigh ^ ll.m_lHigh);
    }

    public LongLong complement() {
        return new LongLong(this.m_lLow ^ 0xFFFFFFFFFFFFFFFFL, this.m_lHigh ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public LongLong shl(int n) {
        if (n < 64) {
            return n == 0 ? this : new LongLong(this.m_lLow << n, this.m_lHigh << n | this.m_lLow >>> 64 - n);
        }
        return new LongLong(0L, this.m_lLow << n - 64);
    }

    public LongLong shr(int n) {
        if (n < 64) {
            return n == 0 ? this : new LongLong(this.m_lLow >>> n | this.m_lHigh << 64 - n, this.m_lHigh >> n);
        }
        return new LongLong(this.m_lHigh >> n - 64, this.m_lHigh < 0L ? -1L : 0L);
    }

    public LongLong ushr(int n) {
        if (n < 64) {
            return n == 0 ? this : new LongLong(this.m_lLow >>> n | this.m_lHigh << 64 - n, this.m_lHigh >>> n);
        }
        return new LongLong(this.m_lHigh >>> n - 64, 0L);
    }

    public LongLong shl(LongLong n) {
        if (n.m_lHigh != 0L || n.m_lLow > 127L || n.m_lLow < 0L) {
            return ZERO;
        }
        return this.shl((int)n.m_lLow);
    }

    public LongLong shr(LongLong n) {
        if (n.m_lHigh != 0L || n.m_lLow > 127L || n.m_lLow < 0L) {
            return ZERO;
        }
        return this.shr((int)n.m_lLow);
    }

    public LongLong ushr(LongLong n) {
        if (n.m_lHigh != 0L || n.m_lLow > 127L || n.m_lLow < 0L) {
            return ZERO;
        }
        return this.ushr((int)n.m_lLow);
    }

    public int signum() {
        return Long.signum(this.m_lHigh);
    }

    public int hashCode() {
        return Long.hashCode(this.m_lLow) ^ Long.hashCode(this.m_lHigh);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongLong)) {
            return false;
        }
        LongLong that = (LongLong)obj;
        return this.m_lLow == that.m_lLow && this.m_lHigh == that.m_lHigh;
    }

    public int compare(LongLong ll) {
        long lThisHigh = this.m_lHigh;
        long lThatHigh = ll.m_lHigh;
        if (lThisHigh != lThatHigh) {
            return Long.compare(lThisHigh, lThatHigh);
        }
        return Long.compareUnsigned(this.m_lLow, ll.m_lLow);
    }

    public int compareUnsigned(LongLong ll) {
        long lThisHigh = this.m_lHigh;
        long lThatHigh = ll.m_lHigh;
        if (lThisHigh != lThatHigh) {
            return Long.compareUnsigned(lThisHigh, lThatHigh);
        }
        return Long.compareUnsigned(this.m_lLow, ll.m_lLow);
    }

    public long getLowValue() {
        return this.m_lLow;
    }

    public long getHighValue() {
        return this.m_lHigh;
    }

    public BigInteger toBigInteger() {
        return LongLong.toUnsignedBigInteger(this.m_lLow).or(BigInteger.valueOf(this.m_lHigh).shiftLeft(64));
    }

    public BigInteger toUnsignedBigInteger() {
        return LongLong.toUnsignedBigInteger(this.m_lLow).or(LongLong.toUnsignedBigInteger(this.m_lHigh).shiftLeft(64));
    }

    public static BigInteger toUnsignedBigInteger(long l) {
        if (l >= 0L) {
            return BigInteger.valueOf(l);
        }
        int nHigh = (int)(l >>> 32);
        int nLow = (int)l;
        return BigInteger.valueOf(Integer.toUnsignedLong(nHigh)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(nLow)));
    }

    public static LongLong fromBigInteger(BigInteger bi) {
        assert (bi.bitLength() <= 128);
        BigInteger biLow = bi.and(BIG_MASK64);
        BigInteger biHigh = bi.shiftRight(64);
        return new LongLong(biLow.longValue(), biHigh.longValue());
    }

    public static LongLong[] fromBigIntegers(BigInteger[] abi) {
        assert (abi.length == 2);
        return new LongLong[]{LongLong.fromBigInteger(abi[0]), LongLong.fromBigInteger(abi[1])};
    }

    public String toString() {
        return this.toBigInteger().toString();
    }

    private static final class Overflow
    extends LongLong {
        private Overflow() {
            super(0L, 0L);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

