/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.constants.ByteConstant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.numbers.xConstrainedInteger;
import org.xvm.runtime.template.numbers.xInt64;
import org.xvm.runtime.template.numbers.xIntLiteral;
import org.xvm.runtime.template.text.xString;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xConst;
import org.xvm.runtime.template.xException;
import org.xvm.runtime.template.xOrdered;

public class xBit
extends xConst {
    public static ObjectHandle.JavaLong ZERO;
    public static ObjectHandle.JavaLong ONE;

    public xBit(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, false);
    }

    @Override
    public void initNative() {
        ZERO = new ObjectHandle.JavaLong(this.getCanonicalClass(), 0L);
        ONE = new ObjectHandle.JavaLong(this.getCanonicalClass(), 1L);
        this.markNativeMethod("toBoolean", VOID, new String[]{"Boolean"});
        this.markNativeMethod("toUInt8", null, new String[]{"numbers.UInt8"});
        this.markNativeMethod("toInt64", null, new String[]{"numbers.Int64"});
        this.markNativeMethod("toUInt64", null, new String[]{"numbers.UInt64"});
        this.markNativeMethod("and", THIS, THIS);
        this.markNativeMethod("or", THIS, THIS);
        this.markNativeMethod("xor", THIS, THIS);
        this.markNativeMethod("not", VOID, THIS);
        this.invalidateTypeInfo();
    }

    @Override
    public boolean isGenericHandle() {
        return false;
    }

    @Override
    public int createConstHandle(Frame frame, Constant constant) {
        if (constant instanceof IntConstant) {
            IntConstant constInt = (IntConstant)constant;
            return frame.pushStack(xBit.makeHandle(constInt.getValue().getLong() != 0L));
        }
        if (constant.getFormat() == Constant.Format.Bit) {
            return frame.pushStack(xBit.makeHandle(((ByteConstant)constant).getValue() != 0));
        }
        return super.createConstHandle(frame, constant);
    }

    @Override
    public int construct(Frame frame, MethodStructure constructor, TypeComposition clazz, ObjectHandle hParent, ObjectHandle[] ahVar, int iReturn) {
        ObjectHandle objectHandle;
        if (ahVar.length >= 1 && (objectHandle = ahVar[0]) instanceof xIntLiteral.IntNHandle) {
            xIntLiteral.IntNHandle hIntN = (xIntLiteral.IntNHandle)objectHandle;
            try {
                long lBit = hIntN.getValue().getInt();
                if (lBit == 0L || lBit == 1L) {
                    return frame.assignValue(iReturn, xBit.makeHandle(lBit == 1L));
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return frame.raiseException(xException.illegalArgument(frame, hIntN.getValue().toString()));
        }
        return frame.raiseException(xException.unsupported(frame));
    }

    @Override
    public int invokeNative1(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        switch (method.getName()) {
            case "and": {
                return this.invokeAnd(frame, hTarget, hArg, iReturn);
            }
            case "or": {
                return this.invokeOr(frame, hTarget, hArg, iReturn);
            }
            case "xor": {
                return this.invokeXor(frame, hTarget, hArg, iReturn);
            }
            case "not": {
                return this.invokeCompl(frame, hTarget, iReturn);
            }
        }
        return super.invokeNative1(frame, method, hTarget, hArg, iReturn);
    }

    @Override
    public int invokeNativeN(Frame frame, MethodStructure method, ObjectHandle hTarget, ObjectHandle[] ahArg, int iReturn) {
        switch (method.getName()) {
            case "toBoolean": 
            case "toUInt8": 
            case "toInt64": 
            case "toUInt64": {
                boolean fValue;
                TypeConstant typeRet = method.getReturn(0).getType();
                ClassTemplate template = this.f_container.getTemplate(typeRet);
                boolean bl = fValue = ((ObjectHandle.JavaLong)hTarget).getValue() != 0L;
                if (template instanceof xConstrainedInteger) {
                    xConstrainedInteger templateTo = (xConstrainedInteger)template;
                    return frame.assignValue(iReturn, templateTo.makeJavaLong(fValue ? 1L : 0L));
                }
                if (!(template instanceof xBoolean)) break;
                return frame.assignValue(iReturn, xBoolean.makeHandle(fValue));
            }
        }
        return super.invokeNativeN(frame, method, hTarget, ahArg, iReturn);
    }

    @Override
    public int invokeAnd(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return frame.assignValue(iReturn, xBit.makeHandle(((ObjectHandle.JavaLong)hTarget).getValue() != 0L & ((ObjectHandle.JavaLong)hArg).getValue() != 0L));
    }

    @Override
    public int invokeOr(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return frame.assignValue(iReturn, xBit.makeHandle(((ObjectHandle.JavaLong)hTarget).getValue() != 0L | ((ObjectHandle.JavaLong)hArg).getValue() != 0L));
    }

    @Override
    public int invokeXor(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        return frame.assignValue(iReturn, xBit.makeHandle(((ObjectHandle.JavaLong)hTarget).getValue() != 0L ^ ((ObjectHandle.JavaLong)hArg).getValue() != 0L));
    }

    @Override
    public int invokeCompl(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, xBit.makeHandle(l == 0L));
    }

    @Override
    public int callEquals(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return frame.assignValue(iReturn, xBoolean.makeHandle(this.compareIdentity(hValue1, hValue2)));
    }

    @Override
    public int callCompare(Frame frame, TypeComposition clazz, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        ObjectHandle.JavaLong h1 = (ObjectHandle.JavaLong)hValue1;
        ObjectHandle.JavaLong h2 = (ObjectHandle.JavaLong)hValue2;
        return frame.assignValue(iReturn, xOrdered.makeHandle(Long.compare(h1.getValue(), h2.getValue())));
    }

    @Override
    public boolean compareIdentity(ObjectHandle hValue1, ObjectHandle hValue2) {
        return ((ObjectHandle.JavaLong)hValue1).getValue() == ((ObjectHandle.JavaLong)hValue2).getValue();
    }

    @Override
    public int buildHashCode(Frame frame, TypeComposition clazz, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, xInt64.makeHandle(l != 0L ? 1L : 0L));
    }

    @Override
    protected int buildStringValue(Frame frame, ObjectHandle hTarget, int iReturn) {
        long l = ((ObjectHandle.JavaLong)hTarget).getValue();
        return frame.assignValue(iReturn, l == 0L ? xString.ZERO : xString.ONE);
    }

    public static ObjectHandle.JavaLong makeHandle(boolean f) {
        return f ? ONE : ZERO;
    }
}

