/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.runtime.template.numbers;

import org.xvm.asm.ClassStructure;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.numbers.xCheckedInt64;
import org.xvm.runtime.template.numbers.xCheckedUnsignedInt;
import org.xvm.runtime.template.numbers.xConstrainedInteger;

public class xCheckedUInt64
extends xCheckedUnsignedInt {
    public static xCheckedUInt64 INSTANCE;

    public xCheckedUInt64(Container container, ClassStructure structure, boolean fInstance) {
        super(container, structure, 0L, -1L, 64);
        if (fInstance) {
            INSTANCE = this;
        }
    }

    @Override
    protected xConstrainedInteger getComplimentaryTemplate() {
        return xCheckedInt64.INSTANCE;
    }

    @Override
    public int invokeMul(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        if (l1 <= 0L) {
            if (l2 == 0L || l1 == 0L) {
                return frame.assignValue(iReturn, this.makeJavaLong(0L));
            }
            if (l2 == 1L) {
                return frame.assignValue(iReturn, hTarget);
            }
            return this.overflow(frame);
        }
        if (l2 <= 0L) {
            if (l1 == 0L || l2 == 0L) {
                return frame.assignValue(iReturn, this.makeJavaLong(0L));
            }
            if (l1 == 1L) {
                return frame.assignValue(iReturn, hArg);
            }
            return this.overflow(frame);
        }
        long lr = l1 * l2;
        if ((l1 | l2) >>> 31 != 0L && xCheckedUInt64.divUnsigned(lr, l2) != l1) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeJavaLong(lr));
    }

    @Override
    public int invokeDiv(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        if (l2 == 0L) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeJavaLong(xCheckedUInt64.divUnsigned(l1, l2)));
    }

    @Override
    public int invokeMod(Frame frame, ObjectHandle hTarget, ObjectHandle hArg, int iReturn) {
        long l1 = ((ObjectHandle.JavaLong)hTarget).getValue();
        long l2 = ((ObjectHandle.JavaLong)hArg).getValue();
        if (l2 == 0L) {
            return this.overflow(frame);
        }
        return frame.assignValue(iReturn, this.makeJavaLong(xCheckedUInt64.modUnsigned(l1, l2)));
    }
}

